function deparam( params, coerce ) {
	var obj = {},
		coerce_types = { 'true': !0, 'false': !1, 'null': null };

	// Iterate over all name=value pairs.
	$.each( params.replace( /\+/g, ' ' ).split( '&' ), function(j,v){
		var param = v.split( '=' ),
			key = decodeURIComponent( param[0] ),
			val,
			cur = obj,
			i = 0,

		// If key is more complex than 'foo', like 'a[]' or 'a[b][c]', split it
		// into its component parts.
			keys = key.split( '][' ),
			keys_last = keys.length - 1;

		// If the first keys part contains [ and the last ends with ], then []
		// are correctly balanced.
		if ( /\[/.test( keys[0] ) && /\]$/.test( keys[ keys_last ] ) ) {
			// Remove the trailing ] from the last keys part.
			keys[ keys_last ] = keys[ keys_last ].replace( /\]$/, '' );

			// Split first keys part into two parts on the [ and add them back onto
			// the beginning of the keys array.
			keys = keys.shift().split('[').concat( keys );

			keys_last = keys.length - 1;
		} else {
			// Basic 'foo' style key.
			keys_last = 0;
		}

		// Are we dealing with a name=value pair, or just a name?
		if ( param.length === 2 ) {
			val = decodeURIComponent( param[1] );

			// Coerce values.
			if ( coerce ) {
				val = val && !isNaN(val)            ? +val              // number
					: val === 'undefined'             ? undefined         // undefined
					: coerce_types[val] !== undefined ? coerce_types[val] // true, false, null
					: val;                                                // string
			}

			if ( keys_last ) {
				// Complex key, build deep object structure based on a few rules:
				// * The 'cur' pointer starts at the object top-level.
				// * [] = array push (n is set to array length), [n] = array if n is
				//   numeric, otherwise object.
				// * If at the last keys part, set the value.
				// * For each keys part, if the current level is undefined create an
				//   object or array based on the type of the next keys part.
				// * Move the 'cur' pointer to the next level.
				// * Rinse & repeat.
				for ( ; i <= keys_last; i++ ) {
					key = keys[i] === '' ? cur.length : keys[i];
					cur = cur[key] = i < keys_last ? cur[key] || ( keys[i+1] && isNaN( keys[i+1] ) ? {} : [] ) : val;
				}

			} else {
				// Simple key, even simpler rules, since only scalars and shallow
				// arrays are allowed.

				if ( $.isArray( obj[key] ) ) {
					// val is already an array, so push on the next value.
					obj[key].push( val );

				} else if ( obj[key] !== undefined ) {
					// val isn't an array, but since a second value has been specified,
					// convert val into an array.
					obj[key] = [ obj[key], val ];

				} else {
					// val is a scalar.
					obj[key] = val;
				}
			}

		} else if ( key ) {
			// No value was defined, so set something meaningful.
			obj[key] = coerce ? undefined : '';
		}
	});

	return obj;
}

(function () {
	'use strict';
	var queryString = {};

	queryString.parse = function (str) {
		if (typeof str !== 'string') {
			return {};
		}

		str = str.trim().replace(/^\?/, '');

		if (!str) {
			return {};
		}

		return str.trim().split('&').reduce(function (ret, param) {
			var parts = param.replace(/\+/g, ' ').split('=');
			var key = parts[0];
			var val = parts[1];

			key = decodeURIComponent(key);
			// missing `=` should be `null`:
			// http://w3.org/TR/2012/WD-url-20120524/#collect-url-parameters
			val = val === undefined ? null : decodeURIComponent(val);

			if (!ret.hasOwnProperty(key)) {
				ret[key] = val;
			} else if (Array.isArray(ret[key])) {
				ret[key].push(val);
			} else {
				ret[key] = [ret[key], val];
			}

			return ret;
		}, {});
	};

	queryString.stringify = function (obj) {
		return obj ? Object.keys(obj).map(function (key) {
			var val = obj[key];

			if (Array.isArray(val)) {
				return val.map(function (val2) {
					return encodeURIComponent(key) + '=' + encodeURIComponent(val2);
				}).join('&');
			}

			return encodeURIComponent(key) + '=' + encodeURIComponent(val);
		}).join('&') : '';
	};

	queryString.push = function (key, new_value) {
		var params = queryString.parse(location.search);
		params[key] = new_value;
		var new_params_string = queryString.stringify(params)
		history.pushState({}, "", window.location.pathname + '?' + new_params_string);
	}

	if (typeof module !== 'undefined' && module.exports) {
		module.exports = queryString;
	} else {
		window.queryString = queryString;
	}
})();

function doRefineFilter(){
	$(".submit_filter").on("click",function(){
		common_refine_filter();
	});
	$(".sort_filter").on("change",function(){
		common_refine_filter();
	});
}

if($("#listing_tbl").length>0){
	init_sidebar_filters();
	get_category_by_parent();
}

function init_sidebar_filters(){
	var viewportWidth = $(window).width();
	// if(viewportWidth<=991){
	// 	$('.desktopView').remove();
	// }else{
	// 	$('.mobileView').remove();			
	// }
	init_range_slider();
	assignValueToFilter();
	doRefineFilter();		
}

function assignValueToFilter(){
	//var page = window.location.hash.substr(1);
	var page = document.URL.split("?");
	var page = page[1];
	if(page!=undefined) {
		var q = deparam(page);
		var msg = JSON.stringify(q);
		var result = $.parseJSON(msg);

		$.each(result, function (k, v) {
			if (typeof v == 'object') {
				v = v;
			} else {
				v = $.makeArray(v);
			}
			for (var a = 0; a < v.length; a++) {
				$('[data-type=' + k + ']').each(function () {
					var val = $(this).val();
					if (jQuery.inArray(val, v) >= 0) {
						$(this).prop("checked", true);
						$(this).attr("selected", true);
					}
				});
			}
		});
		var search = GetURLParameter("q");
	}
	if(search!=undefined){
		$('#search').val(search); $('#prd-search').val(search); 
	}
	common_refine_filter();
}

function init_range_slider(){
    $(".area_filter").each(function () {
        var minRangeValue = $(this).attr('data-min');
        var maxRangeValue = $(this).attr('data-max');
        var minName = $(this).attr('data-min-name');
        var maxName = $(this).attr('data-max-name');
        var unit = $(this).attr('data-unit');

        $(this).append("" +
            "<span class='min-value'></span> " +
            "<span class='max-value'></span>" +
            "<input class='current-min refine_filter' type='hidden' data-type='min-area' data-name='min-area' data-min='"+minRangeValue+"' data-min='"+maxRangeValue+"'  name='"+minName+"'>" +
            "<input class='current-max refine_filter' type='hidden' data-type='max-area' data-name='max-area' data-min='"+minRangeValue+"' data-min='"+maxRangeValue+"'  name='"+maxName+"'>"
        );
        $(this).slider({
            range: true,
            min: minRangeValue,
            max: maxRangeValue,
            values: [minRangeValue, maxRangeValue],
            slide: function (event, ui) {
                event = event;
                var currentMin = parseInt(ui.values[0], 10);
                var currentMax = parseInt(ui.values[1], 10);
                $(this).children(".min-value").text( currentMin + " " + unit);
                $(this).children(".max-value").text(currentMax + " " + unit);
                $(this).children(".current-min").val(currentMin);
                $(this).children(".current-max").val(currentMax);
            }
        });

        var currentMin = parseInt($(this).slider("values", 0), 10);
        var currentMax = parseInt($(this).slider("values", 1), 10);
        $(this).children(".min-value").text( currentMin + " " + unit);
        $(this).children(".max-value").text(currentMax + " " + unit);
        $(this).children(".current-min").val(currentMin);
        $(this).children(".current-max").val(currentMax);
    });

    $(".price_filter").each(function () {
        var minRangeValue = $(this).attr('data-min');
        var maxRangeValue = $(this).attr('data-max');
        var minName = $(this).attr('data-min-name');
        var maxName = $(this).attr('data-max-name');
        var unit = $(this).attr('data-unit');

        $(this).append("" +
            "<span class='min-value'></span> " +
            "<span class='max-value'></span>" +
            "<input class='current-min refine_filter' type='hidden' data-type='min-price' data-name='min-price' data-min='"+minRangeValue+"' data-min='"+maxRangeValue+"' name='"+minName+"'>" +
            "<input class='current-max refine_filter' type='hidden' data-type='max-price' data-name='max-price' data-min='"+minRangeValue+"' data-min='"+maxRangeValue+"'  name='"+maxName+"'>"
        );
        $(this).slider({
            range: true,
            min: minRangeValue,
            max: maxRangeValue,
            values: [minRangeValue, maxRangeValue],
            slide: function (event, ui) {
                event = event;
                var currentMin = parseInt(ui.values[0], 10);
                var currentMax = parseInt(ui.values[1], 10);
                $(this).children(".min-value").text( currentMin + " " + unit);
                $(this).children(".max-value").text(currentMax + " " + unit);
                $(this).children(".current-min").val(currentMin);
                $(this).children(".current-max").val(currentMax);
            }
        });

        var currentMin = parseInt($(this).slider("values", 0), 10);
        var currentMax = parseInt($(this).slider("values", 1), 10);
        $(this).children(".min-value").text( currentMin + " " + unit);
        $(this).children(".max-value").text(currentMax + " " + unit);
        $(this).children(".current-min").val(currentMin);
        $(this).children(".current-max").val(currentMax);
    });
}


function emptyValueToFilter(){
	var page = document.URL.split("?");
	var page = page[1];
	var q = deparam(page);
	var msg = JSON.stringify(q);
	var result = $.parseJSON(msg);
	$.each(result, function(k, v) {
		var id = $('[data-type='+k+']').attr('id') ;
		$('#'+id).val("");
	});
}

function GetURLParameter(sParam) {
	var page = document.URL.split("?");
	var sPageURL = page[1];
	if(sPageURL!=undefined) {
		//var sPageURL = window.location.hash.substring(1);
		var sURLVariables = sPageURL.split('&');
		for (var i = 0; i < sURLVariables.length; i++) {
			var sParameterName = sURLVariables[i].split('=');
			if (sParameterName[0] == sParam) {
				return sParameterName[1];
			}
		}
	}
}

function removeURLParameter(url, key, val) {
	//prefer to use l.search if you have a location/link object
	val=val.replace(/\ /g,'+');
	var urlparts= url.split('?');
	if (urlparts.length>=2) {

		var prefix= encodeURIComponent(key)+'='+val;

		var pars= urlparts[1].split(/[&;]/g);
		//reverse iteration as may be destructive
		for (var i= pars.length; i-- > 0;) {
			//idiom for string.startsWith
			if (pars[i].lastIndexOf(prefix, 0) !== -1) {
				pars.splice(i, 1);
			}
		}

		url= urlparts[0]+'?'+pars.join('&');
		return url;
	} else {
		return url;
	}
}

function common_refine_filter(){
	filteration(1);
}

function filteration(page){
	var parameter = [];
	var refine_filter_arr = [];
	$('input.refine_filter,.refine_filter option:selected,.refine_pfilter option:selected').each(function () {
		if($(this).val()!="" && $(this).val()!=0 && $(this).val()!='all'){
			var dtype = $(this).attr("data-type")
			var value = $(this).val();
			refine_filter_arr.push({'type':dtype,'value':value});
			parameter.push({'name':dtype,'value':value});
		}
	});

	var recursiveEncoded = "?";
	recursiveEncoded += $.param( parameter, true  );
	history.pushState("","",recursiveEncoded);
	ajaxloading('Loading properties...');
	$.post(urljs+"properties/get_listings",{'page':page,"filter_data":refine_filter_arr},function(data){
	   	closeajax();
	   	//goToByScroll('#goto-scroll-area');
   		//console.log(data);
    	$("#listing_tbl").html(data.str);
		$(".pagination_div").html(data.paginate);
		$(".prd_counts").html(data.counts);
		doRefineFilter();
		filter_pagination();
	},'json');

}

function filter_pagination(){
	$(".pagination").on( "click",".page-item a", function (e){
		e.preventDefault();
		var page = $(this).attr("data-page");
		//window.location = "#"+page;
		filteration(page);
	});

}

function goToByScroll(id){
      // Remove "link" from the ID
    id = id.replace("link", "");
      // Scroll
    jQuery('html,body').animate({
        scrollTop: jQuery(id).offset().top},
        'slow');
    $('.sidebar-title').trigger('click');
}


function get_category_by_parent(){
	$('#property_type').on('change',function(e){
		e.preventDefault();
		$('#category_type').html('<option value="">Loading categories...</option>');
		var parent=$(this).val();
		$.post(urljs+"properties/get_sub_categories",{'parent':parent},function(data){
	      if(data.result=='success'){
	      	var data_items='';
	      	var datas = data.data_list;
	      	if(datas.length>0){
		      	for(i=0;i<datas.length;i++){
			      	data_items+='<option data-name="category" data-type="category" value="'+datas[i].slug+'">'+datas[i].text+'</option>';
			    }
			    $('#category_type').html('<option data-name="category" data-type="category" value="all">All Categories</option>');
			    $('#category_type').append(data_items);
			}else{
				$('#category_type').html('<option data-name="category" data-type="category" value="all">All Categories</option>');
			}
	      }else {
	        swal("Error!", data.msg, "warning");
	      }
	    },"json");
	});
}

if($("#callback_form").length>0){
	callback_form();
	side_callback_form();
}

function callback_form(){
	$('#callback_form').validate({		
		errorClass: 'error',
		validClass: 'valid',
		rules: {
			email: {required: true},
			name: {required: true},
			phone: {required: true}
		},
		messages:{
			email: { required: "Please provide your email address"},
			name: { required: "Please provide your name" },
			phone: { required: "Please provide your phone number"}
		},	
		submitHandler: function(){
          	var formdata = new FormData($('#callback_form')[0]);
          	var p_code=$('#p_code').attr('data-val');
          	if(p_code!='' && p_code!='undefined'){
		      formdata.append('p_code',p_code);
		    }
          	formdata.append('p_code',p_code);
            $["ajax"]({
               url: urljs+'properties/save_callback',
               type: "POST",
               dataType: "json",
               data: formdata,
               contentType: false,
               cache: false,
               processData: false,
               	beforeSend: function() {
                   show_btn_load('#callback_form','Please Wait...');
               	},
               	success: function(data) {
                   	close_btn_load('#callback_form');
                   	if(data.result=='success'){
                   		$('#callback_form')[0].reset();
                   		successResult('callback_form',data.msg);
                   	}else{
                   		failureResult('callback_form',data.msg);
                   	}
               },
               error: function() {}
           })		
		}
	});
}

function side_callback_form(){
	$('#s_callback_form').validate({		
		errorClass: 'error',
		validClass: 'valid',
		rules: {
			email: {required: true},
			name: {required: true},
			phone: {required: true}
		},
		messages:{
			email: { required: "Please provide your email address"},
			name: { required: "Please provide your name" },
			phone: { required: "Please provide your phone number"}
		},	
		submitHandler: function(){
          	var formdata = new FormData($('#s_callback_form')[0]);
          	var p_code=$('#p_code').attr('data-val');
          	if(p_code!='' && p_code!='undefined'){
		      formdata.append('p_code',p_code);
		    }
            $["ajax"]({
               url: urljs+'properties/save_callback',
               type: "POST",
               dataType: "json",
               data: formdata,
               contentType: false,
               cache: false,
               processData: false,
               	beforeSend: function() {
                   show_btn_load('#s_callback_form','Please Wait...');
               	},
               	success: function(data) {
                   	close_btn_load('#s_callback_form');
                   	if(data.result=='success'){
                   		$('#s_callback_form')[0].reset();
                   		successResult('s_callback_form',data.msg);
                   	}else{
                   		failureResult('s_callback_form',data.msg);
                   	}
               },
               error: function() {}
           })		
		}
	});
}
