if($("#contactForm").length>0){
	save_contact();
}

function save_contact(){
	$('#contactForm').validate({
		errorClass: 'error',
		validClass: 'valid',
		rules: {
      name: {required: true},
			email: {required: true},
			phone: {
        required: true,
        minlength: 10,
        maxlength: 10
      }
		},
		messages:{
      name: { required: "Please provide your name" },
			email: { required: "Please provide your email address"},
			phone: { required: "Please provide your phone number"}
		},	
		submitHandler: function(){
        var formdata = new FormData($('#contactForm')[0]);
        $["ajax"]({
           url: urljs+'forms/save_contact',
           type: "POST",
           dataType: "json",
           data: formdata,
           contentType: false,
           cache: false,
           processData: false,
           	beforeSend: function() {
               show_btn_load('#contactForm','Please Wait...');
           	},
           	success: function(data) {
               	close_btn_load('#contactForm');
               	if(data.status=='success'){
               		$('#contactForm')[0].reset();               		
                  swal('Success',data.msg,'success');
                }else{
                  swal('Failed',data.msg,'warning');
                }
           },
           error: function() {}
       })
      }
	});
}

if($("#careerForm").length>0) {
  save_career();
}

function save_career(){
	$('#careerForm').validate({
		errorClass: 'error',
		validClass: 'valid',
		rules: {
      name: {required: true},
			email: {required: true},
			phone: {
        required: true,
        minlength: 10,
        maxlength: 10
      },
      'resume[]': {required: true}
		},
		messages:{
      name: { required: "Please provide your name" },
			email: { required: "Please provide your email address"},
			phone: { required: "Please provide your phone number"},
      'resume[]': { required: "Please upload your resume" }
		},	
		submitHandler: function(){
        var formdata = new FormData($('#careerForm')[0]);
        $["ajax"]({
           url: urljs+'forms/save_career',
           type: "POST",
           dataType: "json",
           data: formdata,
           contentType: false,
           cache: false,
           processData: false,
           	beforeSend: function() {
               show_btn_load('#careerForm','Please Wait...');
           	},
           	success: function(data) {
               	close_btn_load('#careerForm');
               	if(data.status=='success'){
                  $('#careerForm')[0].reset();               		
                  swal('Success',data.msg,'success');
                }else{
                  swal('Failed',data.msg,'warning');
                }
           },
           error: function() {}
       })
      }
	});
}

if($("#productDemoForm").length>0){
	save_demo();
}

function save_demo(){
	$('#productDemoForm').validate({
		errorClass: 'error',
		validClass: 'valid',
		rules: {
      name: {required: true},
			email: {required: true},
			phone: {
        required: true,
        minlength: 10,
        maxlength: 10
      },
      products: {required: true}
		},	
		submitHandler: function(){
        var formdata = new FormData($('#productDemoForm')[0]);
        $["ajax"]({
           url: urljs+'request_demo/save_form',
           type: "POST",
           dataType: "json",
           data: formdata,
           contentType: false,
           cache: false,
           processData: false,
           	beforeSend: function() {
               show_btn_load('#productDemoForm','Please Wait...');
           	},
           	success: function(data) {
               	close_btn_load('#productDemoForm');
               	if(data.result=='success'){
               		$('#productDemoForm')[0].reset();               		
                  successResult('productDemoForm',data.msg);
                }else{
                  failureResult('productDemoForm',data.msg);
                }
           },
           error: function() {}
       })
      }
	});
}

function initImageUpload(){
  var drEvent= $('.dropify').dropify({
      messages: {
          'default': 'Drag and drop a file here or click',
          'replace': 'Drag and drop or click to replace',
          'remove': 'Remove',
          'error': 'Ooops, something wrong appended.'
      },
      error: {
          //'fileSize': 'The file size is too big (2M max).'
      },
  });
}