if($("#usersTbl").length>0){		
	get_users(1);
}
function filter(){
	$(".filter").on("click",function(e){
		e.preventDefault();
		var page=1;
		$("#pagenumber").val(page);
		get_users(page);
	});

	$("#result").on( "click",".pagination a", function (e){
		e.preventDefault();		
		var page = $(this).attr("data-page");
		$("#pagenumber").val(page);
		//window.location = "#"+page;
		get_users(page);
	});
}

function get_users(page){		
	ajaxloading('Loading, Please wait..');		
	var refine_filter_arr = [];
	var parameter = [];	
	jQuery('.refine_filter option:selected,input.refine_filter').each(function () {
		refine_filter_arr.push({'type':$(this).attr("data-type"),'value':$(this).val()});
		parameter.push({'name':$(this).attr('data-type'),'value':$(this).val()});
	});
	var recursiveEncoded = $.param( parameter, true );
	//alert(recursiveEncoded);
	//window.location.hash = recursiveEncoded;
	$.post(urljs+"admin/users/get_users",{"csrf_test_name":csrf_test_name,"page":page,'filter_data':refine_filter_arr,},function(data){
		$("#usersTbl").html(data.result);
		closeajax();
		filter();
		delete_user();
		change_userstatus();
	},"json");
}

function delete_user(){
	$('.deladminusr').click(function(){
		var mappingId=$(this).attr('data-id');
		swal({
			title: "You are about to delete this user",
			text: "It cannot be restored at a later time! Continue?",
			type: "warning",
			showCancelButton: true,
			cancelButtonClass: 'btn-secondary waves-effect',
			confirmButtonColor: "#DD6B55",
			confirmButtonText: "Yes",
			cancelButtonText: "No",
			closeOnConfirm: false,
			closeOnCancel: false
		}).then (function (isConfirm) {   
		if (isConfirm.value) { 
				//ajaxloading('Please wait...');
				$.post(urljs+"admin/users/deluser",{'id':mappingId},function(data){
					//closeajax();
					if(data.result==-1){						
						swal("Failed!", data.msg,'warning');
					}else {	
						if(data.canDelete===0){
							swal("Cannot delete", "User linked with other datas!!!", "warning");
						}else{
							//swal("Success!", "Record deleted", "success");
							getAdminUsers();
						}
					}
				},"json");
			} 
		});
	});
}	
function change_userstatus(){
	$('.adminusrStatus').click(function(){
		var id=$(this).attr("data-id");
		var status=$(this).attr("data-val");
		console.log(status);
		var obj=$(this);	
		//ajaxloading('Updating please wait...');
		$.post(urljs+"admin/users/status",{'id':id,'status':status},function(data){
			//closeajax();
			if(data.result>0){
				if(status==1){
					obj.removeClass("b_confirmed");
					obj.addClass("b_pending");
					obj.html("Inctive");
					obj.attr("data-val",0);
				}else{
					obj.removeClass("b_pending");
					obj.addClass("b_confirmed");
					obj.html("Active");
					obj.attr("data-val",1);
				}
				getAdminUsers();
			}
			else{
				swal("Failed!", data.msg,'warning');
			}
		},"json");
	});
}


if($('#addedit_userform').length>0){		
	add_edit_adminusers();
}

function add_edit_adminusers(){
	$('#addedit_userform').validate({
		errorClass: 'error',
		validClass: 'valid',
		rules: {
			firstName: { required: true},
			lastName: { required: true},
			username: {
				required: true,
				remote: {
				url: urljs+"admin/users/checkusername",
				type: "post",
				data:{
					edit: function() {						
						return $("[name=username]").attr("data-edit");
					}					
					}
				}
			},
			email :{
				required:true,
				email:true,
				remote: {
				url: urljs+"admin/users/checkemail",
				type: "post",
				data:{
					edit: function() {						
						return $("[name=email]").attr("data-edit");
					}					
					}
				}
			},
			password: { required: true, minlength:6},
			cpassword: { required: true, minlength: 6 ,equalTo:"[name=password]"},
			roleId: { required: true}
		},
		messages:{
			firstName: { required: "Please enter first name"},
			lastName: { required: "Please enter last name"},
			username: { required: "Please enter username",remote: "Username already exists!!!"},
			email: { required: "Please enter email address",email:"Please enter a valid email",remote: "Email address already exists!!!"},
			password: { required: "Please enter password",minlength:"Minimum length is 6"},
			cpassword:{required: "Please confirm the Password",minlength: "Password should contain atleast 6 characters!",equalTo:"Password mismatch!"},
			roleId:{required: "Please select the role"}
		},	
		submitHandler: function(){
			ajaxloading('Saving, please wait...');
			var admin=$('#addedit_userform').serializeArray();
			$.post(urljs+"admin/users/saveuser",admin,function(data){
				closeajax();
				if(data.result=='success'){
				   swal(data.msg,'','success').then (function (isConfirm) {
						if (isConfirm.value) {
							window.location=urljs+"admin/users";
						}
					});
				}
				else{
					swal(data.msg,'','warning');
				}
					//getadminusers();
			},"json");

		}
	});
}
