if($("#testimonialTbl").length>0){
    get_datas();
    add_member();
}

function filter(){
  $(".filter").on("click",function(e){
    e.preventDefault();
    var page=1;
    $("#pagenumber").val(page);
    get_datas(page);
  });
  
  $("#clearFilter").on("click",function(e){
    e.preventDefault();
    $('#adv-search').find('input.clearAbleFilt,select.clearAbleFilt').val('');
    $('#adv_filter_form').find('input.clearAbleFilt,select.clearAbleFilt').val('');
    $(".filter").click();
  });

  $("#result").on( "click",".pagination a", function (e){
    e.preventDefault();   
    var page = $(this).attr("data-page");
    $("#pagenumber").val(page);
    //window.location = "#"+page;
    get_datas(page);
  });
}

function get_datas(page){ 
  ajaxloading('Loading datas...');  
  var refine_filter_arr = [];
  var parameter = [];
  jQuery('.refine_filter option:selected,input.refine_filter').each(function () {
    refine_filter_arr.push({'type':$(this).attr("data-type"),'value':$(this).val()});
    parameter.push({'name':$(this).attr('data-type'),'value':$(this).val()});
  });
  var recursiveEncoded = $.param( parameter, true  );
  //window.location.hash = recursiveEncoded;
  $.post(urljs+"admin/testimonials/get_datas",{"page":page,'filter_data':refine_filter_arr,},function(data){
    $("#testimonialTbl").html(data.msg);
    $('[data-toggle="tooltip"]').tooltip();
    closeajax();
    filter();
    edit_member();
    delete_data();
  },"json");
}

function delete_data(){
  $('.btn-delPost').on('click',function() {
    var id=$(this).attr('data-id');
        swal({
            name: "Are you sure?",
            text: "You are about to delete the testimonials",
            type: "warning",
            showCancelButton: true,
            cancelButtonClass: 'btn-secondary waves-effect',
            confirmButtonClass: 'btn-success',
            confirmButtonText: "Yes, delete it!",
            closeOnConfirm: true
        }).then(function(isConfirm) {
          if (isConfirm.value) {
            ajaxloading('Processing your request<br>Please wait...');
            $.post(urljs+'admin/testimonials/delete_post',{'id':id},function(data){
                closeajax();
                if(data.result=='success'){
                  get_datas();
                  show_toast('success',data.msg);
                }else{
                  show_toast('error',data.msg);
                }
            },"json");
          }
        });  
    });
}

function add_member(){
  $(".btn-addMember").on("click", function (e){
    e.preventDefault();
    var dataModal = bootbox.dialog({
        name: 'Add New testimonials',
        designation: 'Add Designation',
        description: 'Add Description',
        message: '<i class="fa fa-spinner fa-spin"></i> Loading, Please wait...',
        closeButton: true,
        size: 'medium',
        animate:true,
        className: "addPostView",
    });
    $.post(urljs+"admin/testimonials/add",'',function(data){
      dataModal.find('.bootbox-body').html(data.msg);
      save_member();
    },"json");
  });
}


function edit_member(){
  $(".btn-editMember").on("click", function (e){
    e.preventDefault();
    var id=$(this).attr('data-id');
    var dataModal = bootbox.dialog({
        name: 'Edit testimonials',
        designation: 'Edit Designation',
        description: 'Add Description',
        message: '<i class="fa fa-spinner fa-spin"></i> Loading, Please wait...',
        closeButton: true,
        size: 'medium',
        animate:true,
        className: "addPostView",
    });
    $.post(urljs+"admin/testimonials/edit",{'id':id},function(data){
      dataModal.find('.bootbox-body').html(data.msg);
      initImageUpload();
      save_member();
    },"json");
  });
}

function save_member(){
  $('#post_form').validate({
    errorClass: 'error',
    validClass: 'valid',
    rules: {
      name:{required: true},
      designation:{required: true},
      description:{required: true}
    },
    messages:{
      name:{required: "Please provide the name"},
      designation:{required: "Please provide the designation"},
      description:{required: "Please provide the description"}
    },
    submitHandler: function(e){
      //e.preventDefault();
      var formdata = new FormData($('#post_form')[0]);
        //formdata.append('description',editorInput);
        $["ajax"]({
          url: urljs+"admin/testimonials/save_member",
          type: "POST",
          dataType: "json",
          data: formdata,
          contentType: false,
          cache: false,
          processData: false,
          beforeSend: function() {
              show_btn_load('#post_form','Saving...');
          },
          success: function(data) {
            close_btn_load('#post_form');
            if(data.result=='success'){
              $('.bootbox.addPostView').find('.bootbox-close-button').trigger('click');
              swal('Success',data.msg,'success').then(function(isConfirm) {
                  if (isConfirm.value) {
                    window.location.href=urljs+'admin/testimonials';
                  }else{
                    window.location.href=urljs+'admin/testimonials';
                  }
              });
            }else{
            	failureResult('post_form',data.msg);
            }
            closeajax();
          },
          error: function() {}
        })
      }
  });
}