	if($("#rolesTbl").length>0){		
		get_roles(1);
		add_role();
	}

	function add_role(){
		$(".addRole").on("click",function(e){
			e.preventDefault();
			var dataModal = bootbox.dialog({
		      title: 'Add User Role',
		      message: '<i class="fa fa-spinner fa-spin"></i> Loading, Please wait...',
		      closeButton: true,
		      centerVertical:true,
		      size: 'medium',
		      animate:true,
		      className: "rolesView mediumView",
		    });
			$.post(urljs+"admin/roles/add_role",'',function(data){
				if(data.result=='success'){
		        	dataModal.find('.bootbox-body').html(data.msg);
		        	add_edit_role();
		      	}else {
		        	swal("Error!", data.msg, "warning");
		      	}
			},"json");
		});
	}
	
	function edit_role(){
		$(".editRole").on("click",function(e){
			e.preventDefault();
			var id=$(this).attr('data-id');
			var dataModal = bootbox.dialog({
		      title: 'Edit User Role',
		      message: '<i class="fa fa-spinner fa-spin"></i> Loading, Please wait...',
		      closeButton: true,
		      centerVertical:true,
		      size: 'medium',
		      animate:true,
		      className: "rolesView mediumView",
		    });
			$.post(urljs+"admin/roles/edit_role",{'id':id},function(data){
				if(data.result=='success'){
		        	dataModal.find('.bootbox-body').html(data.msg);
		        	add_edit_role();
		      	}else {
		      		dataModal.find('.bootbox-body').html("Unable to process your request");
		        	//swal("Error!", "Unable to process your request", "warning");
		      	}
			},"json");
		});
	}

	function add_edit_role(){	
		$('#addedit_role_form').validate({
			errorClass: 'error',
			validClass: 'valid',
			rules: {
				name :{
					required:true,
					remote: {
                        url: urljs+"admin/roles/check_name",
                        type: "post",
                        data:{
                            edit: function() {                      
                                return $("[name=name]").attr("data-edit");
                            }                       
                        }
                    }
				}
			},
			messages:{
				name: { required: "Please enter role name",remote:"Role already exists, please choose another name"}
			},	
			submitHandler: function(){
				show_btn_load('#addedit_role_form','Saving...');
				var admin=$('#addedit_role_form').serializeArray();
				$.post(urljs+"admin/roles/save_role",admin,function(data){
					show_btn_load('#addedit_role_form');
					if(data.result=='success'){
						$('.bootbox.modal.rolesView').find('.bootbox-close-button').trigger('click');
						get_roles();
					   	show_toast('success',data,msg);
					}else{
						failureResult('addedit_role_form','Unable to process your request');
					}					
				},"json");

			}
		});
	}

	function filter(){
		$(".filter").on("click",function(e){
			e.preventDefault();
			var page=1;
			$("#pagenumber").val(page);
			get_roles(page);
		});
		$("#result").on( "click",".pagination a", function (e){
			e.preventDefault();		
			var page = $(this).attr("data-page");
			$("#pagenumber").val(page);
			window.location = "#"+page;
			get_roles(page);
		});
	}

	function get_roles(page){		
		ajaxloading('Loading...please wait...');		
		var refine_filter_arr = [];
		var parameter = [];	
		jQuery('.refine_filter option:selected,input.refine_filter').each(function () {
			refine_filter_arr.push({'type':$(this).attr("data-type"),'value':$(this).val()});
			parameter.push({'name':$(this).attr('data-type'),'value':$(this).val()});
		});
		var recursiveEncoded = $.param( parameter, true );
		//alert(recursiveEncoded);
		//window.location.hash = recursiveEncoded;
		$.post(urljs+"admin/roles/getroles",{"csrf_test_name":csrf_test_name,"page":page,'filter_data':refine_filter_arr,},function(data){
			$("#rolesTbl").html(data.msg);
			edit_role();
			filter();
			closeajax();
		},"json");
	}

if($('#edit_permissions').length>0){
	$('.tree').treegrid();
	$('.tree-2').treegrid({
		expanderExpandedClass: 'fa fa-minus',
		expanderCollapsedClass: 'fa fa-plus'
	});
}

	function permissionstatus(id, stat,adminuserId) {
		var statclone = $('#status' + id).html();
	    $('#status' + id).html("<img src='" + urljs + "ui/loaders/1.gif'/>");

	    $.ajax({
	        url: urljs +"admin/roles/permissionstatus",
	        type: 'post',
	        dataType: 'json',
			timeout: 5000,
	        data: {
	            'id': id,
				//"csrf_test_name":$.cookie('csrf_cookie_name'),
	            stat: stat,
				adminuserId: adminuserId
	        },
	        success: function(data) {
				
				if(data.status=="fail"){
					$('#status' + id).html(statclone);
					swal({type: 'error', title:"Fail!",html: data.message});	
					
				}else{
				
	           if ((data.result == "activatesuccess")||(data.result == "deactivatefail")) {
	                $('#status' + id).html(' <span class="btn btn-sm btn-success" style="cursor:pointer;" onclick=permissionstatus("' + id + '","astatus","' + adminuserId + '")><i class="fa fa-check" aria-hidden="true"></i> Allow</span>');

	            } else if ((data.result == "deactivatesuccess")||(data.result == "activatefail")) {
	                $('#status' + id).html(' <span class="btn btn-sm btn-danger" style="cursor:pointer;" onclick=permissionstatus("' + id + '","instatus","' + adminuserId + '")><i class="fa fa-ban" aria-hidden="true"></i> Block</span>');
	            }  else if(data.result=="fail"){
					swal("Error!", data.msg, "error");
					 $('#status' + id).html(statclone);
				}
				}

	        },
			error: function(x, t, m) {
	        if(t==="timeout") {
	            show_toast("error","Got timeout");
	        } else {
	            show_toast("error","Try again later..");
	        }
	    }

	    });
	}