if($(".rptsearch").length>0){
    $('.input-limit-datepicker').daterangepicker({
       	locale: {
            format: 'YYYY/MM/DD'
        },
        minDate: '01/04/2019',
        maxDate: new Date(),
        buttonClasses: ['btn', 'btn-sm'],
        applyClass: 'btn-custom',
        cancelClass: 'btn-secondary',
        dateLimit: {
            months: 2
        }
    });
    update_stat_options();

}

$('.rptsearch').click(function(){
	getreports();
});

$('.rptdownload').click(function(){
	download_report();
});

function update_stat_options(){
$('[name=module]').on('change',function(e){
	e.preventDefault();
	var o=$(this).val();
	if(o=='enquiries'){
		$("[name=status]").html('');
		$("[name=status]").append('<option value=>--All--</option>');
		$("[name=status]").append('<option value="in process">In Process</option>');
		$("[name=status]").append('<option value="converted">Converted</option>');
		$("[name=status]").append('<option value="dead">Dead</option>');
		$("[name=dateType]").html('');
		$("[name=dateType]").append('<option value="createdDate">Created Date</option>');
		$("[name=dateType]").append('<option value="updatedDate">Updated Date</option>');
		$("[name=dateType]").append('<option value="followupDate">Followup Date</option>');
	}else if(o=='tickets'){
		$("[name=status]").html(''); 
		$("[name=status]").append('<option value=>--All--</option>');
		$("[name=status]").append('<option value=1>Open</option>');
		$("[name=status]").append('<option value=0>Closed</option>');
		$("[name=dateType]").html('');
		$("[name=dateType]").append('<option value="createdDate">Created Date</option>');
		$("[name=dateType]").append('<option value="dueDate">Due Date</option>');
		$("[name=dateType]").append('<option value="closedDate">Closed Date</option>');
	}else if(o=='events'){
		$("[name=status]").html('');
		$("[name=status]").append('<option value=>--All--</option>');
		$("[name=dateType]").html('');
		$("[name=dateType]").append('<option value="createdDate">Created Date</option>');
		$("[name=dateType]").append('<option value="eventDate">Event Date</option>');
	}else if(o=='projects'){
		$("[name=status]").html('');
		$("[name=status]").append('<option value=>--All--</option>');
		$("[name=status]").append('<option value=1>Pending</option>');
		$("[name=status]").append('<option value=0>Completed</option>');
		$("[name=dateType]").html('');
		$("[name=dateType]").append('<option value="createdDate">Created Date</option>');
		$("[name=dateType]").append('<option value="endDate">Completed Date</option>');
	}

});
}

function getreports(){
	$('#report_form').validate({
		errorClass: 'error',
		validClass: 'valid',
		submitHandler: function(){
			if($("[name=module]").val() == ""){
				swal('Warning!','Please select the module','warning');
			}else if($("[name=from]").val() == "" || $("[name=to]").val() == ""){
				swal('Warning!','Please select the date range','warning');
			}
			else {
				ajaxloading('Fetching records..<br>please wait...');
				var admin=$('#report_form').serializeArray();
				$.post(urljs+"admin/reports/getreports",admin,function(data){
					closeajax();
					$(".display-report").show();
					$("#reportsTbl").html(data.str);
					$('[data-toggle="tooltip"]').tooltip(); 
					if(data.result=='success'){
						$(".rptdownload").show();
					}else{
						$(".rptdownload").hide();
					}
				},"json");
			}
		}
	});
}

function download_report(){	
	event.preventDefault();
	if($("[name=module]").val() == ""){
		swal('Warning!','Please select the module','warning');
	}else if($("[name=from]").val() == "" || $("[name=to]").val() == ""){
		swal('Warning!','Please select the date range','warning');
	}
	else {
		ajaxloading('Preparing please wait...');
		var admin=$('#report_form').serializeArray();
		$.post(urljs+"admin/reports/download",admin,function(data){
			closeajax();
			if(data.result=='success'){
				swal({
				title: "Selected report is ready for download!",
				type: "success",
				showCancelButton: true,
				cancelButtonClass: 'btn-secondary waves-effect',
				confirmButtonColor: "#3085d6",
				confirmButtonText: "Download",
				cancelButtonText: "Close",
				closeOnConfirm: false,
				closeOnCancel: false
				}).then (function (isConfirm) {   
				if (isConfirm.value) { 
					window.location.href = urljs+data.filepath;
				}
				});
			}else{
				swal("Failed!", "Data not found", "warning");
			}
		},"json");
	}
}
