if($("#propertyTbl").length>0){
    add_property();
    get_properties();
}

function filter(){
  $(".filter").on("click",function(e){
    e.preventDefault();
    var page=1;
    $("#pagenumber").val(page);
    get_properties(page);
  });
  
  $("#clearFilter").on("click",function(e){
    e.preventDefault();
    $('#adv-search').find('input.clearAbleFilt,select.clearAbleFilt').val('');
    $('#adv_filter_form').find('input.clearAbleFilt,select.clearAbleFilt').val('');
    $(".filter").click();
  });

  $("#result").on( "click",".pagination a", function (e){
    e.preventDefault();   
    var page = $(this).attr("data-page");
    $("#pagenumber").val(page);
    //window.location = "#"+page;
    get_properties(page);
  });
}

function get_properties(page){ 
  ajaxloading('Loading Properties...');  
  var refine_filter_arr = [];
  var parameter = [];
  jQuery('.refine_filter option:selected,input.refine_filter').each(function () {
    refine_filter_arr.push({'type':$(this).attr("data-type"),'value':$(this).val()});
    parameter.push({'name':$(this).attr('data-type'),'value':$(this).val()});
  });
  var recursiveEncoded = $.param( parameter, true  );
  //window.location.hash = recursiveEncoded;
  $.post(urljs+"admin/properties/get_datas",{"page":page,'filter_data':refine_filter_arr,},function(data){
    $("#propertyTbl").html(data.msg);
    $('[data-toggle="tooltip"]').tooltip();
    closeajax();
    filter();
    delete_property();
  },"json");
}

function delete_property(){
  $('.btn-delProperty').on('click',function() {
    var id=$(this).attr('data-id');
        swal({
            title: "Are you sure?",
            text: "You are about to delete the project "+id,
            type: "warning",
            showCancelButton: true,
            cancelButtonClass: 'btn-secondary waves-effect',
            confirmButtonClass: 'btn-success',
            confirmButtonText: "Yes, delete it!",
            closeOnConfirm: true
        }).then(function(isConfirm) {
          if (isConfirm.value) {
            ajaxloading('Processing your request<br>Please wait...');
            $.post(urljs+'admin/properties/delete_property',{'id':id},function(data){
                closeajax();
                if(data.result=='success'){
                  get_properties();
                  show_toast('success',data.msg);
                }else{
                  show_toast('error',data.msg);
                }
            },"json");
          }
        });  
    });
}




function add_property(){
	$(".btn-addProperty").on( "click", function (e){
		e.preventDefault();
		var dataModal = bootbox.dialog({
	      title: 'Add New Property',
	      message: '<i class="fa fa-spinner fa-spin"></i> Loading, Please wait...',
	      closeButton: true,
	      size: 'extra-large',
	      animate:true,
	      className: "addPropertyView largeWidth",
	    });
	    $.post(urljs+"admin/properties/add_new",'',function(data){
	      if(data.status=='success'){
	        dataModal.find('.bootbox-body').html(data.msg);
	        $('[data-toggle="tooltip"]').tooltip();
	        get_sub_categories();
	        save_new_property();
          show_cat_fields();
	      }else {
	        swal("Error!", data.msg, "warning");
	      }
	    },"json");
	});
}

function show_cat_fields(){
  $("#p_category").on("change", function(e){
    e.preventDefault();
    var parent_id=$(this).val();
    var items='';
    if(parent_id==16){      
      items='<div class="row"><div class="col-12"><h3>For Lands</h3></div>';
      items+='<div class="col-lg-3 col-12"><div class="form-group"><label>Length</label><input type="text" class="form-control" name="length"/></div></div>';
      items+='<div class="col-lg-3 col-12"><div class="form-group"><label>Width</label><input type="text" class="form-control" name="width"/></div></div>';
      items+='<div class="col-lg-3 col-12"><div class="form-group"><label>Road Width</label><input type="text" class="form-control" name="road_width"/></div></div>';
      items+='<div class="col-lg-3 col-12"><div class="form-group"><label>Frontage</label><input type="text" class="form-control" name="frontage"/></div></div>';
      items+='</div>';
    }else if(parent_id==15){
      items='<div class="row"><div class="col-12"><h3>For Offices</h3></div>';
      items+='<div class="col-lg-3 col-12"><div class="form-group"><label>Workstations</label><input type="text" class="form-control" name="wstations"/></div></div>';
      items+='<div class="col-lg-3 col-12"><div class="form-group"><label>Washrooms</label><input type="text" class="form-control" name="wrooms"/></div></div>';
      items+='<div class="col-lg-3 col-12"><div class="form-group"><label>Cabins</label><input type="text" class="form-control" name="cabins"/></div></div>';
      items+='<div class="col-lg-3 col-12"><div class="form-group"><label>Car Park</label><input type="number" class="form-control" name="garage" min="1"/></div></div>';
      items+='</div>';
    }else if(parent_id==13){
      items='<div class="row"><div class="col-12"><h3>For Resedentials</h3></div>';
      items+='<div class="col-lg-3 col-12"><div class="form-group"><label>Bedroom</label><input type="number" class="form-control" name="beds" min="1"/></div></div>';
      items+='<div class="col-lg-3 col-12"><div class="form-group"><label>Bathroom</label><input type="number" class="form-control" name="bathrooms min="1""/></div></div>';
      items+='<div class="col-lg-3 col-12"><div class="form-group"><label>Balcony</label><input type="number" class="form-control" name="balcony" min="1"/></div></div>';
      items+='<div class="col-lg-3 col-12"><div class="form-group"><label>No. of Units</label><input type="number" class="form-control" name="units" min="1"/></div></div>';
      items+='<div class="col-lg-3 col-12"><div class="form-group"><label>Car Park</label><input type="number" class="form-control" name="garage" min="1"/></div></div>';
      items+='</div>';
    }
    $('.category-fields').html(items);
  });

  $("#category").on("change", function(e){
    e.preventDefault();
    var parent_id=$('#p_category').val();
    var cat_id=$(this).val();
    var items='';
    if(cat_id==27){
      items='<div class="row"><div class="col-12"><h3>For Offices</h3></div>';
      items+='<div class="col-lg-3 col-12"><div class="form-group"><label>Workstations</label><input type="text" class="form-control" name="wstations"/></div></div>';
      items+='<div class="col-lg-3 col-12"><div class="form-group"><label>Washrooms</label><input type="text" class="form-control" name="bathrooms"/></div></div>';
      items+='<div class="col-lg-3 col-12"><div class="form-group"><label>Cabins</label><input type="text" class="form-control" name="cabins"/></div></div>';
      items+='<div class="col-lg-3 col-12"><div class="form-group"><label>Car Park</label><input type="number" class="form-control" name="garage" min="1"/></div></div>';
      items+='</div>';
    }else if(cat_id==28){
      items='<div class="row"><div class="col-12"><h3>For Industrials</h3></div>';
      items+='<div class="col-lg-3 col-12"><div class="form-group"><label>Power KW</label><input type="text" class="form-control" name="power_kw"/></div></div>';
      items+='<div class="col-lg-3 col-12"><div class="form-group"><label>Washrooms</label><input type="text" class="form-control" name="bathrooms"/></div></div>';
      items+='<div class="col-lg-3 col-12"><div class="form-group"><label>Ceiling Height</label><input type="text" class="form-control" name="ceiling_ht"/></div></div>';
      items+='<div class="col-lg-3 col-12"><div class="form-group"><label>Car Park</label><input type="number" class="form-control" name="garage" min="1"/></div></div>';
      items+='</div>';
    }else if(cat_id==29){
      items='<div class="row"><div class="col-12"><h3>For Retails</h3></div>';
      items+='<div class="col-lg-3 col-12"><div class="form-group"><label>Display Space</label><input type="text" class="form-control" name="d_space"/></div></div>';
      items+='<div class="col-lg-3 col-12"><div class="form-group"><label>Washrooms</label><input type="text" class="form-control" name="bathrooms"/></div></div>';
      items+='<div class="col-lg-3 col-12"><div class="form-group"><label>Ceiling Height</label><input type="text" class="form-control" name="ceiling_ht"/></div></div>';
      items+='<div class="col-lg-3 col-12"><div class="form-group"><label>Car Park</label><input type="number" class="form-control" name="garage" min="1"/></div></div>';
      items+='</div>';
    }else if(cat_id==30){
      items='<div class="row"><div class="col-12"><h3>For Warehouses</h3></div>';
      items+='<div class="col-lg-3 col-12"><div class="form-group"><label>Power KW</label><input type="text" class="form-control" name="power_kw"/></div></div>';
      items+='<div class="col-lg-3 col-12"><div class="form-group"><label>Washrooms</label><input type="text" class="form-control" name="bathrooms"/></div></div>';
      items+='<div class="col-lg-3 col-12"><div class="form-group"><label>Ceiling Height</label><input type="text" class="form-control" name="ceiling_ht"/></div></div>';
      items+='<div class="col-lg-3 col-12"><div class="form-group"><label>Car Park</label><input type="number" class="form-control" name="garage" min="1"/></div></div>';
      items+='</div>';
    }else if(parent_id==13){
      items='<div class="row"><div class="col-12"><h3>For Resedentials</h3></div>';
      items+='<div class="col-lg-3 col-12"><div class="form-group"><label>Bedroom</label><input type="number" class="form-control" name="beds" min="1"/></div></div>';
      items+='<div class="col-lg-3 col-12"><div class="form-group"><label>Bathroom</label><input type="number" class="form-control" name="bathrooms min="1""/></div></div>';
      items+='<div class="col-lg-3 col-12"><div class="form-group"><label>Balcony</label><input type="number" class="form-control" name="balcony" min="1"/></div></div>';
      items+='<div class="col-lg-3 col-12"><div class="form-group"><label>No. of Units</label><input type="number" class="form-control" name="units" min="1"/></div></div>';
      items+='</div>';
    }
    $('.category-fields').html(items);
  });
}

function get_sub_categories(){
	$("#p_category").on("change", function(e){
		e.preventDefault();
		$('#category').html('<option value="">Loading categories...</option>');
		var parent=$(this).val();
		$.post(urljs+"admin/categories/get_sub_categories",{'parent':parent},function(data){
	      if(data.result=='success'){
	      	var data_items='';
	      	var datas = data.data_list;
	      	if(datas.length>0){
		      	for(i=0;i<datas.length;i++){
			      	data_items+='<option value="'+datas[i].id+'">'+datas[i].text+'</option>';
			    }
			    $('#category').html('');
			    $('#category').append(data_items);
			}else{
				$('#category').html('');
				$('#category').append('<option value="">Loading categories...</option>');
			}
	      }else {
	        swal("Error!", data.msg, "warning");
	      }
	    },"json");
	});
}

function save_new_property(){
  $('#add_property_form').validate({
    errorClass: 'error',
    validClass: 'valid',
    rules: {
      title:{required: true},
      p_category:{required: true},
      category:{required: true},
      size:{required: true,number:true},
      location:{required: true},
      rera_no:{required: true},
      price:{required: true,number:true},
      sqft_price:{required: true,number:true},
      tot_sqft:{required: true,number:true},
      beds:{required: true,number:true},
      bathrooms:{required: true,number:true},
      //balcony:{required: true,number:true},
      //garage:{required: true,number:true},
      units:{required: true,number:true}
    },
    messages:{
      title:{required: "Please provide some title for this property"},
      p_category:{required: "Please select the property category"},
      category:{required: "Please select sub category"},
      size:{required: "Please enter the property size",number:"Please enter only numbers"},
      location:{required: "Please add the location"},
      rera_no:{required: "Please provide the RERA number"},
      tot_sqft:{required: "Please provide the total SQFT",number:"Please enter only numbers"},
      sqft_price:{required: "Please provide the price per SQFT",number:"Please enter only numbers"},
      price:{required: "Please provide the property price",number:"Please enter only numbers"},
      beds:{required: "Please select the number of beds",number:"Please enter only numbers"},
      bathrooms:{required: "Please select the number of bathrooms",number:"Please enter only numbers"},
      //balcony:{required: "Please select the number of balcony",number:"Please enter only numbers"},
      //garage:{required: "Please select the number of garage",number:"Please enter only numbers"},
      units:{required: "Please select the number of units",number:"Please enter only numbers"}
    },
    submitHandler: function(e){
      //e.preventDefault();
      var formdata = new FormData($('#add_property_form')[0]);
        //formdata.append('description',editorInput);
        $["ajax"]({
          url: urljs+"admin/properties/save_add_property",
          type: "POST",
          dataType: "json",
          data: formdata,
          contentType: false,
          cache: false,
          processData: false,
          beforeSend: function() {
              show_btn_load('#add_property_form','Submitting...');
          },
          success: function(data) {
            close_btn_load('#add_property_form');
            if(data.result=='success'){
            	get_properties();
            	$('.bootbox.addPropertyView').find('.bootbox-close-button').trigger('click');
              	if(data.urlredirect!=''){
              		swal('Success',data.msg,'success').then(function(isConfirm){
              			if(isConfirm.value){
              			window.location.href=urljs+data.urlredirect;
	              		}
    	          	})
        	    }else{
            		swal('Success',data.msg,'success');
              	}
            }else{
            	show_toast('error',data.msg);
            }
            closeajax();
          },
          error: function() {}
        })
      }
  });
}




if($('#content_page').length>0){
	update_status();
	edit_data();
	feature_image();
	floor_plan();
	update_video();
}

function edit_data(){
	$('.btn-dataEdit').on('click',function(e){
		e.preventDefault();
		var id=GetURLParameter('id');
		var type=$(this).attr('data-type');
		var title=type;
		if(type=='floor_plan'){
			title='Floor Plan';
		}
		var dataModal = bootbox.dialog({
	      title: "Edit "+title,
	      message: '<i class="fa fa-spinner fa-spin"></i> Loading, Please wait...',
	      closeButton: true,
	      size: 'extra-large',
	      animate:true,
	      centerVertical:true,
	      className: "addPropertyView largeWidth",
	    });
	    $.post(urljs+"admin/properties/get_update",{'id':id,'type':type},function(data){
	      if(data.result=='success'){
	        dataModal.find('.bootbox-body').html(data.msg);
	        get_sub_categories();
	        save_edit_details();
          show_cat_fields();
	        init_editor(type);
	        save_data(type);
	      }else {
	        swal("Error!", data.msg, "warning");
	      }
	    },"json");
	});
}

function save_edit_details(){
  $('#edit_property_form').validate({
    errorClass: 'error',
    validClass: 'valid',
    rules: {
      title:{required: true},
      p_category:{required: true},
      category:{required: true},
      size:{required: true,number:true},
      location:{required: true},
      rera_no:{required: true},
      sqft_price:{required: true,number:true},
      tot_sqft:{required: true,number:true},
      price:{required: true,number:true},
      beds:{required: true,number:true},
      bathrooms:{required: true,number:true},
      balcony:{required: true,number:true},
      garage:{required: true,number:true},
      units:{required: true,number:true}
    },
    messages:{
      title:{required: "Please provide some title for this property"},
      p_category:{required: "Please select the property category"},
      category:{required: "Please select sub category"},
      size:{required: "Please enter the property size",number:"Please enter only numbers"},
      location:{required: "Please add the location"},
      rera_no:{required: "Please provide the RERA number"},
      tot_sqft:{required: "Please provide the total SQFT",number:"Please enter only numbers"},
      sqft_price:{required: "Please provide the price per SQFT",number:"Please enter only numbers"},
      price:{required: "Please provide the property price",number:"Please enter only numbers"},
      beds:{required: "Please select the number of beds",number:"Please enter only numbers"},
      bathrooms:{required: "Please select the number of bathrooms",number:"Please enter only numbers"},
      balcony:{required: "Please select the number of balcony",number:"Please enter only numbers"},
      garage:{required: "Please select the number of garage",number:"Please enter only numbers"},
      units:{required: "Please select the number of units",number:"Please enter only numbers"}
    },
    submitHandler: function(e){
      	//e.preventDefault();
      	var formdata = new FormData($('#edit_property_form')[0]);
        formdata.append('type','details');
        $["ajax"]({
          url: urljs+"admin/properties/do_update",
          type: "POST",
          dataType: "json",
          data: formdata,
          contentType: false,
          cache: false,
          processData: false,
          beforeSend: function() {
              show_btn_load('#edit_property_form','Updating...');
          },
          success: function(data) {
            close_btn_load('#edit_property_form');
            if(data.result=='success'){
            	$('.bootbox.addPropertyView').find('.bootbox-close-button').trigger('click');
              	swal('Success',data.msg,'success').then(function(isConfirm){
              		if(isConfirm.value){
              			window.location.reload();
              		}else{
              			window.location.reload();
              		}
              	})
            }else{
            	show_toast('error',data.msg);
            }
            closeajax();
          },
          error: function() {}
        })
      }
  });
}

function save_data(type){
	$('#content_form').validate({		
		errorClass: 'error',
		validClass: 'valid',
		rules: {
			overview: {required: true}
		},
		messages:{
			overview: {required:"Type something here"}
		},	
		submitHandler: function(){
			if($('.textEditor').summernote('isEmpty')) {
			  swal('Warning','Please type something to update...','warning');
			}else{
				var formdata = new FormData($('#content_form')[0]);
				formdata.append('type',type);
				$["ajax"]({
				url: urljs+"admin/properties/do_update",
				type: "POST",
				dataType: "json",
				data: formdata,
				contentType: false,
				cache: false,
				processData: false,
				beforeSend: function() {
					show_btn_load('#content_form','Updating...');
				},
				success: function(data) {
					close_btn_load('#content_form');
					if(data.result=='success'){
						$('.bootbox.postDataView').find('.bootbox-close-button').trigger('click');
						swal('Success',data.msg,'success').then(function(isConfirm) {
	                        if (isConfirm.value) {
	                            window.location.reload();
	                        }
                        });
					}
					else{
						swal('Error',data.msg,'warning');
					}
				},
				error: function() {}
			})
			}
		}
	});
}

//featured image
function feature_image(){
	$('.btn-fimageEdit').on('click',function(e){
		e.preventDefault();
		var id=GetURLParameter('id');
		var dataModal = bootbox.dialog({
	      title: "Edit featured image",
	      message: '<i class="fa fa-spinner fa-spin"></i> Loading, Please wait...',
	      closeButton: true,
	      size: 'medium',
	      animate:true,
	      centerVertical:true,
	      className: "postDataView",
	    });
	    $.post(urljs+"admin/properties/get_update",{'type':'f_image','id':id},function(data){
	      if(data.result=='success'){
	        dataModal.find('.bootbox-body').html(data.msg);
	        initImageUpload();
	        save_fimage();
	      }else {
	        swal("Error!", data.msg, "warning");
	      }
	    },"json");
	});
}

function initImageUpload(){
    var drEvent= $('.dropify').dropify({
        messages: {
            'default': 'Drag and drop a file here or click',
            'replace': 'Drag and drop or click to replace',
            'remove': 'Remove',
            'error': 'Ooops, something wrong appended.'
        },
        error: {
            'fileSize': 'The file size is too big (25M max).'
        }
    });
}

function save_fimage(){
	$('#content_form').validate({		
		errorClass: 'error',
		validClass: 'valid',
		rules: {
			'attachment[]': {required: true}
		},
		messages:{
			'attachment[]': {required:"Please select the file"}
		},	
		submitHandler: function(){
				var formdata = new FormData($('#content_form')[0]);
				$["ajax"]({
				url: urljs+"admin/properties/update_featureimage",
				type: "POST",
				dataType: "json",
				data: formdata,
				contentType: false,
				cache: false,
				processData: false,
				beforeSend: function() {
					show_btn_load('#content_form','Updating...');
				},
				success: function(data) {
					close_btn_load('#content_form');
					if(data.result=='success'){
						$('.bootbox.postDataView').find('.bootbox-close-button').trigger('click');
						swal('Success',data.msg,'success').then(function(isConfirm) {
	                        if (isConfirm.value) {
	                            window.location.reload();
	                        }
                        });
					}
					else{
						swal('Error',data.msg,'warning');
					}
				},
				error: function() {}
			})
		}
	});
}

function init_editor(type){
	var editor=$('.textEditor').summernote({
	  toolbar: [
	    // [groupName, [list of button]]
	    ['style', ['bold', 'italic', 'underline', 'clear']],
	    //['font', ['strikethrough', 'superscript', 'subscript']],
	    //['fontsize', ['fontsize']],
	    //['color', ['color']],
	    ['para', ['ul', 'ol', 'paragraph']]
	  ],
	  placeholder:"Type here to update property's "+type+" content...",
	  focus:true
	});
}

function update_status(){
	$('#up_status').on('change',function() {
		if($(this).is(":checked")) {
			var status=1;
        }else{
        	var status=0;
        }
        var id=GetURLParameter('id');
        swal({
            title: "Are you sure?",
            text: "You are about to update the status of this property" ,
            type: "warning",
            showCancelButton: true,
            cancelButtonClass: 'btn-secondary waves-effect',
            confirmButtonClass: 'btn-success',
            confirmButtonText: "Yes, update it!",
            closeOnConfirm: true
        }).then(function(isConfirm) {
	        if (isConfirm.value) {
            ajaxloading('Please wait...');
            $.post(urljs+'admin/properties/do_update',{'id':id,'type':'status','status':status},function(data){
                closeajax();
                if(data.result=='success'){
                    show_toast('success',data.msg)
                }else{
                    show_toast('error',data.msg)
                }
            },"json");
          }
        });  
    });
}

function floor_plan(){
	$('.btn-planEdit').on('click',function(e){
		e.preventDefault();
		var id=GetURLParameter('id');
		var dataModal = bootbox.dialog({
	      title: "Edit Floor Plan",
	      message: '<i class="fa fa-spinner fa-spin"></i> Loading, Please wait...',
	      closeButton: true,
	      size: 'extra-large',
	      animate:true,
	      centerVertical:true,
	      className: "largeWidth floorPlanModal",
	    });
	    $.post(urljs+"admin/properties/get_update",{'type':'floor_plan','id':id},function(data){
	      if(data.result=='success'){
	        dataModal.find('.bootbox-body').html(data.msg);
	        init_floor_editor();
	        initImageUpload();
	        save_floor_plan();
	      }else {
	        swal("Error!", data.msg, "warning");
	      }
	    },"json");
	});
}

function init_floor_editor(type){
	var editor=$('.textEditor').summernote({
	  toolbar: [
	    // [groupName, [list of button]]
	    ['style', ['bold', 'italic', 'underline', 'clear']],
	    //['font', ['strikethrough', 'superscript', 'subscript']],
	    //['fontsize', ['fontsize']],
	    //['color', ['color']],
	    ['para', ['ul', 'ol', 'paragraph']]
	  ],
	  placeholder:"Type here to update property's floor plan content...",
	  focus:true
	});
}

function save_floor_plan(){
	$('#content_form').validate({		
		errorClass: 'error',
		validClass: 'valid',
		rules: {
			//'attachment[]': {required: true}
		},
		messages:{
			//'attachment[]': {required:"Please select the file"}
		},	
		submitHandler: function(){
			if($('.textEditor').summernote('isEmpty')) {
			  swal('Warning','Please type something to update...','warning');
			}else{
				var formdata = new FormData($('#content_form')[0]);
				//formdata.append('type','floor_plan');
				$["ajax"]({
				url: urljs+"admin/properties/save_floor_plan",
				type: "POST",
				dataType: "json",
				data: formdata,
				contentType: false,
				cache: false,
				processData: false,
				beforeSend: function() {
					show_btn_load('#content_form','Updating...');
				},
				success: function(data) {
					close_btn_load('#content_form');
					if(data.result=='success'){
						$('.bootbox.floorPlanModal').find('.bootbox-close-button').trigger('click');
						swal('Success',data.msg,'success').then(function(isConfirm) {
	                        if (isConfirm.value) {
	                            window.location.reload();
	                        }
                        });
					}
					else{
						swal('Error',data.msg,'warning');
					}
				},
				error: function() {}
			})
			}
		}
	});
}


//photos
if($('.photos_box').length>0){
	add_photo();
	remove_image();
	image_info();
}

function add_photo(){
	$('.btn-photosEdit').on('click',function(e){
		var id=GetURLParameter('id');
		e.preventDefault();
		var dataModal = bootbox.dialog({
	      title: "Add Property Photo",
	      message: '<i class="fa fa-spinner fa-spin"></i> Loading, Please wait...',
	      closeButton: true,
	      size: 'medium',
	      animate:true,
	      centerVertical:true,
	      className: "propertyPhotos",
	    });
	    $.post(urljs+"admin/properties/get_update",{'type':'property_photo','id':id},function(data){
	      if(data.result=='success'){
	        dataModal.find('.bootbox-body').html(data.msg);
	        initImageUpload();
	        save_property_photo();
	      }else {
	        swal("Error!", data.msg, "warning");
	      }
	    },"json");
	});
}

function save_property_photo(){
	$('#content_form').validate({		
		errorClass: 'error',
		validClass: 'valid',
		rules: {
			'attachment[]': {required: true}
		},
		messages:{
			'attachment[]': {required:"Please select the file"}
		},	
		submitHandler: function(){
				var formdata = new FormData($('#content_form')[0]);
				$["ajax"]({
				url: urljs+"admin/properties/save_property_photo",
				type: "POST",
				dataType: "json",
				data: formdata,
				contentType: false,
				cache: false,
				processData: false,
				beforeSend: function() {
					show_btn_load('#content_form','Uploading...');
				},
				success: function(data) {
					close_btn_load('#content_form');
					if(data.result=='success'){
						$('.bootbox.propertyPhotos').find('.bootbox-close-button').trigger('click');
						swal('Success',data.msg,'success').then(function(isConfirm) {
	                        if (isConfirm.value) {
	                            window.location.reload();
	                        }
                        });
					}
					else{
						swal('Error',data.msg,'warning');
					}
				},
				error: function() {}
			})
		}
	});
}

function remove_image(){
	$('.btn-fileTrash').on('click',function() {
		var id=$(this).attr('data-id');
		var p_id=GetURLParameter('id');
        swal({
            title: "Are you sure?",
            text: "You are about to delete property photo",
            type: "warning",
            showCancelButton: true,
            cancelButtonClass: 'btn-secondary waves-effect',
            confirmButtonClass: 'btn-success',
            confirmButtonText: "Yes, delete it!",
            closeOnConfirm: true
        }).then(function(isConfirm) {
	        if (isConfirm.value) {
            ajaxloading('Processing your request<br>Please wait...');
            $.post(urljs+'admin/properties/delete_photo',{'id':id,'p_id':p_id},function(data){
                closeajax();
                if(data.result=='success'){
					swal('Success',data.msg,'success').then(function(isConfirm) {
                        if (isConfirm.value) {
                            window.location.reload();
                        }
                    });
				}
				else{
					swal('Error',data.msg,'warning');
				}
            },"json");
          }
        });  
    });
}

function image_info(){
	$('.btn-fileInfo').on('click',function() {
		var id=$(this).attr('data-id');
		var p_id=GetURLParameter('id');
		var dataModal = bootbox.dialog({
	      title: "Image info",
	      message: '<i class="fa fa-spinner fa-spin"></i> Loading, Please wait...',
	      closeButton: true,
	      size: 'medium',
	      animate:true,
	      centerVertical:true,
	      className: "postDataView",
	    });
	    $.post(urljs+"admin/properties/get_photo_info",{'id':id,'p_id':p_id},function(data){
	      if(data.result=='success'){
	        dataModal.find('.bootbox-body').html(data.msg);
	      }else {
	        swal("Error!", data.msg, "warning");
	      }
	    },"json");
    });
}


function update_video(){
	$('.btn-videoEdit').on('click',function(e){
		var id=GetURLParameter('id');
		e.preventDefault();
		var dataModal = bootbox.dialog({
	      title: "Add Property Video",
	      message: '<i class="fa fa-spinner fa-spin"></i> Loading, Please wait...',
	      closeButton: true,
	      size: 'medium',
	      animate:true,
	      centerVertical:true,
	      className: "propertyVideo",
	    });
	    $.post(urljs+"admin/properties/get_update",{'type':'video','id':id},function(data){
	      if(data.result=='success'){
	        dataModal.find('.bootbox-body').html(data.msg);
    		$('[data-toggle="tooltip"]').tooltip();
	        save_property_video();
	      }else {
	        swal("Error!", data.msg, "warning");
	      }
	    },"json");
	});
}


function save_property_video(){
	$('#content_form').validate({		
		errorClass: 'error',
		validClass: 'valid',
		rules: {
			video_url: {required: true}
		},
		messages:{
			video_url: {required:"Please provide the video URL"}
		},	
		submitHandler: function(){
				var formdata = new FormData($('#content_form')[0]);
				$["ajax"]({
				url: urljs+"admin/properties/save_property_video",
				type: "POST",
				dataType: "json",
				data: formdata,
				contentType: false,
				cache: false,
				processData: false,
				beforeSend: function() {
					show_btn_load('#content_form','Updating...');
				},
				success: function(data) {
					close_btn_load('#content_form');
					if(data.result=='success'){
						$('.bootbox.propertyVideo').find('.bootbox-close-button').trigger('click');
						swal('Success',data.msg,'success').then(function(isConfirm) {
	                        if (isConfirm.value) {
	                            window.location.reload();
	                        }
                        });
					}
					else{
						swal('Error',data.msg,'warning');
					}
				},
				error: function() {}
			})
		}
	});
}