if($("#projectTbl").length>0){
    add_project();
    get_projects();
}

function filter(){
  $(".filter").on("click",function(e){
    e.preventDefault();
    var page=1;
    $("#pagenumber").val(page);
    get_projects(page);
  });
  
  $("#clearFilter").on("click",function(e){
    e.preventDefault();
    $('#adv-search').find('input.clearAbleFilt,select.clearAbleFilt').val('');
    $('#adv_filter_form').find('input.clearAbleFilt,select.clearAbleFilt').val('');
    $(".filter").click();
  });

  $("#result").on( "click",".pagination a", function (e){
    e.preventDefault();   
    var page = $(this).attr("data-page");
    $("#pagenumber").val(page);
    //window.location = "#"+page;
    get_projects(page);
  });
}

function get_projects(page){ 
  ajaxloading('Loading Projects...');  
  var refine_filter_arr = [];
  var parameter = [];
  jQuery('.refine_filter option:selected,input.refine_filter').each(function () {
    refine_filter_arr.push({'type':$(this).attr("data-type"),'value':$(this).val()});
    parameter.push({'name':$(this).attr('data-type'),'value':$(this).val()});
  });
  var recursiveEncoded = $.param( parameter, true  );
  //window.location.hash = recursiveEncoded;
  $.post(urljs+"admin/projects/get_datas",{"page":page,'filter_data':refine_filter_arr,},function(data){
    $("#projectTbl").html(data.msg);
    $('[data-toggle="tooltip"]').tooltip();
    closeajax();
    filter();
    delete_project();
  },"json");
}

function delete_project(){
  $('.btn-delProject').on('click',function() {
    var id=$(this).attr('data-id');
        swal({
            title: "Are you sure?",
            text: "You are about to delete the project "+id,
            type: "warning",
            showCancelButton: true,
            cancelButtonClass: 'btn-secondary waves-effect',
            confirmButtonClass: 'btn-success',
            confirmButtonText: "Yes, delete it!",
            closeOnConfirm: true
        }).then(function(isConfirm) {
          if (isConfirm.value) {
            ajaxloading('Processing your request<br>Please wait...');
            $.post(urljs+'admin/projects/delete_project',{'id':id},function(data){
                closeajax();
                if(data.result=='success'){
                  get_projects();
                  show_toast('success',data.msg);
                }else{
                  show_toast('error',data.msg);
                }
            },"json");
          }
        });  
    });
}




function add_project(){
	$(".btn-addProject").on( "click", function (e){
		e.preventDefault();
		var dataModal = bootbox.dialog({
	      title: 'Add New Project',
	      message: '<i class="fa fa-spinner fa-spin"></i> Loading, Please wait...',
	      closeButton: true,
	      size: 'medium',
	      animate:true,
        centerVertical:true,
	      className: "addProjectView",
	    });
	    $.post(urljs+"admin/projects/add_new",'',function(data){
	      if(data.status=='success'){
	        dataModal.find('.bootbox-body').html(data.msg);
	        $('[data-toggle="tooltip"]').tooltip();
	        get_sub_categories();
	        save_new_project();
	      }else {
	        swal("Error!", data.msg, "warning");
	      }
	    },"json");
	});
}

function get_sub_categories(){
  $("#p_category").on("change", function(e){
    e.preventDefault();
    $('#category').html('<option value="">Loading categories...</option>');
    var parent=$(this).val();
    $.post(urljs+"admin/categories/get_sub_categories",{'parent':parent},function(data){
        if(data.result=='success'){
          var data_items='';
          var datas = data.data_list;
          if(datas.length>0){
            for(i=0;i<datas.length;i++){
              data_items+='<option value="'+datas[i].id+'">'+datas[i].text+'</option>';
          }
          $('#category').html('');
          $('#category').append(data_items);
      }else{
        $('#category').html('');
        $('#category').append('<option value="">Loading categories...</option>');
      }
        }else {
          swal("Error!", data.msg, "warning");
        }
      },"json");
  });
}

function save_new_project(){
  $('#add_project_form').validate({
    errorClass: 'error',
    validClass: 'valid',
    rules: {
      name:{required: true},
      location:{required: true},
      description:{required: true},
      p_category:{required: true},
      category:{required: true},
      min_price:{required: true},
      max_price:{required: true}
    },
    messages:{
      name:{required: "Please provide some name for this project"},
      description:{required: "Please provide brief description"},
      location:{required: "Please provide the location"},
      p_category:{required: "Please select the project category"},
      category:{required: "Please select the sub category"},
      min_price:{required: "Please provide the minimum price"},
      max_price:{required: "Please provide the maximum price"}
    },
    submitHandler: function(e){
      //e.preventDefault();
      var formdata = new FormData($('#add_project_form')[0]);
        //formdata.append('description',editorInput);
        $["ajax"]({
          url: urljs+"admin/projects/save_new_project",
          type: "POST",
          dataType: "json",
          data: formdata,
          contentType: false,
          cache: false,
          processData: false,
          beforeSend: function() {
              show_btn_load('#add_project_form','Saving...');
          },
          success: function(data) {
            close_btn_load('#add_project_form');
            if(data.result=='success'){
              $('.bootbox.addProjectView').find('.bootbox-close-button').trigger('click');
              if(data.urlredirect!=''){
                swal('Success',data.msg,'success').then(function(isConfirm){
                  if(isConfirm.value){
                    window.location.href=urljs+data.urlredirect;
                  }
                })
              }else{
              swal('Success',data.msg,'success');
              }
            }else{
              show_toast('error',data.msg);
            }
            closeajax();
          },
          error: function() {}
        })
      }
  });
}




if($('#content_page').length>0){
  update_status();
  feature_image();
  edit_data();
}

//featured image
function feature_image(){
  $('.btn-fimageEdit').on('click',function(e){
    e.preventDefault();
    var id=GetURLParameter('id');
    var dataModal = bootbox.dialog({
        title: "Edit featured image",
        message: '<i class="fa fa-spinner fa-spin"></i> Loading, Please wait...',
        closeButton: true,
        size: 'medium',
        animate:true,
        centerVertical:true,
        className: "postDataView",
      });
      $.post(urljs+"admin/projects/get_update",{'type':'f_image','id':id},function(data){
        if(data.result=='success'){
          dataModal.find('.bootbox-body').html(data.msg);
          initImageUpload();
          save_fimage();
        }else {
          swal("Error!", data.msg, "warning");
        }
      },"json");
  });
}

function initImageUpload(){
    var drEvent= $('.dropify').dropify({
        messages: {
            'default': 'Drag and drop a file here or click',
            'replace': 'Drag and drop or click to replace',
            'remove': 'Remove',
            'error': 'Ooops, something wrong appended.'
        },
        error: {
            'fileSize': 'The file size is too big (25M max).'
        }
    });
}

function save_fimage(){
  $('#content_form').validate({   
    errorClass: 'error',
    validClass: 'valid',
    rules: {
      'attachment[]': {required: true}
    },
    messages:{
      'attachment[]': {required:"Please select the file"}
    },  
    submitHandler: function(){
        var formdata = new FormData($('#content_form')[0]);
        $["ajax"]({
        url: urljs+"admin/projects/update_feature_image",
        type: "POST",
        dataType: "json",
        data: formdata,
        contentType: false,
        cache: false,
        processData: false,
        beforeSend: function() {
          show_btn_load('#content_form','Updating...');
        },
        success: function(data) {
          close_btn_load('#content_form');
          if(data.result=='success'){
            $('.bootbox.postDataView').find('.bootbox-close-button').trigger('click');
            swal('Success',data.msg,'success').then(function(isConfirm) {
              if (isConfirm.value) {
                  window.location.reload();
              }
            });
          }
          else{
            swal('Error',data.msg,'warning');
          }
        },
        error: function() {}
      })
    }
  });
}

function update_status(){
  $('#up_status').on('change',function() {
    if($(this).is(":checked")) {
      var status=1;
        }else{
          var status=0;
        }
        var id=GetURLParameter('id');
        swal({
            title: "Are you sure?",
            text: "You are about to update the status of this property" ,
            type: "warning",
            showCancelButton: true,
            cancelButtonClass: 'btn-secondary waves-effect',
            confirmButtonClass: 'btn-success',
            confirmButtonText: "Yes, update it!",
            closeOnConfirm: true
        }).then(function(isConfirm) {
          if (isConfirm.value) {
            ajaxloading('Please wait...');
            $.post(urljs+'admin/projects/do_update',{'id':id,'type':'status','status':status},function(data){
                closeajax();
                if(data.result=='success'){
                    show_toast('success',data.msg)
                }else{
                    show_toast('error',data.msg)
                }
            },"json");
          }
        });  
    });
}

function edit_data(){
  $('.btn-dataEdit').on('click',function(e){
    e.preventDefault();
    var id=GetURLParameter('id');
    var type=$(this).attr('data-type');
    var dataModal = bootbox.dialog({
        title: "Edit "+type,
        message: '<i class="fa fa-spinner fa-spin"></i> Loading, Please wait...',
        closeButton: true,
        size: 'extra-large',
        animate:true,
        centerVertical:true,
        className: "addPropertyView largeWidth",
      });
      $.post(urljs+"admin/projects/get_update",{'id':id,'type':type},function(data){
        if(data.result=='success'){
          dataModal.find('.bootbox-body').html(data.msg);
          init_editor(type);
          get_sub_categories();
          save_edit_details();
          save_data(type);
        }else {
          swal("Error!", data.msg, "warning");
        }
      },"json");
  });
}

function init_editor(type){
  var editor=$('.textEditor').summernote({
    toolbar: [
      // [groupName, [list of button]]
      ['style', ['bold', 'italic', 'underline', 'clear']],
      //['font', ['strikethrough', 'superscript', 'subscript']],
      //['fontsize', ['fontsize']],
      //['color', ['color']],
      ['table', ['table']],
      //['insert', ['grid']],
      ['para', ['ul', 'ol', 'paragraph']]
    ],
    grid: {
        wrapper: "row",
        columns: [
            "col-md-12",
            "col-md-6",
            "col-md-4",
            "col-md-3",
        ]
    },
    callbacks: {
        onGridInsert: null
    },
    icons: {
        grid: "fa fa-user"
    },
    placeholder:"Type here to update project's "+type+" content...",
    focus:true
  });
}

function save_edit_details(){
  $('#edit_project_form').validate({
    errorClass: 'error',
    validClass: 'valid',
    rules: {
      name:{required: true},
      location:{required: true},
      description:{required: true},
      p_category:{required: true},
      category:{required: true},
      min_price:{required: true},
      max_price:{required: true}
    },
    messages:{
      name:{required: "Please provide some name for this project"},
      description:{required: "Please provide brief description"},
      location:{required: "Please provide the location"},
      p_category:{required: "Please select the project category"},
      category:{required: "Please select the sub category"},
      min_price:{required: "Please provide the minimum price"},
      max_price:{required: "Please provide the maximum price"}
    },
    submitHandler: function(e){
        //e.preventDefault();
        var formdata = new FormData($('#edit_project_form')[0]);
        formdata.append('type','details');
        $["ajax"]({
          url: urljs+"admin/projects/do_update",
          type: "POST",
          dataType: "json",
          data: formdata,
          contentType: false,
          cache: false,
          processData: false,
          beforeSend: function() {
              show_btn_load('#edit_project_form','Updating...');
          },
          success: function(data) {
            close_btn_load('#edit_project_form');
            if(data.result=='success'){
              $('.bootbox.addPropertyView').find('.bootbox-close-button').trigger('click');
                swal('Success',data.msg,'success').then(function(isConfirm){
                  if(isConfirm.value){
                    window.location.reload();
                  }else{
                    window.location.reload();
                  }
                })
            }else{
              show_toast('error',data.msg);
            }
            closeajax();
          },
          error: function() {}
        })
      }
  });
}

function save_data(type){
  $('#content_form').validate({   
    errorClass: 'error',
    validClass: 'valid',
    rules: {
      content: {required: true}
    },
    messages:{
      content: {required:"Type something here"}
    },  
    submitHandler: function(){
      if($('.textEditor').summernote('isEmpty')) {
        swal('Warning','Please type something to update...','warning');
      }else{
        var formdata = new FormData($('#content_form')[0]);
        formdata.append('type',type);
        $["ajax"]({
        url: urljs+"admin/projects/do_update",
        type: "POST",
        dataType: "json",
        data: formdata,
        contentType: false,
        cache: false,
        processData: false,
        beforeSend: function() {
          show_btn_load('#content_form','Updating...');
        },
        success: function(data) {
          close_btn_load('#content_form');
          if(data.result=='success'){
            $('.bootbox.addPropertyView').find('.bootbox-close-button').trigger('click');
            swal('Success',data.msg,'success').then(function(isConfirm) {
                if (isConfirm.value) {
                    window.location.reload();
                }
              });
          }
          else{
            swal('Error',data.msg,'warning');
          }
        },
        error: function() {}
      })
      }
    }
  });
}

//photos
if($('.photos_box').length>0){
  add_photo();
  remove_image();
  image_info();
}

function add_photo(){
  $('.btn-photosEdit').on('click',function(e){
    var id=GetURLParameter('id');
    e.preventDefault();
    var dataModal = bootbox.dialog({
        title: "Add Project Photo",
        message: '<i class="fa fa-spinner fa-spin"></i> Loading, Please wait...',
        closeButton: true,
        size: 'medium',
        animate:true,
        centerVertical:true,
        className: "projectPhotos",
      });
      $.post(urljs+"admin/projects/get_update",{'type':'property_photo','id':id},function(data){
        if(data.result=='success'){
          dataModal.find('.bootbox-body').html(data.msg);
          initImageUpload();
          save_property_photo();
        }else {
          swal("Error!", data.msg, "warning");
        }
      },"json");
  });
}

function save_property_photo(){
  $('#content_form').validate({   
    errorClass: 'error',
    validClass: 'valid',
    rules: {
      'attachment[]': {required: true}
    },
    messages:{
      'attachment[]': {required:"Please select the file"}
    },  
    submitHandler: function(){
        var formdata = new FormData($('#content_form')[0]);
        $["ajax"]({
        url: urljs+"admin/projects/save_property_photo",
        type: "POST",
        dataType: "json",
        data: formdata,
        contentType: false,
        cache: false,
        processData: false,
        beforeSend: function() {
          show_btn_load('#content_form','Uploading...');
        },
        success: function(data) {
          close_btn_load('#content_form');
          if(data.result=='success'){
            $('.bootbox.projectPhotos').find('.bootbox-close-button').trigger('click');
            swal('Success',data.msg,'success').then(function(isConfirm) {
              if (isConfirm.value) {
                  window.location.reload();
              }
            });
          }
          else{
            swal('Error',data.msg,'warning');
          }
        },
        error: function() {}
      })
    }
  });
}

function remove_image(){
  $('.btn-fileTrash').on('click',function() {
    var id=$(this).attr('data-id');
    var p_id=GetURLParameter('id');
        swal({
            title: "Are you sure?",
            text: "You are about to delete project photo",
            type: "warning",
            showCancelButton: true,
            cancelButtonClass: 'btn-secondary waves-effect',
            confirmButtonClass: 'btn-success',
            confirmButtonText: "Yes, delete it!",
            closeOnConfirm: true
        }).then(function(isConfirm) {
          if (isConfirm.value) {
            ajaxloading('Processing your request<br>Please wait...');
            $.post(urljs+'admin/projects/delete_photo',{'id':id,'p_id':p_id},function(data){
                closeajax();
                if(data.result=='success'){
                  swal('Success',data.msg,'success').then(function(isConfirm) {
                    if (isConfirm.value) {
                        window.location.reload();
                    }
                });
              }
              else{
                swal('Error',data.msg,'warning');
              }
            },"json");
          }
        });  
    });
}

function image_info(){
  $('.btn-fileInfo').on('click',function() {
    var id=$(this).attr('data-id');
    var p_id=GetURLParameter('id');
    var dataModal = bootbox.dialog({
        title: "Image info",
        message: '<i class="fa fa-spinner fa-spin"></i> Loading, Please wait...',
        closeButton: true,
        size: 'medium',
        animate:true,
        centerVertical:true,
        className: "postDataView",
      });
      $.post(urljs+"admin/projects/get_photo_info",{'id':id,'p_id':p_id},function(data){
        if(data.result=='success'){
          dataModal.find('.bootbox-body').html(data.msg);
        }else {
          swal("Error!", data.msg, "warning");
        }
      },"json");
    });
}

if($("#p_tags_tbl").length>0){
    $(".select2").select2({
        placeholder: "Select the property",
        allowClear: false
    });
    get_tags();
    save_tags();
}

function tags_filter(){
  $("#result").on( "click",".pagination a", function (e){
    e.preventDefault();   
    var page = $(this).attr("data-page");
    $("#pagenumber").val(page);
    //window.location = "#"+page;
    get_tags(page);
  });
}

function get_tags(page){ 
  $("#p_tags_tbl").html('<div class="text-center"><img src="'+urljs+'ui/loaders/throbber_12.gif" height="30"> Loading, Please wait...</div>');
  var id=GetURLParameter('id');
  $.post(urljs+"admin/projects/get_tags",{"page":page,'id':id},function(data){
    $("#p_tags_tbl").html(data.msg);
    $('[data-toggle="tooltip"]').tooltip();
    closeajax();
    tags_filter();
    remove_tag();
  },"json");
}

function save_tags(){
  $('#add_tag_form').validate({   
    errorClass: 'error',
    validClass: 'valid',
    rules: {
      property_id: {required: true}
    },
    messages:{
      property_id: {required:"Please select the property to add"}
    },  
    submitHandler: function(){
      var formdata = new FormData($('#add_tag_form')[0]);
      var p_id=GetURLParameter('id');
      formdata.append('p_id',p_id);
      $["ajax"]({
        url: urljs+"admin/projects/save_tags",
        type: "POST",
        dataType: "json",
        data: formdata,
        contentType: false,
        cache: false,
        processData: false,
        beforeSend: function() {
          show_btn_load('#add_tag_form','Adding...');
        },
        success: function(data) {
          close_btn_load('#add_tag_form');
          if(data.result=='success'){
            get_tags();
            show_toast('success',data.msg);
          }
          else{
            show_toast('error',data.msg);
          }
        },
        error: function() {}
      })
    }
  });
}

function remove_tag(){
  $('.btn-delProject').on('click',function() {
    var id=$(this).attr('data-id');
    var p_id=GetURLParameter('id');
        swal({
            title: "Are you sure?",
            text: "You are about to remove the property tag",
            type: "warning",
            showCancelButton: true,
            cancelButtonClass: 'btn-secondary waves-effect',
            confirmButtonClass: 'btn-success',
            confirmButtonText: "Yes, delete it!",
            closeOnConfirm: true
        }).then(function(isConfirm) {
          if (isConfirm.value) {
            ajaxloading('Processing your request<br>Please wait...');
            $.post(urljs+'admin/projects/remove_tag',{'id':id,'p_id':p_id},function(data){
                closeajax();
                if(data.result=='success'){
                  get_tags();
                  show_toast('success',data.msg);
                }else{
                  show_toast('error',data.msg);
                }
            },"json");
          }
        });  
    });
}
