if($("#propertyTbl").length>0){
  init_select2();
  get_properties();
}

function init_select2(){
  $(".select2").select2({
    placeholder: "Select item to add",
    allowClear: false
  });
}

function filter(){
  $(".filter").on("click",function(e){
    e.preventDefault();
    var page=1;
    $("#pagenumber").val(page);
    get_properties(page);
  });
  
  $("#clearFilter").on("click",function(e){
    e.preventDefault();
    $('#adv-search').find('input.clearAbleFilt,select.clearAbleFilt').val('');
    $('#adv_filter_form').find('input.clearAbleFilt,select.clearAbleFilt').val('');
    $(".filter").click();
  });

  $("#result").on( "click",".pagination a", function (e){
    e.preventDefault();   
    var page = $(this).attr("data-page");
    $("#pagenumber").val(page);
    //window.location = "#"+page;
    get_properties(page);
  });
}

function get_properties(page){ 
  ajaxloading('Loading Properties...');  
  var refine_filter_arr = [];
  var parameter = [];
  jQuery('.refine_filter option:selected,input.refine_filter').each(function () {
    refine_filter_arr.push({'type':$(this).attr("data-type"),'value':$(this).val()});
    parameter.push({'name':$(this).attr('data-type'),'value':$(this).val()});
  });
  var recursiveEncoded = $.param( parameter, true  );
  //window.location.hash = recursiveEncoded;
  $.post(urljs+"admin/featured/get_properties",{"page":page,'filter_data':refine_filter_arr,},function(data){
    $("#propertyTbl").html(data.msg);
    $('[data-toggle="tooltip"]').tooltip();
    closeajax();
    filter();
    save_property();
    remove_property();
  },"json");
}

function save_property(){
  $('#add_feature_form').validate({   
    errorClass: 'error',
    validClass: 'valid',
    rules: {
      property_id: {required: true}
    },
    messages:{
      property_id: {required:"Please select the property to add"}
    },  
    submitHandler: function(){
      var formdata = new FormData($('#add_feature_form')[0]);
      $["ajax"]({
        url: urljs+"admin/featured/save_property",
        type: "POST",
        dataType: "json",
        data: formdata,
        contentType: false,
        cache: false,
        processData: false,
        beforeSend: function() {
          show_btn_load('#add_feature_form','Adding...');
        },
        success: function(data) {
          close_btn_load('#add_feature_form');
          $('#add_feature_form')[0].reset();
          if(data.result=='success'){
            get_properties();
            show_toast('success',data.msg);
          }
          else{
            show_toast('error',data.msg);
          }
        },
        error: function() {}
      })
    }
  });
}

function remove_property(){
  $('.btn-delProperty').on('click',function() {
    var id=$(this).attr('data-id');
    var code=$(this).attr('data-code');
        swal({
            title: "Are you sure?",
            text: "You are about to remove the property",
            type: "warning",
            showCancelButton: true,
            cancelButtonClass: 'btn-secondary waves-effect',
            confirmButtonClass: 'btn-success',
            confirmButtonText: "Yes, delete it!",
            closeOnConfirm: true
        }).then(function(isConfirm) {
          if (isConfirm.value) {
            ajaxloading('Processing your request<br>Please wait...');
            $.post(urljs+'admin/featured/remove_property',{'id':id,'code':code},function(data){
                closeajax();
                if(data.result=='success'){
                  get_properties();
                  show_toast('success',data.msg);
                }else{
                  show_toast('error',data.msg);
                }
            },"json");
          }
        });  
    });
}


//featured projects

if($("#projectTbl").length>0){
  init_select2();
  get_projects();
}

function project_filter(){
  $(".filter").on("click",function(e){
    e.preventDefault();
    var page=1;
    $("#pagenumber").val(page);
    get_projects(page);
  });
  
  $("#clearFilter").on("click",function(e){
    e.preventDefault();
    $('#adv-search').find('input.clearAbleFilt,select.clearAbleFilt').val('');
    $('#adv_filter_form').find('input.clearAbleFilt,select.clearAbleFilt').val('');
    $(".filter").click();
  });

  $("#result").on( "click",".pagination a", function (e){
    e.preventDefault();   
    var page = $(this).attr("data-page");
    $("#pagenumber").val(page);
    //window.location = "#"+page;
    get_projects(page);
  });
}

function get_projects(page){
  ajaxloading('Loading Projects...');
  var refine_filter_arr = [];
  var parameter = [];
  jQuery('.refine_filter option:selected,input.refine_filter').each(function () {
    refine_filter_arr.push({'type':$(this).attr("data-type"),'value':$(this).val()});
    parameter.push({'name':$(this).attr('data-type'),'value':$(this).val()});
  });
  var recursiveEncoded = $.param( parameter, true  );
  //window.location.hash = recursiveEncoded;
  $.post(urljs+"admin/featured/get_projects",{"page":page,'filter_data':refine_filter_arr,},function(data){
    $("#projectTbl").html(data.msg);
    $('[data-toggle="tooltip"]').tooltip();
    closeajax();
    project_filter();
    save_project();
    remove_project();
  },"json");
}

function save_project(){
  $('#add_feature_form').validate({   
    errorClass: 'error',
    validClass: 'valid',
    rules: {
      project_id: {required: true}
    },
    messages:{
      project_id: {required:"Please select the project to add"}
    },  
    submitHandler: function(){
      var formdata = new FormData($('#add_feature_form')[0]);
      $["ajax"]({
        url: urljs+"admin/featured/save_project",
        type: "POST",
        dataType: "json",
        data: formdata,
        contentType: false,
        cache: false,
        processData: false,
        beforeSend: function() {
          show_btn_load('#add_feature_form','Adding...');
        },
        success: function(data) {
          close_btn_load('#add_feature_form');
          $('#add_feature_form')[0].reset();
          if(data.result=='success'){
            get_projects();
            show_toast('success',data.msg);
          }
          else{
            show_toast('error',data.msg);
          }
        },
        error: function() {}
      })
    }
  });
}

function remove_project(){
  $('.btn-delProject').on('click',function() {
    var id=$(this).attr('data-id');
    var code=$(this).attr('data-code');
        swal({
            title: "Are you sure?",
            text: "You are about to remove the project",
            type: "warning",
            showCancelButton: true,
            cancelButtonClass: 'btn-secondary waves-effect',
            confirmButtonClass: 'btn-success',
            confirmButtonText: "Yes, delete it!",
            closeOnConfirm: true
        }).then(function(isConfirm) {
          if (isConfirm.value) {
            ajaxloading('Processing your request<br>Please wait...');
            $.post(urljs+'admin/featured/remove_project',{'id':id,'code':code},function(data){
                closeajax();
                if(data.result=='success'){
                  get_projects();
                  show_toast('success',data.msg);
                }else{
                  show_toast('error',data.msg);
                }
            },"json");
          }
        });  
    });
}