   jQuery(document).ready(function() {
    // menu items
    //var arrayjson =[{"icon":"","href":"","text":"Hai","id":"1","children":[{"icon":"","href":"","text":"Sub-hai","id":"2"}]},{"icon":"","href":"","text":"Sample Page","id":"3"},{"icon":"","href":"","text":"aaa","id":"4"}];

    // icon picker options
    var iconPickerOptions = {
        searchText: "Buscar...",
        labelHeader: "{0}/{1}"
    };
    // sortable list options
    var sortableListOptions = {
        placeholderCss: {
            'background-color': "#cccccc"
        }
    };

    var editor = new MenuEditor('load_menu_here', {
        listOptions: sortableListOptions,
        iconPicker: iconPickerOptions
    });
    editor.setForm($('#frmEdit'));

    //editor.setData(arrayjson);

    editor.setUpdateButton($('#btnUpdate'));
    $('#btnReload').on('click', function() {
        editor.setData(arrayjson);
    });

    if ($("#load_menu_here").length > 0) {
        get_menus();
    }

    $('#btnOutput').on('click', function() {
        var str = editor.getString();
        //alert(str);
        ajaxloading("Updating... Please Wait...");
        $.post(urljs+"admin/categories/save_categories",{'str':str},function(data){
            closeajax();
            if (data.status == "success") {
                editor.setData(data.result.menus);
                show_toast('success','Categories has been updated');
            }else{
                show_toast('warning','Unable to update, please try later...');
            }
        },"json");

    });

    function get_menus(){
        $["ajax"]({
            url: urljs+"admin/categories/get_datas",
            type: "POST",
            dataType: "json",
            data: '',
            contentType: false,
            cache: false,
            processData: false,
            beforeSend: function() {
               ajaxloading("Loading categories...");
            },
            success: function(data) {
                closeajax();
                if (data.status == "success") {
                    editor.setData(data.result.menus);
                    category_operations();
                    save_addData();
                }else{
                    show_toast('warning','Unable to fetch categories...');
                }
            },
            error: function() {
                closeajax();
            }
        })
    }

    function category_operations(){
        $(".btnRemove").unbind().click(function(e) {
            var id = $(this).closest('li').attr('data-id');
            swal({
                title: "Are you sure?",
                text: "You cannot revert back at later time!",
                type: "warning",
                showCancelButton: true,
                cancelButtonClass: 'btn-secondary waves-effect',
                confirmButtonClass: 'btn-warning',
                confirmButtonText: "Yes, delete it!",
                closeOnConfirm: true
            }).then(function(isConfirm) {
                if (isConfirm.value) {
                    ajaxloading("Processing request... Please Wait...");
                    $.post(urljs+"admin/categories/delete_cat",{'id':id},function(data){
                        closeajax();
                        if (data.status == "success") {
                            get_menus();
                            show_toast('success',data.msg);
                        }else{
                            show_toast('warning',data.msg);
                        }
                    },"json");
                } else {
                    //swal("Cancelled", "Your imaginary file is safe :)", "error");
                }
            });
        });
            
        $(".btnEdit").unbind().click(function(e) {
            var id = $(this).closest('li').attr('data-id');
            ajaxloading("Please Wait...");
            $.post(urljs+"admin/categories/edit_cat",{'id':id},function(data){
                closeajax();
                if (data.status == "success") {
                    var dialog = bootbox.dialog({
                        title: 'Category settings',
                        message: data.msg,
                        centerVertical:true,
                        closeButton: true
                    });
                    initImageUpload();
                    save_editData();
                }else{
                    show_toast('warning',data.msg);
                }
            },"json");
            //  swal("Deleted!", "Your imaginary file has been deleted.", "success");
               
        });       
    }

    function initImageUpload(){
        var logo_exist=$("#imageinput").attr("data-logo");
        var logo_url=$("#imageinput").attr("data-url");
        if(logo_exist!=""){
            var imageFile=logo_url;
        }
        var drEvent= $('.dropify').dropify({
            defaultFile:imageFile,
            messages: {
                'default': 'Drag and drop a file here or click',
                'replace': 'Drag and drop or click to replace',
                'remove': 'Remove',
                'error': 'Ooops, something wrong appended.'
            },
            error: {
                'fileSize': 'The file size is too big (25M max).'
            }
        });
        $('.dropify-filename-inner').html(logo_exist);
    }

    function save_addData(){
        $('#add_cat_form').validate({
            rules: {
                cat_name:{
                    required:true,
                    remote: {
                        url: urljs+"admin/categories/check_add_exists",
                        type: "post",
                        data:{
                            edit: function() {                      
                                return $("[name=cat_name]").attr("data-edit");
                            }                       
                        }
                    }
                }
            },
            messages:{
                cat_name :{required :"Please provide category name",remote:"Category already exists!"}
            },  
            errorClass: 'error',
            validClass: 'valid',
            submitHandler: function(e){
                //e.preventDefault();
                var formdata = new FormData($('#add_cat_form')[0]);
                $["ajax"]({
                    url: urljs+"admin/categories/save_update",
                    type: "POST",
                    dataType: "json",
                    data: formdata,
                    contentType: false,
                    cache: false,
                    processData: false,
                    beforeSend: function() {
                        show_btn_load('#add_cat_form','Adding...');
                    },
                    success: function(data) {
                        closeajax();
                        get_menus();
                        if(data.result>0){
                            $('#add_cat_form').find('input').val('');
                            close_btn_load('#add_cat_form');
                            bootbox.hideAll();
                            show_toast('success',data.msg);
                        }
                        else{
                            show_toast('warning',data.msg);
                        }
                    },
                    error: function() {
                        closeajax();
                    }
                })
            }
        });
    }

    function save_editData(){
        $('#edit_cat_form').validate({
            rules: {
                text:{
                    required:true,
                    remote: {
                        url: urljs+"admin/categories/check_exists",
                        type: "post",
                        data:{
                            edit: function() {                      
                                return $("[name=text]").attr("data-edit");
                            }                       
                        }
                    }
                }
            },
            messages:{
                text :{required :"Please provide category name",remote:"Category already exists!"}
            },  
            errorClass: 'error',
            validClass: 'valid',
            submitHandler: function(e){
                event.preventDefault();
                var formdata = new FormData($('#edit_cat_form')[0]);
                $["ajax"]({
                    url: urljs+"admin/categories/save_update",
                    type: "POST",
                    dataType: "json",
                    data: formdata,
                    contentType: false,
                    cache: false,
                    processData: false,
                    beforeSend: function() {
                        show_btn_load('#edit_cat_form','Updating...');
                    },
                    success: function(data) {
                        get_menus();
                        closeajax();
                        if(data.result>0){
                            close_btn_load('#edit_cat_form');
                            bootbox.hideAll();
                            show_toast('success',data.msg);
                        }
                        else{
                            show_toast('warning',data.msg);
                        }
                    },
                    error: function() {
                        closeajax();
                    }
                })
            }
        });
    }

});