<!DOCTYPE html>
<head>
   <title><?php echo $title ?></title>
   <meta charset="utf-8">
   <meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1">
   <?php echo $common_css ?>
</head>
<body>

 <!--preloader start-->
 <div id="preloader">
        <div class="loader1">
            <span></span>
            <span></span>
            <span></span>
            <span></span>
            <span></span>
        </div>
    </div>
    <!--preloader end-->

<!-- Main header start -->
<?php echo $header_main ?>
<!-- Main header end -->


<div class="main">

<!--page header section start-->
<section class="" style="background: url('<?php echo base_url(); ?>ui/frontend/images/bg.png')no-repeat center center / cover">
    <div class="section-lg bg-gradient-primary text-white section-header">
        <div class="container">
            <div class="row justify-content-center bread-crumb-position">
                <div class="col-md-8 col-lg-7">
                    <div class="page-header-content text-center">
                        <h1>Litigation Verification</h1>
                        <nav aria-label="breadcrumb" class="d-flex justify-content-center">
                            <ol class="breadcrumb breadcrumb-transparent breadcrumb-text-light">
                                <li class="breadcrumb-item"><a href="<?php echo base_url(); ?>">Home</a></li>
                                <li class="breadcrumb-item active" aria-current="page">Litigation Verification</li>
                            </ol>
                        </nav>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>
<!--page header section end-->

    <!--project details section start-->
    <section class="section section-lg">
        <div class="container">
            <div class="row justify-content-between align-items-center">
                <div class="col-md-12 col-lg-12 mb-4 mb-md-0 mb-lg-0">
                    <div class="img-wrap mb-md-4 mb-lg-0">
                        <img src="<?php echo base_url(); ?>ui/frontend/images/bc.jpg" alt="project" class="img-fluid rounded shadow-sm" />
                    </div>
                </div>
                <!-- <div class="col-md-12 col-lg-4">
                    <?php echo $common_service_menu ?>
                </div> -->
            </div>

            <!--project details row start-->
            <div class="row mt-5">
                <div class="col-md-12">
                    <div class="project-details-content text-justify">
                        <h2>Litigation Verification</h2>
                        <p>In India, the crime rate was 237.9 cases per one lakh population in 2017, which rose to 241.2 in 2019, say police sources. There is also a study rise in the number of cases in District Courts, High Courts and Supreme Court across the country.</p>
                        <p>As we enter the era where Intellectual Property is the new wealth, trusting human association whether it is employer - employee, client – vendor requires judicious decision making prior to any official engagements. These litigation checks are not just limited to B2B, but it is of paramount significance in B2C cases especially in marriages, employment of maids/servants/drivers for single living or aged couples.</p>
                        <p>DHI Litigation Verification can prevent Businesses and Individuals from illegitimate engagements that could cost precious time, money, legal hassles, losses to data and resources, reputation risks, theft of Intellectual properties and last but not the least Life in some extreme cases. These can potentially affect business/individual relationship and may take years for recovery or sometime irreversible.</p>
                        <p>Our Litigation Verification is not just limited to searches through publicly available data but we work closely with network of 50+ Lawyers across India, to get to the grass roots of any possible litigation for a given individual.</p>
                    </div>
                </div>
            </div>
            <div class="row mt-4">
                <div class="col-md-12">
                    <h5>We currently offer the following services as part of Litigation Verification</h5>
                </div>
                <div class="col-md-6">
                    <div class="project-details-feature">
                        <ul class="list-unstyled tech-feature-list">
                            <li class="py-1"><span class="ti-control-forward mr-2 text-secondary"></span><a href="<?php echo base_url(); ?>services/criminal_litigation_verification">Criminal Litigation Verification</a>
                            </li>
                            <li class="py-1"><span class="ti-control-forward mr-2 text-secondary"></span><a href="<?php echo base_url(); ?>services/national_international_database_checks">National and International Database Checks</a>
                            </li>
                            <li class="py-1"><span class="ti-control-forward mr-2 text-secondary"></span><a href="<?php echo base_url(); ?>services/legal_consultation_clarification">Legal Consultation and Clarification</a></li>
                        </ul>
                    </div>
                </div>
                <div class="col-md-6">
                    <div class="project-details-feature">
                        <ul class="list-unstyled tech-feature-list">
                            <li class="py-1"><span class="ti-control-forward mr-2 text-secondary"></span><a href="<?php echo base_url(); ?>services/corporate_due_diligence_verification">Corporate Due Diligence Verification</a>
                            </li>
                            <li class="py-1"><span class="ti-control-forward mr-2 text-secondary"></span><a href="<?php echo base_url(); ?>services/public_data_verification">Public Data Verification at Jurisdiction Institutional Offices</a>
                            </li>
                            <li class="py-1"><span class="ti-control-forward mr-2 text-secondary"></span><a href="<?php echo base_url(); ?>services/corporate_legal_support">Corporate Legal Support for B2B, B2C cases</a></li>
                        </ul>
                    </div>
                </div>
            </div>
            <!--project details row end-->
        </div>
    </section>
    <!--project details section end-->

    <?php echo $common_cat ?>

    <?php echo $common_clients ?>


</div>

<!-- Footer start -->
<?php echo $footer ?>
<!-- Footer end -->



<?php echo $common_js ?>
</body>
</html>
