<!DOCTYPE html>
<head>
   <title><?php echo $title ?></title>
   <meta charset="utf-8">
   <meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1">
   <?php echo $common_css ?>
</head>
<body>

 <!--preloader start-->
 <div id="preloader">
        <div class="loader1">
            <span></span>
            <span></span>
            <span></span>
            <span></span>
            <span></span>
        </div>
    </div>
    <!--preloader end-->

<!-- Main header start -->
<?php echo $header_main ?>
<!-- Main header end -->


<div class="main">

<!--page header section start-->
<section class="" style="background: url('<?php echo base_url(); ?>ui/frontend/images/bg.png')no-repeat center center / cover">
    <div class="section-lg bg-gradient-primary text-white section-header">
        <div class="container">
            <div class="row justify-content-center bread-crumb-position">
                <div class="col-md-8 col-lg-7">
                    <div class="page-header-content text-center">
                        <h1>Due Deligence</h1>
                        <nav aria-label="breadcrumb" class="d-flex justify-content-center">
                            <ol class="breadcrumb breadcrumb-transparent breadcrumb-text-light">
                                <li class="breadcrumb-item"><a href="<?php echo base_url(); ?>">Home</a></li>
                                <li class="breadcrumb-item active" aria-current="page">Due Deligence</li>
                            </ol>
                        </nav>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>
<!--page header section end-->

    <!--project details section start-->
    <!-- <section class="section section-lg"> -->
        <div class="container">
            

            <!--project details row start-->
            <div class="row mt-5">
                <div class="col-md-12">
                    <div class="project-details-content text-justify">
                        <h3>Due Deligence</h3>
                        <p><strong>DHI offers comprehensive due diligence services to support various business transactions and decision-making processes. Our expertise extends to different categories of due diligence, including:</strong></p>


                        <h5>Vendor Due Diligence:</h5>
                        <ul>
                            <li>We conduct thorough assessments of potential vendors and suppliers, evaluating their financial stability, operational capabilities, reputation, regulatory compliance, and quality standards.</li>
                            <li>Our vendor due diligence services help mitigate risks associated with supplier reliability, product quality, and regulatory compliance.</li>
                        </ul>

                        <h5>Tenant Due Diligence:</h5>
                        <ul>
                            <li>We assist landlords and property managers in assessing potential tenants by conducting comprehensive due diligence. This includes evaluating their financial stability, creditworthiness, rental history, and references.</li>
                            <li>Our tenant due diligence services enable landlords to make informed decisions, minimising risks related to non-payment, property damage, and lease violations.</li>
                        </ul>

                        <h5>Property Due Diligence:</h5>
                        <ul>
                            <li>We provide extensive due diligence services for real estate buyers and investors. Our team evaluates the legal status, title deeds, zoning regulations, environmental impact, physical condition, and any encumbrances or liens associated with the property.</li>
                            <li>Our property due diligence services help clients identify potential issues, estimate property value accurately, and make informed investment decisions.</li>
                        </ul>

                        <p><strong>With our meticulous approach and in-depth analysis, we ensure that our clients have the necessary information to make sound decisions while mitigating risks and ensuring compliance. Our due diligence services empower businesses to establish trust, minimise potential pitfalls, and achieve successful outcomes in their transactions and ventures.</strong></p>
                    </div>
                </div>
            </div>

            <h5><strong>Due Deligence Services</strong></h5>
            <ul class="mb-5 list-service">
                <li><a href="<?php echo base_url().'services/due-deligence/vendor-verification'; ?>">Vendor Due Diligence <i class="fa fa-arrow-right"></i></a></li>
                <li><a href="<?php echo base_url().'services/due-deligence/tenant-verification'; ?>">Tenant Due Diligence <i class="fa fa-arrow-right"></i></a></li>
                <li><a href="<?php echo base_url().'services/due-deligence/property-verification'; ?>">Property Due Diligence <i class="fa fa-arrow-right"></i></a></li>
                
            </ul>
          
            <!--project details row end-->
        </div>

    <!--project details section end-->

    <?php echo $common_cat ?>

    <!-- <?php //echo $common_clients ?> -->


</div>

<!-- Footer start -->
<?php echo $footer ?>
<!-- Footer end -->



<?php echo $common_js ?>
</body>
</html>
