<!DOCTYPE html>

<head>
    <title><?php echo $title ?></title>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1">
    <?php echo $common_css ?>
</head>

<body>

    <!--preloader start-->
    <div id="preloader">
        <div class="loader1">
            <span></span>
            <span></span>
            <span></span>
            <span></span>
            <span></span>
        </div>
    </div>
    <!--preloader end-->

    <!-- Main header start -->
    <?php echo $header_main ?>
    <!-- Main header end -->


    <div class="main">

        <!--page header section start-->
        <section class="" style="background: url('<?php echo base_url(); ?>ui/frontend/images/bg.png')no-repeat center center / cover">
            <div class="section-lg bg-gradient-primary text-white section-header">
                <div class="container">
                    <div class="row justify-content-center bread-crumb-position">
                        <div class="col-md-8 col-lg-7">
                            <div class="page-header-content text-center">
                                <h1>Property Verification</h1>
                                <nav aria-label="breadcrumb" class="d-flex justify-content-center">
                                    <ol class="breadcrumb breadcrumb-transparent breadcrumb-text-light">
                                        <li class="breadcrumb-item"><a href="<?php echo base_url(); ?>">Home</a></li>
                                        <li class="breadcrumb-item"><a href="<?php echo base_url().'services/contact-point-verification'; ?>">CPV</a></li>
                                        <li class="breadcrumb-item active" aria-current="page"> Property Verification</li>
                                    </ol>
                                </nav>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>
        <!--page header section end-->

        <!--project details section start-->
        <section class="section section-lg">
            <div class="container">

                <!--project details row start-->
                <div class="row align-items-center">
                    <div class="col-md-12">
                        <div class="project-details-content text-justify">
                            <!-- <h2>For Employment Purposes-</h2> -->
<h3>Property Verification</h3>
                            <p><strong>Looking for reliable property verification services? DHI Verification ensures accurate assessment and verification of property-related information with:</strong></p>
                            <ul>
                                <li>Personal visits to the property address to confirm its identification and authenticity.</li>
                                <li>Capture property photographs with geo locations for cross-verification with valuation reports.</li>
                                <li>Thorough verification of property documents such as Khata, Building Plans, and Tax Paid Receipts with issuing authorities.</li>
                                <li>Two modes of property document verification: verbal confirmation and certified copies.</li>
                                <li>Verbal confirmation involves visiting authorities and obtaining their comments on document authenticity.</li>
                                <li>Certified copies are obtained based on bank requirements, taking 1-4 weeks for processing.</li>
                                <li>Minimizing the risk of lending based on forged documents by ensuring authenticity verification.</li>
                                <li>Expert handling of property-based loans to mitigate the challenges of loan recovery in case of default.</li>
                                <li>Protection against fraud by identifying and preventing the submission of forged property documents.</li>
                            </ul>
                            <p><strong>Choose DHI Verification for accurate and reliable property verification services.</strong></p>
                        </div>
                    </div>
                </div>
            </div>
        </section>

            <div class="container mb-5">
                <div class="row">
                    <div class="col-lg-12">
                        <div class="project-details-content text-justify">
                            <h5>FAQs</h5>
                            <div class="accordion" id="accordionExample">
                                <div class="card">
                                    <div class="card-header" id="headingOne">
                                        <h2 class="mb-0">
                                            <button class="btn btn-link btn-block text-left" type="button" data-toggle="collapse" data-target="#collapseOne" aria-expanded="true" aria-controls="collapseOne">
                                            What documents are required for property-based loan verification?
                                            </button>
                                        </h2>
                                    </div>

                                    <div id="collapseOne" class="collapse show" aria-labelledby="headingOne" data-parent="#accordionExample">
                                        <div class="card-body">
                                            <ul>
                                                <li>For properties in BBMP/BDA jurisdiction: EC, Khata, Khata Extract, Tax paid receipt, and Building plan.</li>
                                                <li>For properties in other jurisdictions: EC, Form 9 and Form 11, Tax paid receipt, and Building plan.</li>    
                                            </ul>
                                        </div>
                                    </div>
                                </div>
                                <div class="card">
                                    <div class="card-header" id="headingTwo">
                                        <h2 class="mb-0">
                                            <button class="btn btn-link btn-block text-left collapsed" type="button" data-toggle="collapse" data-target="#collapseTwo" aria-expanded="false" aria-controls="collapseTwo">
                                            How are these documents verified?
                                            </button>
                                        </h2>
                                    </div>
                                    <div id="collapseTwo" class="collapse" aria-labelledby="headingTwo" data-parent="#accordionExample">
                                        <div class="card-body">
                                        <li>Verification is done through online sources and public data whenever available.</li>
                                           <li>Personal visits are conducted to respective departments/offices when information is not publicly available.</li>
                                        </div>
                                    </div>
                                </div>
                                <div class="card">
                                    <div class="card-header" id="headingThree">
                                        <h2 class="mb-0">
                                            <button class="btn btn-link btn-block text-left collapsed" type="button" data-toggle="collapse" data-target="#collapseThree" aria-expanded="false" aria-controls="collapseThree">
                                            Which property documents are frequently fabricated?
                                            </button>
                                        </h2>
                                    </div>
                                    <div id="collapseThree" class="collapse" aria-labelledby="headingThree" data-parent="#accordionExample">
                                        <div class="card-body">
                                            <ul>
                                                <li>Khata documents are most frequently tampered with, followed by building plans and tax paid receipts.</li>
                                                <li>In the case of apartments, apartment and floor numbers are sometimes altered to raise multiple loans on the same property.</li>
                                            </ul>
                                           
                                        </div>
                                    </div>
                                </div>
                                <div class="card">
                                    <div class="card-header" id="headingFour">
                                        <h2 class="mb-0">
                                            <button class="btn btn-link btn-block text-left collapsed" type="button" data-toggle="collapse" data-target="#collapseFour" aria-expanded="false" aria-controls="collapseFour">
                                            How much time does court verification take?
                                            </button>
                                        </h2>
                                    </div>
                                    <div id="collapseFour" class="collapse" aria-labelledby="headingFour" data-parent="#accordionExample">
                                        <div class="card-body">
                                            <ul>
                                                <li>Generally, court verification takes 1 to 2 working days.</li>
                                                <li>In cases where suspicion arises, it may take longer to ensure comprehensive verification.</li>
                                            </ul>
                                        </div>
                                    </div>
                                </div>
                                <div class="card">
                                    <div class="card-header" id="headingFive">
                                        <h2 class="mb-0">
                                            <button class="btn btn-link btn-block text-left collapsed" type="button" data-toggle="collapse" data-target="#collapseFive" aria-expanded="false" aria-controls="collapseFive">
                                            How many attempts are made before concluding a case as UTV?
                                            </button>
                                        </h2>
                                    </div>
                                    <div id="collapseFive" class="collapse" aria-labelledby="headingFive" data-parent="#accordionExample">
                                        <div class="card-body">
                                            <ul>
                                                <li>We make multiple attempts and explore different sources to gather information.</li>
                                                <li>If no information is obtained from any reliable source, we conclude the case as UTV.</li>
                                               
                                            </ul>
                                        </div>
                                    </div>
                                </div>
                                <div class="card">
                                    <div class="card-header" id="headingSix">
                                        <h2 class="mb-0">
                                            <button class="btn btn-link btn-block text-left collapsed" type="button" data-toggle="collapse" data-target="#collapseSix" aria-expanded="false" aria-controls="collapseSix">
                                            Does an employer need to obtain the employee's consent for verification?
                                            </button>
                                        </h2>
                                    </div>
                                    <div id="collapseSix" class="collapse" aria-labelledby="headingSix" data-parent="#accordionExample">
                                        <div class="card-body">
                                            <ul>
                                                <li>Yes, it is necessary to obtain the employee's consent before initiating any background verification process.</li>
                                                <li>We prioritize the importance of consent and ensure compliance with legal requirements.</li>
                                               
                                            </ul>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
               
                <!--project details row end-->
            </div>
        <!--project details section end-->

        <?php echo $common_cat ?>

        <!-- <?php //echo $common_clients ?> -->


    </div>

    <!-- Footer start -->
    <?php echo $footer ?>
    <!-- Footer end -->



    <?php echo $common_js ?>
</body>

</html>