<!DOCTYPE html>

<head>
    <title><?php echo $title ?></title>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1">
    <?php echo $common_css ?>
</head>

<body>

    <!--preloader start-->
    <div id="preloader">
        <div class="loader1">
            <span></span>
            <span></span>
            <span></span>
            <span></span>
            <span></span>
        </div>
    </div>
    <!--preloader end-->

    <!-- Main header start -->
    <?php echo $header_main ?>
    <!-- Main header end -->


    <div class="main">

        <!--page header section start-->
        <section class="" style="background: url('<?php echo base_url(); ?>ui/frontend/images/bg.png')no-repeat center center / cover">
            <div class="section-lg bg-gradient-primary text-white section-header">
                <div class="container">
                    <div class="row justify-content-center bread-crumb-position">
                        <div class="col-md-8 col-lg-7">
                            <div class="page-header-content text-center">
                                <h1>Litigation Verification</h1>
                                <nav aria-label="breadcrumb" class="d-flex justify-content-center">
                                    <ol class="breadcrumb breadcrumb-transparent breadcrumb-text-light">
                                        <li class="breadcrumb-item"><a href="<?php echo base_url(); ?>">Home</a></li>
                                        <li class="breadcrumb-item"><a href="<?php echo base_url().'services/contact-point-verification'; ?>">CPV</a></li>
                                        <li class="breadcrumb-item active" aria-current="page"> Litigation Verification</li>
                                    </ol>
                                </nav>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>
        <!--page header section end-->

        <!--project details section start-->
        <section class="section section-lg">
            <div class="container">

                <!--project details row start-->
                <div class="row align-items-center">
                    <div class="col-md-12">
                        <div class="project-details-content text-justify">
                            <!-- <h2>For Employment Purposes-</h2> -->
<h3>Property Verification</h3>
                            <p>Before making a credit decision, it is crucial to check if the loan applicant is involved in any judicial proceedings. An applicant's involvement in legal matters can have a significant impact on their ability to repay the loan. At DHI Verification, we provide comprehensive litigation verification services to assess the litigation history of individuals and advise banks and financial institutions accordingly.</p>

                            <p><strong>Our litigation verification includes checking for the following:</strong></p>
                            <ul>
                                <li><strong>Parole status: </strong>Verification of whether the applicant is on temporary release from prison.</li>
                                <li><strong>Cheque bounce cases: </strong>Checking if the applicant is involved in any cases related to bounced cheques.</li>
                                <li><strong>Habitual offender status: </strong>Assessing if the applicant has a history of repeated offenses.</li>
                                <li><strong>Wilful defaulter status: </strong>Verifying if the applicant has intentionally defaulted on previous loans.</li>
                                <li><strong>Debt Recovery Tribunal (DRT) cases: </strong>Checking if the applicant is facing any cases in the DRT.</li>
                                <li><strong>Criminal antecedents: </strong>Verifying if the applicant has any criminal records.</li>
                                <li><strong>Anticipatory bail status: </strong>Assessing if the applicant is on anticipatory bail.</li>
                                <li><strong>National Company Law Tribunal (NCLT) cases: </strong>Checking if the applicant is involved in any cases in the NCLT.</li>
                                <li><strong>Property litigation: </strong>Verifying if the applicant is engaged in any legal disputes related to properties.</li>
                            </ul>

                            <p>By conducting thorough litigation checks, we help banks and financial institutions make informed lending decisions while considering the potential risks associated with the applicant's litigation history. Our verification services cover the litigation status of individuals on a local, regional, or pan India basis, depending on the requirements of the bank or NBFC.</p>
                        </div>
                    </div>
                </div>
            </div>
        </section>

            <div class="container mb-5">
                <div class="row">
                    <div class="col-lg-12">
                        <div class="project-details-content text-justify">
                            <h5>FAQs</h5>
                            <div class="accordion" id="accordionExample">
                                <div class="card">
                                    <div class="card-header" id="headingOne">
                                        <h2 class="mb-0">
                                            <button class="btn btn-link btn-block text-left" type="button" data-toggle="collapse" data-target="#collapseOne" aria-expanded="true" aria-controls="collapseOne">
                                            What information is required to check the litigation status of applicants?
                                            </button>
                                        </h2>
                                    </div>

                                    <div id="collapseOne" class="collapse show" aria-labelledby="headingOne" data-parent="#accordionExample">
                                        <div class="card-body">
                                           <p>We need the applicant's name, father's name, address, and age.</p>
                                        </div>
                                    </div>
                                </div>
                                <div class="card">
                                    <div class="card-header" id="headingTwo">
                                        <h2 class="mb-0">
                                            <button class="btn btn-link btn-block text-left collapsed" type="button" data-toggle="collapse" data-target="#collapseTwo" aria-expanded="false" aria-controls="collapseTwo">
                                            How is the litigation status verified?
                                            </button>
                                        </h2>
                                    </div>
                                    <div id="collapseTwo" class="collapse" aria-labelledby="headingTwo" data-parent="#accordionExample">
                                        <div class="card-body">
                                           <p>We verify the litigation status through E-Courts, various Tribunals, NCLT, CCTNS (Crime and Criminal Tracking Network & Systems), and the list of wilful defaulters.</p>
                                        </div>
                                    </div>
                                </div>
                                <div class="card">
                                    <div class="card-header" id="headingThree">
                                        <h2 class="mb-0">
                                            <button class="btn btn-link btn-block text-left collapsed" type="button" data-toggle="collapse" data-target="#collapseThree" aria-expanded="false" aria-controls="collapseThree">
                                            Why should a financial institution check the litigation status of loan applicants?
                                            </button>
                                        </h2>
                                    </div>
                                    <div id="collapseThree" class="collapse" aria-labelledby="headingThree" data-parent="#accordionExample">
                                        <div class="card-body">
                                            <ul>
                                                <li>The ability to repay the loan can be severely affected if an applicant is involved in litigation.</li>
                                                <li>Checking for litigation helps identify habitual offenders who may defraud banks or financial institutions in one place and apply for loans elsewhere.</li>
                                                <li>Litigation checks can reveal cases involving the applicant related to cheque bounce offenses that may not reflect in credit rating reports.</li>
                                            </ul>
                                           
                                        </div>
                                    </div>
                                </div>
                               
                            </div>
                        </div>
                    </div>
                </div>
                <h6 class="mt-4"><strong>Choose DHI Verification for reliable litigation verification services. Our experienced professionals ensure thorough checks and timely delivery, providing banks and financial institutions with the necessary information to make informed credit decisions while mitigating potential risks associated with litigation.</strong></h6>
                <!--project details row end-->
            </div>

           
        <!--project details section end-->

        <?php echo $common_cat ?>

        <!-- <?php //echo $common_clients ?> -->


    </div>

    <!-- Footer start -->
    <?php echo $footer ?>
    <!-- Footer end -->



    <?php echo $common_js ?>
</body>

</html>