<!DOCTYPE html>

<head>
    <title><?php echo $title ?></title>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1">
    <?php echo $common_css ?>
</head>

<body>

    <!--preloader start-->
    <div id="preloader">
        <div class="loader1">
            <span></span>
            <span></span>
            <span></span>
            <span></span>
            <span></span>
        </div>
    </div>
    <!--preloader end-->

    <!-- Main header start -->
    <?php echo $header_main ?>
    <!-- Main header end -->


    <div class="main">

        <!--page header section start-->
        <section class="" style="background: url('<?php echo base_url(); ?>ui/frontend/images/bg.png')no-repeat center center / cover">
            <div class="section-lg bg-gradient-primary text-white section-header">
                <div class="container">
                    <div class="row justify-content-center bread-crumb-position">
                        <div class="col-md-8 col-lg-7">
                            <div class="page-header-content text-center">
                                <h1>KYC Verification</h1>
                                <nav aria-label="breadcrumb" class="d-flex justify-content-center">
                                    <ol class="breadcrumb breadcrumb-transparent breadcrumb-text-light">
                                        <li class="breadcrumb-item"><a href="<?php echo base_url(); ?>">Home</a></li>
                                        <li class="breadcrumb-item"><a href="<?php echo base_url().'services/contact-point-verification'; ?>">CPV</a></li>
                                        <li class="breadcrumb-item active" aria-current="page"> KYC Verification</li>
                                    </ol>
                                </nav>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>
        <!--page header section end-->

        <!--project details section start-->
        <section class="section section-lg">
            <div class="container">

                <!--project details row start-->
                <div class="row align-items-center">
                    <div class="col-md-12">
                        <div class="project-details-content text-justify">
                            <!-- <h2>For Employment Purposes-</h2> -->
<h3>KYC Document Verification</h3>
                            <p><strong>DHI Verification offers professional and efficient KYC services, ensuring timely and accurate verification of identity documents through online verification and government databases. Looking for reliable KYC verification services? DHI Verification offers professional identity document verification with:</strong></p>
                            <ul>
                                <li>Thorough verification of identity documents to confirm the authenticity of personal details.</li>
                                <li>Cross-checking against public databases and watch lists for enhanced security.</li>
                                <li>Validating proof of age and residence for various day-to-day activities.</li>
                                <li>Verification of photo identity for airports and other identity-dependent situations.</li>
                                <li>Enabling access to government benefits and services through PAN and Aadhar verification.</li>
                                <li>Ensuring the integrity of identity documents to prevent identity theft and impersonation.</li>
                                <li>Advising banks and financial institutions on collecting multiple identity documents for easy cross-verification.</li>
                                <li>Online verification of identity documents through issuing authorities' websites and public databases.</li>
                            </ul>
                        </div>
                    </div>
                </div>
            </div>
        </section>

            <div class="container mb-5">
                <div class="row">
                    <div class="col-lg-12">
                        <div class="project-details-content text-justify">
                            <h5>FAQs</h5>
                            <div class="accordion" id="accordionExample">
                                <div class="card">
                                    <div class="card-header" id="headingOne">
                                        <h2 class="mb-0">
                                            <button class="btn btn-link btn-block text-left" type="button" data-toggle="collapse" data-target="#collapseOne" aria-expanded="true" aria-controls="collapseOne">
                                            What are the commonly used Identity Documents?
                                            </button>
                                        </h2>
                                    </div>

                                    <div id="collapseOne" class="collapse show" aria-labelledby="headingOne" data-parent="#accordionExample">
                                        <div class="card-body">
                                            <ul>
                                                <li>Aadhar Card.</li>
                                                <li>Passport.</li>   
                                                <li>PAN Card.</li> 
                                                <li>Driving License.</li> 
                                                <li>Voter ID.</li> 
                                               
                                            </ul>
                                        </div>
                                    </div>
                                </div>
                                <div class="card">
                                    <div class="card-header" id="headingTwo">
                                        <h2 class="mb-0">
                                            <button class="btn btn-link btn-block text-left collapsed" type="button" data-toggle="collapse" data-target="#collapseTwo" aria-expanded="false" aria-controls="collapseTwo">
                                            Which Identity Documents can be used as Address Proof?
                                            </button>
                                        </h2>
                                    </div>
                                    <div id="collapseTwo" class="collapse" aria-labelledby="headingTwo" data-parent="#accordionExample">
                                        <div class="card-body">
                                        <li>Aadhar Card.</li>
                                           <li>Passport.</li>
                                           <li>Driving License.</li>
                                           <li>Voter ID.</li>
                                           <li>Bank passbook (valid address proof).</li>
                                           <li>In some situations, Ration Card, Birth Certificates, and Matriculation Certificates may also be accepted as identity proof.</li>
                                        </div>
                                    </div>
                                </div>
                                <div class="card">
                                    <div class="card-header" id="headingThree">
                                        <h2 class="mb-0">
                                            <button class="btn btn-link btn-block text-left collapsed" type="button" data-toggle="collapse" data-target="#collapseThree" aria-expanded="false" aria-controls="collapseThree">
                                            As a Banker/Financial Institution, which Identity Documents should be collected from applicants?
                                            </button>
                                        </h2>
                                    </div>
                                    <div id="collapseThree" class="collapse" aria-labelledby="headingThree" data-parent="#accordionExample">
                                        <div class="card-body">
                                            <ul>
                                                <li>It is advisable to collect documents that can be verified through Government databases.</li>
                                                <li>PAN, Aadhar, Driving License, and Voter ID can be verified online.</li>
                                            </ul>
                                           
                                        </div>
                                    </div>
                                </div>
                                <div class="card">
                                    <div class="card-header" id="headingFour">
                                        <h2 class="mb-0">
                                            <button class="btn btn-link btn-block text-left collapsed" type="button" data-toggle="collapse" data-target="#collapseFour" aria-expanded="false" aria-controls="collapseFour">
                                            Should we collect multiple identity documents?
                                            </button>
                                        </h2>
                                    </div>
                                    <div id="collapseFour" class="collapse" aria-labelledby="headingFour" data-parent="#accordionExample">
                                        <div class="card-body">
                                            <ul>
                                                <li>Yes, it is advisable to collect multiple identity documents.</li>
                                                <li>Having multiple documents allows for cross-verification, ensuring the authenticity and identity of an individual.</li>
                                            </ul>
                                        </div>
                                    </div>
                                </div>
                                <div class="card">
                                    <div class="card-header" id="headingFive">
                                        <h2 class="mb-0">
                                            <button class="btn btn-link btn-block text-left collapsed" type="button" data-toggle="collapse" data-target="#collapseFive" aria-expanded="false" aria-controls="collapseFive">
                                            How are the Identity Documents verified?
                                            </button>
                                        </h2>
                                    </div>
                                    <div id="collapseFive" class="collapse" aria-labelledby="headingFive" data-parent="#accordionExample">
                                        <div class="card-body">
                                            <ul>
                                                <li>Identity Documents are verified online through the websites or public databases of the issuing authorities.</li>
                                                <li>DHI utilizes these sources to verify the authenticity and validity of the submitted Identity Documents.</li>
                                            </ul>
                                        </div>
                                    </div>
                                </div>
                              
                            </div>
                        </div>
                    </div>
                </div>
                <h6 class="mt-4"><strong>Choose DHI Verification for accurate and reliable KYC verification services. Our experienced professionals ensure thorough verification of Identity Documents to confirm the identity of individuals, minimizing the risk of identity theft and impersonation.</strong></h6>
               
                <!--project details row end-->
            </div>
        <!--project details section end-->

        <?php echo $common_cat ?>

        <!-- <?php //echo $common_clients ?> -->


    </div>

    <!-- Footer start -->
    <?php echo $footer ?>
    <!-- Footer end -->



    <?php echo $common_js ?>
</body>

</html>