<!DOCTYPE html>

<head>
    <title><?php echo $title ?></title>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1">
    <?php echo $common_css ?>
</head>

<body>

    <!--preloader start-->
    <div id="preloader">
        <div class="loader1">
            <span></span>
            <span></span>
            <span></span>
            <span></span>
            <span></span>
        </div>
    </div>
    <!--preloader end-->

    <!-- Main header start -->
    <?php echo $header_main ?>
    <!-- Main header end -->


    <div class="main">

        <!--page header section start-->
        <section class="" style="background: url('<?php echo base_url(); ?>ui/frontend/images/bg.png')no-repeat center center / cover">
            <div class="section-lg bg-gradient-primary text-white section-header">
                <div class="container">
                    <div class="row justify-content-center bread-crumb-position">
                        <div class="col-md-8 col-lg-7">
                            <div class="page-header-content text-center">
                                <h1>Income Verification</h1>
                                <nav aria-label="breadcrumb" class="d-flex justify-content-center">
                                    <ol class="breadcrumb breadcrumb-transparent breadcrumb-text-light">
                                        <li class="breadcrumb-item"><a href="<?php echo base_url(); ?>">Home</a></li>
                                        <li class="breadcrumb-item"><a href="<?php echo base_url().'services/contact-point-verification'; ?>">CPV</a></li>
                                        <li class="breadcrumb-item active" aria-current="page"> Income Verification</li>
                                    </ol>
                                </nav>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>
        <!--page header section end-->

        <!--project details section start-->
        <section class="section section-lg">
            <div class="container">

                <!--project details row start-->
                <div class="row align-items-center">
                    <div class="col-md-12">
                        <div class="project-details-content text-justify">
                            <!-- <h2>For Employment Purposes-</h2> -->
                            <h3>Income Verification</h3>
                            <p><strong>Looking for reliable income verification services? DHI Verification provides thorough and professional assessment of applicant income with:</strong></p>
                            <ul>
                                <li>Personal visits to verify income sources such as employment, business, rental, and agriculture.</li>
                                <li>Cross-verification of salary income through salary slips, bank statements, Form-16, and ITR.</li>
                                <li>Validation of business income through bank statements, ITR, and GST filings.</li>
                                <li>Verification of rental income using income figures, bank statements, and ITR.</li>
                                <li>Corroborative evidence for income from tuition, catering, construction, tailoring, etc.</li>
                                <li>Checking bank statements, ITR, and conducting neighbour inquiries to confirm income sources.</li>
                                <li>Collection of necessary documents for income verification based on applicant type (salaried, business, rental income).</li>
                                <li>Online verification through available public data and personal visits to relevant departments/offices.</li>
                                <li>Identifying frequently tampered income documents like ITR, pay slips, and rental agreements.</li>
                                <li>Ensuring accurate verification to protect against fraudulent income claims.</li>
                            </ul>
                            <p><strong>Choose DHI Verification for accurate and reliable property verification services.</strong></p>
                        </div>
                    </div>
                </div>
            </div>
        </section>

        <div class="container mb-5">
            <div class="row">
                <div class="col-lg-12">
                    <div class="project-details-content text-justify">
                        <h5>FAQs</h5>
                        <div class="accordion" id="accordionExample">
                            <div class="card">
                                <div class="card-header" id="headingOne">
                                    <h2 class="mb-0">
                                        <button class="btn btn-link btn-block text-left" type="button" data-toggle="collapse" data-target="#collapseOne" aria-expanded="true" aria-controls="collapseOne">
                                            What documents are required from salaried applicants for income verification?
                                        </button>
                                    </h2>
                                </div>

                                <div id="collapseOne" class="collapse show" aria-labelledby="headingOne" data-parent="#accordionExample">
                                    <div class="card-body">
                                        <ul>
                                            <li>Last three month’s payslips.</li>
                                            <li>UAN Number issued by the EPF Department.</li>
                                            <li>Last six months bank statement/</li>
                                            <li>Last three years Form-16.</li>
                                            <li>Last three years ITR (Income Tax Return).</li>
                                            <li>Form 26AS.</li>
                                        </ul>
                                    </div>
                                </div>
                            </div>
                            <div class="card">
                                <div class="card-header" id="headingTwo">
                                    <h2 class="mb-0">
                                        <button class="btn btn-link btn-block text-left collapsed" type="button" data-toggle="collapse" data-target="#collapseTwo" aria-expanded="false" aria-controls="collapseTwo">
                                            What documents are required from business income applicants for income verification?
                                        </button>
                                    </h2>
                                </div>
                                <div id="collapseTwo" class="collapse" aria-labelledby="headingTwo" data-parent="#accordionExample">
                                    <div class="card-body">
                                        <li>Last one year bank statement.</li>
                                        <li>Last one year GST Filings.</li>
                                        <li>Last three years ITR & balance sheet.</li>
                                        <li>Form 26AS.</li>
                                    </div>
                                </div>
                            </div>
                            <div class="card">
                                <div class="card-header" id="headingThree">
                                    <h2 class="mb-0">
                                        <button class="btn btn-link btn-block text-left collapsed" type="button" data-toggle="collapse" data-target="#collapseThree" aria-expanded="false" aria-controls="collapseThree">
                                            What documents are required from rental income applicants for income verification?
                                        </button>
                                    </h2>
                                </div>
                                <div id="collapseThree" class="collapse" aria-labelledby="headingThree" data-parent="#accordionExample">
                                    <div class="card-body">
                                        <ul>
                                            <li>Rental agreements.</li>
                                            <li>Last year bank statement of the account where rental income is credited.</li>
                                        </ul>

                                    </div>
                                </div>
                            </div>
                            <div class="card">
                                <div class="card-header" id="headingFour">
                                    <h2 class="mb-0">
                                        <button class="btn btn-link btn-block text-left collapsed" type="button" data-toggle="collapse" data-target="#collapseFour" aria-expanded="false" aria-controls="collapseFour">
                                            How are these income documents verified?
                                        </button>
                                    </h2>
                                </div>
                                <div id="collapseFour" class="collapse" aria-labelledby="headingFour" data-parent="#accordionExample">
                                    <div class="card-body">
                                        <ul>
                                            <li>Whenever possible, verification is done through online sources and public data.</li>
                                            <li>In cases where information is not publicly available, personal visits are made to the respective departments/offices for verification.</li>
                                        </ul>
                                    </div>
                                </div>
                            </div>
                            <div class="card">
                                <div class="card-header" id="headingFive">
                                    <h2 class="mb-0">
                                        <button class="btn btn-link btn-block text-left collapsed" type="button" data-toggle="collapse" data-target="#collapseFive" aria-expanded="false" aria-controls="collapseFive">
                                            Which income documents are frequently fabricated or tampered with?
                                        </button>
                                    </h2>
                                </div>
                                <div id="collapseFive" class="collapse" aria-labelledby="headingFive" data-parent="#accordionExample">
                                    <div class="card-body">
                                        <ul>
                                            <li>ITR (Income Tax Return) is the most frequently tampered income document.</li>
                                            <li>Pay slips and bank statements are also commonly tampered with.</li>
                                            <li>Rental income documents such as rental agreements and rental receipts are susceptible to fabrication.</li>
                                            <li>In cases where applicants claim income from sources like tuition, catering, tailoring, civil works, or labor supply, DHI looks for corroborative evidence to confirm these income sources.</li>

                                        </ul>
                                    </div>
                                </div>
                            </div>

                        </div>
                    </div>
                </div>
            </div>
            <h6 class="mt-5 text-center"><strong>Choose DHI Verification for accurate and reliable income verification services.</strong></h6>

            <!--project details row end-->
        </div>
        <!--project details section end-->

        <?php echo $common_cat ?>

        <!-- <?php //echo $common_clients 
                ?> -->


    </div>

    <!-- Footer start -->
    <?php echo $footer ?>
    <!-- Footer end -->



    <?php echo $common_js ?>
</body>

</html>