<!DOCTYPE html>

<head>
    <title><?php echo $title ?></title>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1">
    <?php echo $common_css ?>
</head>

<body>

    <!--preloader start-->
    <div id="preloader">
        <div class="loader1">
            <span></span>
            <span></span>
            <span></span>
            <span></span>
            <span></span>
        </div>
    </div>
    <!--preloader end-->

    <!-- Main header start -->
    <?php echo $header_main ?>
    <!-- Main header end -->


    <div class="main">

        <!--page header section start-->
        <section class="" style="background: url('<?php echo base_url(); ?>ui/frontend/images/bg.png')no-repeat center center / cover">
            <div class="section-lg bg-gradient-primary text-white section-header">
                <div class="container">
                    <div class="row justify-content-center bread-crumb-position">
                        <div class="col-md-8 col-lg-7">
                            <div class="page-header-content text-center">
                                <h1>Education Verification</h1>
                                <nav aria-label="breadcrumb" class="d-flex justify-content-center">
                                    <ol class="breadcrumb breadcrumb-transparent breadcrumb-text-light">
                                        <li class="breadcrumb-item"><a href="<?php echo base_url(); ?>">Home</a></li>
                                        <li class="breadcrumb-item"><a href="<?php echo base_url().'services/contact-point-verification'; ?>">CPV</a></li>
                                        <li class="breadcrumb-item active" aria-current="page"> Education Verification</li>
                                    </ol>
                                </nav>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>
        <!--page header section end-->

        <!--project details section start-->
        <section class="section section-lg">
            <div class="container">

                <!--project details row start-->
                <div class="row align-items-center">
                    <div class="col-md-12">
                        <div class="project-details-content text-justify">
                            <!-- <h2>For Employment Purposes-</h2> -->
<h3>Education Verification</h3>
                            <p><strong>Looking to verify educational credentials? DHI Verification offers professional education verification services with:</strong></p>
                            <ul>
                                <li>Thorough verification of admission details, including qualification examination, entrance examination rank, admission confirmation, and fee breakdown.</li>
                                <li>Timely collection and verification of marks cards, admission letters, and other relevant documents.</li>
                                <li>Online verification through public databases and personal visits to institutes and departments when necessary.</li>
                                <li>Ensuring genuineness of admission and confirming the accuracy of educational information.</li>
                                <li>Trusted and experienced professionals dedicated to delivering quality and reliable education verification services.</li>
                            </ul>
                        </div>
                    </div>
                </div>
            </div>
        </section>

            <div class="container mb-5">
                <div class="row">
                    <div class="col-lg-12">
                        <div class="project-details-content text-justify">
                            <h5>FAQs</h5>
                            <div class="accordion" id="accordionExample">
                                <div class="card">
                                    <div class="card-header" id="headingOne">
                                        <h2 class="mb-0">
                                            <button class="btn btn-link btn-block text-left" type="button" data-toggle="collapse" data-target="#collapseOne" aria-expanded="true" aria-controls="collapseOne">
                                            What documents are to be collected for Admission to Professional courses?
                                            </button>
                                        </h2>
                                    </div>

                                    <div id="collapseOne" class="collapse show" aria-labelledby="headingOne" data-parent="#accordionExample">
                                        <div class="card-body">
                                            <ul>
                                                <li>Marks cards of Qualifying examination passed.</li>
                                                <li>Entrance Examination Rank.</li>  
                                                <li>Quota under which admission is offered.</li>  
                                                <li>Admission confirmation letter from the institute.</li>
                                                <li>Fee break-up details.</li>
                                                <p>For Admission to General Degree Programmes:</p>
                                                <ul>
                                                <li>Marks cards of Qualifying examination passed.</li>
                                                <li>Quota under which admission is offered.</li>
                                                <li>Admission confirmation letter from the institute.</li>
                                                <li>Fee break-up details.</li>
                                                </ul>
                                                
                                            </ul>
                                        </div>
                                    </div>
                                </div>
                                <div class="card">
                                    <div class="card-header" id="headingTwo">
                                        <h2 class="mb-0">
                                            <button class="btn btn-link btn-block text-left collapsed" type="button" data-toggle="collapse" data-target="#collapseTwo" aria-expanded="false" aria-controls="collapseTwo">
                                            How are these documents verified?
                                            </button>
                                        </h2>
                                    </div>
                                    <div id="collapseTwo" class="collapse" aria-labelledby="headingTwo" data-parent="#accordionExample">
                                        <div class="card-body">
                                        <li>Wherever information is available online in the form of public data, it is verified, and evidence is collected.</li>
                                           <li>In cases where information is not publicly available, DHI Verification conducts personal visits to the respective institutes/departments/offices to verify the authenticity of the provided documents.</li>
                                        </div>
                                    </div>
                                </div>                                                                                    
                            </div>
                        </div>
                    </div>
                </div>
               
                <!--project details row end-->
            </div>
        <!--project details section end-->

        <?php echo $common_cat ?>

        <!-- <?php //echo $common_clients ?> -->


    </div>

    <!-- Footer start -->
    <?php echo $footer ?>
    <!-- Footer end -->



    <?php echo $common_js ?>
</body>

</html>