<!DOCTYPE html>
<head>
   <title><?php echo $title ?></title>
   <meta charset="utf-8">
   <meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1">
   <?php echo $common_css ?>
</head>
<body>

 <!--preloader start-->
 <div id="preloader">
        <div class="loader1">
            <span></span>
            <span></span>
            <span></span>
            <span></span>
            <span></span>
        </div>
    </div>
    <!--preloader end-->

<!-- Main header start -->
<?php echo $header_main ?>
<!-- Main header end -->


<div class="main">

<!--page header section start-->
<section class="" style="background: url('<?php echo base_url(); ?>ui/frontend/images/bg.png')no-repeat center center / cover">
    <div class="section-lg bg-gradient-primary text-white section-header">
        <div class="container">
            <div class="row justify-content-center bread-crumb-position">
                <div class="col-md-8 col-lg-7">
                    <div class="page-header-content text-center">
                        <h1>Contact Point Verification</h1>
                        <nav aria-label="breadcrumb" class="d-flex justify-content-center">
                            <ol class="breadcrumb breadcrumb-transparent breadcrumb-text-light">
                                <li class="breadcrumb-item"><a href="<?php echo base_url(); ?>">Home</a></li>
                                <li class="breadcrumb-item active" aria-current="page">Contact Point Verification</li>
                            </ol>
                        </nav>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>
<!--page header section end-->

    <!--project details section start-->
    <!-- <section class="section section-lg"> -->
        <div class="container">
            

            <!--project details row start-->
            <div class="row mt-5 mb-3">
                <div class="col-md-12">
                    <div class="project-details-content text-justify">
                        <h3>Contact Point Verification</h3>
                        <p><strong>Contact Point Verification (CPV) is a crucial process for banks, ensuring accurate scrutiny and approval of loan applications. At DHI, we go beyond the traditional approach of document verification and provide comprehensive CPV services. Here's how we add value through our CPV process:</strong></p>
                        <ul>
                            <li>Expertise and Resources: With reduced internal expertise, banks have adopted the Central Loan Processing Model (CLP) model, where Branch Heads focus on business development while the CLP  handles scrutiny and approval. DHI fills the gap by conducting the due diligence of loan applicants and help you to take informed decisions.</li>
                            <li>Data Gathering and Evidence: Our CPV process goes beyond document authentication. We gather data and evidence through customer and field interactions, serving as true advocates for banks. This comprehensive approach facilitates quick and accurate decision-making in loan applications.</li>
                            <li>Communication and Collaboration: We recognize the importance of seamless communication and collaboration between the Branch, CPC, and customers. By ensuring effective communication channels, we strive to maintain quality and timely delivery, thus preventing Non-Performing Assets (NPAs).</li>
                            <li>Customized Software: DHI utilizes in-house proprietary software that can be highly customized to meet the specific needs of each bank. This software facilitates collaboration among different stakeholders and is integrated with a mobile app for easy access and streamlined processes.</li>
                            <li>Quality and Timely Delivery: Our CPV services prioritise both quality assurance and timely delivery. By leveraging technology and efficient processes, we aim to provide accurate verification results within the required time frame.</li>
                        </ul>

                        <h6><strong>At DHI, we understand the significance of CPV in the loan approval process. Through our expertise, data-driven approach, and collaborative tools, we strive to enhance the accuracy, efficiency, and effectiveness of contact point verification, ensuring a smooth loan application process for banks and their customers.</strong></h6>
                    </div>
                </div>
            </div>

        <h5><strong>CPV Services</strong></h5>
            <ul class="mb-5 list-service">
                <li><a href="<?php echo base_url().'services/cpv/address_verification'; ?>">Address Verification <i class="fa fa-arrow-right"></i></a></li>
                <li><a href="<?php echo base_url().'services/cpv/kyc-document-verification'; ?>">KYC Verification <i class="fa fa-arrow-right"></i></a></li>
                <li><a href="<?php echo base_url().'services/cpv/education-verification'; ?>">Education Verification <i class="fa fa-arrow-right"></i></a></li>
                <li><a href="<?php echo base_url().'services/cpv/income-verification'; ?>">Income Verification <i class="fa fa-arrow-right"></i></a></li>
                <li><a href="<?php echo base_url().'services/cpv/property-verification'; ?>">Property Verification <i class="fa fa-arrow-right"></i></a></li>
                <li><a href="<?php echo base_url().'services/cpv/litigation-verification'; ?>">Litigation Verification <i class="fa fa-arrow-right"></i></a></li>
                
            </ul>
          
            <!--project details row end-->
        </div>

    <!--project details section end-->

    <?php echo $common_cat ?>

    <!-- <?php //echo $common_clients ?> -->


</div>

<!-- Footer start -->
<?php echo $footer ?>
<!-- Footer end -->



<?php echo $common_js ?>
</body>
</html>
