<!DOCTYPE html>
<head>
   <title><?php echo $title ?></title>
   <meta charset="utf-8">
   <meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1">
   <?php echo $common_css ?>
</head>
<body>

 <!--preloader start-->
 <div id="preloader">
        <div class="loader1">
            <span></span>
            <span></span>
            <span></span>
            <span></span>
            <span></span>
        </div>
    </div>
    <!--preloader end-->

<!-- Main header start -->
<?php echo $header_main ?>
<!-- Main header end -->


<div class="main">

<!--page header section start-->
<section class="" style="background: url('<?php echo base_url(); ?>ui/frontend/images/bg.png')no-repeat center center / cover">
    <div class="section-lg bg-gradient-primary text-white section-header">
        <div class="container">
            <div class="row justify-content-center bread-crumb-position">
                <div class="col-md-8 col-lg-7">
                    <div class="page-header-content text-center">
                        <h1>Contact Point Verification</h1>
                        <nav aria-label="breadcrumb" class="d-flex justify-content-center">
                            <ol class="breadcrumb breadcrumb-transparent breadcrumb-text-light">
                                <li class="breadcrumb-item"><a href="<?php echo base_url(); ?>">Home</a></li>
                                <li class="breadcrumb-item active" aria-current="page">Contact Point Verification</li>
                            </ol>
                        </nav>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>
<!--page header section end-->

    <!--project details section start-->
    <section class="section section-lg">
        <div class="container">
            <div class="row justify-content-between align-items-center">
                <div class="col-md-12 col-lg-12 mb-4 mb-md-0 mb-lg-0">
                    <div class="img-wrap mb-md-4 mb-lg-0">
                        <img src="<?php echo base_url(); ?>ui/frontend/images/bc.jpg" alt="project" class="img-fluid rounded shadow-sm" />
                    </div>
                </div>
                <!-- <div class="col-md-12 col-lg-4">
                    <?php echo $common_service_menu ?>
                </div> -->
            </div>

            <!--project details row start-->
            <div class="row mt-5">
                <div class="col-md-12">
                    <div class="project-details-content text-justify">
                        <h2>Contact Point Verification</h2>
                        <p>Banks historically relied on internal staff for CPV, these expertise were often available at Branch levels. Reduced expertise resources have made Banks to adopt the model of CPC (Central Processing Cell) for loan application scrutiny and approval. This has led to Branch Heads vested with responsibility of focusing on business development and customer relations, while CPC with the scrutiny and approval. This has resulted in onboarding vendors who could facilitate CPV services for the bank.</p>
                        <p>At DHI, CPV is not just verifying documents for its authenticity unlike most vendors treat it. It is to gather data and evidence during customer/field interaction as true advocates of Banks, in order to facilitate quick and accurate decision making of the loan application. DHI additionally understands how Communication, Collaboration between Branch-CPC-Customer for Quality and Timely Delivery is pivotal to avoid NPA’s. We achieve this through an in-house proprietary software (which can be highly customized to Bank specific needs for each of the services listed below) for Collaboration and integrated with a Mobile App.</p>
                    </div>
                </div>
            </div>
            <div class="row mt-4">
                <div class="col-md-12">
                    <h5>We currently offer the following services as part of CPV</h5>
                </div>
                <div class="col-md-6">
                    <div class="project-details-feature">
                        <ul class="list-unstyled tech-feature-list">
                            <li class="py-1"><span class="ti-control-forward mr-2 text-secondary"></span><a href="<?php echo base_url(); ?>services/address_verification">Address Verification</a>
                            </li>
                            <li class="py-1"><span class="ti-control-forward mr-2 text-secondary"></span><a href="<?php echo base_url(); ?>services/employment_verification">Employment Verification</a>
                            </li>
                            <li class="py-1"><span class="ti-control-forward mr-2 text-secondary"></span><a href="<?php echo base_url(); ?>services/income_verification">Income Verification</a></li>
                            <li class="py-1"><span class="ti-control-forward mr-2 text-secondary"></span><a href="<?php echo base_url(); ?>services/proforma_verification">Proforma Verification</a></li>
                            <li class="py-1"><span class="ti-control-forward mr-2 text-secondary"></span><a href="<?php echo base_url(); ?>services/property_verification">Property Verification</a></li>
                            <li class="py-1"><span class="ti-control-forward mr-2 text-secondary"></span><a href="<?php echo base_url(); ?>services/kyc_document_verification">KYC document Verification</a>
                            </li>
                        </ul>
                    </div>
                </div>
                <div class="col-md-6">
                    <div class="project-details-feature">
                        <ul class="list-unstyled tech-feature-list">
                            <li class="py-1"><span class="ti-control-forward mr-2 text-secondary"></span><a href="<?php echo base_url(); ?>services/plan_approval_verification_property">Plan Approval Verification – Property</a>
                            </li>
                            <li class="py-1"><span class="ti-control-forward mr-2 text-secondary"></span><a href="<?php echo base_url(); ?>services/katha_verification_property">Katha Verification – Property</a></li>
                            <li class="py-1"><span class="ti-control-forward mr-2 text-secondary"></span><a href="<?php echo base_url(); ?>services/education_verification">Education Verification</a></li>
                            <li class="py-1"><span class="ti-control-forward mr-2 text-secondary"></span><a href="<?php echo base_url(); ?>services/business_verification">Business Verification</a></li>
                            <li class="py-1"><span class="ti-control-forward mr-2 text-secondary"></span><a href="<?php echo base_url(); ?>services/bank_statement_verification">Bank statement Verification</a></li>
                        </ul>
                    </div>
                </div>
            </div>
            <!--project details row end-->
        </div>
    </section>
    <!--project details section end-->

    <?php echo $common_cat ?>

    <?php echo $common_clients ?>


</div>

<!-- Footer start -->
<?php echo $footer ?>
<!-- Footer end -->



<?php echo $common_js ?>
</body>
</html>
