<!DOCTYPE html>

<head>
    <title><?php echo $title ?></title>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1">
    <?php echo $common_css ?>
</head>

<body>

    <!--preloader start-->
    <div id="preloader">
        <div class="loader1">
            <span></span>
            <span></span>
            <span></span>
            <span></span>
            <span></span>
        </div>
    </div>
    <!--preloader end-->

    <!-- Main header start -->
    <?php echo $header_main ?>
    <!-- Main header end -->


    <div class="main">

        <!--page header section start-->
        <section class="" style="background: url('<?php echo base_url(); ?>ui/frontend/images/bg.png')no-repeat center center / cover">
            <div class="section-lg bg-gradient-primary text-white section-header">
                <div class="container">
                    <div class="row justify-content-center bread-crumb-position">
                        <div class="col-md-8 col-lg-7">
                            <div class="page-header-content text-center">
                                <h1>Address Verification</h1>
                                <nav aria-label="breadcrumb" class="d-flex justify-content-center">
                                    <ol class="breadcrumb breadcrumb-transparent breadcrumb-text-light">
                                        <li class="breadcrumb-item"><a href="<?php echo base_url(); ?>">Home</a></li>
                                        <li class="breadcrumb-item"><a href="<?php echo base_url().'services/contact-point-verification'; ?>">CPV</a></li>
                                        <li class="breadcrumb-item active" aria-current="page"> Address Verification</li>
                                    </ol>
                                </nav>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>
        <!--page header section end-->

        <!--project details section start-->
        <section class="section section-lg">
            <div class="container">

                <!--project details row start-->
                <div class="row align-items-center">
                    <div class="col-md-12">
                        <div class="project-details-content text-justify">
                            <!-- <h2>For Employment Purposes-</h2> -->
                            <h3>Address Verification</h3>
                            <h6>Need for Residence Address Verification</h6>
                            <ul>
                                <li>For Banks, Co-operative Banks, Non-Banking Financial Institutions, Credit Societies, Chit Companies, etc it is mandatory to verify the residence of a loan applicant.</li>
                                <li>It is also necessary for regular follow-ups, sending reminders if the repayment is irregular.</li>
                                <li>In the event the loan becomes an NPA, then demand notices, legal notices are to be sent to the place where the defaulter resides.</li>
                                <li>Many people with fraudulent intentions approach financial institutions. Such people hide their original address and give the wrong address.</li>
                                <li>Few people may give the wrong address to the financial institution with fraudulent intentions. We personally visit the residence of the applicant to confirm the genuinity of the same.</li>
                            </ul>

                            <h6>Need for Income (Business/Employment/Rental Income) Address Verification</h6>
                            <ul>
                                <li>It is important to visit the applicant's income address verification whether it is employment place, business place or rental income places. In many instances business place, employment place, rental income places are created temporarily to avail loans from banks.</li>
                                <li>Employment place verification must be done by someone physically. We personally visit the employment place and enquire whether the applicant is employed in the place which he/she has declared in the loan application. We collect proof of employment such as employee ID card, visiting card etc. We take the photographs of employment place along with geo-locations.</li>
                                <li>Business place verification must be done by someone physically. We personally visit the business place and find out whether the business really exists, whether the business is running in a normal course, whether the stocks are available so on. We collect proof of
                                    business such as business license, labour certificate son on. We take the photographs of business place along with geo-locations.</li>
                                <li>Rental Income place verification must be done by someone physically. In case of rental
                                    income, we personally visit the rental income place and enquire about the same. We take the photographs of rental income place along with geo-locations.</li>
                            </ul>

                            <h6>Need for Property Address Verification</h6>
                            <ul>
                                <li>We visit the property place (for property-based loans) and confirm the property address. Whether it an apartment, independent building, empty site (plot) so on. We take
                                    photographs of property place along with geo-locations.</li>
                            </ul>

                            <p>Are you looking for Contact Point Verification Agency, which is highly experienced and run by professionals!? Look no further. DHI Verification offers quality and timely delivery of CPV Services.</p>
                        </div>
                    </div>
                </div>
            </div>
        </section>

        <div class="container mb-5">
            <div class="row">
                <div class="col-lg-12">
                    <div class="project-details-content text-justify">
                        <h5>FAQs</h5>
                        <div class="accordion" id="accordionExample">
                            <div class="card">
                                <div class="card-header" id="headingOne">
                                    <h2 class="mb-0">
                                        <button class="btn btn-link btn-block text-left" type="button" data-toggle="collapse" data-target="#collapseOne" aria-expanded="true" aria-controls="collapseOne">
                                            Does every Applicant's residence address need to be verified!?
                                        </button>
                                    </h2>
                                </div>

                                <div id="collapseOne" class="collapse show" aria-labelledby="headingOne" data-parent="#accordionExample">
                                    <div class="card-body">
                                        <p>As per RBI guidelines, applicant's residence need to be verified and confirmed.</p>
                                    </div>
                                </div>
                            </div>
                            <div class="card">
                                <div class="card-header" id="headingTwo">
                                    <h2 class="mb-0">
                                        <button class="btn btn-link btn-block text-left collapsed" type="button" data-toggle="collapse" data-target="#collapseTwo" aria-expanded="false" aria-controls="collapseTwo">
                                            Is it necessary to take the consent of the applicant to conduct residence address verification?
                                        </button>
                                    </h2>
                                </div>
                                <div id="collapseTwo" class="collapse" aria-labelledby="headingTwo" data-parent="#accordionExample">
                                    <div class="card-body">
                                        <p>Yes. It is important to take the consent of the applicant not only for residence verification, but also for verification of employment, business, property, bank statement etc. Without the cooperation of the applicants', it is not practical to verify any of the information provided by them.</p>
                                    </div>
                                </div>
                            </div>
                            <div class="card">
                                <div class="card-header" id="headingThree">
                                    <h2 class="mb-0">
                                        <button class="btn btn-link btn-block text-left collapsed" type="button" data-toggle="collapse" data-target="#collapseThree" aria-expanded="false" aria-controls="collapseThree">
                                            Is it necessary to verify the applicant's address whenever he/she changes residence?
                                        </button>
                                    </h2>
                                </div>
                                <div id="collapseThree" class="collapse" aria-labelledby="headingThree" data-parent="#accordionExample">
                                    <div class="card-body">
                                        <p>It is advisable to do so. Whenever applicant's change the residence, employment, business place, bank account etc, it is advisable to verify the same and update in the records. It comes in handy in any situation.</p>

                                    </div>
                                </div>
                            </div>
                            <div class="card">
                                <div class="card-header" id="headingFour">
                                    <h2 class="mb-0">
                                        <button class="btn btn-link btn-block text-left collapsed" type="button" data-toggle="collapse" data-target="#collapseFour" aria-expanded="false" aria-controls="collapseFour">
                                            How is Address Verification conducted?
                                        </button>
                                    </h2>
                                </div>
                                <div id="collapseFour" class="collapse" aria-labelledby="headingFour" data-parent="#accordionExample">
                                    <div class="card-body">
                                        <ul>
                                            <li>Address verification is conducted through a field officer’s visit to the mentioned address.</li>
                                            <li>The field officer verifies the residence address details, the tenure of stay, the ownership status and details of other members residing there. Depending on the client's requirement, the field officer may collect the proof of residence to cross-verify the residence's address. In case the door is found locked, the officer goes ahead and verifies the details from people residing in the neighbourhood.</li>
                                            <li>In case of employment, field officer attempts to meet the employee at the employment place, and collects his/her ID Card, visiting card etc. Attempt is also made to meet the HR Manager / Reporting Manager to confirm the tenure of employment, salary details etc.</li>
                                            <li>In case of rental property verification, we visit to the rental property to ensure it is occupied by tenants and there is a rental income.</li>
                                            <li>In case of property verification, a visit is made to the property to confirm the address of the property.</li>
                                        </ul>
                                        <p>Depending on the client's requirement, the field officer may collect the proof of residence to cross-verify the residence's address</p>
                                    </div>
                                </div>
                            </div>
                            <div class="card">
                                <div class="card-header" id="headingFive">
                                    <h2 class="mb-0">
                                        <button class="btn btn-link btn-block text-left collapsed" type="button" data-toggle="collapse" data-target="#collapseFive" aria-expanded="false" aria-controls="collapseFive">
                                            What about verifying the current address and the permanent address of Applicants?
                                        </button>
                                    </h2>
                                </div>
                                <div id="collapseFive" class="collapse" aria-labelledby="headingFive" data-parent="#accordionExample">
                                    <div class="card-body">
                                        <ul>
                                            <li>A permanent address is the legal address of an individual where an individual is a registered resident with his/her name. The permanent address appears in government documents like Aadhr, voter ID card, ration card, driving license, and passport. Many people, who stay away from home, use their parents’ house as their permanent address. Therefore, a permanent address is also defined as an address where the applicant receives official documents and correspondence.</li>
                                            <li>Temporary address is a temporary correspondence location. It can be the address where an individual is currently residing in rented accommodation or in a paying guest facility, with a friend or a relative.</li>
                                            <li>Generally, a permanent address is given more weightage compared to a temporary address as a temporary address may keep changing. It is advisable to get both permanent and temporary addresses verified for any eventuality.</li>
                                            <li>Depending on the Bank's/NBFC's requirement, we can visit both permanent address and current address.</li>
                                        </ul>
                                    </div>
                                </div>
                            </div>


                            <div class="card">
                                <div class="card-header" id="headingSix">
                                    <h2 class="mb-0">
                                        <button class="btn btn-link btn-block text-left collapsed" type="button" data-toggle="collapse" data-target="#collapseSix" aria-expanded="false" aria-controls="collapseSix">
                                            What is the time taken and cost involved in doing Residence Address Verification?
                                        </button>
                                    </h2>
                                </div>
                                <div id="collapseSix" class="collapse" aria-labelledby="headingSix" data-parent="#accordionExample">
                                    <div class="card-body">
                                        <p>Both cost and time taken to verify the residence address typically depend upon the accessibility and remoteness of the address. Also, address verification may not be feasible in certain disturbed and/or remote areas by the conventional method of a personal visit. Even it is possible it may cost extremely high. In such cases, we seek the approval for additional cost and time to complete the verification.</p>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="row mt-4">
                        <div class="col-lg-8">
                            <div class="project-details-content text-justify">
                                <h5>Our Safe, Secure and Cost Effective Solutions for Residence Address Verification</h5>
                                <ul>
                                    <li><strong>Is there a way to do address verification digitally?</strong></li>
                                    <ul>
                                        <li>Yes. It is possible to employ digital methods to verify the residence address of an employee. We are one of the top ten background verification companies in India and we offer a safe and secure digital platform to verify your employee's address within minutes which saves you time and cost.</li>
                                    </ul>
                                    <li><strong>How does your digital address verification solution works?</strong></li>
                                    <ul>
                                        <li>Using our solution you can initiate the address verification for your applicant's by yourself. Your employee will get a link on his phone. By clicking the link, he/she fills in details pertaining to the residence and takes a photo/selfie of the residence. Along with the geo-location details, all the information comes to your system instantly!!</li>
                                        <a href="Http://demos.odopix.in/dhiWeb/request_demo" class="btn btn-secondary mb-3">Requset For Demo</a>
                                    </ul>

                                    <li><strong>Does your digital platform help to collect the documents from the applicant's?</strong></li>
                                    <ul>
                                        <li>Yes. It can also be used to collect information such as KYC documents, Proof of residence, Photos, income documents, property documents etc.</li>
                                        <a href="Http://demos.odopix.in/dhiWeb/request_demo" class="btn btn-secondary mb-3">Requset For Demo</a>
                                    </ul>
                                </ul>
                            </div>
                        </div>
                        <div class="col-md-4 serv-img">
                            <img src="<?php echo base_url() ?>ui/frontend/images/services/cpv/address.png">
                        </div>
                    </div>
                </div>
            </div>

            <!--project details row end-->
        </div>
        <!--project details section end-->

        <?php echo $common_cat ?>

        <!-- <?php //echo $common_clients 
                ?> -->


    </div>

    <!-- Footer start -->
    <?php echo $footer ?>
    <!-- Footer end -->



    <?php echo $common_js ?>
</body>

</html>