<!DOCTYPE html>

<head>
    <title><?php echo $title ?></title>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1">
    <?php echo $common_css ?>
</head>

<body>

    <!--preloader start-->
    <div id="preloader">
        <div class="loader1">
            <span></span>
            <span></span>
            <span></span>
            <span></span>
            <span></span>
        </div>
    </div>
    <!--preloader end-->

    <!-- Main header start -->
    <?php echo $header_main ?>
    <!-- Main header end -->


    <div class="main">

        <!--page header section start-->
        <section class="" style="background: url('<?php echo base_url(); ?>ui/frontend/images/bg.png')no-repeat center center / cover">
            <div class="section-lg bg-gradient-primary text-white section-header">
                <div class="container">
                    <div class="row justify-content-center bread-crumb-position">
                        <div class="col-md-8 col-lg-7">
                            <div class="page-header-content text-center">
                                <h1>ID Verification</h1>
                                <nav aria-label="breadcrumb" class="d-flex justify-content-center">
                                    <ol class="breadcrumb breadcrumb-transparent breadcrumb-text-light">
                                        <li class="breadcrumb-item"><a href="<?php echo base_url(); ?>">Home</a></li>
                                        <li class="breadcrumb-item"><a href="<?php echo base_url().'services/bgv'; ?>">BGV</a></li>
                                        <li class="breadcrumb-item active" aria-current="page"> ID Verification</li>
                                    </ol>
                                </nav>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>
        <!--page header section end-->

        <!--project details section start-->
        <section class="section section-lg pb-0">
            <div class="container">

                <!--project details row start-->
                <div class="row align-items-center">
                    <div class="col-md-12">

                        <div class="project-details-content text-justify">
                            <h3>Identity Document Verification</h3>
                            <p>In India, having valid proof of identification is crucial for employers, authorities, and financial institutions to determine and confirm an individual's identity. DHI Verification, a trusted background verification company, specializes in collecting and verifying details related to identity proof, ensuring accurate and reliable results.</p>

                            <p><strong>The need for ID verification:<strong></p>
                            <ul>
                                <li><strong>Proof of Age and Residence:</strong> Various ID proofs serve as evidence of address and age, required for day-to-day activities. For example, an Aadhar card is necessary to open a bank account. </li>
                                <li><strong>Photo Identity: </strong> ID proofs serve as verification of photo identity. When entering an airport or similar facilities, presenting a valid photo ID such as Aadhar, Driving License, or Passport is required for cross-checking. </li>
                                <li><strong>Accessing Government Benefits: </strong> ID proofs like PAN and Aadhar enable employees to avail benefits such as ESI, PF, and insurance benefits. </li>
                                <li><strong>Utilizing Government Services: </strong> ID proofs allow individuals to enjoy privileges like driving a car, riding a motorcycle, or traveling internationally with a Passport. </li>
                            </ul>

                            <p>Employers must ensure that prospective employees have valid identity proof to fulfill their statutory obligations regarding employee benefits like ESI, PF, and Group Insurance. Additionally, verifying identity documents helps prevent the hiring of fraudsters using stolen identities. DHI Verification is equipped to handle instances of identity theft and impersonation, providing comprehensive solutions.</p>

                        </div>
                    </div>
                </div>
            </div>
        </section>

        <section class="section section-lg pt-0">
            <div class="container">

                <div class="row mt-4">
                    <div class="col-lg-12">
                        <div class="project-details-content text-justify">
                            <h5>FAQs</h5>
                            <div class="accordion" id="accordionExample">
                                <div class="card">
                                    <div class="card-header" id="headingOne">
                                        <h2 class="mb-0">
                                            <button class="btn btn-link btn-block text-left" type="button" data-toggle="collapse" data-target="#collapseOne" aria-expanded="true" aria-controls="collapseOne">
                                                What are the commonly used identity documents?
                                            </button>
                                        </h2>
                                    </div>

                                    <div id="collapseOne" class="collapse show" aria-labelledby="headingOne" data-parent="#accordionExample">
                                        <div class="card-body">

                                            <ul>
                                                <li>Aadhar Card</li>
                                                <li>Passport</li>
                                                <li>PAN Card</li>
                                                <li>Driving License</li>
                                                <li>Voter ID</li>
                                            </ul>
                                        </div>
                                    </div>
                                </div>
                                <div class="card">
                                    <div class="card-header" id="headingTwo">
                                        <h2 class="mb-0">
                                            <button class="btn btn-link btn-block text-left collapsed" type="button" data-toggle="collapse" data-target="#collapseTwo" aria-expanded="false" aria-controls="collapseTwo">
                                                Which identity documents should employers collect from employees?
                                            </button>
                                        </h2>
                                    </div>
                                    <div id="collapseTwo" class="collapse" aria-labelledby="headingTwo" data-parent="#accordionExample">
                                        <div class="card-body">
                                            <ul>
                                                <li>It is advisable to collect documents that can be verified through government databases.</li>
                                                <li>Online verification is possible for PAN, Aadhar, Driving License, and Voter ID.</li>
                                            </ul>
                                        </div>
                                    </div>
                                </div>
                                <div class="card">
                                    <div class="card-header" id="headingThree">
                                        <h2 class="mb-0">
                                            <button class="btn btn-link btn-block text-left collapsed" type="button" data-toggle="collapse" data-target="#collapseThree" aria-expanded="false" aria-controls="collapseThree">
                                                Should multiple identity documents be collected?
                                            </button>
                                        </h2>
                                    </div>
                                    <div id="collapseThree" class="collapse" aria-labelledby="headingThree" data-parent="#accordionExample">
                                        <div class="card-body">
                                            <p>Yes, it is recommended to collect multiple identity documents for easy cross-verification and to ensure the individual's identity.</p>
                                        </div>
                                    </div>
                                </div>
                                <div class="card">
                                    <div class="card-header" id="headingFour">
                                        <h2 class="mb-0">
                                            <button class="btn btn-link btn-block text-left collapsed" type="button" data-toggle="collapse" data-target="#collapseFour" aria-expanded="false" aria-controls="collapseFour">
                                                How are identity documents verified?
                                            </button>
                                        </h2>
                                    </div>
                                    <div id="collapseFour" class="collapse" aria-labelledby="headingFour" data-parent="#accordionExample">
                                        <div class="card-body">
                                            <p>Identity documents are verified online through the issuing authorities' websites and public databases.</p>
                                            <p>Choose DHI Verification for reliable and efficient ID verification services. Our expertise in collecting and verifying identity details ensures that employers and organizations have accurate and trustworthy information, mitigating the risks associated with identity theft and impersonation.</p>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="row mt-4">
                    <div class="col-lg-8">
                        <div class="project-details-content text-justify">
                            <h5>Our Safe, Secure and Cost Effective Solutions for Residence Address Verification</h5>
                            <ul>
                                <li>DHI Verification offers a digital platform for address verification, ensuring safe and secure processes.</li>
                                <li>Our platform allows you to initiate address verification for your employees, who can provide residence details and take photos/selfies of their residences using a link sent to their phones.</li>
                                <li>Instantly receive all the information, including geo-location details, in your system, saving you time and cost.</li>
                                <li>Our digital platform can also be used to collect employee information such as KYC documents, proof of residence, and photos.</li>
                            </ul>
                        </div>
                    </div>
                    <div class="col-md-4 serv-img">
                        <img src="<?php echo base_url() ?>ui/frontend/images/services/cpv/address.png">
                    </div>
                </div>

            </div>
        </section>
        <!--project details section end-->

        <?php echo $common_cat ?>

        <!-- <?php //echo $common_clients 
                ?> -->


    </div>

    <!-- Footer start -->
    <?php echo $footer ?>
    <!-- Footer end -->



    <?php echo $common_js ?>

</body>

</html>