<!DOCTYPE html>

<head>
    <title><?php echo $title ?></title>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1">
    <?php echo $common_css ?>
</head>

<body>

    <!--preloader start-->
    <div id="preloader">
        <div class="loader1">
            <span></span>
            <span></span>
            <span></span>
            <span></span>
            <span></span>
        </div>
    </div>
    <!--preloader end-->

    <!-- Main header start -->
    <?php echo $header_main ?>
    <!-- Main header end -->


    <div class="main">

        <!--page header section start-->
        <section class="" style="background: url('<?php echo base_url(); ?>ui/frontend/images/bg.png')no-repeat center center / cover">
            <div class="section-lg bg-gradient-primary text-white section-header">
                <div class="container">
                    <div class="row justify-content-center bread-crumb-position">
                        <div class="col-md-8 col-lg-7">
                            <div class="page-header-content text-center">
                                <h1>Global Database Verification</h1>
                                <nav aria-label="breadcrumb" class="d-flex justify-content-center">
                                    <ol class="breadcrumb breadcrumb-transparent breadcrumb-text-light">
                                        <li class="breadcrumb-item"><a href="<?php echo base_url(); ?>">Home</a></li>
                                        <li class="breadcrumb-item"><a href="<?php echo base_url().'services/bgv'; ?>">BGV</a></li>
                                        <li class="breadcrumb-item active" aria-current="page">Global Database Verification</li>
                                    </ol>
                                </nav>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>
        <!--page header section end-->

        <!--project details section start-->
        
            <div class="container mt-4 mb-2">

                <!--project details row start-->
                <div class="row align-items-center">
                    <div class="col-md-12">
                        <div class="project-details-content text-justify">
                            <!-- <h2>For Employment Purposes-</h2> -->
                            <h3>Global Database Verification</h3>
                            <p>Global database checks are a crucial component of our comprehensive background investigation services. At DHI Verification, we conduct extensive searches across national and international databases to ensure the safety and security of your organization.</p>
                        </div>
                    </div>
                </div>
            </div>
       

            <div class="container mb-5">
                <div class="row">
                    <div class="col-lg-12">
                        <div class="project-details-content text-justify">
                            <h5>FAQs</h5>
                            <div class="accordion" id="accordionExample">
                                <div class="card">
                                    <div class="card-header" id="headingOne">
                                        <h2 class="mb-0">
                                            <button class="btn btn-link btn-block text-left" type="button" data-toggle="collapse" data-target="#collapseOne" aria-expanded="true" aria-controls="collapseOne">
                                            What details are required from employees for global database verification?
                                            </button>
                                        </h2>
                                    </div>

                                    <div id="collapseOne" class="collapse show" aria-labelledby="headingOne" data-parent="#accordionExample">
                                        <div class="card-body">
                                            <ul>
                                                <li>Complete name of the applicant.</li>
                                                <li>Father's name.</li>
                                                <li>Date of Birth (DOB).</li>
                                                <li>Full address.</li>
                                               
                                            </ul>
                                        </div>
                                    </div>
                                </div>
                                <div class="card">
                                    <div class="card-header" id="headingTwo">
                                        <h2 class="mb-0">
                                            <button class="btn btn-link btn-block text-left collapsed" type="button" data-toggle="collapse" data-target="#collapseTwo" aria-expanded="false" aria-controls="collapseTwo">
                                            How are these details verified?
                                            </button>
                                        </h2>
                                    </div>
                                    <div id="collapseTwo" class="collapse" aria-labelledby="headingTwo" data-parent="#accordionExample">
                                        <div class="card-body">
                                           <p>We verify the provided details by conducting searches in national and international databases.</p>
                                        </div>
                                    </div>
                                </div>
                                <div class="card">
                                    <div class="card-header" id="headingThree">
                                        <h2 class="mb-0">
                                            <button class="btn btn-link btn-block text-left collapsed" type="button" data-toggle="collapse" data-target="#collapseThree" aria-expanded="false" aria-controls="collapseThree">
                                            How much time does global database verification take?
                                            </button>
                                        </h2>
                                    </div>
                                    <div id="collapseThree" class="collapse" aria-labelledby="headingThree" data-parent="#accordionExample">
                                        <div class="card-body">
                                            <ul>
                                                <li>Generally, global database verification takes 1 to 2 working days.</li>
                                                <li>In suspected cases, where further investigation is required, it may take additional time. We ensure prompt communication with the client in such cases.</li>
                                            </ul>
                                           
                                        </div>
                                    </div>
                                </div>
                                <div class="card">
                                    <div class="card-header" id="headingFour">
                                        <h2 class="mb-0">
                                            <button class="btn btn-link btn-block text-left collapsed" type="button" data-toggle="collapse" data-target="#collapseFour" aria-expanded="false" aria-controls="collapseFour">
                                            What does "UTV" (Unable to Verify) mean? When is a case concluded as UTV?
                                            </button>
                                        </h2>
                                    </div>
                                    <div id="collapseFour" class="collapse" aria-labelledby="headingFour" data-parent="#accordionExample">
                                        <div class="card-body">
                                            <ul>
                                                <li>If there is insufficient data available to arrive at a conclusive result, the case is labeled as UTV.</li>
                                                <li>In such instances, where information is limited or unavailable, we provide transparency and communicate the status to our clients.</li>
                                            </ul>
                                        </div>
                                    </div>
                                </div>
                                <div class="card">
                                    <div class="card-header" id="headingFive">
                                        <h2 class="mb-0">
                                            <button class="btn btn-link btn-block text-left collapsed" type="button" data-toggle="collapse" data-target="#collapseFive" aria-expanded="false" aria-controls="collapseFive">
                                            Does an employer need to obtain the employee's consent for verification?
                                            </button>
                                        </h2>
                                    </div>
                                    <div id="collapseFive" class="collapse" aria-labelledby="headingFive" data-parent="#accordionExample">
                                        <div class="card-body">
                                            <ul>
                                                <li>Yes, it is mandatory to obtain the employee's consent before initiating any background verification process.</li>
                                                <li>We prioritize consent and adhere to legal requirements throughout the verification process.</li>
                                               
                                            </ul>
                                        </div>
                                    </div>
                                </div>
                                
                            </div>
                        </div>
                    </div>
                </div>
               
                <!--project details row end-->
            </div>

            <div class="container my-3">
                <h6><strong>At DHI Verification, we conduct thorough global database checks to identify any politically exposed individuals, high-risk candidates, individuals engaged in criminal activities, or those listed on terror watch lists. Our extensive investigations uncover crucial information, helping our clients make informed decisions while mitigating risks related to compliance, reputation, and legal obligations</strong></h6>
            </div>
        <!--project details section end-->

        <?php echo $common_cat ?>

        <!-- <?php //echo $common_clients ?> -->


    </div>

    <!-- Footer start -->
    <?php echo $footer ?>
    <!-- Footer end -->



    <?php echo $common_js ?>
</body>

</html>