<!DOCTYPE html>

<head>
    <title><?php echo $title ?></title>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1">
    <?php echo $common_css ?>
</head>

<body>

    <!--preloader start-->
    <div id="preloader">
        <div class="loader1">
            <span></span>
            <span></span>
            <span></span>
            <span></span>
            <span></span>
        </div>
    </div>
    <!--preloader end-->

    <!-- Main header start -->
    <?php echo $header_main ?>
    <!-- Main header end -->


    <div class="main">

        <!--page header section start-->
        <section class="" style="background: url('<?php echo base_url(); ?>ui/frontend/images/bg.png')no-repeat center center / cover">
            <div class="section-lg bg-gradient-primary text-white section-header">
                <div class="container">
                    <div class="row justify-content-center bread-crumb-position">
                        <div class="col-md-8 col-lg-7">
                            <div class="page-header-content text-center">
                                <h1>Employment Verification</h1>
                                <nav aria-label="breadcrumb" class="d-flex justify-content-center">
                                    <ol class="breadcrumb breadcrumb-transparent breadcrumb-text-light">
                                        <li class="breadcrumb-item"><a href="<?php echo base_url(); ?>">Home</a></li>
                                        <li class="breadcrumb-item"><a href="<?php echo base_url() . 'services/bgv'; ?>">BGV</a></li>
                                        <li class="breadcrumb-item active" aria-current="page"> Employment Verification</li>
                                    </ol>
                                </nav>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>
        <!--page header section end-->

        <!--project details section start-->
       
            <div class="container mt-4 mb-2">

                <!--project details row start-->
                <div class="row align-items-center">
                    <div class="col-md-12">
                        <div class="project-details-content text-justify">
                            <!-- <h2>For Employment Purposes-</h2> -->
                            <h3>Employment Verification</h3>

                            <p>Employment verification is a crucial step in the hiring process that confirms the work history of a prospective employee. At DHI Verification, we offer comprehensive employment verification services to help you make informed hiring decisions and ensure that your candidates have the necessary experience and qualifications for the job.</p>
                        </div>
                    </div>
                </div>
            </div>
        

        <div class="container mb-5">
            <div class="row">
                <div class="col-lg-12">
                    <div class="project-details-content text-justify">
                        <h5>FAQs</h5>
                        <div class="accordion" id="accordionExample">
                            <div class="card">
                                <div class="card-header" id="headingOne">
                                    <h2 class="mb-0">
                                        <button class="btn btn-link btn-block text-left" type="button" data-toggle="collapse" data-target="#collapseOne" aria-expanded="true" aria-controls="collapseOne">
                                            What documents should employers collect from employees for previous employment verification?
                                        </button>
                                    </h2>
                                </div>

                                <div id="collapseOne" class="collapse show" aria-labelledby="headingOne" data-parent="#accordionExample">
                                    <div class="card-body">
                                        <ul>
                                            <li>Offer letter</li>
                                            <li>Relieving letter</li>
                                            <li>Experience letter</li>
                                            <li>Pay slip</li>
                                            <li>UAN number</li>
                                            <li>Letter of authorization duly signed by the candidate</li>
                                        </ul>
                                    </div>
                                </div>
                            </div>
                            <div class="card">
                                <div class="card-header" id="headingTwo">
                                    <h2 class="mb-0">
                                        <button class="btn btn-link btn-block text-left collapsed" type="button" data-toggle="collapse" data-target="#collapseTwo" aria-expanded="false" aria-controls="collapseTwo">
                                            How are these documents verified?
                                        </button>
                                    </h2>
                                </div>
                                <div id="collapseTwo" class="collapse" aria-labelledby="headingTwo" data-parent="#accordionExample">
                                    <div class="card-body">
                                        <ul>
                                            <li>We email the provided documents to the employer to seek written confirmation of the employment history.</li>
                                            <li>In some cases, a personal visit to the employer's location may be required for verification.</li>
                                        </ul>
                                    </div>
                                </div>
                            </div>
                            <div class="card">
                                <div class="card-header" id="headingThree">
                                    <h2 class="mb-0">
                                        <button class="btn btn-link btn-block text-left collapsed" type="button" data-toggle="collapse" data-target="#collapseThree" aria-expanded="false" aria-controls="collapseThree">
                                            How long does it take to verify previous employment?
                                        </button>
                                    </h2>
                                </div>
                                <div id="collapseThree" class="collapse" aria-labelledby="headingThree" data-parent="#accordionExample">
                                    <div class="card-body">
                                        <p>Generally, the verification process takes 7 to 10 working days.</p>
                                    </div>
                                </div>
                            </div>
                            <div class="card">
                                <div class="card-header" id="headingFour">
                                    <h2 class="mb-0">
                                        <button class="btn btn-link btn-block text-left collapsed" type="button" data-toggle="collapse" data-target="#collapseFour" aria-expanded="false" aria-controls="collapseFour">
                                            Is a visit to the previous employer necessary?
                                        </button>
                                    </h2>
                                </div>
                                <div id="collapseFour" class="collapse" aria-labelledby="headingFour" data-parent="#accordionExample">
                                    <div class="card-body">
                                        <ul>
                                            <li>In most cases, employment verification is obtained through email correspondence with the employer.</li>
                                            <li>However, if deemed necessary, we may conduct a personal visit to verify previous employments.</li>
                                        </ul>
                                    </div>
                                </div>
                            </div>
                            <div class="card">
                                <div class="card-header" id="headingFive">
                                    <h2 class="mb-0">
                                        <button class="btn btn-link btn-block text-left collapsed" type="button" data-toggle="collapse" data-target="#collapseFive" aria-expanded="false" aria-controls="collapseFive">
                                            What if the previous employer has gone out of business?
                                        </button>
                                    </h2>
                                </div>
                                <div id="collapseFive" class="collapse" aria-labelledby="headingFive" data-parent="#accordionExample">
                                    <div class="card-body">
                                        <ul>
                                            <li>If the previous employer is no longer in business, we make a personal visit to the last known address and inquire with neighboring businesses.</li>
                                            <li>We also cross-verify information with the Ministry of Corporate Affairs before concluding the verification.</li>

                                        </ul>
                                    </div>
                                </div>
                            </div>
                            <div class="card">
                                <div class="card-header" id="headingSix">
                                    <h2 class="mb-0">
                                        <button class="btn btn-link btn-block text-left collapsed" type="button" data-toggle="collapse" data-target="#collapseSix" aria-expanded="false" aria-controls="collapseSix">
                                            How do you verify employment documents issued by fake companies?
                                        </button>
                                    </h2>
                                </div>
                                <div id="collapseSix" class="collapse" aria-labelledby="headingSix" data-parent="#accordionExample">
                                    <div class="card-body">
                                        <ul>
                                            <li>We maintain a list of known fake companies and cross-check against it.</li>
                                            <li>If the company is not on our list, we verify its existence with the Ministry of Corporate Affairs and EPF.</li>
                                            <li>Personal visits to the employer's given address may be conducted if necessary.</li>
                                        </ul>
                                    </div>
                                </div>
                            </div>

                            <div class="card">
                                <div class="card-header" id="headingSeven">
                                    <h2 class="mb-0">
                                        <button class="btn btn-link btn-block text-left collapsed" type="button" data-toggle="collapse" data-target="#collapseSeven" aria-expanded="false" aria-controls="collapseSeven">
                                            What does "UTV" (Unable to Verify) mean? When is a case concluded as UTV?
                                        </button>
                                    </h2>
                                </div>
                                <div id="collapseSeven" class="collapse" aria-labelledby="headingSeven" data-parent="#accordionExample">
                                    <div class="card-body">
                                        <p>A case is concluded as UTV when the company is permanently closed or if there have been significant changes in management or company name.</p>
                                    </div>
                                </div>
                            </div>

                            <div class="card">
                                <div class="card-header" id="headingEight">
                                    <h2 class="mb-0">
                                        <button class="btn btn-link btn-block text-left collapsed" type="button" data-toggle="collapse" data-target="#collapseEight" aria-expanded="false" aria-controls="collapseEight">
                                            How many attempts are made before concluding a case as UTV?
                                        </button>
                                    </h2>
                                </div>
                                <div id="collapseEight" class="collapse" aria-labelledby="headingEight" data-parent="#accordionExample">
                                    <div class="card-body">
                                        <p>Generally, we make 3 to 5 attempts to obtain the required information before concluding a case as UTV.</p>
                                    </div>
                                </div>
                            </div>

                            <div class="card">
                                <div class="card-header" id="headingNine">
                                    <h2 class="mb-0">
                                        <button class="btn btn-link btn-block text-left collapsed" type="button" data-toggle="collapse" data-target="#collapseNine" aria-expanded="false" aria-controls="collapseNine">
                                            How do you verify gig-workers?
                                        </button>
                                    </h2>
                                </div>
                                <div id="collapseNine" class="collapse" aria-labelledby="headingNine" data-parent="#accordionExample">
                                    <div class="card-body">
                                        <ul>
                                            <li>For gig-workers, identity verification and criminal background checks provide valuable information.</li>
                                            <li>If provided with the email addresses of previous entities that engaged the gig-workers, we can also gather relevant information.</li>
                                        </ul>
                                    </div>
                                </div>
                            </div>

                            <div class="card">
                                <div class="card-header" id="headingTen">
                                    <h2 class="mb-0">
                                        <button class="btn btn-link btn-block text-left collapsed" type="button" data-toggle="collapse" data-target="#collapseTen" aria-expanded="false" aria-controls="collapseTen">
                                            Can employment be verified through digital mode?
                                        </button>
                                    </h2>
                                </div>
                                <div id="collapseTen" class="collapse" aria-labelledby="headingTen" data-parent="#accordionExample">
                                    <div class="card-body">
                                        <p>Employment verification can be done digitally based on UAN (Universal Account Number) checks.</p>
                                    </div>
                                </div>
                            </div>

                            <div class="card">
                                <div class="card-header" id="headingEleven">
                                    <h2 class="mb-0">
                                        <button class="btn btn-link btn-block text-left collapsed" type="button" data-toggle="collapse" data-target="#collapseEleven" aria-expanded="false" aria-controls="collapseEleven">
                                            Is it necessary to obtain the employee's consent for any verification?
                                        </button>
                                    </h2>
                                </div>
                                <div id="collapseEleven" class="collapse" aria-labelledby="headingEleven" data-parent="#accordionExample">
                                    <div class="card-body">
                                        <p>Yes, it is necessary to obtain the employee's consent before initiating any background verification process. Transparency and cooperation are essential for a successful verification.</p>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!--project details row end-->
        </div>
        <!--project details section end-->

        <?php echo $common_cat ?>

        <!-- <?php //echo $common_clients 
                ?> -->


    </div>

    <!-- Footer start -->
    <?php echo $footer ?>
    <!-- Footer end -->



    <?php echo $common_js ?>
</body>

</html>