<!DOCTYPE html>

<head>
    <title><?php echo $title ?></title>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1">
    <?php echo $common_css ?>
</head>

<body>

    <!--preloader start-->
    <div id="preloader">
        <div class="loader1">
            <span></span>
            <span></span>
            <span></span>
            <span></span>
            <span></span>
        </div>
    </div>
    <!--preloader end-->

    <!-- Main header start -->
    <?php echo $header_main ?>
    <!-- Main header end -->


    <div class="main">

        <!--page header section start-->
        <section class="" style="background: url('<?php echo base_url(); ?>ui/frontend/images/bg.png')no-repeat center center / cover">
            <div class="section-lg bg-gradient-primary text-white section-header">
                <div class="container">
                    <div class="row justify-content-center bread-crumb-position">
                        <div class="col-md-8 col-lg-7">
                            <div class="page-header-content text-center">
                                <h1>Drug Test</h1>
                                <nav aria-label="breadcrumb" class="d-flex justify-content-center">
                                    <ol class="breadcrumb breadcrumb-transparent breadcrumb-text-light">
                                        <li class="breadcrumb-item"><a href="<?php echo base_url(); ?>">Home</a></li>
                                        <li class="breadcrumb-item"><a href="<?php echo base_url().'services/bgv'; ?>">BGV</a></li>
                                        <li class="breadcrumb-item active" aria-current="page"> Drug Test</li>
                                    </ol>
                                </nav>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>
        <!--page header section end-->

        <!--project details section start-->
        <section class="section section-lg">
            <div class="container">

                <!--project details row start-->
                <div class="row align-items-center">
                    <div class="col-md-12">
                        <div class="project-details-content text-justify">
                            <h3>Drug Test</h3>
                            <h5>Pre-Employment Drug Testing Program</h5>

                            <p>A pre-employment drug testing program is an essential part of background investigations, helping employers safeguard their workplaces from the risks associated with drug users. At DHI Verification, we provide comprehensive drug testing services to assist organizations in maintaining a safe and productive work environment.</p>

                            <h5>Why Drug Testing Matters</h5>
                            <p>Drug abuse has become a growing concern in India, especially with the rapid economic growth witnessed in recent years. HR departments in many companies are grappling with the root causes contributing to this menace. To address this issue, an increasing number of organizations are implementing drug testing programs. Here's why drug tests are important</p>
                            <ul>
                                <li>
                                    Drug users are more prone to accidents, posing risks to workplace safety.
                                </li>
                                <li>Drug testing helps improve worker safety, health, and overall well-being.</li>
                                <li>By avoiding workplace hazards associated with drug abuse, organizations can protect their employees.</li>
                                <li>Drug tests help prevent employee theft and absenteeism, reducing potential risks to the company.</li>
                                <li>Substance abuse hampers employee productivity, affecting overall organizational performance.</li>
                                <li>Drug users pose a significant threat to organizations dealing with sensitive data and confidential information.</li>
                            </ul>

                            <h5>Our Drug Testing Process-</h5>
                            <p>We collaborate with reputed testing laboratories and work closely with our clients to design and maintain effective pre-employment drug testing programs. Here's an overview of our process:</p>
                            <ol>
                                <li><strong>Client initiates the drug test:</strong>
                                    <ul>
                                        <li>Clients provide us with the candidate's details, including name, date of birth, gender, address, and contact number.</li>
                                        <li>Indicate the preferred collection mode (corporate pickup, home visit, or lab visit) and scheduled date and time.</li>

                                    </ul>
                                </li>
                                <li><strong>DHI initiates the cases to the vendor:</strong>
                                    <p>We verify the client's input and pass the necessary details to our trusted vendor.</p>
                                </li>
                                <li><strong>Location visits and sample collection:</strong>
                                    <p>Once the cases are assigned to the vendor, the vendor confirms the collection by providing the field executive's details, including name and phone number.</p>
                                </li>
                                <li><strong>Delivering the samples to the lab:</strong>
                                    <p>The collected samples are delivered to the nearest lab, which is tied up with our vendor.</p>
                                </li>
                                <li><strong>Processing the sample:</strong>
                                    <p>The lab processes the samples according to the defined panel and components, following the agreed-upon Statement of Work (SOW).</p>
                                </li>
                                <li><strong>Report generation and quality check:</strong>
                                    <ul>
                                        <li>After processing, the lab generates the final report, which undergoes a quality check by a doctor before sharing it with DHI.</li>
                                        <li>In case of a positive result, detailed observations explaining the findings are provided.</li>
                                    </ul>
                                </li>
                                <li><strong>Final quality check and sharing with the client:</strong>
                                    <ul>
                                        <li>DHI conducts a final quality check of the report to ensure accuracy and reliability.</li>
                                        <li>We publish the verified report to the client, enabling them to make informed decisions based on the results.</li>
                                    </ul>
                                </li>
                            </ol>

                            <p>Through our comprehensive drug testing services, including alcohol testing and physical examinations, we help organizations create a safer, more productive workplace while respecting the employee's right to privacy.</p>

                            <p>With our meticulous approach and in-depth analysis, we ensure that our clients have the necessary information to make sound decisions while mitigating risks and ensuring compliance. Our due diligence services empower businesses to establish trust, minimise potential pitfalls, and achieve successful outcomes in their transactions and ventures.</p>
                        </div>
                    </div>
                </div>
            </div>
        </section>




        <!--project details section end-->

        <?php echo $common_cat ?>

        <!-- <?php //echo $common_clients 
                ?> -->


    </div>

    <!-- Footer start -->
    <?php echo $footer ?>
    <!-- Footer end -->



    <?php echo $common_js ?>
</body>

</html>