<!DOCTYPE html>

<head>
    <title><?php echo $title ?></title>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1">
    <?php echo $common_css ?>
</head>

<body>

    <!--preloader start-->
    <div id="preloader">
        <div class="loader1">
            <span></span>
            <span></span>
            <span></span>
            <span></span>
            <span></span>
        </div>
    </div>
    <!--preloader end-->

    <!-- Main header start -->
    <?php echo $header_main ?>
    <!-- Main header end -->


    <div class="main">

        <!--page header section start-->
        <section class="" style="background: url('<?php echo base_url(); ?>ui/frontend/images/bg.png')no-repeat center center / cover">
            <div class="section-lg bg-gradient-primary text-white section-header">
                <div class="container">
                    <div class="row justify-content-center bread-crumb-position">
                        <div class="col-md-8 col-lg-7">
                            <div class="page-header-content text-center">
                                <h1>Address Verification</h1>
                                <nav aria-label="breadcrumb" class="d-flex justify-content-center">
                                    <ol class="breadcrumb breadcrumb-transparent breadcrumb-text-light">
                                        <li class="breadcrumb-item"><a href="<?php echo base_url(); ?>">Home</a></li>
                                        <li class="breadcrumb-item"><a href="<?php echo base_url().'services/bgv'; ?>">BGV</a></li>
                                        <li class="breadcrumb-item active" aria-current="page"> Address Verification</li>
                                    </ol>
                                </nav>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>
        <!--page header section end-->

        <!--project details section start-->
        <section class="section section-lg">
            <div class="container">

                <!--project details row start-->
                <div class="row align-items-center">
                    <div class="col-md-12">
                        <div class="project-details-content text-justify">
                            <h3>Address Verification</h3>
                            <h6>For Employment Purposes-</h6>

                            <ul>
                                <li>Verify the residence address of your employees to ensure effective communication during pre-hiring and post-termination phases.</li>
                                <li>Reach out to employees during special events or emergencies, such as birthdays, anniversaries, mishaps, accidents, or medical emergencies.</li>
                                <li>Fulfill legal obligations by sending notices and information related to employee absenteeism, disciplinary issues, or violation of company policies.</li>
                                <li>Provide accurate address information to law enforcement agencies in case of theft, embezzlement, or criminal activities involving employees.</li>
                                <li>Establish a reliable mode of contact in situations where telecom communication is disrupted due to natural calamities.</li>
                                <li>Keep track of valuable assets assigned to employees, especially in the era of hybrid work.</li>
                            </ul>

                            <p>Address verification is complex and requires expertise. DHI Verification, an experienced background verification company, is equipped to handle the intricacies involved in address verification.</p>
                        </div>
                    </div>
                </div>
            </div>
        </section>

            <div class="container">
                <div class="row">
                    <div class="col-lg-12">
                        <div class="project-details-content text-justify">
                            <h5>FAQs</h5>
                            <div class="accordion" id="accordionExample">
                                <div class="card">
                                    <div class="card-header" id="headingOne">
                                        <h2 class="mb-0">
                                            <button class="btn btn-link btn-block text-left" type="button" data-toggle="collapse" data-target="#collapseOne" aria-expanded="true" aria-controls="collapseOne">
                                                Does every employee's residence address need to be verified?
                                            </button>
                                        </h2>
                                    </div>

                                    <div id="collapseOne" class="collapse show" aria-labelledby="headingOne" data-parent="#accordionExample">
                                        <div class="card-body">
                                            <p>Ideally, yes. Unpredictable situations may require contacting employees at their residences, making it advisable to verify the address of prospective and existing employees.</p>
                                        </div>
                                    </div>
                                </div>
                                <div class="card">
                                    <div class="card-header" id="headingTwo">
                                        <h2 class="mb-0">
                                            <button class="btn btn-link btn-block text-left collapsed" type="button" data-toggle="collapse" data-target="#collapseTwo" aria-expanded="false" aria-controls="collapseTwo">
                                                Does an employer need to take the employee's consent for residence address verification?
                                            </button>
                                        </h2>
                                    </div>
                                    <div id="collapseTwo" class="collapse" aria-labelledby="headingTwo" data-parent="#accordionExample">
                                        <div class="card-body">
                                            <p>Yes. It is important to obtain the employee's consent before initiating residence address verification. Cooperation from the employee is essential for the process.</p>
                                        </div>
                                    </div>
                                </div>
                                <div class="card">
                                    <div class="card-header" id="headingThree">
                                        <h2 class="mb-0">
                                            <button class="btn btn-link btn-block text-left collapsed" type="button" data-toggle="collapse" data-target="#collapseThree" aria-expanded="false" aria-controls="collapseThree">
                                                Is it necessary to verify the employee's address when they change residence?
                                            </button>
                                        </h2>
                                    </div>
                                    <div id="collapseThree" class="collapse" aria-labelledby="headingThree" data-parent="#accordionExample">
                                        <div class="card-body">
                                            It is advisable to do so. Keeping updated information about the employee's residential address, photos of the residence, geo-locations, and landmarks is an industry best practice that proves useful in various situations.
                                        </div>
                                    </div>
                                </div>
                                <div class="card">
                                    <div class="card-header" id="headingFour">
                                        <h2 class="mb-0">
                                            <button class="btn btn-link btn-block text-left collapsed" type="button" data-toggle="collapse" data-target="#collapseFour" aria-expanded="false" aria-controls="collapseFour">
                                                How is address verification conducted?
                                            </button>
                                        </h2>
                                    </div>
                                    <div id="collapseFour" class="collapse" aria-labelledby="headingFour" data-parent="#accordionExample">
                                        <div class="card-body">
                                            <ul>
                                                <li>Address verification involves a field officer's visit to the mentioned address.</li>
                                                <li>The field officer verifies address details, tenure of stay, ownership status, and information about other members residing there.</li>
                                                <li>If the door is locked, the officer may verify details from neighbours.</li>
                                                <li>Depending on the client's requirement, the field officer may collect proof of residence to cross-verify the address.</li>
                                            </ul>
                                        </div>
                                    </div>
                                </div>
                                <div class="card">
                                    <div class="card-header" id="headingFive">
                                        <h2 class="mb-0">
                                            <button class="btn btn-link btn-block text-left collapsed" type="button" data-toggle="collapse" data-target="#collapseFive" aria-expanded="false" aria-controls="collapseFive">
                                                What about verifying the current and permanent addresses?
                                            </button>
                                        </h2>
                                    </div>
                                    <div id="collapseFive" class="collapse" aria-labelledby="headingFive" data-parent="#accordionExample">
                                        <div class="card-body">
                                            <ul>
                                                <li>Permanent addresses are legal addresses where individuals are registered residents. They appear in government documents such as Aadhar, voter ID, ration card, driving license, and passport.</li>
                                                <li>Temporary addresses are locations where individuals currently reside, such as rented accommodations or with friends or relatives.</li>
                                                <li>It is advisable to verify both permanent and temporary addresses for any eventuality.</li>
                                            </ul>
                                        </div>
                                    </div>
                                </div>
                                <div class="card">
                                    <div class="card-header" id="headingSix">
                                        <h2 class="mb-0">
                                            <button class="btn btn-link btn-block text-left collapsed" type="button" data-toggle="collapse" data-target="#collapseSix" aria-expanded="false" aria-controls="collapseSix">
                                                What is the time and cost involved in address verification?
                                            </button>
                                        </h2>
                                    </div>
                                    <div id="collapseSix" class="collapse" aria-labelledby="headingSix" data-parent="#accordionExample">
                                        <div class="card-body">
                                            <ul>
                                                <li>Time and cost depend on the accessibility and remoteness of the address.</li>
                                                <li>Address verification may not be feasible or may incur high costs in certain disturbed or remote areas. </li>
                                            </ul>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="row mt-4 mb-4">
                    <div class="col-lg-8">
                        <div class="project-details-content text-justify">
                            <h5>Our Safe, Secure and Cost Effective Solutions for Residence Address Verification</h5>
                            <ul>
                                <li>DHI Verification offers a digital platform for address verification, ensuring safe and secure processes.</li>
                                <li>Our platform allows you to initiate address verification for your employees, who can provide residence details and take photos/selfies of their residences using a link sent to their phones.</li>
                                <li>Instantly receive all the information, including geo-location details, in your system, saving you time and cost.</li>
                                <li>Our digital platform can also be used to collect employee information such as KYC documents, proof of residence, and photos.</li>
                            </ul>
                        </div>
                    </div>
                    <div class="col-md-4 serv-img">
                        <img src="<?php echo base_url() ?>ui/frontend/images/services/cpv/address.png">
                    </div>
                </div>
                <!--project details row end-->
            </div>
        <!--project details section end-->

        <?php echo $common_cat ?>

        <!-- <?php //echo $common_clients ?> -->


    </div>

    <!-- Footer start -->
    <?php echo $footer ?>
    <!-- Footer end -->



    <?php echo $common_js ?>
</body>

</html>