<!DOCTYPE html>

<head>
    <title><?php echo $title ?></title>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1">
    <?php echo $common_css ?>
</head>

<body>

    <!--preloader start-->
    <div id="preloader">
        <div class="loader1">
            <span></span>
            <span></span>
            <span></span>
            <span></span>
            <span></span>
        </div>
    </div>
    <!--preloader end-->

    <!-- Main header start -->
    <?php echo $header_main ?>
    <!-- Main header end -->


    <div class="main">

        <!--page header section start-->
        <section class="" style="background: url('<?php echo base_url(); ?>ui/frontend/images/bg.png')no-repeat center center / cover">
            <div class="section-lg bg-gradient-primary text-white section-header">
                <div class="container">
                    <div class="row justify-content-center bread-crumb-position">
                        <div class="col-md-8 col-lg-7">
                            <div class="page-header-content text-center">
                                <h1>Case Quest</h1>
                                <nav aria-label="breadcrumb" class="d-flex justify-content-center">
                                    <ol class="breadcrumb breadcrumb-transparent breadcrumb-text-light">
                                        <li class="breadcrumb-item"><a href="<?php echo base_url(); ?>">Home</a></li>
                                        <li class="breadcrumb-item active" aria-current="page">Our Products / Case Quest</li>
                                    </ol>
                                </nav>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>
        <!--page header section end-->

        <!--project details section start-->
        <section class="section section-lg pb-0">
            <div class="container">

                <!--project details row start-->
                <div class="row align-items-center">
                    <div class="col-md-12">

                        <div class="project-details-content text-justify">
                            <h3>Case Quest</h3>
                            <h5>Product Background</h5>
                            <p>For any organization engaging with third party, the need of minimizing fraudulent engagement or risk is imminent. Therefore, in risk management identifying legal trails or proceedings against individual or organization is highly warranted. Because court litigation pertains data to various walks of human engagement be it Financial, Contractual, Criminal and Civil which are very niche to court and tribunal bodies. </p>
                            <p>The reliance on the Government of India’s e-court portal increased over time, especially after NASCOM approved the litigation verification through court records.</p>
                            <p>The various limitations of e-court restricted searching capabilities beyond the jurisdiction which stands vital in today’s scenario where people move across the country seeking employment and opportunities. </p>

                            <h5>DHI’s Case Quest Solution</h5>
                            <p>DHI Case Quest is a Software Solution for searching litigations across Lower court to Apex court pan India. </p>
                            <div class="text-center case-quest-img">
                                <img src="<?php echo base_url() ?>ui/frontend/images/products/case-quest-1.png" class="img-fluid">
                            </div>

                            <div class="my-5">
                            <h5>Search Capabilities</h5>
                            <div class="table-responsive case-quest-table">
                                <table class="table-bordered w-100">
                                    <tbody>
                                    <tr>
                                        <th rowspan="3">Phonetic Similarity</th>
                                        <td>Inayat Ishaque Madre ↔ INAYAT ISSAQUE MADRE AZIZ AHMED ABDUL G SHAK M I</td>
                                    </tr>
                                    <tr>
                                        <td>Kapil Bhaurao Deogade ↔ Kapil Bhaurao Devgade</td>
                                    </tr>
                                    <tr>
                                        <td> Naval Prashar ↔ NAVAL PARASAR AND ORS</td>
                                    </tr>
                                    </tbody>

                                    <tr>
                                        <th>Transliteration</th>
                                        <td>SABHAVATH GANESH ↔ Sabavath Ganesh
                                        </td>
                                    </tr>
                                    
                                    <tr>
                                        <th rowspan="2">Spelling Differences</th>
                                        <td>NAVEEN VERMA ↔ Navin Verma</td>
                                    </tr>
                                    <tr>
                                        <td>VICKY MEDKAR ↔ Vicky Laxman Medhekar</td>
                                    </tr>

                                    <tr>
                                        <th>Nicknames</th>
                                        <td>Md Danish ↔ MOHD DANISH 1 J
                                        </td>
                                    </tr>

                                    <tr>
                                        <th rowspan="2">Missing Spaces or Hyphens</th>
                                        <td>Pawan Pr ↔ PAWAN P R</td>
                                    </tr>
                                    <tr>
                                        <td>Vishnu Av ↔ Vishnu Gopal A V</td>
                                    </tr>

                                    <tr>
                                        <th rowspan="3">Titles and Honorifics</th>
                                        <td>Anshul Malhotra ↔ Mr  Anshul Malhotra</td>
                                    </tr>
                                    <tr>
                                        <td>Sukesh Karir ↔ SMT SUMAN SUKESH KARIR</td>
                                    </tr>
                                    <tr>
                                        <td>GYANCHANDRA YADAV ↔  Mr Gyanchand Rammurat Yadav and New India Ass Co Ltd</td>
                                    </tr>

                                    <tr>
                                        <th rowspan="3">Typographic Differences</th>
                                        <td>Hanmant Venkatrao Jadhav ↔ Hnamant S/o Venkatrao Jadhav</td>
                                    </tr>
                                    <tr>
                                        <td>Vinod Sonba Chavan ↔ Vinod Sonba Cahvan</td>
                                    </tr>
                                    <tr>
                                        <td>Ajay Shamra ↔ AJAY SHARMA</td>
                                    </tr>

                                    <tr>
                                        <th rowspan="3">Missing Name Components</th>
                                        <td>Deepak Dangwal ↔ Deepak Sundarlal Dangwal</td>
                                    </tr>
                                    <tr>
                                        <td>Nilesh Pawar  ↔ Nilesh Ashok Pawar</td>
                                    </tr>
                                    <tr>
                                        <td>Parmar Mehul  ↔  MEHUL AMARATBHAI PARMAR</td>
                                    </tr>

                                    <tr>
                                        <th rowspan="3">Out-of-order Name Components</th>
                                        <td>Vanzara Sureshbhai Shravan Bhai  ↔  SURESHBHAI </td>
                                    </tr>
                                    <tr>
                                        <td>SHRAVANBHAI VANZARA</td>
                                    </tr>
                                    <tr>
                                        <td>Sharma Anup Ramniwas ↔ ANUP RAMNIWAS SHARMA</td>
                                    </tr>

                                    <tr>
                                        <th rowspan="3">Initials</th>
                                        <td>PAVANKUMAR S GUPTA ↔ PAVANKUMAR SUNILKUMAR GUPTA</td>
                                    </tr>
                                    <tr>
                                        <td>SHIVAJI T RAKH  ↔  Shivaji Tukaram Rakh</td>
                                    </tr>
                                    <tr>
                                        <td>SAMBHAJI S NIKAM ↔ Sambhaji Sainath Nikam</td>
                                    </tr>

                                    <tr>
                                        <th rowspan="2">Names split inconsistently across database fields</th>
                                        <td>G RANJITH KUMAR  ↔  Ranjithkumar S/o Ganesan</td>
                                    </tr>
                                    <tr>
                                        <td>Vanzara Sureshbhai Shravan Bhai ↔ SURESHBHAI SHRAVANBHAI VANZARA</td>
                                    </tr>
                                    

                                </table>
                            </div>
                            </div>

                            <h5>Input Data Required</h5>
                            <ul>
                                <li>Name of the Person, alias name (if any).</li>
                                <li>Father’s Name / Mother’s Name / Husband’s Name / Wife’s Name. </li>
                                <li>Age or Date of Birth.</li>
                                <li>Address (both present and permanent).</li>
                                <li>Information about period of stay will help.</li>
                            </ul>

                            <h5>Reporting Format (based on Tagging Guidelines)</h5>
                            <ul>
                                <li>Customer-specific reporting template.</li>
                                <li>Customer-specific Tagging Guidelines including addition / deletion of different types of litigation (comprehensive tagging guidelines are shared on request).</li>
                                <li>Detailed report in case of red cases, to enable you to take an informed decision.</li>
                                <li>Support in terms of applying and collecting documents from Courts. </li>
                                <li>Value-added legal expert support for better understanding and concluding the cases.</li>
                            </ul>

                            <h5>Features at Glance</h5>
                            <ul class="mb-5">
                                <li>E-court data <strong>from 2006 to date.</strong></li>
                                <li>More than <strong>46 crore litigant </strong>records across pan India.</li>
                                <li><strong>State-of-the-art searching algorithm </strong>assisted by AI & ML with configurable search criteria to the depth of Case Type, Jurisdictions using <strong>sophisticated tagging guidelines. </strong></li>
                                <li><strong>API for automated searching </strong>for Green report processing with Subject Matter Expert inputs for possible matches towards Red reports.</li>
                                <li><strong>Data encrypted </strong>at rest and on transit for tamper proof.</li>
                                <li>State of the art <strong>Business Continuity Plan </strong>in place for uninterrupted service.</li>
                                <li><strong>In-house Legal team </strong>with<strong>pan India Legal network</strong>working as Subject Matter Experts (SME’s).</li>
                                <li>Searches Data pertaining to <strong>Lower court to Apex court / Police FIRS / Tribunals.</strong></li>
                            </ul>
                        </div>
                    </div>
                </div>
            </div>
        </section>

        <?php echo $common_cat ?>

        <!-- <?php //echo $common_clients 
                ?> -->


    </div>

    <!-- Footer start -->
    <?php echo $footer ?>
    <!-- Footer end -->



    <?php echo $common_js ?>

</body>

</html>