<!DOCTYPE html>

<head>
   <title><?php echo $title ?></title>
   <meta charset="utf-8">
   <meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1">
   <?php echo $common_css ?>
</head>

<body>

   <!--preloader start-->
   <div id="preloader">
      <div class="loader1">
         <span></span>
         <span></span>
         <span></span>
         <span></span>
         <span></span>
      </div>
   </div>
   <!--preloader end-->

   <!-- Main header start -->
   <?php echo $header_main ?>
   <!-- Main header end -->




   <div class="container">
      <div class="row text-justify">
         <div class="col-md-12">
            <div class="my-5 pt-5">
               <h3>Privacy Policy</h3>
               <!-- <h5>Scope of this Policy</h5> -->
               <p>DHI Investigation Services Private Limited has created this privacy policy in order to describe how we collect, use, maintain, share and protect your personal information when you use our website, <a href="https://www.dhiverification.com" target="_blank">www.dhiverification.com</a> (hereinafter “Website” or “Site”) in connection with our employment screening services, security risk management services, investigations, protective security, response services and intelligence services. This privacy policy applies solely to information collected when you visit our Website, except where stated otherwise.</p>
               <p><b>This policy will describe the following:</b></p>
               <ul>
                  <li>What information we collect;</li>
                  <li>How information is used;</li>
                  <li>With whom it is shared;</li>
                  <li>How information can be corrected;</li>
                  <li>How it is secured; and,</li>
                  <li>Who to contact with concerns or questions about our privacy practices.</li>
               </ul>
               <h5>Changes to this Policy</h5>
               <p>This policy may be subject to updates. Any future material changes or additions to the processing of personal information as described in this policy will be communicated to you through an appropriate channel. For example, we may place a prominent notice on our Website or email you to let you know of an updated policy.</p>
               <h5>Information Collection on our Website</h5>
               <p>DHI strives to limit its collection of personal information to that necessary for the offering and administration of our services. Our Site collects the following types of information when you visit:</p>
               <ul>
                  <li>Personally identifying information; and,</li>
                  <li>Non-personally identifiable information</li>
               </ul>
               <h5>Personally Identifiable Information</h5>
               <p>Personally identifying information (PII or “personal data”) is any information that can identify you, such as your name, address, and IP address. It does not include anonymized, aggregate or statistical information. Based on your relationship with us, you may be asked to provide certain PII as described below. If certain information is requested but not mandatory, DHI will identify which information is required.</p>
               <ul>
                  <li><b>Online Questions or Requests</b> (which may be collected through our Site or offline). When you are requesting materials or information from DHI, we may collect your name, job title, address, email address, phone number, IP address, company name, country/state of residence, photocopy of your ID and other PII, as well as professional interests and the reasons why you are requesting the DHI services or products.</li>
                  <li><b>Job Applicants.</b> When you apply for employment with DHI we will collect your name, email address, country of residence, physical address, cell phone number and any information you include in your resume which you upload through the Site</li>
                  <li><b>Employment Screening Client Login</b> When you use the client log-in portal for background checks, you will be sent to our vendors’ system and webpage where they will collect login information such as account, username and/or password in order to access your account and perform the requested services.</li>
                  <li><b>Background Screening Services</b> (which may be collected through our Site or
                     offline). When your employer or landlord requests a background check, DHI may
                     collect your PII both online and offline to process the request.</li>
                  <li><b>Billing Information</b> (which may be collected through our Site or offline). If you
                     purchase our services you may need to provide DHI with payment and billing
                     information, such as your credit card details and billing address.</li>
               </ul>
               <h5>Non-personally Identifiable Information</h5>
               <p>When you visit our Website, we may collect and store general Internet data, such as your
                  domain name, browser type, device, date and time of access, which of our web pages you
                  visited, the referring Uniform Resource Locator (URL) and how long you spend on each
                  page. This information may be collected to assist us in making improvements to our Website
                  and to administer our Website. We do not link this information to any PII. DHI may employ
                  third party companies and individuals to facilitate these services (e.g., maintenance, analysis,
                  audit, development). These third parties have limited access to your information and only to
                  perform these services or tasks on our behalf</p>
               <h5>Information Use</h5>
               <p>Personally identifying information collected through our Site may be used to:</p>
               <ul>
                  <li>To respond to your inquiries, process requests or otherwise correspond with you
                     regarding employment, supplier affiliations, programs or services;
                  </li>
                  <li>Conduct pre-employment background checks, commercial background checks as
                     requested by customers of background check reports such as employers, investors,
                     and landlords;</li>
                  <li>Provide you with marketing information about DHI’s services and products;</li>
                  <li>Process billing, invoice and payment functions when you request DHI services; and,</li>
                  <li>Analyze and improve DHI’s services.</li>
               </ul>
               <h5>Cookies</h5>
               <p>Cookies are small text files that a website can send to a user’s browser for storage on the hard
                  drive. Cookies can make use of the Internet easier by saving and administering status,
                  preferences, and other user information. In other words, a cookie allows a website to
                  “remember” a user’s actions or preferences over time. For instance, when we use a cookie to
                  identify you, you would not have to log in a password more than once, thereby saving time
                  while on our Site. Cookies used by the Site do not contain your personally identifying
                  information. DHI may use cookies to route users through the Site, customize users’
                  experiences on the Site, to help us send you information about our services, and to improve
                  the Site. When you access the Site, certain non-PII is automatically logged. This information
                  may include your operating system, screen settings, Web browser software, and referring
                  website, if any. It is used for system improvement and administration, security, statistical
                  analysis purposes, and other internal business purposes. The Site may use service providers
                  for analytics purposes. These providers collect information about you anonymously and
                  report website trends without identifying individual visitors. These service providers use their
                  own cookies to track visitor interactions. Website owners can view a variety of reports
                  containing aggregate information about how visitors interact with their website so they can
                  improve their website. DHI does not control third-party cookies and their use may be
                  governed by the privacy policies of the service providers employing these cookies.</p>
               <p>Most browsers are set to accept cookies but users can change the setting to block cookies or
                  otherwise choose how cookies are handled. Although disabling cookies will not interfere with
                  your ability to access the Site, users will need to accept cookies to use certain services on the
                  Site</p>
               <p>You can manage website cookies in your browser settings, and you always have the choice to
                  change these settings by accepting, rejecting, or deleting cookies. If you choose to change
                  your settings, you may find that certain functions and features of our Site will not work as
                  intended. All browser settings are slightly different, so to manage cookies, you should refer to
                  the relevant settings within your browser.</p>
               <ul>
                  <li><a href="https://support.mozilla.org/en-US/kb/clear-cookies-and-site-data-firefox?redirectslug=delete-cookies-remove-info-websites-stored&amp;redirectlocale=en-US" target="_blank">Mozilla Firefox®</a></li>
                  <li><a href="https://support.microsoft.com/en-us/windows/delete-and-manage-cookies-168dab11-0753-043d-7c16-ede5947fc64d#ie=ie-11" target="_blank">Microsoft® Internet Explorer</a></li>
                  <li><a href="https://support.google.com/accounts/answer/61416?hl=en" target="_blank">Google Chrome™</a></li>
                  <li><a href="https://support.apple.com/en-us/HT201265" target="_blank">Safari®</a></li>
               </ul>
               <h5>Third-Party Links and Websites</h5>
               <p>This policy applies to DHI’s Website. However, you are able to access third-party sites
                  through our Site by, for example, clicking on hyperlinks to those third-party sites from within
                  our Site. We are not responsible for the content or privacy practices of any third-party sites,
                  and if you visit those websites, we encourage you to review their respective privacy policies.
                  Third party links on our Site are provided for your convenience and to provide further
                  information or serve as a resource. They do not signify that we endorse the website(s). DHI
                  exercises no control whatsoever over such other websites and web-based resources and is not
                  responsible or liable for the availability thereof or the content, advertising, products or other
                  materials thereon. DHI shall not be responsible or liable, directly or indirectly, for any
                  damage or loss incurred or suffered by any user in connection therewith. Your access and use
                  of linked websites, including information, material, products and services therein, is solely at
                  your own risk.</p>
               <p>DHI also may offer via the Website third party services, such as social media login, social
                  media sharing and social media commenting. Any information which is collected by DHI
                  when you access a third party service is processed under this privacy policy. Information
                  collected by third party service providers themselves will be governed by their own privacy
                  policy.</p>
               <h5>Information Sharing and Disclosure</h5>
               <p>DHI may disclose information we collect through this Site:</p>
               <ul>
                  <li>To complete a transaction that you request through our Site;</li>
                  <li>To complete a transaction requested by a third party for background screening
                     purposes;</li>
                  <li>To government agencies or DHI’s suppliers or vendors in order to conduct
                     background investigations as requested by your employer or landlord;</li>
                  <li>When required by law or other legal process, when pertinent to judicial or
                     governmental investigations or proceedings;</li>
                  <li>When necessary to investigate, take action or prevent suspected or actual illegal
                     activities, fraud, or potential threats to safety or personal physical safety; and,</li>
               </ul>
               <h5>Data Retention</h5>
               <p>DHI retains personal information as needed to provide you services or product information,
                  respond to inquiries, consider your employment application, partner with you, or as required
                  by contractual, statutory or other legal obligations.</p>
               <h5>Security and Confidentiality</h5>
               <p>DHI strives to protect personal information that we collect, maintain and disclose through the
                  use of appropriate and reasonable administrative, physical and technical safeguards.</p>
               <hr>
               <h5 style="color: var(--orange-color);">Point of Contact</h5>
               <p>If you have any questions or comments about DHI privacy policy or our privacy practices,
                  please contact us at:</p>
               <p><b>DHI Investigation Services Pvt. Ltd.</b><br>
                  #155, 2nd Floor, Ambara Arcade, Above Royal Enfield Showroom, <br>9th Cross, Bhadrappa
                  Layout, Hebbal Ring Road, <br>Bangalore, Karnataka, India, <br>PIN – 560094</p>
               <p>By Email contact: <a href="mailto:gopalkrishna@dhiverification.com">gopalkrishna@dhiverification.com</a></p>
            </div>
         </div>
      </div>
      </section>
      <div class="row">
         <div class="col-md-12">
            <h3>Terms &amp; Conditions and Refund Policy</h3>
            <p class="text-justify">Thank you for accessing www.dhiverification.com. This site is owned by DHI Investigation Services Pvt Ltd. (hereinafter referred to as “DHI Verification”). By accessing this site, you indicate your unconditional acceptance of the terms &amp; conditions of use. We reserve this right, in our sole discretion, to update or revise these terms &amp; conditions. Continued use of the site following the posting of any changes to the ‘terms &amp; conditions’, constitutes your acceptance of those changes. At DHI Verification, we try our best to create a space where you can explore our services in a safe and secure environment. All products and services information are displayed on www.dhiverification.com which constitutes an "invitation to offer". DHI Verification reserves the right to accept or reject your offer. Your order for purchase our products and services, constitutes your "offer" which shall be subject to the terms and conditions as listed below.</p>
            <h5>1. Eligibility to use our site</h5>
            <p class="text-justify">Use of the Site is available only to persons who can legally enter into contracts under applicable laws. Persons who are "incompetent to contract", within the meaning of the Indian Contract Act, 1872 including un-discharged insolvents etc. are not eligible to use the Site. DHI Verification reserves the right to terminate your access to the Site if it discovers that you are under the age of 18 years or suffers from any other disability, as recognized under Indian Contract Act, 1872.</p>
            <h5>2. Electronic Communications</h5>
            <p class="text-justify">When you use the site or send emails or other data, information or communicate to us, you agree and understand that you are communicating with us electronically and give your consent to receive communications electronically from us periodically, when required.</p>
            <h5>3. Reviews, Feedback, Submissions</h5>
            <p class="text-justify">All reviews, comments, feedback, postcards, suggestions, ideas, and other submissions disclosed, submitted or offered to DHI Verification directly or otherwise disclosed, submitted or offered in connection with your use of this Site (collectively referred to "Comments") will remain DHI Verification property. Such disclosure, submission or offer of any comments shall constitute an assignment to DHI Verification of all worldwide rights, titles and interests in all copyrights and other intellectual properties in the comments. Thus, DHI Verification exclusively owns all such rights, titles and interests and shall not be limited in any way in its use, commercial or otherwise. DHI Verification will be entitled to use, reproduce, disclose, modify, adapt, create derivative works from, publish, display and distribute any comments you submit for any purpose whatsoever, without restriction and without compensating you in any way. DHI Verification is and shall be under no obligation (1) to maintain any Comments in confidence; or (2) to pay you any compensation for any Comments; or (3) to respond to any Comments. You agree that any comments submitted by you to the Site will not violate this policy or any right of any third party, including copyright, trademark, privacy or other personal or proprietary right(s), and will not cause injury to any person or entity. You further agree that no comments submitted by you to the site will be libelous or otherwise unlawful, threatening, abusive or obscene material, or contain software viruses, political campaigning, commercial solicitation, chain letters, mass mailings or any form of "spam".</p>
            <p class="text-justify">DHI Verification does not regularly review posted comments, but does reserve the right (but not the obligation) to monitor and edit or remove any comment submitted to the Site. You grant DHI Verification the right to use the name that you submit in connection with any of the posted comments. You agree not to use a false email address, impersonate any person or entity, or otherwise mislead as to the origin of any Comments you submit. You are and shall remain solely responsible for the content of any comments you make and you agree to indemnify DHI Verification and its affiliates for all claims resulting from any Comments you submit, we take no responsibility and assume no liability for any comments submitted by you or any third party.</p>
            <h5>4. Accuracy of Content/ Information of Products on the Web Site</h5>
            <p class="text-justify">While DHI Verification strives to provide accurate product and pricing information, typographical errors may occur. In the event that a product is listed at an incorrect price or with incorrect information due to an error in pricing or product information, DHI Verification shall have the right, on our sole discretion, to modify the price of the products, or information of the products or to refuse or cancel any orders placed for that product, unless the product has already been dispatched. In the event.</p>
            <h5>5. Refund Policy</h5>
            <p class="text-justify">In case the you have placed a service request with DHI Verification and paid for the same; and the verification could not be done for whatever reason then in such cases a refund shall be made after deducting any cost (if any) to the company in handling such service request within seven working days. In case you have placed a service request with DHI Verification and paid for the same; and DHI Verification finds it is not possible to fulfill the requested service before it is initiated; then complete refund shall be made within in seven working days. Kindly note that we cannot process your refund request, In case you raise stop check request after we have done our part of verification work.</p>
         </div>
      </div>
   </div>
 


   <!-- Footer start -->
   <?php echo $footer ?>
   <!-- Footer end -->



   <?php echo $common_js ?>

   <script>
      $("a.cookie-close-btn, button.accept-cookies").on("click", function() {
         $(".cookie-overlay").css("display", "none");
      });

      $(".class").on("click", function() {

      })
   </script>
   <script src="https://cdnjs.cloudflare.com/ajax/libs/waypoints/4.0.1/jquery.waypoints.min.js"></script>
   <script src="https://cdn.jsdelivr.net/npm/jquery.counterup@2.1.0/jquery.counterup.min.js"></script>
   <script src="https://cdnjs.cloudflare.com/ajax/libs/popper.js/1.14.7/umd/popper.min.js"></script>
   <script src="https://stackpath.bootstrapcdn.com/bootstrap/4.3.1/js/bootstrap.min.js"></script>
</body>

</html>