<!DOCTYPE html>

<head>
    <title><?php echo $title ?></title>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1">
    <?php echo $common_css ?>
</head>

<body>

    <!--preloader start-->
    <div id="preloader">
        <div class="loader1">
            <span></span>
            <span></span>
            <span></span>
            <span></span>
            <span></span>
        </div>
    </div>
    <!--preloader end-->

    <!-- Main header start -->
    <?php echo $header_main ?>
    <!-- Main header end -->


    <div class="main">

        <!--hero section start-->
        <?php
        $where = array('status' => 1);
        $sliderQ = $this->common_model->get_table_data('sliders', $where, '*', true);
        if ($sliderQ->num_rows() > 0) {
        ?>
            <div class="owl-carousel owl-theme hero-content-slider custom-dot custom-dot-2">
                <?php
                foreach ($sliderQ->result() as $sliders) {
                ?>
                    <div class="item" style="background: url('<?php echo base_url() . $sliders->upload_dir . $sliders->f_image ?>') no-repeat center center / cover">
                        <div class="hero-content-wrap">
                            <div class="hero-content-align">
                                <h1 class="display-2"><?php echo ucwords($sliders->title) ?></h1>
                                <p class="lead"><?php echo ucwords($sliders->description) ?></p>
                                <a href="<?php echo base_url(); ?>contact_us" class="btn btn-secondary mt-3"><?php echo ucwords($sliders->btn_name) ?></a>
                            </div>
                        </div>
                    </div>
                <?php } ?>
            </div>
        <?php } else { ?>
            <div class="alert alert-info">No sliders found at this time, please visit us later!</div>
        <?php } ?>
        <!--custom indicator list start-->
        <!--<ul id="carousel-custom-indicator" class="owl-dots list-inline text-center custom-indicators position-absolute bottom-0 w-100 mb-0 d-none d-sm-none d-md-block d-lg-block">
                <li class="list-inline-item">
                    <a href="<?php echo base_url(); ?>services/background_verification">
                        <button class="border-0 d-flex align-items-center"><span
                            class="fas fa-graduation-cap icon icon-xs mr-2"></span> Background <span class="item"> Verification</span>
                            <span class="fa fa-arrow-right arrow"></span>
                        </button>
                    </a>
                </li>
                <li class="list-inline-item">
                <a href="<?php echo base_url(); ?>services/litigation_verification"><button class="border-0 d-flex align-items-center"><span
                            class="fas fa-gavel icon icon-xs mr-2"></span> Litigation <span class="item"> Verification</span>
                            <span class="fa fa-arrow-right arrow"></span>
                    </button></a>
                </li>
                <li class="list-inline-item">
                    <a href="<?php echo base_url(); ?>services/contact_point_verification"><button class="border-0 d-flex align-items-center">
                        <span class="fas fa-phone icon icon-xs mr-2"></span> Contact Point <span class="item"> Verification</span>
                            <span class="fa fa-arrow-right arrow"></span>
                    </button></a>
                </li>
                <li class="list-inline-item">
                <a href="<?php echo base_url(); ?>services/technology_solutions"><button class="border-0 d-flex align-items-center"><span
                            class="fas fa-rocket icon icon-xs mr-2"></span> Technology <span class="item"> Solutions</span>
                            <span class="fa fa-arrow-right arrow"></span>
                    </button></a>
                </li>
            </ul>-->
        <!--custom indicator list end-->
        </section>
        <!--hero section end-->

        <?php echo $common_clients ?>

        <!--about section start-->
        <section class="section section-lg basic about">
            <div class="container">
                <div class="row row-grid align-items-center">
                    <div class="col-12 col-lg-5">
                        <h2>DHI Verification</h2>
                        <p class="lead">In 2010, we a team of professionals from Legal, Academics, Accounting and Information Technology decided to embark on a journey to provide professional and value-added services to business community in India. We found legal services for corporate India especially in Human Resource Development was inadequate, given</p>

                        <a href="<?php echo base_url() ?>about_us" class="btn btn-secondary mt-3">Know more<span class="icon icon-xs ml-2"><span class="fas fa-arrow-right"></span></span></a>
                    </div>
                    <div class="col-12 col-lg-6 ml-lg-auto">
                        <div class="row">
                            <div class="col-12 col-sm-6">
                                <div class="card bg-default text-white shadow-soft rounded mb-4 counter-card">
                                    <div class="text-center m-auto">
                                        <span class="icon icon-lg d-block"><i class="fas fa-user-shield"></i></span>
                                        <h5>Leaders in digital verification</h5>
                                        <!-- <p class="mb-0">Create low-effort customer service experiences.</p> -->
                                    </div>
                                </div>
                                <div class="card bg-light text-white shadow-soft rounded mb-4 counter-card">
                                    <div class="text-center year-logo">
                                    <img src="<?php echo base_url(); ?>ui/frontend/images/12th-logo.png" alt="client logo" class="img-fluid img-responsive">
                                        <!-- <p class="mb-0">Proactively develop B2B alignments rather.</p> -->
                                    </div>
                                </div>
                            </div>
                            <div class="col-12 col-md-6 col-sm-6  counter-main">
                                <!--cta section start-->
                                <section class="py-0 text-white" style="background: url('<?php echo base_url() ?>ui/frontend/images/bg.png ')no-repeat center center fixed; background-size:cover; ">
                                    <div class="section section-sm bg-gradient-primary counters">
                                        <div class="container">
                                            <?php
                                            $where = array('status' => 1);
                                            $statQ = $this->common_model->get_table_data('stats', $where, '*', true);
                                            if ($statQ->num_rows() > 0) {
                                            ?>
                                                <div class="row">
                                                    <?php
                                                    foreach ($statQ->result() as $stats) {
                                                    ?>
                                                        <div class="col-6 col-md-6 col-lg-6 mb-4 mb-md-4 mb-lg-0">
                                                            <div class="icon-box text-center">
                                                                <div class="icon icon-md">
                                                                    <?php if ($stats->f_image != '') { ?>
                                                                        <img src="<?php echo base_url() . $stats->upload_dir . $stats->f_image ?>" class="card-img-top rounded-circle">
                                                                    <?php } else { ?>
                                                                        <img class="card-img-top rounded-circle" src="<?php echo base_url() ?>ui/frontend/images/avatar.svg">
                                                                    <?php } ?>
                                                                </div>
                                                                <span class="counts-content d-block display-3 my-2"><?php echo $stats->cases ?></span>
                                                                <h3 class="h6 counter-content"><?php echo ucwords($stats->name) ?></h3>
                                                            </div>
                                                        </div>
                                                    <?php } ?>
                                                </div>
                                            <?php } else { ?>
                                                <div class="alert alert-info">No statistics found at this time, please visit us later!</div>
                                            <?php } ?>
                                        </div>
                                    </div>
                                </section>
                                <!--cta section end-->
                            </div>
                        </div>
                    </div>
                </div>
            </div>
    </div>
    </div>
    </section>
    <!--about section end-->

    <?php echo $common_usp ?>

    <!--features section start-->
    <section class="section section-lg bg-soft services">
        <div class="container">
            <div class="row justify-content-center">
                <div class="col-md-8">
                    <div class="section-heading text-center mb-5">
                        <h2 class="text-primary">Best Quality Services</h2>
                    </div>
                </div>
            </div>

            <div class="row">
                <div class="col-md-3 col-lg-3 mb-4">
                    <!-- Icon box -->
                    <div class="icon-box text-center p-1">
                        <div class="card-icon">
                            <img src="<?php echo base_url(); ?>ui/frontend/images/quality/address-verify.png" alt="icon" width="60" class="img-fluid">
                        </div>
                        <a href="<?php echo base_url(); ?>services/background_verification"><h2 class="h5 card-sub-text text-primary">Background verification</h2></a>
                        <!-- <p class="mb-0">Academic qualification demonstrates Individual value proposition for employment. DHI helps verify the sanctity of completion and Mode of education.</p> -->
                        <!-- <a href="<?php echo base_url(); ?>services/background_verification" class="btn btn-sm btn-secondary mt-3">Read more<span class="icon icon-xs ml-2"><span class="fas fa-arrow-right"></span></span></a> -->
                    </div>
                    <!-- End of Icon box -->
                </div>

                <div class="col-md-3 col-lg-3 mb-4">
                    <!-- Icon box -->
                    <div class="icon-box text-center p-1">
                        <div class="card-icon">
                            <img src="<?php echo base_url(); ?>ui/frontend/images//quality/court-verify.png" alt="icon" width="60" class="img-fluid">
                        </div>
                        <a href="<?php echo base_url(); ?>services/litigation_verification"><h2 class="h5 card-sub-text text-primary">Litigation verification</h2></a>
                        <!-- <p class="mb-0">Litigation history speaks about Individual or an Institution, DHI is servicing over 70 plus national and multinational corporates to meet their employment and vendor engagement compliances.</p> -->
                        <!-- <a href="<?php echo base_url(); ?>services/litigation_verification" class="btn btn-sm btn-secondary mt-3">Read more<span class="icon icon-xs ml-2"><span class="fas fa-arrow-right"></span></span></a> -->
                    </div>
                    <!-- End of Icon box -->
                </div>
                <div class="col-md-3 col-lg-3 mb-4">
                    <!-- Icon box -->
                    <div class="icon-box text-center p-1">
                        <div class="card-icon">
                            <img src="<?php echo base_url(); ?>ui/frontend/images//quality/cpv-verify.png" alt="icon" width="60" class="img-fluid">
                        </div>
                        <a href="<?php echo base_url(); ?>services/contact_point_verification"><h2 class="h5 card-sub-text text-primary">Contact point verification (CPV)</h2></a>
                        <!-- <p class="mb-0">Banks and NBFCs require CPV for retail and corporate loans, DHI currently caters to over 750 branches across Banks and NBFC’s.</p> -->
                        <!-- <a href="<?php echo base_url(); ?>services/contact_point_verification" class="btn btn-sm btn-secondary mt-3">Read more<span class="icon icon-xs ml-2"><span class="fas fa-arrow-right"></span></span></a> -->
                    </div>
                    <!-- End of Icon box -->
                </div>
                <div class="col-md-3 col-lg-3 mb-4 mb-lg-0">
                    <!-- Icon box -->
                    <div class="icon-box text-center p-1">
                        <div class="card-icon">
                            <img src="<?php echo base_url(); ?>ui/frontend/images/quality/social-verify.png" alt="icon" width="60" class="img-fluid">
                        </div>
                        <a href="<?php echo base_url(); ?>services/technology_solutions"><h2 class="h5 card-sub-text text-primary">Technology Solutions</h2></a>
                        <!-- <p class="mb-0">DHICasequest is a search engine for conglomeration of litigation data across Indian courts and other institutions/departments available publicly.</p> -->
                        <!-- <a href="<?php echo base_url(); ?>services/technology_solutions" class="btn btn-sm btn-secondary mt-3">Read more<span class="icon icon-xs ml-2"><span class="fas fa-arrow-right"></span></span></a> -->
                    </div>
                    <!-- End of Icon box -->
                </div>

                <div class="col-md-3 col-lg-3 mb-4">
                    <!-- Icon box -->
                    <div class="icon-box text-center p-1">
                        <div class="card-icon">
                            <img src="<?php echo base_url(); ?>ui/frontend/images/quality/employe-verify.png" alt="icon" width="60" class="img-fluid">
                        </div>
                        <a href="<?php echo base_url(); ?>services/background_verification"><h2 class="h5 card-sub-text text-primary">Employment verification</h2></a>
                    </div>
                    <!-- End of Icon box -->
                </div>


                <div class="col-md-3 col-lg-3 mb-4">
                    <!-- Icon box -->
                    <div class="icon-box text-center p-1">
                        <div class="card-icon">
                            <img src="<?php echo base_url(); ?>ui/frontend/images/quality/education-verify.png" alt="icon" width="60" class="img-fluid">
                        </div>
                        <a href="<?php echo base_url(); ?>services/background_verification"><h2 class="h5 card-sub-text text-primary">Education verification</h2></a>
                    </div>
                    <!-- End of Icon box -->
                </div>

                <div class="col-md-3 col-lg-3 mb-4">
                    <!-- Icon box -->
                    <div class="icon-box text-center p-1">
                        <div class="card-icon">
                            <img src="<?php echo base_url(); ?>ui/frontend/images/quality/criminal-verify.png" alt="icon" width="60" class="img-fluid">
                        </div>
                        <a href="<?php echo base_url(); ?>services/background_verification"><h2 class="h5 card-sub-text text-primary">Criminal Records Check</h2></a>
                    </div>
                    <!-- End of Icon box -->
                </div>


                <div class="col-md-3 col-lg-3 mb-4">
                    <!-- Icon box -->
                    <div class="icon-box text-center p-1">
                        <div class="card-icon">
                            <img src="<?php echo base_url(); ?>ui/frontend/images/quality/global-verify.png" alt="icon" width="60" class="img-fluid">
                        </div>
                        <a href="<?php echo base_url(); ?>services/background_verification"><h2 class="h5 card-sub-text text-primary">Global Database Verification</h2></a>
                    </div>
                    <!-- End of Icon box -->
                </div>

                <div class="col-md-3 col-lg-3 mb-4">
                    <!-- Icon box -->
                    <div class="icon-box text-center p-1">
                        <div class="card-icon">
                            <img src="<?php echo base_url(); ?>ui/frontend/images/quality/credit-check.png" alt="icon" width="60" class="img-fluid">
                        </div>
                        <a href="<?php echo base_url(); ?>services/background_verification"><h2 class="h5 card-sub-text text-primary">Credit Check</h2></a>
                    </div>
                    <!-- End of Icon box -->
                </div>

                <div class="col-md-3 col-lg-3 mb-4">
                    <!-- Icon box -->
                    <div class="icon-box text-center p-1">
                        <div class="card-icon">
                            <img src="<?php echo base_url(); ?>ui/frontend/images/quality/drug-verify.png" alt="icon" width="60" class="img-fluid">
                        </div>
                        <a href="<?php echo base_url(); ?>services/background_verification"><h2 class="h5 card-sub-text text-primary">Drug Test Screening</h2></a>
                    </div>
                    <!-- End of Icon box -->
                </div>

                <div class="col-md-3 col-lg-3 mb-4">
                    <!-- Icon box -->
                    <div class="icon-box text-center p-1">
                        <div class="card-icon">
                            <img src="<?php echo base_url(); ?>ui/frontend/images/quality/passport-verify.png" alt="icon" width="60" class="img-fluid">
                        </div>
                        <a href="<?php echo base_url(); ?>services/background_verification"><h2 class="h5 card-sub-text text-primary">Passport Verification</h2></a>
                    </div>
                    <!-- End of Icon box -->
                </div>

                <div class="col-md-3 col-lg-3 mb-4">
                    <!-- Icon box -->
                    <div class="icon-box text-center p-1">
                        <div class="card-icon">
                            <img src="<?php echo base_url(); ?>ui/frontend/images/quality/din-verify.png" alt="icon" width="60" class="img-fluid">
                        </div>
                        <a href="<?php echo base_url(); ?>services/background_verification"><h2 class="h5 card-sub-text text-primary">DIN Verification</h2></a>
                    </div>
                    <!-- End of Icon box -->
                </div>

                
            </div>
        </div>
    </section>
    <!--features section end-->

    <?php echo $common_request_demo ?>



    <?php echo $common_cat ?>

    <!-- <?php // echo $common_team 
            ?> -->

    <!--<section class="section section-lg ">
            <div class="container">
                <div class="row justify-content-center">
                    <div class="col-lg-8">
                        <div class="section-heading text-center mb-5">
                            <h2>Our Team</h2>
                        </div>
                    </div>
                </div>
                <?php
                $where = array('status' => 1);
                $teamQ = $this->common_model->get_table_data('teams', $where, '*', true);
                if ($teamQ->num_rows() > 0) {
                ?>
                <div class="row">
                    <?php
                    foreach ($teamQ->result() as $teams) {
                    ?>
                        <div class="col-12 col-md-6 col-lg-3 mb-md-4 mb-lg-0 mb-4">
                            <div class="profile-card">
                                <div class="card bg-soft  shadow-sm animate-hover border-variant-soft">
                                    <div class="profile-image-small shadow-inse rounded-circle p-1 mt-4">
                                        <?php if ($teams->f_image != '') { ?>
                                        <img src="<?php echo base_url() . $teams->upload_dir . $teams->f_image ?>"  class="card-img-top rounded-circle">
                                        <?php } else { ?>
                                            <img class="card-img-top rounded-circle" src="<?php echo base_url() ?>ui/frontend/images/avatar.svg">
                                        <?php } ?>
                                    </div>
                                    <div class="card-body text-center">
                                        <h3 class="h5"><?php echo ucwords($teams->name) ?></h3>
                                        <span class="h6 font-weight-normal text-gray mb-3"><?php echo ucwords($teams->designation) ?></span>
                                    </div>
                                </div>
                            </div>
                        </div>
                    <?php } ?>
                </div>
                <?php } else { ?>
                    <div class="alert alert-info">No team members found at this time, please visit us later!</div>
                <?php } ?>
            </div>   
        </section>-->

    <?php echo $common_testimonial ?>
    </div>

    <div class="cookie-overlay">
        <div class="d-flex">
            <div class="mr-3 font-12">By clicking the "Accept" button below, you agree to our <a href="">Cookie Policy</a> & <a href="">Terms &amp; Conditions</a>.</div>
            <a href="javascript:;" class="cookie-close-btn">&times;</a>
        </div>
        <button class="btn btn-primary mt-3 accept-cookies">Accept & Continue</button>
    </div>

    <!-- Footer start -->
    <?php echo $footer ?>
    <!-- Footer end -->



    <?php echo $common_js ?>

    <script>
        $("a.cookie-close-btn, button.accept-cookies").on("click", function() {
            $(".cookie-overlay").css("display", "none");
        });

        $(".class").on("click", function() {

        })
    </script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/waypoints/4.0.1/jquery.waypoints.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/jquery.counterup@2.1.0/jquery.counterup.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/popper.js/1.14.7/umd/popper.min.js"></script>
    <script src="https://stackpath.bootstrapcdn.com/bootstrap/4.3.1/js/bootstrap.min.js"></script>
    <script>
        $('.counter').counterUp({
            delay: 10,
            time: 2000
        });

        $('.counter').addClass('animated fadeIn');
        $('h3').addClass('animated fadeIn');
    </script>
</body>

</html>