<!DOCTYPE html>

<head>
    <title><?php echo $title ?></title>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1">
    <?php echo $common_css ?>
</head>

<body>

    <!--preloader start-->
    <div id="preloader">
        <div class="loader1">
            <span></span>
            <span></span>
            <span></span>
            <span></span>
            <span></span>
        </div>
    </div>
    <!--preloader end-->

    <!-- Main header start -->
    <?php echo $header_main ?>
    <!-- Main header end -->


    <div class="main">

        <!--page header section start-->
        <section class="" style="background: url('<?php echo base_url(); ?>ui/frontend/images/bg.png')no-repeat center center / cover">
            <div class="section-lg bg-gradient-primary text-white section-header">
                <div class="container">
                    <div class="row justify-content-center bread-crumb-position">
                        <div class="col-md-8 col-lg-7">
                            <div class="page-header-content text-center">
                                <h1>Contact Us</h1>
                                <nav aria-label="breadcrumb" class="d-flex justify-content-center">
                                    <ol class="breadcrumb breadcrumb-transparent breadcrumb-text-light">
                                        <li class="breadcrumb-item"><a href="<?php echo base_url(); ?>">Home</a></li>
                                        <li class="breadcrumb-item active" aria-current="page">Contact Us</li>
                                    </ol>
                                </nav>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>
        <!--page header section end-->

        <!--contact us section start-->
        <section class="section section-lg">
            <div class="container contact">
                <div class="row justify-content-around align-items-center">
                    <div class="col-md-6">
                        <div class="contact-us-form bg-soft rounded p-5">
                            <h4>Fill the form below</h4>
                            <form method="POST" id="contactForm" class="contact-us-form mt-4">
                                <div class="form-row">
                                    <div class="col-12">
                                        <div class="form-group">
                                            <input type="text" class="form-control" name="name" placeholder="Enter name">
                                        </div>
                                    </div>
                                    <div class="col-12">
                                        <div class="form-group">
                                            <input type="email" class="form-control" name="email" placeholder="Enter email">
                                        </div>
                                    </div>
                                    <div class="col-12">
                                        <div class="form-group">
                                            <input type="text" class="form-control" name="phone" placeholder="Enter mobile">
                                        </div>
                                    </div>
                                    <div class="col-12">
                                        <div class="form-group">
                                            <textarea name="message" class="form-control" rows="7" cols="25" placeholder="Message"></textarea>
                                        </div>
                                    </div>


                                    <div class="col-lg-12">
                                        <div class="form-wrap">
                                            <div id="g-recaptcha" name="grecaptcha" class="g-recaptcha" data-sitekey="6Ldjb5onAAAAAFGNJ9W_VSTMRW4sTUJU6bd5mO6-"></div>
                                        </div>
                                    </div>

                                    <div class="col-sm-12 mt-3 text-center">
                                        <button type="submit" class="btn btn-secondary" id="btnContactUs">
                                            Send Message
                                        </button>
                                    </div>
                                </div>
                            </form>
                        </div>
                    </div>
                    <div class="col-md-5">
                        <div class="contact-us-content">
                            <p class="lead">We Are Here For Your Help</p>
                            <h2>Get in Touch for Authentic Legal Background Verification</h2>
                            <hr>
                            <h5>Address</h5>
                            <address>
                                <b>DHI Investigation Services Pvt. Ltd.</b><br> #155, 2nd Floor, Ambara Arcade, Above Royal Enfield Showroom, 9th Cross, Bhadrappa Layout, Hebbal Ring Road, Bangalore, Karnataka, India, PIN - 560094
                            </address>
                            <br>
                            <span>Phone: <a href="tel:9243441888" class="link-color">+91-9243441888</a></span> <br>
                            <span>Email: <a href="mailto:reachus@dhiverification.com
" class="link-color">reachus@dhiverification.com
                                </a></span>

                        </div>
                    </div>
                </div>
            </div>
        </section>
        <!--contact us section end-->

        <!--contact map section start-->
        <div class="section py-0">
            <div class="google-map mb-n2 opacity-9 w-100">
                <iframe src="https://www.google.com/maps/embed?pb=!1m14!1m8!1m3!1d15547.24287070023!2d77.5790495!3d13.0477172!3m2!1i1024!2i768!4f13.1!3m3!1m2!1s0x0%3A0x23f17e321cbd4c21!2sDHI%20Investigation%20Services%20Pvt.%20Ltd.!5e0!3m2!1sen!2sin!4v1650281424690!5m2!1sen!2sin" height="450" style="border:0;" allowfullscreen=""></iframe>
            </div>
        </div>
        <!--contact map section end-->


    </div>

    <!-- Footer start -->
    <?php echo $footer ?>
    <!-- Footer end -->



    <?php echo $common_js ?>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/sweetalert/2.1.2/sweetalert.min.js"></script>
    <script src="https://www.google.com/recaptcha/api.js"></script>
    <script type="text/javascript" src="<?php echo base_url() ?>ui/frontend/js/my-scripts/forms.js"></script>
</body>

</html>