<!DOCTYPE html>

<head>
    <title><?php echo $title ?></title>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1">
    <?php echo $common_css ?>
</head>

<body>

    <!--preloader start-->
    <div id="preloader">
        <div class="loader1">
            <span></span>
            <span></span>
            <span></span>
            <span></span>
            <span></span>
        </div>
    </div>
    <!--preloader end-->

    <!-- Main header start -->
    <?php echo $header_main ?>
    <!-- Main header end -->


    <div class="main">

        <!--page header section start-->
        <section class="" style="background: url('<?php echo base_url(); ?>ui/frontend/images/bg.png')no-repeat center center / cover">
            <div class="section-lg bg-gradient-primary text-white section-header">
                <div class="container">
                    <div class="row justify-content-center bread-crumb-position">
                        <div class="col-md-8 col-lg-7">
                            <div class="page-header-content text-center">
                                <h1>Career</h1>
                                <nav aria-label="breadcrumb" class="d-flex justify-content-center">
                                    <ol class="breadcrumb breadcrumb-transparent breadcrumb-text-light">
                                        <li class="breadcrumb-item"><a href="<?php echo base_url(); ?>">Home</a></li>
                                        <li class="breadcrumb-item active" aria-current="page">Career</li>
                                    </ol>
                                </nav>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>
        <!--page header section end-->

        <!--contact us section start-->
        <section class="section section-lg">
            <div class="container contact">
                <div class="col-12 pb-3 message-box d-none">
                    <div class="alert alert-danger"></div>
                </div>
                <div class="row justify-content-around align-items-center">
                    <div class="col-md-6">
                        <div class="contact-us-content">
                            <p class="lead">Career Form</p>
                            <h2>Mail us your updated CV to <a href="mailto:reachus@dhiverification.com
">reachus@dhiverification.com
                                </a> <br> We will revert to you shortly after the review</h2>
                        </div>
                    </div>

                    <div class="col-md-6">
                        <div class="contact-us-form bg-soft rounded p-5">
                            <h4>Apply Now</h4>
                            <form method="POST" id="careerForm" class="contact-us-form mt-4">
                                <div class="form-row">
                                    <div class="col-12">
                                        <div class="form-group">
                                            <input type="text" class="form-control" name="name" placeholder="Enter name" required="required">
                                        </div>
                                    </div>
                                    <div class="col-12">
                                        <div class="form-group">
                                            <input type="email" class="form-control" name="email" placeholder="Enter email" required="required">
                                        </div>
                                    </div>
                                    <div class="col-12">
                                        <div class="form-group">
                                            <input type="text" class="form-control" name="phone" placeholder="Enter Phone" required="required">
                                        </div>
                                    </div>
                                    <div class="col-12">
                                        <div class="form-group">
                                            <label>Upload your resume</label>
                                            <input type="file" class="form-control" name="resume[]" required="required">
                                        </div>
                                    </div>

                                    <div class="col-lg-12">
                                        <div class="form-wrap">
                                            <div id="g-recaptcha" name="grecaptcha" class="g-recaptcha" data-sitekey="6Ldjb5onAAAAAFGNJ9W_VSTMRW4sTUJU6bd5mO6-"></div>
                                        </div>
                                    </div>

                                    <div class="col-sm-12 mt-3 text-center">
                                        <button type="submit" class="btn btn-secondary" id="btnContactUs">
                                            Submit
                                        </button>
                                    </div> 
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </section>
        <!--contact us section end-->

        <?php echo $common_cat ?>


    </div>

    <!-- Footer start -->
    <?php echo $footer ?>
    <!-- Footer end -->



    <?php echo $common_js ?>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/sweetalert/2.1.2/sweetalert.min.js"></script>
    <script src="https://www.google.com/recaptcha/api.js"></script>
    <script type="text/javascript" src="<?php echo base_url() ?>ui/frontend/js/my-scripts/forms.js"></script>

</body>

</html>