<?php 
    if($propertyQ->num_rows()>0){
        foreach ($propertyQ->result() as $property_data) {
            $ptype=$property_data->ptype;
            $code=$property_data->code;
            $title=$property_data->title;
            $p_category=$property_data->parent_category;
            $category=$property_data->sub_category;
            $size=$property_data->size;
            $location=$property_data->location;
            $price=$property_data->price;
            $sqft_price=$property_data->sqft_price;
            $tot_sqft=$property_data->tot_sqft;
            $rera_no=$property_data->rera_no;

            $beds=$property_data->beds;
            $bathrooms=$property_data->bathrooms;
            $balcony=$property_data->balcony;
            $garage=$property_data->garage;
            $units=$property_data->units;
            $wstations=$property_data->wstations;
            $cabins=$property_data->cabins;
            $power_kw=$property_data->power_kw;
            $ceiling_ht=$property_data->ceiling_ht;
            $d_space=$property_data->d_space;
            $length=$property_data->length;
            $width=$property_data->width;
            $r_width=$property_data->r_width;
            $frontage=$property_data->frontage;

            $upload_dir=$property_data->upload_dir;
            $slug=$property_data->slug;
            $createdDate=$property_data->createdDate;
            $created_by=$property_data->created_by;
            $updatedDate=$property_data->updatedDate;
            $updated_by=$property_data->updated_by;
            $status=$property_data->status;
        }
    }

    foreach ($detailsQ->result() as $details) {
        $feature_image=$details->feature_image;
        $description=$details->description;
        $features=$details->features;
        $floor_plan=$details->floor_plan;
        $floor_diagram=$details->floor_diagram;
        $video_url=$details->video_url;
    }
?>

<!DOCTYPE html>
<html>  
<head>
	<meta charset="utf-8">
	<meta name="viewport" content="width=device-width, initial-scale=1.0">
	<!-- App title -->
	<title><?php echo 'Edit Property | '.ucwords($title); ?></title>
    <link href="<?php echo base_url()?>ui/assets/plugins/summernote/dist/summernote.css" rel="stylesheet" />
  <?php echo $commonCss; ?>
</head>

   <body class="fixed-left">
	<div id="wrapper">      
		<?php echo $header_main; ?>                 

		<?php echo $header_menu; ?>
           
        <!-- End Navigation Bar-->
		
		   <!-- ============================================================== -->
        <!-- Start right Content here -->
        <!-- ============================================================== -->
            <div class="content-page property-page" id="content_page">
                <!-- Start content -->
                <div class="content">
                    <div class="container-fluid">

                        <div class="row">
                            <div class="col-xl-12">
                                <div class="page-title-box">
                                    <h4 class="page-title float-left"><?php echo 'Edit '.ucwords($title) ?></h4>

                                    <ol class="breadcrumb float-right">
                                        <li class="breadcrumb-item"><a href="<?php echo base_url() ?>admin/dashboard">Home</a></li>
                                        <li class="breadcrumb-item"><a href="<?php echo base_url() ?>admin/properties">Properties</a></li>
                                        <li class="breadcrumb-item active">Edit</li>
                                        <li class="breadcrumb-item active"><?php echo ucwords($title) ?></li>
                                    </ol>

                                    <div class="clearfix"></div>
									<p>Here you can manage property details that will be displayed in website listing.</p>									
                                </div>
                            </div>
                        </div>
                        <!-- end row -->
                        
                        <div class="row">
                            <div class="col-lg-12 text-right">
                                <div class="form-group mb-4">
                                    <label class="ui-switch switch-icon mr-3 mb-0">
                                        <input type="checkbox" id="up_status" <?php if($status==1){ echo 'checked';} ?> name="status"><span></span>
                                    </label>Display in Listing
                                </div>
                            </div>
                        </div>
                        

                        <div class="row">
                            <div class="col-lg-8">
                                <div class="card property-details">
                                	<div class="card-header">
                                		Property details
                                        <span><button type="button" class="btn btn-success btn-dataEdit" data-type="details">Edit</button></span>
                                	</div>
                                	<div class="card-box">
                                        <div class="row">
                                            <div class="col-lg-7 col-12">
                                        		<ul class="list-unstyled mb-0">
                                                    <li><b>Type</b> - <?php if($ptype==0){echo "Resale Property";}else{echo "New Project";} ?></li>
                                                    <li><b>Title</b> - <?php echo $title ?></li>
                                        			<li><b>Category</b> - <?php echo $p_category.'->'.$category ?></li>
                                        			<li><b>Location</b> - <?php echo $location ?></li>
                                        			<li><b>RERA No.</b> - <?php echo $rera_no ?></li>
                                                    <li><b>Total Area</b> - <?php echo $tot_sqft ?> SQFT</li>
                                                    <li><b>Price/SQFT</b> - Rs.<?php echo moneyFormat($sqft_price) ?></li>
                                        			<li><b>Price</b> - Rs.<?php echo moneyFormat($price) ?></li>
                                        			<li><b>Size</b> - <?php echo $size ?> SQFT</li>
                                                    <?php if($beds!=''){ ?>
                                                    <li><b>Bedrooms</b> - <?php echo $beds ?></li>
                                                    <?php }if($bathrooms!=''){ ?>
                                                    <li><b>Bathrooms</b> - <?php echo $bathrooms ?></li>
                                                    <?php }if($balcony!=''){ ?>
                                                    <li><b>Balcony</b> - <?php echo $balcony ?></li>
                                                    <?php }if($garage!=''){ ?>
                                                    <li><b>Car Parks</b> - <?php echo $garage ?></li>
                                                    <?php }if($units!=''){ ?>
                                                    <li><b>Units</b> - <?php echo $units ?></li>
                                                    <?php }if($wstations!=''){ ?>
                                                    <li><b>Work Stations</b> - <?php echo $wstations ?></li>
                                                    <?php }if($cabins!=''){ ?>
                                                    <li><b>Cabins</b> - <?php echo $cabins ?></li>
                                                    <?php }if($power_kw!=''){ ?>
                                                    <li><b>Power KW</b> - <?php echo $power_kw ?></li>
                                                    <?php }if($ceiling_ht!=''){ ?>
                                                    <li><b>Ceiling Height</b> - <?php echo $ceiling_ht ?></li>
                                                    <?php }if($d_space!=''){ ?>
                                                    <li><b>Display Space</b> - <?php echo $d_space ?></li>
                                                    <?php }if($length!=''){ ?>
                                                    <li><b>Length</b> - <?php echo $length ?></li>
                                                    <?php }if($width!=''){ ?>
                                                    <li><b>Width</b> - <?php echo $width ?></li>
                                                    <?php }if($r_width!=''){ ?>
                                                    <li><b>Road Width</b> - <?php echo $r_width ?></li>
                                                    <?php }if($frontage!=''){ ?>
                                                    <li><b>Frontage</b> - <?php echo $frontage ?></li>
                                                    <?php } ?>                                                        
                                                </ul>                                        
                                            </div>
                                            <div class="col-lg-5 col-12">
                                                <ul class="list-unstyled">
                                                    <li><b>#ID</b> - <?php echo $code ?></li>
                                                    <li><b>Created</b> - <?php echo getMyDbDate('%d %M %Y %h:%i %A',$createdDate); ?></li>
                                                    <li><b>Created By</b> - <?php echo ucwords($created_by); ?></li>
                                                    <li><b>Last Updated</b> - <?php if($updatedDate!=''){ echo getMyDbDate('%d %M %Y %h:%i %A',$updatedDate);}else{ echo 'N/A';} ?></li>
                                                    <li><b>Updated By</b> - <?php if($updated_by!=''){echo ucwords($updated_by);}else{echo 'N/A';} ?></li>
                                                </ul>
                                            </div>
                                        </div>
                                	</div>
                                </div>
                            </div>
                            <div class="col-lg-4">
                                <div class="card feature-img-box">
                                    <div class="card-header">
                                        Featured Image
                                        <span><button type="button" class="btn btn-success btn-fimageEdit" data-type="f_image">Edit</button></span>
                                    </div>
                                    <div class="card-box">
                                        <?php if($feature_image!=''){ ?>
                                            <img src="<?php echo base_url().$upload_dir.$feature_image ?>" class="img-fluid">
                                        <?php }else{ ?>
                                        <div class="alert alert-warning">No image uploaded</div>
                                        <?php } ?>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="card">
                            <div class="card-header">
                                Description
                                <span><button type="button" class="btn btn-success btn-dataEdit" data-type="description">Edit</button></span>
                            </div>
                            <div class="card-box">
                                <?php if($description!=''){ echo $description; }else{ ?>
                                <div class="alert alert-warning">No description content updated</div>
                                <?php } ?>
                            </div>
                        </div>

                        <div class="card">
                            <div class="card-header">
                                Features
                                <span><button type="button" class="btn btn-success btn-dataEdit" data-type="features">Edit</button></span>
                            </div>
                            <div class="card-box">
                                <?php if($features!=''){ echo $features; }else{ ?>
                                <div class="alert alert-warning">No feature content updated</div>
                                <?php } ?>
                            </div>
                        </div>

                        <div class="card floor-plan-box">
                            <div class="card-header">
                                Floor Plans
                                <span><button type="button" class="btn btn-success btn-planEdit" data-type="floor_plan">Edit</button></span>
                            </div>
                            <div class="card-box">
                                <div class="row">
                                    <div class="col-lg-8">
                                        <h5>Floor Plan Details</h5>
                                        <?php if($floor_plan!=''){ echo $floor_plan; }else{ ?>
                                        <div class="alert alert-warning">No content updated</div>
                                        <?php } ?>
                                    </div>
                                    <div class="col-lg-4">
                                        <h5>Floor Plan Diagram</h5>
                                        <?php if($floor_diagram!=''){ ?>
                                            <img src="<?php echo base_url().$upload_dir.$floor_diagram ?>" class="img-fluid">
                                        <?php }else{ ?>
                                        <div class="alert alert-warning">No content updated</div>
                                        <?php } ?>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="card photos_box">
                            <div class="card-header">
                                Property Photos
                                <span><button type="button" class="btn btn-success btn-photosEdit" data-type="photos">Add New</button></span>
                            </div>
                            <div class="card-box">
                                <div id="photos_tbl">
                                    <div class="images-list">
                                        <div class="row">
                                            <?php 
                                                if($photosQ->num_rows()>0){
                                                    foreach ($photosQ->result() as $photos) {
                                            ?>
                                            <div class="col-lg-4 col-12">
                                                <div class="card">
                                                    <div class="card-box">
                                                        <img src="<?php echo base_url().$photos->folder.$photos->file_name ?>" class="img-fluid">
                                                    </div>
                                                    <div class="card-footer">
                                                        <span class="btn btn-info btn-fileInfo" data-id="<?php echo $photos->id ?>"><i class="fa fa-info-circle"></i> Details</span>
                                                        <span class="btn btn-danger btn-fileTrash" data-id="<?php echo $photos->id ?>"><i class="fa fa-trash"></i> Delete</span>
                                                    </div>
                                                </div>
                                            </div>
                                            <?php } }else{ ?>
                                                <div class="col-12">
                                                    <div class="alert alert-warning">No images uploaded</div>
                                                </div>
                                            <?php } ?>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="card property-video-box">
                            <div class="card-header">
                                Property Video
                                <span><button type="button" class="btn btn-success btn-videoEdit" data-type="video">Edit</button></span>
                            </div>
                            <div class="card-box">
                                <?php if($video_url!=''){ ?>
                                    <div class="row">
                                        <div class="col-lg-8 offset-2">
                                            <?php echo $video_url ?>
                                        </div>
                                    </div>
                                <?php }else{ ?>
                                <div class="alert alert-warning">No video updated</div>
                                <?php } ?>
                            </div>
                        </div>


                    </div> <!-- container -->
                </div> <!-- content -->
            </div>
        <!-- ============================================================== -->
        <!-- Start right Content here -->
        <!-- ============================================================== -->
      
            <!-- Footer -->
            <footer class="footer">
             <?php echo $footer; ?>
            </footer>
            <!-- End Footer -->
        </div> <!-- End wrapper -->
    <?php echo $commonJs; ?>
    <script src="<?php echo base_url()?>ui/assets/plugins/summernote/dist/summernote.min.js"></script>
    <script src="<?php echo base_url(); ?>ui/assets/js/scripts/properties.js"></script>        
    </body>
</html>