<!DOCTYPE html>
<html>  
<head>
	<meta charset="utf-8">
	<meta name="viewport" content="width=device-width, initial-scale=1.0">
	<!-- App title -->
	<title><?php echo $title; ?></title>
  <?php echo $commonCss; ?>
</head>

   <body class="fixed-left">
	<div id="wrapper">      
		<?php echo $header_main; ?>                 

		<?php echo $header_menu; ?>
           
        <!-- End Navigation Bar-->
		
		   <!-- ============================================================== -->
        <!-- Start right Content here -->
        <!-- ============================================================== -->
            <div class="content-page">
                <!-- Start content -->
                <div class="content">
                    <div class="container-fluid">

                        <div class="row">
                            <div class="col-xl-12">
                                <div class="page-title-box">
                                    <h4 class="page-title float-left">Projects</h4>

                                    <ol class="breadcrumb float-right">
                                        <li class="breadcrumb-item"><a href="<?php echo base_url() ?>admin/dashboard">Home</a></li>
                                        <li class="breadcrumb-item active">Projects</li>
                                    </ol>

                                    <div class="clearfix"></div>
									<p>Here are the list of projects.</p>
									<div class="row">										
										<div class="col-sm-12">
											<button type="button" class="btn btn-success waves-effect waves-light btn-sm btn-addProject">
											 <span class="btn-label"><i class="fa fa-plus"></i> </span>Add New
											 </button>
										</div>
									</div>									
                                </div>
                            </div>
                        </div>
                        <!-- end row -->

						<div class="row">
                            <div class="col-12">
                                <div class="card-box adv_filter tblbox">
									<div class="card-body">
										<div class="row mb-4">
											<div class="col-sm-10 col-11">
									            <div class="input-group  pull-left" id="adv-search">
									                <input type="text" class="form-control refine_filter" id="product" data-type="search" placeholder="Search for any records..." />
									                <input type="hidden" name="page" id="pagenumber" data-type="page" data-id="page"  class="refine_filter" />
									                <div class="input-group-btn">
									                    <div class="btn-group" role="group">
									                        <div class="dropdown dropdown-lg">
									                            <button type="button" class="btn btn-default dropdown-toggle" data-toggle="dropdown" aria-expanded="false"><span class="caret"></span></button>
									                            <div class="dropdown-menu">
									                            	<form class="form-horizontal" role="form">
									                            		<div class="row">
										                                  	<div class="col-6 form-group">
										                                    	<label for="filter">Search by name</label>
										                                  		<input type="text" data-type="f_title" id="f_title" class="form-control refine_filter" placeholder="Enter project name...">
										                                  	</div>
										                                  	<div class="col-6 form-group">
										                                    	<label for="filter">Search by id</label>
										                                  		<input type="text" data-type="f_id" id="f_id" class="form-control refine_filter" placeholder="Enter project id...">
										                                  	</div>
										                                 </div>
									                                  	<div class="row">
										                                  	<div class="col-6 form-group">
										                                    	<label for="filter">Filter by category</label>
										                                  		<select data-type="f_category" id="f_category" class="form-control refine_filter">
										                                  			<option value="" data-type="f_category">All categories</option>
										                                  			<?php 
										                                  			if($categoryQ->num_rows()>0){
										                                  				foreach ($categoryQ->result() as $category) {
										                                  			?>
										                                  			<option value="<?php echo $category->id ?>" data-type="f_category"><?php echo $category->text ?></option>
										                                  			<?php } } ?>
										                                  		</select>
										                                  	</div>								                                  	
										                                  	<div class="col-6 form-group">
											                                    <label for="filter">Filter by Visibility</label>
											                                   	<select class="form-control refine_filter" data-type="f_status" id="f_status">
																					<option data-type="f_status" value="" selected>--All items--</option>
																					<option data-type="f_status" value="1">Visible</option>
																					<option data-type="f_status" value="0">Hidden</option>
																				</select>
										                                 	</div>
										                                </div>
									                                  	<div class="row">
									                                  	<div class="col-6 form-group">
											                                    <label for="filter">Sort by</label>
											                                  	<select class="form-control refine_filter" data-type="sortBy" id="sortBy">
																					<option data-type="sortBy" value="createdDesc">Newest First</option>
																					<option data-type="sortBy" value="createdAsc">Oldest First</option>
																					<option data-type="sortBy" value="updatedDate">Last Updated</option>
																				</select>
																			</div>
									                                  	<div class="col-6 form-group">
										                                    <label for="filter">Records per page</label>
										                                  	<select class="form-control refine_filter float-right" data-type="perpage" id="perpage">
																				<option data-type="perpage" value="10">10</option>
																				<option data-type="perpage" value="25">25</option>
																				<option data-type="perpage" value="50">50</option>
																				<option data-type="perpage" value="100">100</option>
																			</select>
																		</div>
																		</div>
										                            </form>
									                        	</div>
									                    	</div>
									                    	<button type="button" class="btn btn-primary filter"><span class="fa fa-search" aria-hidden="true"></span></button>
									                    </div>
									                </div>
									            </div>
									        </div>
									        <div class="col-sm-2 col-1">
												<a class="fullscreen-link float-right"><i class="fa fa-arrows-alt"></i></a>
											</div>
										</div>
										<div class="row">
											<div class="col-12">
												<div id="projectTbl"></div>
											</div>
										</div>
									</div>                                  
                                </div>
                            </div>
                        </div> <!-- end row -->




                    </div> <!-- container -->

                </div> <!-- content -->



            </div>

        <!-- ============================================================== -->
        <!-- Start right Content here -->
        <!-- ============================================================== -->
      
            <!-- Footer -->
            <footer class="footer">
             <?php echo $footer; ?>
            </footer>
            <!-- End Footer -->
        </div> <!-- End wrapper -->
    <?php echo $commonJs; ?>
    <script src="<?php echo base_url(); ?>ui/assets/js/scripts/projects.js"></script>        
    </body>
</html>