<?php 
    $feature_image='';
    $description='';
    if($propertyQ->num_rows()>0){
        foreach ($propertyQ->result() as $property_data) {
            $code=$property_data->code;
            $name=$property_data->name;
            $p_category=$property_data->p_category;
            $category=$property_data->category;
            $parent_category=$property_data->parent_category;
            $sub_category=$property_data->sub_category;

            $location=$property_data->location;
            $upload_dir=$property_data->upload_dir;
            $slug=$property_data->slug;
            $feature_image=$property_data->feature_image;
            $description=$property_data->description;
            $createdDate=$property_data->createdDate;
            $created_by=$property_data->created_by;
            $updatedDate=$property_data->updatedDate;
            $updated_by=$property_data->updated_by;
            $status=$property_data->status;
            $p_visibility=$property_data->p_visibility;

            $min_sba=$property_data->min_sba;
            $max_sba=$property_data->max_sba;
            $min_carpet=$property_data->min_carpet;
            $max_carpet=$property_data->max_carpet;
            $min_price=$property_data->min_price;
            $max_price=$property_data->max_price;
        }
    }
?>

<!DOCTYPE html>
<html>  
<head>
	<meta charset="utf-8">
	<meta name="viewport" content="width=device-width, initial-scale=1.0">
	<!-- App title -->
	<title><?php echo 'Edit Project | '.ucwords($name); ?></title>
    <link href="<?php echo base_url()?>ui/assets/plugins/summernote/dist/summernote.css" rel="stylesheet" />
    <link href="<?php echo base_url()?>ui/assets/plugins/select2/css/select2.min.css" rel="stylesheet" />
  <?php echo $commonCss; ?>
</head>

   <body class="fixed-left">
	<div id="wrapper">      
		<?php echo $header_main; ?>                 

		<?php echo $header_menu; ?>
           
        <!-- End Navigation Bar-->
		
		   <!-- ============================================================== -->
        <!-- Start right Content here -->
        <!-- ============================================================== -->
            <div class="content-page property-page" id="content_page">
                <!-- Start content -->
                <div class="content">
                    <div class="container-fluid">

                        <div class="row">
                            <div class="col-xl-12">
                                <div class="page-title-box">
                                    <h4 class="page-title float-left"><?php echo 'Edit '.ucwords($name).' Project' ?></h4>

                                    <ol class="breadcrumb float-right">
                                        <li class="breadcrumb-item"><a href="<?php echo base_url() ?>admin/dashboard">Home</a></li>
                                        <li class="breadcrumb-item"><a href="<?php echo base_url() ?>admin/projects">Projects</a></li>
                                        <li class="breadcrumb-item active">Edit</li>
                                        <li class="breadcrumb-item active"><?php echo ucwords($name); ?></li>
                                    </ol>

                                    <div class="clearfix"></div>
									<p>Here you can manage project details that will be displayed in website listing.</p>									
                                </div>
                            </div>
                        </div>
                        <!-- end row -->
                        
                        <div class="row">
                            <div class="col-lg-12 text-right">
                                <div class="form-group mb-4">
                                    <label class="ui-switch switch-icon mr-3 mb-0">
                                        <input type="checkbox" id="up_status" <?php if($p_visibility==1){ echo 'checked';} ?> name="status"><span></span>
                                    </label>Display in Listing
                                </div>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-lg-8">
                                <div class="card property-details">
                                    <div class="card-header">
                                        Project details
                                        <span><button type="button" class="btn btn-success btn-dataEdit" data-type="details">Edit</button></span>
                                    </div>
                                    <div class="card-box">
                                        <div class="row">
                                            <div class="col-lg-7 col-12">
                                                <ul class="list-unstyled mb-0">
                                                    <li><b>Name</b> - <?php echo $name ?></li>
                                                    <li><b>Category</b> - <?php echo $parent_category.'->'.$sub_category ?></li>
                                                    <li><b>Location</b> - <?php echo $location ?></li>
                                                    <li><b>Min SB Area</b> - <?php echo $min_sba ?> SQFT</li>
                                                    <li><b>Max SB Area</b> - <?php echo $max_sba ?> SQFT</li>
                                                    <li><b>Min Carpet Area</b> - <?php echo $min_carpet ?> SQFT</li>
                                                    <li><b>Max Carpet Area</b> - <?php echo $max_carpet ?> SQFT</li>
                                                    <li><b>Min Price</b> - Rs.<?php echo moneyFormat($min_price) ?></li>
                                                    <li><b>Max Price</b> - Rs.<?php echo moneyFormat($max_price) ?></li>
                                                </ul>                                        
                                            </div>
                                            <div class="col-lg-5 col-12">
                                                <ul class="list-unstyled">
                                                    <li><b>#ID</b> - <?php echo $code ?></li>
                                                    <li><b>Created</b> - <?php echo getMyDbDate('%d %M %Y %h:%i %A',$createdDate); ?></li>
                                                    <li><b>Created By</b> - <?php echo ucwords($created_by); ?></li>
                                                    <li><b>Last Updated</b> - <?php if($updatedDate!=''){ echo getMyDbDate('%d %M %Y %h:%i %A',$updatedDate);}else{ echo 'N/A';} ?></li>
                                                    <li><b>Updated By</b> - <?php if($updated_by!=''){echo ucwords($updated_by);}else{echo 'N/A';} ?></li>
                                                </ul>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="col-lg-4">
                                <div class="card feature-img-box">
                                    <div class="card-header">
                                        Featured Image
                                        <span><button type="button" class="btn btn-success btn-fimageEdit" data-type="f_image">Edit</button></span>
                                    </div>
                                    <div class="card-box">
                                        <?php if($feature_image!=''){ ?>
                                            <img src="<?php echo base_url().$upload_dir.$feature_image ?>" class="img-fluid">
                                        <?php }else{ ?>
                                        <div class="alert alert-warning">No image uploaded</div>
                                        <?php } ?>
                                    </div>
                                </div>
                            </div>
                            <div class="col-12">
                                <div class="card property-details">
                                    <div class="card-header">
                                        Description
                                        <span><button type="button" class="btn btn-success btn-dataEdit" data-type="description">Edit</button></span>
                                    </div>
                                    <div class="card-box">
                                        <?php if($description!=''){ echo $description; }else{ ?>
                                        <div class="alert alert-warning">No description content updated</div>
                                        <?php } ?>
                                    </div>
                                </div>
                            </div>
                        </div>    

                        <div class="card photos_box">
                            <div class="card-header">
                                Project Photos
                                <span><button type="button" class="btn btn-success btn-photosEdit" data-type="photos">Add New</button></span>
                            </div>
                            <div class="card-box">
                                <div id="photos_tbl">
                                    <div class="images-list">
                                        <div class="row">
                                            <?php 
                                                if($photosQ->num_rows()>0){
                                                    foreach ($photosQ->result() as $photos) {
                                            ?>
                                            <div class="col-lg-4 col-12">
                                                <div class="card">
                                                    <div class="card-box">
                                                        <img src="<?php echo base_url().$photos->folder.$photos->file_name ?>" class="img-fluid">
                                                    </div>
                                                    <div class="card-footer">
                                                        <span class="btn btn-info btn-fileInfo" data-id="<?php echo $photos->id ?>"><i class="fa fa-info-circle"></i> Details</span>
                                                        <span class="btn btn-danger btn-fileTrash" data-id="<?php echo $photos->id ?>"><i class="fa fa-trash"></i> Delete</span>
                                                    </div>
                                                </div>
                                            </div>
                                            <?php } }else{ ?>
                                                <div class="col-12">
                                                    <div class="alert alert-warning">No images uploaded</div>
                                                </div>
                                            <?php } ?>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>                                

                        <div class="card property-list">
                            <div class="card-header">
                                <div class="row">
                                    <div class="col-md-6 col-12">
                                        <div class="card-title">Properties tagged to this project</div>
                                    </div>
                                    <div class="col-md-6 col-12">
                                        <form id="add_tag_form" role="form">
                                            <div class="row">
                                                <div class="col-10">
                                                    <select class="form-control select2" name="property_id">
                                                        <option></option>
                                                        <?php
                                                        if($prlistQ->num_rows()>0){
                                                            foreach ($prlistQ->result() as $properties) {
                                                        ?>
                                                        <option value="<?php echo $properties->code ?>"><?php echo $properties->title.', '.$properties->location.' ('.$properties->code.')' ?></option>
                                                        <?php } } ?>
                                                    </select>
                                                </div>
                                                <div class="col-2">
                                                    <button type="submit" class="btn btn-primary">Add</button>
                                                </div>
                                            </div>
                                        </form>
                                    </div>
                                </div>
                            </div>
                            <div class="card-box">
                                <div id="p_tags_tbl"></div>
                            </div>
                        </div>

                    </div> <!-- container -->
                </div> <!-- content -->
            </div>
        <!-- ============================================================== -->
        <!-- Start right Content here -->
        <!-- ============================================================== -->
      
            <!-- Footer -->
            <footer class="footer">
             <?php echo $footer; ?>
            </footer>
            <!-- End Footer -->
        </div> <!-- End wrapper -->
    <?php echo $commonJs; ?>
    <script src="<?php echo base_url()?>ui/assets/plugins/summernote/dist/summernote-grid.min.js"></script>
    <script src="<?php echo base_url()?>ui/assets/plugins/summernote/dist/summernote.min.js"></script>
    <script src="<?php echo base_url()?>ui/assets/plugins/select2/js/select2.full.min.js"></script>
    <script src="<?php echo base_url(); ?>ui/assets/js/scripts/projects.js"></script>        
    </body>
</html>