<!DOCTYPE html>
<html>  
<head>
	<meta charset="utf-8">
	<meta name="viewport" content="width=device-width, initial-scale=1.0">
	<!-- App title -->
	<title><?php echo $title; ?></title>
    <link href="<?php echo base_url()?>ui/assets/plugins/select2/css/select2.min.css" rel="stylesheet" />
  <?php echo $commonCss; ?>
</head>

   <body class="fixed-left">
	<div id="wrapper">      
		<?php echo $header_main; ?>                 

		<?php echo $header_menu; ?>
           
        <!-- End Navigation Bar-->
		
		   <!-- ============================================================== -->
        <!-- Start right Content here -->
        <!-- ============================================================== -->
            <div class="content-page feature-page">
                <!-- Start content -->
                <div class="content">
                    <div class="container-fluid">

                        <div class="row">
                            <div class="col-xl-12">
                                <div class="page-title-box">
                                    <h4 class="page-title float-left">Featured Projects</h4>

                                    <ol class="breadcrumb float-right">
                                        <li class="breadcrumb-item"><a href="<?php echo base_url() ?>admin/dashboard">Home</a></li>
                                        <li class="breadcrumb-item active">Featured</li>
                                        <li class="breadcrumb-item active">Projects</li>
                                    </ol>

                                    <div class="clearfix"></div>
									<p>Here are the list of projects that will be displayed as featured items.</p>
                                </div>
                            </div>
                        </div>
                        <!-- end row -->

						<div class="row">
                            <div class="col-12">
                                <div class="card-box adv_filter tblbox">
									<div class="card-body">
										<div class="row mb-4">
											<div class="col-sm-6 col-11">
									            <div class="input-group  pull-left" id="adv-search">
									                <input type="text" class="form-control refine_filter" id="product" data-type="search" placeholder="Search for any records..." />
									                <input type="hidden" name="page" id="pagenumber" data-type="page" data-id="page"  class="refine_filter" />
									                <div class="input-group-btn">
									                    <div class="btn-group" role="group">
									                        <div class="dropdown dropdown-lg">
									                            <button type="button" class="btn btn-default dropdown-toggle" data-toggle="dropdown" aria-expanded="false"><span class="caret"></span></button>
									                            <div class="dropdown-menu">
									                            	<form class="form-horizontal" role="form">
									                            		<div class="row">
										                                  	<div class="col-6 form-group">
										                                    	<label for="filter">Search by title</label>
										                                  		<input type="text" data-type="f_title" id="f_title" class="form-control refine_filter" placeholder="Enter project name...">
										                                  	</div>
										                                  	<div class="col-6 form-group">
										                                    	<label for="filter">Search by id</label>
										                                  		<input type="text" data-type="f_id" id="f_id" class="form-control refine_filter" placeholder="Enter project id...">
										                                  	</div>
										                                 </div>
									                                  	<div class="row">
									                                  	<div class="col-6 form-group">
											                                    <label for="filter">Sort by</label>
											                                  	<select class="form-control refine_filter" data-type="sortBy" id="sortBy">
																					<option data-type="sortBy" value="createdDesc">Newest First</option>
																					<option data-type="sortBy" value="createdAsc">Oldest First</option>
																					<option data-type="sortBy" value="updatedDate">Last Updated</option>
																				</select>
																			</div>
									                                  	<div class="col-6 form-group">
										                                    <label for="filter">Records per page</label>
										                                  	<select class="form-control refine_filter float-right" data-type="perpage" id="perpage">
																				<option data-type="perpage" value="10">10</option>
																				<option data-type="perpage" value="25">25</option>
																				<option data-type="perpage" value="50">50</option>
																				<option data-type="perpage" value="100">100</option>
																			</select>
																		</div>
																		</div>
										                            </form>
									                        	</div>
									                    	</div>
									                    	<button type="button" class="btn btn-primary filter"><span class="fa fa-search" aria-hidden="true"></span></button>
									                    </div>
									                </div>
									            </div>
									        </div>
									        <div class="col-md-5 col-12">
		                                        <form id="add_feature_form" role="form">
		                                            <div class="row">
		                                                <div class="col-10 pr-0">
		                                                    <select class="form-control select2" name="project_id">
		                                                        <option></option>
		                                                        <?php
		                                                            if($pr_listQ->num_rows()>0){
		                                                            foreach ($pr_listQ->result() as $pr_lists) {
		                                                        ?>
		                                                        <option value="<?php echo $pr_lists->code ?>"><?php echo $pr_lists->name.', '.$pr_lists->location.' ('.$pr_lists->code.')' ?></option>
		                                                        <?php
		                                                            }
		                                                        }
		                                                        ?>
		                                                    </select>
		                                                </div>
		                                                <div class="col-2 pl-0">
		                                                    <button type="submit" class="btn btn-primary">Add</button>
		                                                </div>
		                                            </div>
		                                        </form>
		                                    </div>
									        <div class="col-sm-1 col-1">
												<a class="fullscreen-link float-right"><i class="fa fa-arrows-alt"></i></a>
											</div>
										</div>
										<div class="row">
											<div class="col-12">
												<div id="projectTbl"></div>
											</div>
										</div>
									</div>                                  
                                </div>
                            </div>
                        </div> <!-- end row -->




                    </div> <!-- container -->

                </div> <!-- content -->



            </div>

        <!-- ============================================================== -->
        <!-- Start right Content here -->
        <!-- ============================================================== -->
      
            <!-- Footer -->
            <footer class="footer">
             <?php echo $footer; ?>
            </footer>
            <!-- End Footer -->
        </div> <!-- End wrapper -->
    <?php echo $commonJs; ?>
    <script src="<?php echo base_url()?>ui/assets/plugins/select2/js/select2.full.min.js"></script>
    <script src="<?php echo base_url(); ?>ui/assets/js/scripts/featured.js"></script>        
    </body>
</html>