<!DOCTYPE html>
<html>  
<head>
	<meta charset="utf-8">
	<meta name="viewport" content="width=device-width, initial-scale=1.0">
	<!-- App title -->
	<title><?php echo $title; ?></title>
  	<?php echo $commonCss; ?>
</head>

   <body class="fixed-left">
	<div id="wrapper">      
		<?php echo $header_main; ?>                 

		<?php echo $header_menu; ?>
           
        <!-- End Navigation Bar-->
		
		   <!-- ============================================================== -->
        <!-- Start right Content here -->
        <!-- ============================================================== -->
		<div class="content-page">
			<!-- Start content -->
			<div class="content dashboard-content" id="dashboard_stats">
				<div class="container-fluid">
					<!-- Page-Title -->
					<div class="row">
						<div class="col-xl-12">
							<div class="page-title-box">
								<h4 class="page-title float-left">Dashboard</h4>

								<ol class="breadcrumb float-right">
									<li class="breadcrumb-item"><a href="javascript:;">Home</a></li>
									<li class="breadcrumb-item active">Dashboard</li>
								</ol>

								<div class="clearfix"></div>
                                <p class="text-muted font-13 card-caption">Displaying all the system statistics </p>
							</div>
						</div>
					</div>

					<div class="row">
                        <div class="col-sm-12 col-12 stats-box">
                       		<div class="card-box mycardbox logbox">
                       			<div class="card-head">
	                                <h4 class="header-title m-t-0">Activity Log</h4>
	                                <div class="card-tools">	                                    
	                                    <a class="card-collapse"><i class="fa fa-angle-down"></i></a>
                                    	<a class="dropdown-toggle" data-toggle="dropdown"><i class="fa fa-ellipsis-h"></i></a>
	                                    <div class="dropdown-menu dropdown-menu-right">
		                                    <a class="dropdown-item fullscreen-link"><i class="fa fa-arrows-alt"></i> Fullscreen</a>
	                                    	<a class="dropdown-item card-remove"><i class="fa fa-close"></i> Remove</a>
	                                    </div>
	                                </div>
	                            </div>
                                <p class="text-muted font-13 card-caption">Latest system activity logs </p>
                                <div class="card-body">
		                            <div class="inbox-widget nicescroll jobcard_details">
		                                
		                            	<?php 
											if($logTblQ->num_rows()>0){
												echo '<ul class="timeline scroller">';
												foreach ($logTblQ->result() as $rowlog){
										?>
		                                    <li class="timeline-item">
		                                        <span class="timeline-point bg-primary"></span>
		                                        <?php
		                                        if($rowlog->uname==get_a_username())
		                                        	{ 
		                                        		$logmsg='<strong>You</strong> '.$rowlog->description;
		                                        	}
		                                        	else{
		                                        		$logmsg='<strong>'.ucfirst($rowlog->uname).'</strong> '.$rowlog->description;
		                                        	}
		                                        ?>
		                                        <span><?php echo $logmsg ?></span>
		                                        <small class="float-right text-muted ml-2 nowrap"><?php echo humanTiming(strtotime($rowlog->createdDate)).' ago'; ?></small>
		                                    </li>
		                                <?php } echo "</ul>"; }else{ ?>
		                                	<p class="text-center">No records found...</p>
		                                <?php } ?>
		                            </div>
		                        </div>
                        	</div>
                        </div>
					</div>
                <!-- end row -->
            </div> <!-- container -->		           
		</div>
	</div>

<!-- ============================================================== -->
<!-- Start right Content here -->
<!-- ============================================================== -->

<!-- Footer -->
<footer class="footer">
 <?php echo $footer; ?>
</footer>
<!-- End Footer -->
</div>
<!-- End wrapper -->
<?php echo $commonJs; ?>
</body>
</html>