<!DOCTYPE html>
<head>
   <title><?php echo $title ?></title>
   <meta charset="utf-8">
   <meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1">
   <?php echo $common_css ?>
</head>
<body>

 <!--preloader start-->
 <div id="preloader">
        <div class="loader1">
            <span></span>
            <span></span>
            <span></span>
            <span></span>
            <span></span>
        </div>
    </div>
    <!--preloader end-->

<!-- Main header start -->
<?php echo $header_main ?>
<!-- Main header end -->


<div class="main">

<!--page header section start-->
<section class="" style="background: url('<?php echo base_url(); ?>ui/frontend/images/bg.png')no-repeat center center / cover">
    <div class="section-lg bg-gradient-primary text-white section-header">
        <div class="container">
            <div class="row justify-content-center bread-crumb-position">
                <div class="col-md-8 col-lg-7">
                    <div class="page-header-content text-center">
                        <h1>About Us</h1>
                        <nav aria-label="breadcrumb" class="d-flex justify-content-center">
                            <ol class="breadcrumb breadcrumb-transparent breadcrumb-text-light">
                                <li class="breadcrumb-item"><a href="<?php echo base_url(); ?>">Home</a></li>
                                <li class="breadcrumb-item active" aria-current="page">About Us</li>
                            </ol>
                        </nav>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>
<!--page header section end-->

<!--work process section start-->
<section class="section section-lg  ">
    <div class="container">
        <div class="row justify-content-center">
            <div class="col-md-12">
                <div class="section-heading mb-3">
                    <h2>About Us</h2>
                </div>
            </div>
        </div>
        <div class="row row-reverse">
                <div class="col-md-12">
                    <h5>Our Story</h5>
                    <p class=" text-black"><strong>In 2010, a team of professionals from the legal, academic, accounting, and information technology fields came together with a vision to provide professional and value-added services to the business community in India.</strong> </p>
                    <ul>
                        <li>Recognizing the inadequate legal services for corporate India, especially in the field of Human Resource Development, we set out on a journey to fill this gap. </li>
                        <li>We understood the challenges faced by businesses in hiring workforces across various industries and the risks associated with making wrong hires. </li>
                        <li>We envisioned a solution— court record verification— and invested in building a network of legal professionals across the country to provide reliable and compliant verification services.</li>
                    </ul>


                    <h5>Mission and Vision </h5>
                    <ul>
                        <li>Enabling Informed Decision is our Mission</li>
                        <li>DHI stands for excellence practices across stakeholders towards achieving Fine Structured Constant is our vision</li>
                        <li>Our mission is to provide deft and reliable verification services that mitigate corporate risks while considering the interests of job seekers. </li>
                        <li>We strive to deliver professional, timely, and auditable verification solutions that meet international compliance standards and address the specific needs of our clients.</li>
                    </ul>

                    <h5>Our Team</h5>
                    <ul>
                        <li>We have a dedicated team of professionals who are passionate about what they do. With expertise in law, technology, and business processes, our team ensures the highest quality of service delivery. </li>
                        <li>We believe in continuous learning and improvement, enabling us to stay at the forefront of our industry and meet the evolving needs of our clients.</li>
                    </ul>

                    <h5>Milestones</h5>
                    <ul>
                        <li>Since our inception, we have achieved significant milestones. What started as 300 verifications per month in 2011 has now grown to over 3000 verifications per day, with an impressive turnaround time of 97-99%.</li>
                        <li>We have reinvested a substantial part of our revenues into research and development, enabling us to enhance our software, improve our business processes, and provide value-added services. </li>
                        <li>We are proud to be an ISO 9001 and ISO 27001 certified company, and a member of NASCOMM.</li>
                    </ul>

                </div>
                
                
               
                
               
                
            </div>
    </div>
</section>
<!--work process section end-->

<!--about section start-->
<section class="section section-lg bg-primary vision-mission">
    <div class="container">
        <div class="row">
            <div class="col-md-12 col-lg-12 mb-5">
                <div class="feature-tabs-wrap">
                    <div class="tab-content feature-tab-content">
                        <div class="tab-pane active" id="feature-tab-3">
                            <div class="row">
                                <div class="col-md-6 col-lg-6">
                                    <!-- Icon box -->
                                    <div class="icon-box text-center p-5 border border-variant-soft bg-white rounded-custom">
                                        <div class="card-icon mb-4">
                                            <img src="<?php echo base_url(); ?>ui/frontend/img/icon/icon-2.svg" alt="icon" width="60" class="img-fluid">
                                        </div>
                                        <h2 class="h5">Our Ability</h2>
                                        <p class="mb-0">What started 300 verifications per month in 2011 has become over 3000 verification per day with 97-99% Turnaround time accomplishment and reduced quality penalties. This speaks volumes about our resolve and commitment.</p>
                                    </div>
                                    <!-- End of Icon box -->
                                </div>
                                <div class="col-md-6 col-lg-6">
                                    <!-- Icon box -->
                                    <div class="icon-box text-center p-5 border border-variant-soft bg-white rounded-custom">
                                        <div class="card-icon mb-4">
                                            <img src="<?php echo base_url(); ?>ui/frontend/img/icon/icon-1.svg" alt="icon" width="60" class="img-fluid">
                                        </div>
                                        <h2 class="h5">Our Philosophy</h2>
                                        <p class="mb-0">We understand that our services should not only address at mitigating corporate risks, it should not come at the cost of the candidate seeking employment either. Our employees are made to understand that their every delivery impacts the entirety, in the cob web of life.</p>
                                    </div>
                                    <!-- End of Icon box -->
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-md-12">
                <p class="lead text-white">
                    DHI has continued to reinvest major part of its revenues in R&D of solutions be it in software, business plan, process improvements for providing value added services and timely delivery. We are now an ISO 2001 and ISO 27001 certified company with NASCOMM membership.
                </p>
            </div>
        </div>
    </div>
</section>
<!--about section end-->

<!--about section start-->
<section class="section section-lg bg-soft">
    <div class="container">
        <div class="row justify-content-center">
            <div class="col-md-9 col-lg-8">
                <div class="section-heading text-center">
                    <h2>These last 10 years we have grown and sustained in this ever-demanding business due to the following accomplishments and strengths:</h2>
                </div>
            </div>
        </div>
        <div class="row">
            <div class="col-md-12 col-lg-12">
                <div class="feature-tabs-wrap">
                    <div class="tab-content feature-tab-content">
                        <div class="tab-pane about_tab active" id="feature-tab-2">
                            <div class="row">
                                <div class="col-12 col-lg-6 col-md-6 col-sm-6 mb-4">
                                    <div class="services-single d-flex p-5 border border-variant-soft bg-white rounded-custom">
                                        <div class="services-content-wrap text-left">
                                            <h3 class="h6">Developing custom software solutions or processes as per service demands</h3>
                                            <p>Resulting in reliable and timely delivery of services</p>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-12 col-lg-6 col-md-6 col-sm-6 mb-4">
                                    <div class="services-single d-flex p-5 border border-variant-soft bg-white rounded-custom">
                                        <div class="services-content-wrap text-left">
                                            <h3 class="h6">Over one million plus cases of verification in a year, consistently for the last 3 years</h3>
                                            <p>Volumes are good problems to us and our customers, we understand its value</p>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-12 col-lg-6 col-md-6 col-sm-6 mb-4">
                                    <div class="services-single d-flex p-5 border border-variant-soft bg-white rounded-custom">
                                        <div class="services-content-wrap text-left">
                                            <h3 class="h6">Believing in Technology enabled services</h3>
                                            <p>Provides accuracy, speed and possibility of e-services (through API)</p>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-12 col-lg-6 col-md-6 col-sm-6 mb-4">
                                    <div class="services-single d-flex p-5 border border-variant-soft bg-white rounded-custom">
                                        <div class="services-content-wrap text-left">
                                            <h3 class="h6">80+ work force</h3>
                                            <p>Team DHI believes that the company belongs to them</p>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-12 col-lg-6 col-md-6 col-sm-6 mb-4">
                                    <div class="services-single d-flex p-5 border border-variant-soft bg-white rounded-custom">
                                        <div class="services-content-wrap text-left">
                                            <h3 class="h6">Developing team of Subject Matter Expertise across our services offerings</h3>
                                            <p>Technology is only a facilitator at most times, Human abilities is always niche.</p>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-12 col-lg-6 col-md-6 col-sm-6 mb-4">
                                    <div class="services-single d-flex p-5 border border-variant-soft bg-white rounded-custom">
                                        <div class="services-content-wrap text-left">
                                            <h3 class="h6">200+ Network of Consulting Partners</h3>
                                            <p>Network of Legal Fraternity, Field consultants and Consultants with Subject Matter expertise provides one-stop solution to customers</p>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-12 col-lg-6 col-md-6 col-sm-6 mb-4">
                                    <div class="services-single d-flex p-5 border border-variant-soft bg-white rounded-custom">
                                        <div class="services-content-wrap text-left">
                                            <h3 class="h6">Treating both Employee and Customers as Clients</h3>
                                            <p>Resulting in highest customer and employee retention</p>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-12 col-lg-6 col-md-6 col-sm-6 mb-4">
                                    <div class="services-single d-flex p-5 border border-variant-soft bg-white rounded-custom">
                                        <div class="services-content-wrap text-left">
                                            <h3 class="h6">Deft handling of Issue</h3>
                                            <p>Solutions to address cause and not symptom</p>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-12 col-lg-6 col-md-6 col-sm-6 mb-4">
                                    <div class="services-single d-flex p-5 border border-variant-soft bg-white rounded-custom">
                                        <div class="services-content-wrap text-left">
                                            <h3 class="h6">Adhere to Process, Standards and Compliance</h3>
                                            <p>Organization thrives in all fronts, only by complying to standards</p>
                                            <p>Annual audits across customers have resulted in highly compliant work atmosphere.</p>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-12 col-lg-6 col-md-6 col-sm-6 mb-4">
                                    <div class="services-single d-flex p-5 border border-variant-soft bg-white rounded-custom">
                                        <div class="services-content-wrap text-left">
                                            <h3 class="h6">NASCOMM registered company with ISO 9001 and ISO 27001 compliance</h3>
                                            <p>Makes us reliable, information secure and be part of conducive business environment</p>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>
<!--about section end-->

<?php echo $common_testimonial ?>

<!-- <?php //echo $common_team ?> -->

<?php echo $common_cat ?>

<?php echo $common_clients ?>


</div>

<!-- Footer start -->
<?php echo $footer ?>
<!-- Footer end -->



<?php echo $common_js ?>
</body>
</html>
