<?php
class Listing_model extends CI_Model{

	public function filter_listings($filter_data,$item,$page)
	{
		$sqlOrderBY='';
		$sql = "SELECT p.*,pd.feature_image,
				sc.text as parent_category,sc.slug as parent_catslug,c.text as sub_category,c.slug as sub_catslug
				FROM properties p
				INNER JOIN property_details pd
				ON p.code=pd.propertyId
				LEFT JOIN categories sc
				ON p.p_category=sc.id
				LEFT JOIN categories c
				ON p.category=c.id
				WHERE (p.p_visibility=1  AND p.ptype=0 ";

		if(!empty($filter_data)){
			foreach ($filter_data as $k => $v) {
	            if(($v['type']=='search')&&($v['value']!="")){
			 			$value = $v['value'];
	                    $sql .= " ) AND (p.org_name like '%" . $value . "%' or p.slug like '%" . $value . "%' or p.title like '%" . $value . "%' or sc.name like '%" . $value . "%' or sc.slug like '%" . $value . "%' or p.location like '%" . $value . "%'";
				}
				if(($v['type']=='ptype')&&($v['value']!="")&&($v['value']!='all')){
					$value = $v['value'];
	                $sql .= " ) AND (sc.slug like '%" . $value . "%'";
				}
				if(($v['type']=='category')&&($v['value']!="")&&($v['value']!='all')){
					$value = $v['value'];
	                $sql .= " ) AND (c.slug like '%" . $value . "%'";
				}
				if(($v['type']=='location')&&($v['value']!="")&&($v['value']!='all')){
			 			$value = $v['value'];
	                    $sql .= " ) AND (p.location like '%".$value."%'";
				}
				if(($v['type']=='bedroom')&&($v['value']!="")&&($v['value']!='all')){
					$value = $v['value'];
	                $sql .= " ) AND (p.beds='".$value."'";
				}
				if(($v['type']=='bathroom')&&($v['value']!="")&&($v['value']!='all')){
					$value = $v['value'];
	                $sql .= " ) AND (p.bathrooms='".$value."'";
				}
				if(($v['type']=='balcony')&&($v['value']!="")&&($v['value']!='all')){
					$value = $v['value'];
	                $sql .= " ) AND (p.balcony='".$value."'";
				}
				if(($v['type']=='garage')&&($v['value']!="")&&($v['value']!='all')){
					$value = $v['value'];
	                $sql .= " ) AND (p.garage='".$value."'";
				}
				if(($v['type']=='min-area')&&($v['value']!="")&&($v['value']>0)){
					$value = $v['value'];
	                $sql .= " ) AND (p.tot_sqft>='".$value."'";
				}
				if(($v['type']=='max-area')&&($v['value']!="")&&($v['value']>0)){
					$value = $v['value'];
	                $sql .= " ) AND (p.tot_sqft<='".$value."'";
				}
				if(($v['type']=='min-price')&&($v['value']!="")&&($v['value']>0)){
					$value = $v['value'];
	                $sql .= " ) AND (p.price>='".$value."'";
				}
				if(($v['type']=='max-price')&&($v['value']!="")&&($v['value']>0)){
					$value = $v['value'];
	                $sql .= " ) AND (p.price<='".$value."'";
				}
				if (($v['type']== 'sort')&&($v['value']!="")) {
	                $value = $v['value'];
	                if ($value == "default") {
	                    $sqlOrderBY = " ORDER BY p.createdDate DESC ";
	                }else if ($value == "low-to-high") {
	                    $sqlOrderBY = " ORDER BY p.price ASC ";
	                }else if ($value == "high-to-low") {
	                    $sqlOrderBY = " ORDER BY p.price DESC ";
	                }else if ($value == "newest") {
	                    $sqlOrderBY = " ORDER BY p.createdDate DESC ";
	                }else if ($value == "oldest") {
	                    $sqlOrderBY = " ORDER BY p.createdDate ASC ";
	                }else {
	                    $sqlOrderBY = " ORDER BY p.createdDate DESC ";
	                }
	            }
			}
		}
		$sql.=")  GROUP BY p.propertyId";

		if($sqlOrderBY==''){
			$sqlOrderBY=' ORDER BY p.createdDate DESC ';
		}
			
		if(($item==0) &&($page==0)){
			$sql.=$sqlOrderBY;
			//print_r($sql);
	        $query = $this->db->query($sql);
	        return $query->num_rows();
		}
		else{
			$sql .= $sqlOrderBY." limit $page,$item";
			$query=$this->db->query($sql);
			return $query;
		}
	}

	function paginate_function($item_per_page, $current_page, $total_records, $total_pages) {
		
		 $pagination = '';
		 if ($total_pages > 0 && $total_pages != 1 && $current_page <= $total_pages) { //verify total pages and current page number
		 $pagination .= '<ul class="pagination">';

		 $right_links = $current_page + 3;
		 $previous = $current_page - 3; //previous link 
		 $next_link = $current_page + 1; //next link
		 $previous_link = $current_page - 1;
		 $first_link = true; //boolean var to decide our first link

		 if($current_page > 1){
			//$previous_link = ($previous==0)?1:$previous;
			$pagination .= '<li class="page-item first"><a class="page-link" href="javascript:;" data-page="1" title="First">&laquo;</a></li>'; //first link
			$pagination .= '<li class="page-item"><a class="page-link" href="javascript:;"" data-page="' . $previous_link . '" title="Previous">&lt;</a></li>'; //previous link
			for($i = ($current_page - 2); $i < $current_page; $i++){ //Create left-hand side links
				if($i > 0){
				 	$pagination .= '<li class="page-item"><a class="page-link" href="javascript:;" data-page="' . $i . '" title="Page ' . $i . '">' . $i . '</a></li>';
				}
			}
			$first_link = false; //set first link to false
		 }

		if($first_link){ //if current active page is first link
			$pagination .= '<li class="page-item first active"><a class="page-link" href="javascript:;">' . $current_page . '</a></li>';
		}else if ($current_page == $total_pages) { //if it's the last active link
			$pagination .= '<li class="page-item last active"><a class="page-link" href="javascript:;">' . $current_page . '</a></li>';
		}else{ //regular current link
			$pagination .= '<li class="page-item active"><a class="page-link" href="javascript:;">' . $current_page . '</a></li>';
		}

		for($i = $current_page + 1; $i < $right_links; $i++){ //create right-hand side links
			if ($i <= $total_pages) {
		 		$pagination .= '<li class="page-item"><a class="page-link" href="javascript:;" data-page="' . $i . '" title="Page ' . $i . '">' . $i . '</a></li>';
		 	}
		}
		if($current_page < $total_pages){
		 	//$next_link = ($i > $total_pages)? $total_pages : $i;
			$pagination .= '<li class="page-item"><a class="page-link" href="javascript:;" data-page="' . $next_link . '" title="Next">&gt;</a></li>'; //next link
		 	$pagination .= '<li class="page-item last"><a class="page-link" href="javascript:;" data-page="' . $total_pages . '" title="Last">&raquo;</a></li>'; //last link
		}
			$pagination .= '</ul>';
		}
		return $pagination; //return pagination links
	}

	function get_list_by_slug($slug){
		$sql = "SELECT p.*,pd.*, sc.text as parent_category, c.text as sub_category
				FROM properties p
				INNER JOIN property_details pd
				ON p.code=pd.propertyId
				LEFT JOIN categories sc
				ON p.p_category=sc.id
				LEFT JOIN categories c
				ON p.category=c.id
				WHERE p.p_visibility=1 AND p.slug='$slug'";
		$query=$this->db->query($sql);
		return $query;
	}

	function get_categories_by_parent($parent){
		$sql = "SELECT c.text,c.slug
				FROM categories c
				LEFT JOIN categories pc
				ON pc.id=c.parent
				WHERE pc.slug='$parent'";
		$query=$this->db->query($sql);
		return $query;
	}

	function get_latest_properties($limit,$propertyId=''){
		$sql = "SELECT p.*,pd.feature_image 
				FROM properties p
				INNER JOIN property_details pd
				ON p.code=pd.propertyId
				WHERE p.p_visibility=1 AND p.ptype=0";
		if($propertyId!=''){
			$sql.= " AND p.code!='$propertyId'";
		}
		$sql.= "	ORDER BY p.createdDate DESC LIMIT $limit";
		$query=$this->db->query($sql);
		return $query;
	}
	
	function get_filter_ranges(){
		$sql = "SELECT MIN(p.price) as min_price, MAX(p.price) as max_price,
				MIN(p.tot_sqft) as min_area, MAX(p.tot_sqft) as max_area
				FROM properties p WHERE p.p_visibility=1  AND p.ptype=0";
		$query=$this->db->query($sql);
		return $query;
	}

	function get_category_counts(){
		$sql = "SELECT c.text,count(*) as count				
				FROM categories c
				LEFT JOIN properties p
				ON p.category=c.id
				LEFT JOIN categories sc
				ON c.id=sc.id
				WHERE p_visibility=1";
		$query=$this->db->query($sql);
		return $query;
	}

	function get_similar_properties($data){
		$category=$data['category'];
		$p_category=$data['p_category'];
		$location=$data['location'];
		$location=$data['location'];
		$propertyId=$data['propertyId'];
		$sql = "SELECT p.*,pd.feature_image 
				FROM properties p
				INNER JOIN property_details pd
				ON p.code=pd.propertyId
				WHERE p.p_visibility=1 AND p.code!='$propertyId' AND p.ptype=1
				AND (p.category='$category' OR p.p_category='$p_category' OR p.location like '%$location%')";
		$query=$this->db->query($sql);
		return $query;
	}



	//projects

	public function filter_projects($filter_data,$item,$page)
	{
		$sqlOrderBY='';
		$sql = "SELECT p.*,
				sc.text as parent_category,sc.slug as parent_catslug,c.text as sub_category,c.slug as sub_catslug
				FROM projects p
				LEFT JOIN categories sc
				ON p.p_category=sc.id
				LEFT JOIN categories c
				ON p.category=c.id
				WHERE (p.p_visibility=1 ";

		if(!empty($filter_data)){
			foreach ($filter_data as $k => $v) {
	            if(($v['type']=='search')&&($v['value']!="")){
			 			$value = $v['value'];
	                    $sql .= " ) AND (p.name like '%" . $value . "%' or p.slug like '%" . $value . "%' or p.location like '%" . $value . "%'";
				}
				if(($v['type']=='ptype')&&($v['value']!="")&&($v['value']!='all')){
					$value = $v['value'];
	                $sql .= " ) AND (sc.slug like '%" . $value . "%'";
				}
				if(($v['type']=='category')&&($v['value']!="")&&($v['value']!='all')){
					$value = $v['value'];
	                $sql .= " ) AND (c.slug like '%" . $value . "%'";
				}
				if(($v['type']=='location')&&($v['value']!="")&&($v['value']!='all')){
			 			$value = $v['value'];
	                    $sql .= " ) AND (p.location like '%".$value."%'";
				}
				if (($v['type']== 'sort')&&($v['value']!="")) {
	                $value = $v['value'];
	                if ($value == "default") {
	                    $sqlOrderBY = " ORDER BY p.createdDate DESC ";
	                }else if ($value == "newest") {
	                    $sqlOrderBY = " ORDER BY p.createdDate DESC ";
	                }else if ($value == "oldest") {
	                    $sqlOrderBY = " ORDER BY p.createdDate ASC ";
	                }else {
	                    $sqlOrderBY = " ORDER BY p.createdDate DESC ";
	                }
	            }
			}
		}
		$sql.=")  GROUP BY p.projectId";

		if($sqlOrderBY==''){
			$sqlOrderBY=' ORDER BY p.createdDate DESC ';
		}
			
		if(($item==0) &&($page==0)){
			$sql.=$sqlOrderBY;
			//print_r($sql);
	        $query = $this->db->query($sql);
	        return $query->num_rows();
		}
		else{
			$sql .= $sqlOrderBY." limit $page,$item";
			$query=$this->db->query($sql);
			return $query;
		}
	}

	function get_project_by_slug($slug){
		$sql = "SELECT p.*, sc.text as parent_category, c.text as sub_category
				FROM projects p
				LEFT JOIN categories sc
				ON p.p_category=sc.id
				LEFT JOIN categories c
				ON p.category=c.id
				WHERE p.p_visibility=1 AND p.slug='$slug'";
		$query=$this->db->query($sql);
		return $query;
	}
	
	function get_similar_projects($data){
		$category=$data['category'];
		$p_category=$data['p_category'];
		$location=$data['location'];
		$projectId=$data['projectId'];
		$sql = "SELECT p.*
				FROM projects p
				WHERE p.p_visibility=1 AND p.projectId!='$projectId' 
				AND (p.category='$category' OR p.p_category='$p_category' OR p.location like '%$location%')";
		$query=$this->db->query($sql);
		return $query;
	}

	function get_latest_projects($limit,$projectId=''){
		$sql = "SELECT p.* 
				FROM projects p
				WHERE p.p_visibility=1 ";
		if($projectId!=''){
			$sql.= " AND p.projectId!='$projectId'";
		}
		$sql.= "	ORDER BY p.createdDate DESC LIMIT $limit";
		$query=$this->db->query($sql);
		return $query;
	}

	function get_tagged_properties($tag_id,$tag_type){
		$sql = "SELECT p.*,pd.feature_image 
				FROM properties p
				INNER JOIN property_details pd
				ON p.code=pd.propertyId
				INNER JOIN property_tags pt
				ON pt.propertyId=p.code
				WHERE p.p_visibility=1 AND p.ptype=1
				AND pt.tag_id='$tag_id' OR pt.tag_type='$tag_type'";
		$query=$this->db->query($sql);
		return $query;
	}

	function get_project_ranges(){
		$sql = "SELECT MIN(p.min_price) as min_price, MAX(p.max_price) as max_price,
				MIN(p.min_sba) as min_area, MAX(p.min_sba) as max_area
				FROM projects p WHERE p.p_visibility=1";
		$query=$this->db->query($sql);
		return $query;
	}

}