<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class GoogleAnalytics {

  

    public function __construct() {
        require_once 'google-api-php-client/vendor/autoload.php';
   

     
    }

   
    public function get_total($type = 'users') {
        if ($this->access_token_ready) {
            $analytics = new Google_AnalyticsService($this->client);
            try {

                $optParams = array(
                    'max-results' => '100');
                $results = $analytics->data_ga->get('ga:' . $this->ga_api_profileId, '2015-02-18', '2016-01-15', 'ga:' . $type, $optParams);

                $ga_total = 0;
                if (count($results->getRows()) > 0) {
                    foreach ($results->getRows() as $row) {
                        foreach ($row as $cell) {
                            $ga_total = $cell;
                        }
                    }
                } else {
                    return 0;
                }
                return $ga_total;
            } catch (Exception $ex) {
                $error = $ex->getMessage();
                die($error);
            }
        }
    }

    /**
     * 
     * @param type $dimension Type of dimension to filter {browser,browserVersion,operatingSystem,operatingSystemVersion,isMobile,isTablet,mobileDeviceBranding,mobileDeviceModel,mobileInputSelector,mobileDeviceInfo,mobileDeviceMarketingName,deviceCategory}
     * @param type $type Type of result {users,newUsers,percentNewSessions,sessions,bounces}
     * https://developers.google.com/analytics/devguides/reporting/core/dimsmets
     */
    public function get_dimensions($dimension = 'browser', $type = 'users') {
        if ($this->access_token_ready) {
            $analytics = new Google_AnalyticsService($this->client);
            try {
                $optParams = array(
                    'dimensions' => 'ga:' . $dimension,
                    'max-results' => '100');
                $results = $analytics->data_ga->get('ga:' . $this->ga_api_profileId, '2015-02-18', '2016-01-15', 'ga:' . $type, $optParams);

                $ga_dimension = array();
                if (count($results->getRows()) > 0) {
                    foreach ($results->getRows() as $row) {
                        $ga_dimension[$row[0]] = $row[1];
                    }
                } else {
                    return NULL;
                }
                return $ga_dimension;
            } catch (Exception $ex) {
                $error = $ex->getMessage();
                die($error);
            }
        }
    }

    public function get_profile_info() {
        if ($this->access_token_ready) {
            $analytics = new Google_AnalyticsService($this->client);
            try {
                $optParams = array(
                    'max-results' => '1');
                $results = $analytics->data_ga->get('ga:' . $this->ga_api_profileId, '2015-02-18', '2016-01-15', 'ga:users', $optParams);

                $profileInfo = $results->getProfileInfo();

                $html = <<<HTML
<pre>
Account ID               = {$profileInfo->getAccountId()}
Web Property ID          = {$profileInfo->getWebPropertyId()}
Internal Web Property ID = {$profileInfo->getInternalWebPropertyId()}
Profile ID               = {$profileInfo->getProfileId()}
Table ID                 = {$profileInfo->getTableId()}
Profile Name             = {$profileInfo->getProfileName()}
</pre>
HTML;

                return $html;
            } catch (Exception $ex) {
                $error = $ex->getMessage();
                die($error);
            }
        }
    }
}
