<?php

if (!defined('BASEPATH'))
exit('No direct script access allowed');

//admin data
if (!function_exists('check_admin_session')) {
    function check_admin_session(){
        $ci =& get_instance();
        $ci->load->library('session');
        if($ci->session->userdata('tc_adminId')==null && $ci->session->userdata('tc_aisLogged')==null){
            if(!empty($_SERVER['HTTP_X_REQUESTED_WITH']) && strtolower($_SERVER['HTTP_X_REQUESTED_WITH'])=='xmlhttprequest')
            {
                $value=array(
                    'session'=>'false'
                );          
                echo json_encode($value);
                exit();
            }else{
                redirect(base_url().'admin/login');
            }
        }
    }
}

if (!function_exists('is_a_logged')) {    
    function is_a_logged()
    {
        $ci =& get_instance();
        $ci->load->library('session');
        return $ci->session->userdata('tc_aisLogged');            
    }    
}
   
if (!function_exists('get_adminId')) {    
    function get_adminId()
    {
        $ci =& get_instance();
        $ci->load->library('session');
        return $ci->session->userdata('tc_adminId');            
    }
}

if (!function_exists('get_a_username')) {
    function get_a_username()
    {
        $ci =& get_instance();
        $ci->load->library('session');
        return $ci->session->userdata('tc_aUserName');
    }
}

if (!function_exists('get_a_email')) {
    function get_a_email()
    {
        $ci =& get_instance();
        $ci->load->library('session');
        return $ci->session->userdata('tc_aEmail');
    }
}

if (!function_exists('get_a_role')) {
    function get_a_role()
    {
        $ci =& get_instance();
        $ci->load->library('session');
        return $ci->session->userdata('tc_aRoleId');
    }
}

if (!function_exists('get_a_type')) {
    function get_a_type()
    {
        $ci =& get_instance();
        $ci->load->library('session');
        return $ci->session->userdata('tc_aType');
    }
}

if(!function_exists('insert_a_log')){
    function insert_a_log($data){
        $ci =& get_instance();
        $ci->load->library('common_model',true);
        $data['ip_address']=get_ipaddress();
        $data['createdDate']=cur_datetime();
        $data['user_id']=get_adminId();
        $data['uname']=get_a_username();
        $data['u_type']='admin';
        $result = $ci->common_model->insert_table_data("activity_log", $data);
        return $result;        
    }
}

if(!function_exists('insert_log')){
    function insert_log($data){
        $ci =& get_instance();
        $ci->load->library('common_model',true);
        $data['ip_address']=get_ipaddress();
        $data['createdDate']=cur_datetime();
        $data['u_type']='user';
        $result = $ci->common_model->insert_table_data("activity_log", $data);
        return $result;        
    }
}

function create_slug($string){
  $slug=preg_replace('/[^A-Za-z0-9-]+/', '-', $string);
  return strtolower($slug);
} 

if (!function_exists('setRemember')) {
    function setRemember($remember,$uname,$pwd){
        if(trim($remember)=='on') {
            $year = time() + 3600 * 24 * 365;
        }else if($remember=="") {            
            $year = time() - 3600 * 24 * 365;
        }
        setcookie('user_remember_me', $uname, $year);
        setcookie('user_password', $pwd, $year);
    }
}


if(!function_exists('check_permission')){
    function check_permission($rid,$type){
        $ci =& get_instance();
        $ci->load->library('common_model',true);
        $where = array('role_id'=>get_a_role(),'permission_id'=>$rid);
        $mode = true;
        $result = $ci->common_model->get_table_data("role_permission_map", $where,'',$mode);
        $num_rows = $result->num_rows();
        if($num_rows == 0){
            if($type=="json"){
                $value=array(
                    'result'=>"fail",
                    'msg'=>"You don't have permission. <br/>Please contact your Site Admininstrator to request access."
                );
                echo json_encode($value);
                exit;
            }else{            
                redirect(base_url().'admin/permission');
            }        
        }        
    }        
}

if (!function_exists('get_ipaddress')) {    
    function get_ipaddress(){
        if (!empty($_SERVER['HTTP_CLIENT_IP']))   //check ip from share internet
        {
          $ip=$_SERVER['HTTP_CLIENT_IP'];
        }
        elseif (!empty($_SERVER['HTTP_X_FORWARDED_FOR']))   //to check ip is pass from proxy
        {
          $ip=$_SERVER['HTTP_X_FORWARDED_FOR'];
        }
        else
        {
          $ip=$_SERVER['REMOTE_ADDR'];
        }
        return $ip;
    }     
}

if (!function_exists('cur_datetime')) {    
    function cur_datetime()
    {   
        date_default_timezone_set('Asia/Kolkata');
        $date=date('Y-m-d H:i:s');
        return $date;
    }    
}

if (!function_exists('getMyDbDate')) {   
    function getMyDbDate($dateFormat,$date){        
        return date($dateFormat,strtotime(trim($date)));
    }
}

if (!function_exists('withErrors')) {
    function withErrors($msg,$result=""){
         $value=array(
                'status'=>"fail",
                'result' =>$result,
                'msg'=>$msg,
                );
        return $value;
    }
}
if (!function_exists('withSuccess')) {
    function withSuccess($msg,$result=""){
         $value=array(
            'status'=>"success",
            'result' => $result,
            'msg'=>$msg,
            );
        return $value;
    }
}


if(!function_exists('write_excel_data')){   
    function write_excel_data($txt){
        $ci =& get_instance();
        $filename = $ci->session->userdata('opx_adminid')."-newfile.txt";
        $myfile = fopen( getcwd()."/lib/data_read/$filename", "w") or die("Unable to open file!");

        //$this->excel_data = $txt;
        fwrite($myfile, $txt);
    }   
}
	// sentence teaser
// this function will cut the string by how many words you want
function word_teaser($string, $count){
  $original_string = $string;
  $words = explode(' ', $original_string);
 
  if (count($words) > $count){
   $words = array_slice($words, 0, $count);
   $string = implode(' ', $words);
  }
 
  return $string;
}

function string_teaser($string,$count){
    $string = strip_tags($string); $string = trim($string);
    if(strlen($string)<$count+1){
        $res = $string. " ".str_repeat("&nbsp;",$count-strlen($string));
    }else{

        $res = substr($string, 0, $count)."...";
    }
    return $res;
}

function filename_teaser($string,$count,$ext){
    $string = strip_tags($string); $string = trim($string);
    if(strlen($string)<$count+1){
        $res = $string.$ext;
    }else{

        $res = substr($string, 0, $count)."...".$ext;
    }
    return $res;
}

function moneyFormat($num) {
    $explrestunits = "" ;
    if(strlen($num)>3) {
        $lastthree = substr($num, strlen($num)-3, strlen($num));
        $restunits = substr($num, 0, strlen($num)-3); // extracts the last three digits
        $restunits = (strlen($restunits)%2 == 1)?"0".$restunits:$restunits; // explodes the remaining digits in 2's formats, adds a zero in the beginning to maintain the 2's grouping.
        $expunit = str_split($restunits, 2);
        for($i=0; $i<sizeof($expunit); $i++) {
            // creates each of the 2's group and adds a comma to the end
            if($i==0) {
                $explrestunits .= (int)$expunit[$i].","; // if is first value , convert into integer
            } else {
                $explrestunits .= $expunit[$i].",";
            }
        }
        $thecash = $explrestunits.$lastthree;
    } else {
        $thecash = $num;
    }
    return $thecash; // writes the final format where $currency is the currency symbol.
}

function file_download($filepath){
	  if(file_exists($filepath)) {

            header('Content-Description: File Transfer');

            header('Content-Type: application/octet-stream');

            header('Content-Disposition: attachment; filename="'.basename($filepath).'"');

            header('Expires: 0');

            header('Cache-Control: must-revalidate');

            header('Pragma: public');

            header('Content-Length: ' . filesize($filepath));

            flush(); // Flush system output buffer

            readfile($filepath);

            exit;

        }
	
}

 function fileSizeUnits($bytes)
    {
        if ($bytes >= 1073741824)
        {
            $bytes = number_format($bytes / 1073741824, 2) . ' GB';
        }
        elseif ($bytes >= 1048576)
        {
            $bytes = number_format($bytes / 1048576, 2) . ' MB';
        }
        elseif ($bytes >= 1024)
        {
            $bytes = number_format($bytes / 1024, 2) . ' KB';
        }
        elseif ($bytes > 1)
        {
            $bytes = $bytes . ' bytes';
        }
        elseif ($bytes == 1)
        {
            $bytes = $bytes . ' byte';
        }
        else
        {
            $bytes = '0 bytes';
        }

        return $bytes;
}

function humanTiming ($time)
{
    $time = time() - $time; // to get the time since that moment
    $time = ($time<1)? 1 : $time;
    $tokens = array (
        31536000 => 'year',
        2592000 => 'month',
        604800 => 'week',
        86400 => 'day',
        3600 => 'hour',
        60 => 'minute',
        1 => 'second'
    );
    foreach ($tokens as $unit => $text) {
        if ($time < $unit) continue;
        $numberOfUnits = floor($time / $unit);
        return $numberOfUnits.' '.$text.(($numberOfUnits>1)?'s':'');
    }
}

if(!function_exists('currencyWords')){

function currencyWords($number) {
    $no = round($number);
    $decimal = round($number - ($no = floor($number)), 2) * 100;    
    $digits_length = strlen($no);    
    $i = 0;
    $str = array();
    $words = array(
        0 => '',
        1 => 'One',
        2 => 'Two',
        3 => 'Three',
        4 => 'Four',
        5 => 'Five',
        6 => 'Six',
        7 => 'Seven',
        8 => 'Eight',
        9 => 'Nine',
        10 => 'Ten',
        11 => 'Eleven',
        12 => 'Twelve',
        13 => 'Thirteen',
        14 => 'Fourteen',
        15 => 'Fifteen',
        16 => 'Sixteen',
        17 => 'Seventeen',
        18 => 'Eighteen',
        19 => 'Nineteen',
        20 => 'Twenty',
        30 => 'Thirty',
        40 => 'Forty',
        50 => 'Fifty',
        60 => 'Sixty',
        70 => 'Seventy',
        80 => 'Eighty',
        90 => 'Ninety');
    $digits = array('', 'Hundred', 'Thousand', 'Lakh', 'Crore');
    while ($i < $digits_length) {
        $divider = ($i == 2) ? 10 : 100;
        $number = floor($no % $divider);
        $no = floor($no / $divider);
        $i += $divider == 10 ? 1 : 2;
        if ($number) {
            $plural = (($counter = count($str)) && $number > 9) ? 's' : null;            
            $str [] = ($number < 21) ? $words[$number] . ' ' . $digits[$counter] . $plural : $words[floor($number / 10) * 10] . ' ' . $words[$number % 10] . ' ' . $digits[$counter] . $plural;
        } else {
            $str [] = null;
        }  
    }
    
    $Rupees = implode(' ', array_reverse($str));
    $paise = ($decimal) ? "And Paise " . ($words[$decimal - $decimal%10]) ." " .($words[$decimal%10])  : '';
    return ($Rupees ? 'Rupees ' . $Rupees : '') . $paise . " Only";
}

}


function send_email($templateName,$mailData){
    $ci =& get_instance();
    $content  = $ci->load->view('email-templates/'.$templateName, $mailData, TRUE); 
    $from='';
    $fromText='';
    $user_cc='';
    if(isset($mailData['attachment'])){
        $attachment=$mailData['attachment'];
    }else{
        $attachment='';
    }
    if(isset($mailData['attachmentName'])){
        $attachmentName=$mailData['attachmentName'];
    }else{
        $attachmentName='';
    }

    $mailsend = $ci->admin->sendmail($from, $fromText, $mailData['mailTo'], $user_cc, $mailData['mailSubject'], $content,$attachment,$attachmentName);             
    return $mailsend;
    
}

if(!function_exists('send_sms')){
    function send_sms($toMobile,$message){
        //print_r($toMobile);
        if(!empty($toMobile)){
            $ci =& get_instance();
            $ci->load->library('adminmodel',true);
            $sWhere = array('id' => 1 );
            $settings=$ci->adminmodel->get_table_data('sms_settings',$sWhere,'*',true);
            //print_r($this->db->last_query());

            $username = $settings->row()->username;
            $password = $settings->row()->password;
            $senderId = $settings->row()->senderId;
            $message = urlencode($message);
            if(is_array($toMobile)){
                $toMobile = implode(',', $toMobile);
            }

            
            $msgURL = "http://smsalert.dmudra.com/api/smsapi.aspx?username=$username&password=$password&to=$toMobile&from=$senderId&message=$message";
            //$msgURL = "http://smsalert.dmudra.com/api/smscredit.aspx?username=odopix&password=odopix098";

            $_h = curl_init();
            curl_setopt($_h, CURLOPT_HEADER, 1);
            curl_setopt($_h, CURLOPT_RETURNTRANSFER, 1);
            curl_setopt($_h, CURLOPT_HTTPGET, 1);
            curl_setopt($_h, CURLOPT_URL, $msgURL);
            curl_setopt($_h, CURLOPT_DNS_USE_GLOBAL_CACHE, false );
            curl_setopt($_h, CURLOPT_DNS_CACHE_TIMEOUT, 2 );

            //var_dump(curl_exec($_h));
            //var_dump(curl_getinfo($_h));
            //var_dump(curl_error($_h));
            $html=curl_exec($_h);
            if($html === false) {
                $msg=curl_error($_h);
                $result=0;
            }
            else {
                $msg= 'Operation completed without any errors';
                $result=1;
            }

            //print_r($_h);
            curl_close($_h);
        }else {
            $msg= 'Mobile number is compulsary to send sms';
            $result=0;
        }
        $value = array('msg' =>$msg ,'result'=>$result );
        return $value;
    }
}

