<?php
class Users extends CI_Controller{
	
	function __construct(){
		parent::__construct();	
		check_admin_session();
		$this->load->model("common_model","",true);
		$this->load->model("usermodel","",true);
		$this->admin->nocache(); 
	}
	
	function index(){
		//check_permission(3,'uri');
		$data = $this->admin->common_admin_files();
		$data['title']="Users";
		$this->load->view("admin/users/users_view",$data);
	}
	
	function get_users(){
		//check_permission(4,'json');	
		$page = (int) $this->input->post('page');
		$filter_data=$this->input->post('filter_data');
		$get_total_rows = $this->usermodel->filter_users($filter_data,0,0);
		$item_per_page="10";
		foreach ($filter_data as $k => $v) {
			if (($v['type'] == 'perpage') && $v['value'] != "") {
				$item_per_page = (int)$v['value'];
			}
		}
		$data = $this->common_model->getPaginationData($item_per_page,$page,$get_total_rows);
		$data['adminusers']=$this->usermodel->filter_users($filter_data,$data['item_per_page'],$data['page_position']);
		$str=$this->load->view("admin/users/users_tbl_view",$data,true);
		$value=array(
			'result'=>$str
		);
        echo json_encode($value);
	}
	
	function add(){	
		//check_permission(5,'uri');
		$data=array();
		$data = $this->admin->common_admin_files();
		$data['title']="Add new user";
		$this->load->view("admin/users/add_users_view",$data);
	}

	function edit(){
		//check_permission(6,'uri');
		$id=$this->uri->segment(4);
		if($id!=""){
			check_permission(1,'edit','uri');
			$data=array();
			$data = $this->admin->common_admin_files();
			$data['title']="Edit user";
			$where = array('adminId' => $id);
			$data['adminuser']=$this->common_model->get_table_data('admin_users',$where,'*',true);
			$this->load->view("admin/users/edit_users_view",$data);
		}else{
			redirect(base_url().'admin/dashboard');
		}
	}

	function checkusername(){
		$name=$this->admin->escapespecialchrs(trim($this->input->post('username')));
		$edit=$this->admin->escapespecialchrs($this->input->post('edit'));
		$q=0;
		if(strtolower($edit)!=strtolower($name)){
			$where=array('username'=>$name);
			$query=$this->common_model->get_table_data('admin_users',$where,'*',true);
			$q=$query->num_rows();
		}
		$result="true";
		if($q>0){
			$result="false";
		}		
		echo $result;
	}
	
	function checkemail(){
		$name=$this->admin->escapespecialchrs(trim($this->input->post('email')));
		$edit=$this->admin->escapespecialchrs($this->input->post('edit'));
		$q=0;
		if(strtolower($edit)!=strtolower($name)){
			$where=array('email'=>$name);
			$query=$this->common_model->get_table_data('admin_users',$where,'*',true);
			$q=$query->num_rows();
		}
		$result="true";
		if($q>0){
			$result="false";
		}		
		echo $result;
	}
	
	function saveuser(){
		$adminId=$this->input->post("adminId");
		$name=$this->input->post("name");
		$username=$this->input->post("username");
		$password=$this->input->post("password");
		$email=$this->input->post("email");
		$roleId=$this->input->post("roleId");
		

		$where = array('email' => $email);
		$get_res=$this->common_model->get_table_data('admin_users',$where,'*',true);

		$result='fail';
		$msg='';
		// if($get_res->num_rows()>0){
		// 	$msg='Email address already exists';
		// }else{
			$data['adminId']=$adminId;
			$data['name']=$name;
			$data['username']=$username;
			$data['password'] = $this->common_model->hash($password);
			$data['email']=$email;
			$data['roleId']=$roleId==""?0:$roleId;
			$data['status']=1;
			$result=0;
			$q=$this->usermodel->saveuser($data);
			if($q['id']!=""){
				$result='success';
				$msg=$q['msg'];
			}else{
				$msg=$q['msg'];
			}
		//}
		$value=array(
			'result'=>$result,
			'msg'=>$msg
		);
		
		echo json_encode($value);
	}
	
	function deluser(){
		//check_permission(7,'json');
		$id=$this->input->post("id");
		$str=-1;
		$canDelete=1;
		$result=$this->usermodel->deluser($id);
		$str=$result['result'];	
		$canDelete=$result['canDelete'];
		$value=array(
			'result'=>$str,
			'canDelete'=>$canDelete
		);
		echo json_encode($value);
	}
	
	function status() {
		//check_permission(6,'json');
        $id=$this->input->post("id");
        $status=$this->input->post("status");
        $q=-1;        
        $msg="";
        $msg="Inactive";
        if($status==1){
            $msg="Active";
        }
        $q=$this->usermodel->saveuser_status($id,$status);	
        $value=array(
            'result'=>$q,
            'msg'=>$msg
        );
        echo json_encode($value);
    }
	
	
}