<?php
class Testimonials extends CI_Controller{
	
	function __construct(){
		parent::__construct();
        check_admin_session();
		$this->load->model("adminmodel","",true);
        $this->load->model("common_model","",true);
        $this->load->model("testimonials_model","",true);
		$this->admin->nocache(); 
	}
	
	function index(){
    	$data = $this->admin->common_admin_files();
    	$data['title']="Testimonials";
    	$this->load->view("admin/testimonials/main_view",$data);
	}

    function get_datas(){
        $page = (int) $this->input->post('page');
        $filter_data=$this->input->post('filter_data');
        $get_total_rows = $this->testimonials_model->filter_datas($filter_data,0,0);
        $item_per_page="10";
        foreach ($filter_data as $k => $v) {
            if (($v['type'] == 'perpage') && $v['value'] != "") {
                $item_per_page = (int)$v['value'];
            }
        }
        $data = $this->common_model->getPaginationData($item_per_page,$page,$get_total_rows);        
        $data['dataQ']=$this->testimonials_model->filter_datas($filter_data,$data['item_per_page'],$data['page_position']);        
        $str = $this->load->view("admin/testimonials/tbl_view", $data, true);
        $value = array(
        	'result'=>'success',
            'msg' => $str
        );
        echo json_encode($value);
    }

	function add(){
		$data=array();
    	$str=$this->load->view("admin/testimonials/add_view",$data,true);
    	$value = array(
        	'result'=>'success',
            'msg' => $str
        );
        echo json_encode($value);
	}

	function edit(){
		$data=array();
		$id=$this->input->post('id');
		$where = array('id' => $id);
	    $data['dataQ']=$this->common_model->get_table_data('testimonials',$where,'*',true);
    	$str=$this->load->view("admin/testimonials/edit_view",$data,true);
    	$value = array(
        	'result'=>'success',
            'msg' => $str
        );
        echo json_encode($value);
	}

	function save_member(){
		$id=$this->input->post('id');
		$image_old=$this->input->post('image_old');
		$data['name']=$this->input->post('name');
		$data['designation']=$this->input->post('designation');
		$data['status']=$this->input->post('status');
		$result='fail';
		$file_res='fail';
		if($data['status']==''){
			$data['status']=1;
		}

		if($id==''){
			$month_today=date('m');
			$year_today=date('Y');
		}else{
			$where=array('id'=>$id);
			$get_res=$this->common_model->get_table_data('testimonials',$where,'*',true);
	    }
			
			$data['updatedBy']=get_adminId();
			$data['updatedDate']=cur_datetime();
			$where = array('id' => $id);
			
			$res=$this->common_model->update_table_data('testimonials',$where,$data);
			//print_r($this->db->last_query());
			if($res>0){
				$result='success';
				$msg='Testimonials updated successfully';

				$logData['action']='update';
				$logData['description']='updated the Testimonials '.$data['name'];
				$logData['dataId']=$id;
				$logData['module']='testimonials';
				$logData['table_name']='testimonials';
				insert_a_log($logData);
			}else{
				$msg='Unable to update the testimonials';
			}
		//print_r($this->db->last_query());

		$value = array(
        	'result'=>$result,
            'msg' => $msg
        );
        echo json_encode($value);
	}

    function delete_post(){
        $id=$this->input->post('id');
        $result='fail';
        $msg='';
        $where = array('id'=>$id);
        $get_res=$this->common_model->get_table_data('testimonials',$where,'*',true);
        if($get_res->num_rows()>0){
            $res=$this->common_model->delete_table_data('testimonials',$where);
            if($res>0){
                $result='success';
                $msg='Testimonials ('.$get_res->row()->name.') has been deleted';

                $logData['action']='delete';
		        $logData['description']='deleted the Testimonials '.$get_res->row()->name;
		        $logData['dataId']=$id;
		        $logData['module']='testimonials';
		        $logData['table_name']='testimonials';
		        insert_a_log($logData);
            }else{
                $msg='Unable to delete the Testimonials, try after sometime';
            }
        }else{
            $msg='Testimonials data error, refresh this page and try again';
        }
        $value=array(
            'result'=>$result,
            'msg'=>$msg
        );        
        echo json_encode($value);
    }

}