<?php
class Sliders extends CI_Controller{
	
	function __construct(){
		parent::__construct();
        check_admin_session();
		$this->load->model("adminmodel","",true);
        $this->load->model("common_model","",true);
        $this->load->model("sliders_model","",true);
		$this->admin->nocache(); 
	}
	
	function index(){
    	$data = $this->admin->common_admin_files();
    	$data['title']="Homepage sliders";
    	$this->load->view("admin/sliders/main_view",$data);
	}

    function get_datas(){
        $page = (int) $this->input->post('page');
        $filter_data=$this->input->post('filter_data');
        $get_total_rows = $this->sliders_model->filter_datas($filter_data,0,0);
        $item_per_page="10";
        foreach ($filter_data as $k => $v) {
            if (($v['type'] == 'perpage') && $v['value'] != "") {
                $item_per_page = (int)$v['value'];
            }
        }
		if(empty($page)){
			$page=1;
		}
        $data = $this->common_model->getPaginationData($item_per_page,$page,$get_total_rows);        
        $data['dataQ']=$this->sliders_model->filter_datas($filter_data,$data['item_per_page'],$data['page_position']);     
		//print_r($this->db->last_query());
        $str = $this->load->view("admin/sliders/tbl_view", $data, true);
        $value = array(
        	'result'=>'success',
            'msg' => $str
        );
        echo json_encode($value);
    }

	function add(){
		$data=array();
    	$str=$this->load->view("admin/sliders/add_view",$data,true);
    	$value = array(
        	'result'=>'success',
            'msg' => $str
        );
        echo json_encode($value);
	}

	function edit(){
		$data=array();
		$id=$this->input->post('id');
		$where = array('id' => $id);
	    $data['dataQ']=$this->common_model->get_table_data('sliders',$where,'*',true);
    	$str=$this->load->view("admin/sliders/edit_view",$data,true);
    	$value = array(
        	'result'=>'success',
            'msg' => $str
        );
        echo json_encode($value);
	}

	function save_member(){
		$id=$this->input->post('id');
		$image_old=$this->input->post('image_old');
		$data['title']=$this->input->post('title');
		$data['description']=$this->input->post('description');
		$data['btn_name']=$this->input->post('btn_name');
		$data['btn_link']=$this->input->post('btn_link');
		$data['status']=$this->input->post('status');
		$result='fail';
		$file_res='fail';
		if($data['status']==''){
			$data['status']=1;
		}

		if($id==''){
			$month_today=date('m');
			$year_today=date('Y');
			$dir = 'uploads/sliders/'.$month_today.'-'.$year_today.'/';
	        if(!file_exists($dir)){
	            mkdir($dir , 0777, true);
	        }
		}else{
			$where=array('id'=>$id);
			$get_res=$this->common_model->get_table_data('sliders',$where,'*',true);
			$dir=$get_res->row()->upload_dir;
	    }
        $extensions = array("jpeg","jpg","png","PNG","JPEG","JPG");
        if(!empty($_FILES)){
            //foreach($_FILES['attachment']['tmp_name'] as $key => $tmp_name )
            for($i=0;$i<1;$i++)
            {
                $key = $i;
                if(!empty($_FILES['attachment']['tmp_name'][$key])){
                    $file_name = $_FILES['attachment']['name'][$key];
                    $file_size =$_FILES['attachment']['size'][$key];
                    $file_tmp =$_FILES['attachment']['tmp_name'][$key];
                    $file_type=$_FILES['attachment']['type'][$key];        
                    $ext = pathinfo($file_name, PATHINFO_EXTENSION);
                    if($file_size > 2000000) {
                        $msg='File size should not exceed 2 MB';
                    }
                    if(in_array($ext,$extensions ) === true)
                    {  

                        $target = $dir.$file_name;
                        if(file_exists($target)){
                            $file_name = rand(01,1000).$file_name;
                        }
                        $target = $dir.$file_name;
                        if(move_uploaded_file($file_tmp, $dir.$file_name))
                        {
                            $data['f_image']=$file_name;
                            $file_res='success';
                        }else{
                            $msg = 'Error in uploading file';               
                        }
                    
                    }else{
                        $msg = 'Error in uploading file. <br>File type is not allowed.';
                    }
                }else{
                   if($image_old==''){
			            $msg='Please select the file to upload';
			        }else{
			        	$data['f_image']=$image_old;
			        	$file_res='success';
			        }
                }
            }
        }else{
            if($image_old==''){
	            $msg='Please select the file to upload';
	        }else{
	        	$data['f_image']=$image_old;
	        	$file_res='success';
	        }
        }

        if($file_res=='success'){
	        
	        if($id==''){
	        	$data['upload_dir']=$dir;
	        	$data['createdBy']=get_adminId();
    			$data['createdDate']=cur_datetime();
				$res=$this->common_model->insert_table_data('sliders',$data);
				if($res>0){
					$result='success';
					$msg='sliders created successfully';

					$logData['action']='create';
			        $logData['description']='added a new Sliders '.$data['title'];
			        $logData['dataId']=$id;
			        $logData['module']='sliders';
			        $logData['table_name']='sliders';
			        insert_a_log($logData);

				}else{
					$msg='Unable to add a new Sliders, try after sometime';
				}
			}else{
				
				$data['updatedBy']=get_adminId();
    			$data['updatedDate']=cur_datetime();
				$where = array('id' => $id);
				
				$res=$this->common_model->update_table_data('sliders',$where,$data);
				//print_r($this->db->last_query());
				if($res>0){
					$result='success';
					$msg='Sliders updated successfully';

					$logData['action']='update';
			        $logData['description']='updated the Sliders '.$data['title'];
			        $logData['dataId']=$id;
			        $logData['module']='sliders';
			        $logData['table_name']='sliders';
			        insert_a_log($logData);
				}else{
					$msg='Unable to update the sliders';
				}
			}
			
		}
		//print_r($this->db->last_query());

		$value = array(
        	'result'=>$result,
            'msg' => $msg
        );
        echo json_encode($value);
	}

    function delete_post(){
        $id=$this->input->post('id');
        $result='fail';
        $msg='';
        $where = array('id'=>$id);
        $get_res=$this->common_model->get_table_data('sliders',$where,'*',true);
        if($get_res->num_rows()>0){
            $res=$this->common_model->delete_table_data('sliders',$where);
            if($res>0){
                $result='success';
                $msg='Slider ('.$get_res->row()->title.') has been deleted';

                $logData['action']='delete';
		        $logData['description']='deleted the Slider '.$get_res->row()->title;
		        $logData['dataId']=$id;
		        $logData['module']='sliders';
		        $logData['table_name']='sliders';
		        insert_a_log($logData);
            }else{
                $msg='Unable to delete the slider, try after sometime';
            }
        }else{
            $msg='Slider data error, refresh this page and try again';
        }
        $value=array(
            'result'=>$result,
            'msg'=>$msg
        );        
        echo json_encode($value);
    }

}