<?php
class settings extends CI_Controller{
	
	function __construct(){
		parent::__construct();
        check_admin_session();
		$this->load->model("adminmodel","",true);
        $this->load->model("common_model","",true);
		$this->admin->nocache(); 
	}

	function index(){
        redirect(base_url().'admin/dashboard');
    }

	function company(){
    	$data = $this->admin->common_admin_files();	
        $where = array('id' => 1);
    	$data['settings']=$this->common_model->get_table_data('company_settings',$where,'*',true);
    	$data['title']="Company profile settings";
    	$this->load->view("admin/settings/company_view",$data);
	}

	function save_csettings(){
        $data['company']=$this->input->post("company");
        $data['caption']=$this->input->post("caption");
        $data['address']=$this->input->post("address");
        $data['phone']=$this->input->post("phone");
        $data['mobile']=$this->input->post("mobile");
        $data['email']=$this->input->post("email");
        $data['website']=$this->input->post("website");
        $data['GSTIN']=$this->input->post("GSTIN");     
        $data['updatedBy']=get_adminId();
        $data['updatedDate']=cur_datetime();

        $result='fail';
        $where = array('id' => 1);
        $q=$this->common_model->update_table_data('company_settings',$where,$data);
        //print_r($this->db->last_query());
        if($q>0){
        	$result='success';
        	$logData['action']='Update';
            $logData['description']='updated company profile';
            $logData['dataId']=1;
            $logData['module']='Company Settings';
            $logData['table_name']='company_settings';
            insert_a_log($logData);
        }
		$value=array(
			'result'=>$result
		);
		echo json_encode($value);
	}
	
    function email(){
        $data = $this->admin->common_admin_files();
        $where = array('settingId' => 1);
        $settings=$this->common_model->get_table_data('mail_settings',$where,'*',true);
        $data['title']="Email automation settings";
        $data['settings']=$settings;
        $this->load->view("admin/settings/mail_view",$data);
    }

    function save_esettings(){
        $result='fail';
        $data['host']=$this->input->post("host");
        $data['port']=$this->input->post("port");
        $data['hostUsername']=$this->input->post("hostUsername");
        $data['hostPassword']=$this->input->post("hostPassword");
        $data['smtpAuth']=$this->input->post("smtpAuth");
        $data['smtpSecure']=$this->input->post("smtpSecure");
        $data['from']=$this->input->post("from");
        $data['fromText']=$this->input->post("fromText");
        $data['status']=1;
        $data['updatedBy']=get_adminId();
        $data['updatedDate']=cur_datetime();

        $settingId=1;
        $where = array('settingId' => $settingId);
        //$q=$this->adminmodel->insert_table_data('mail_settings',$data);
        $q=$this->common_model->update_table_data('mail_settings',$where,$data);
        //print_r($this->db->last_query());
        if($q>0){
            $result='success';
            $logData['action']='Update';
            $logData['description']='updated email automation settings';
            $logData['dataId']=1;
            $logData['module']='Email Settings';
            $logData['table_name']='mail_settings';
            insert_a_log($logData);
        }
        $value=array(
            'result'=>$result
        );
        echo json_encode($value);
    }


  function test_esettings(){
        $from = "";
        $fromText="";
        $user_to = $this->input->post('testemail');
        $user_cc = "";
        $user_sub = "Test email";
        $content   = "This is the test email form Freedom Cards";

        $mailsend = $this->admin->sendmail($from, $fromText, $user_to, $user_cc, $user_sub, $content,"","");      

        if($mailsend!=1) {
            $value = withErrors('Mailer Error: ' . $mailsend);
        } else {
            $value = withSuccess("Test message has been sent");
        }       
    
        echo json_encode($value);
    }


    function sms(){
            check_permission(3,'edit','uri');
            $data = $this->admin->common_admin_files();
            $where = array('id' => 1);
            $settings=$this->common_model->get_table_data('sms_settings',$where,'*',true);
            $data['title']="SMS automation settings";
            $data['settings']=$settings;
            $this->load->view("admin/settings/sms_view",$data);
    }

    function saveSMSsettings(){
        $settingId=$this->input->post("id");
        $username=$this->input->post("username");
        $password=$this->input->post("password");
        $senderId=$this->input->post("senderId");
        //$email=$this->input->post("email");

        $result='fail';
        $data['username']=$username;
        $data['password']=$password;
        $data['senderId']=$senderId;
        $data['lastUpdated']=cur_datetime();
        $data['updatedBy']=get_adminId();
        //$data['email']=$email;

        $where=array('id'=>1);
        $q=$this->common_model->update_table_data('sms_settings',$where,$data);
        if($q>0){
            $result='success';
            $logData['action']='Update';
            $logData['description']='updated sms settings';
            $logData['dataId']=1;
            $logData['module']='SMS Settings';
            $logData['table_name']='sms_settings';
            insert_a_log($logData);
        }
        $value=array(
            'result'=>$result
        );
        
        echo json_encode($value);
    }

    function test_sms(){
        $toMobile=  $this->input->post("testsms");
        $message='This is a test sms from Freedom Cards';
        $sentRes=send_sms($toMobile,$message);
        if($sentRes['result']>0){
            $status='success';
            $msg='Successfully sent test sms...';
        }else{
            $status='fail';
            $msg='Failed to send sms!';
        }
        $value=array(
            'status'=>$status,
            'msg'=>$msg
        );
        echo json_encode($value);
    }
}