<?php
class roles extends CI_Controller{
	
	function __construct(){
		parent::__construct();	
		check_admin_session();
		$this->load->model("common_model","",true);
		$this->load->model("rolesmodel","",true);
		$this->admin->nocache(); 
	}

	function index(){
		//check_permission("8",'uri');
		$data = $this->admin->common_admin_files();
		$data['title']="Roles";		
		$this->load->view("admin/roles/roles_view",$data);
	}	

	function getroles(){
		//check_permission("9",'json');
		$page = (int) $this->input->post('page');
		$filter_data=$this->input->post('filter_data');
		$get_total_rows = $this->rolesmodel->filter_role($filter_data,0,0);
		$item_per_page="10";
		foreach ($filter_data as $k => $v) {
			if (($v['type'] == 'perpage') && $v['value'] != "") {
				$item_per_page = (int)$v['value'];
			}
		}
		if(empty($page)){
			$page=1;
		}
		$data = $this->common_model->getPaginationData($item_per_page,$page,$get_total_rows);		
		$data['roles']=$this->rolesmodel->filter_role($filter_data,$data['item_per_page'],$data['page_position']);		
		$str=$this->load->view("admin/roles/roles_tbl_view",$data,true);
		$value=array(
			'result'=>'success',
			'msg'=>$str
		);
        echo json_encode($value);
	}

	function add_role(){
		//check_permission("10",'json');
		$data=array();
		$result='success';
		$msg=$this->load->view("admin/roles/addedit_role_view",$data,true);
		$value=array(
			'result'=>$result,
			'msg'=>$msg
		);
        echo json_encode($value);
	}

	function edit_role(){
		//check_permission("11",'json');
		$id=$this->input->post('id');
		$data=array();
		$result='fail';
		$where=array('id'=>$id);
		$data['dataQ']=$this->common_model->get_table_data('role',$where,'*',true);
		if($data['dataQ']->num_rows()>0){
			$result='success';
		}
		$msg=$this->load->view("admin/roles/addedit_role_view",$data,true);
		$value=array(
			'result'=>$result,
			'msg'=>$msg
		);
        echo json_encode($value);
	}

	function check_name(){
		$name=$this->admin->escapespecialchrs(trim($this->input->post('name')));
		$edit=$this->admin->escapespecialchrs($this->input->post('edit'));
		$q=0;
		if(strtolower($edit)!=strtolower($name)){
			$where=array('name'=>$name);
			$query=$this->common_model->get_table_data('role',$where,'*',true);
			$q=$query->num_rows();
		}
		$result="true";
		if($q>0){
			$result="false";
		}		
		echo $result;
	}

	function save_role(){
		$id=$this->input->post('id');
		$data['name']=$this->input->post('name');
		$data['description']=$this->input->post('description');
		$result='fail';
		$msg='';
		if($id!=''){
			$data['updatedBy']=get_adminId();
			$data['updatedDate']=cur_datetime();
			$where = array('id' => $id);
			$id=$this->common_model->update_table_data('role',$where,$data);
			$result='success';
			$msg='Role ('.$data['name'].') has been created';
			$logData['action']='Create';
			$logData['description']='created a new user role '.$data['name'];
		}else{
			$data['createdBy']=get_adminId();
			$data['createdDate']=cur_datetime();
			$id=$this->common_model->insert_table_data('role',$data);
			$result='success';
			$msg='Role ('.$data['name'].') has been updated';
			$logData['action']='Update';
			$logData['description']='updated the user role '.$data['name'];
		}
		if($result=='success'){
			$logData['dataId']=$id;
			$logData['module']='Roles';
			$logData['table_name']='role';
			insert_a_log($logData);
		}

		$value=array(
			'result'=>$result,
			'msg'=>$msg
		);
        echo json_encode($value);
	}

	function permissions(){
		//check_permission("17",'uri');
		$id=$_GET['id'];
		$data=array();
		$data = $this->admin->common_admin_files();
		$data['title']="Manage Permissions";
		$data['role_id']=$id;
		$data['getPermission']=$this->rolesmodel->getPermissions($id);
		$this->load->view("admin/roles/permissions_view",$data);
	}
	
	function permissionStatus(){
        $post = $this->input->post();
        $ret  = $this->rolesmodel->updatePermsisionStatus($post);  //Passing table name and id as argument
		
        if ($post['stat'] == "instatus") {
            if ($ret > 0) {
                $result = "activatesuccess";
                $stat   = "astatus";
            } else {
                $result = "activatefail";
                $stat   = "astatus";
            }
        } else if ($post['stat'] == "astatus") {
            if ($ret > 0) {
                $result = "deactivatesuccess";
                $stat   = "instatus";
            } else {
                $result = "deactivatefail";
                $stat   = "instatus";
            }
        }
        echo json_encode(array(
            'result' => $result,
            'stat' => $stat
        ));
        
    }

}