<?php

defined('BASEPATH') OR exit('No direct script access allowed');

class Properties extends CI_Controller {

	function __construct(){
		parent::__construct();
		check_admin_session();
		$this->load->model("adminmodel","",true);
		$this->load->model("common_model","",true);
		$this->load->model("property_model","",true);
		$this->admin->nocache(); 
	}
	
    public function index() {
        $data = $this->admin->common_admin_files();
		$data['title']="All Properties";
		$where = array('status' => 1);
		$data['categoryQ']=$this->common_model->get_table_data('categories',$where,'*',true);
		$this->load->view("admin/properties/main_view",$data);
    }

    function get_datas(){
        $page = (int) $this->input->post('page');
        $filter_data=$this->input->post('filter_data');
        $get_total_rows = $this->property_model->filter_datas($filter_data,0,0);
        $item_per_page="10";
        foreach ($filter_data as $k => $v) {
            if (($v['type'] == 'perpage') && $v['value'] != "") {
                $item_per_page = (int)$v['value'];
            }
        }
		if(empty($page)){
			$page=1;
		}
        $data = $this->common_model->getPaginationData($item_per_page,$page,$get_total_rows);        
        $data['dataQ']=$this->property_model->filter_datas($filter_data,$data['item_per_page'],$data['page_position']);        
        $str = $this->load->view("admin/properties/tbl_view", $data, true);
        $value = array(
        	'result'=>'success',
            'msg' => $str
        );
        echo json_encode($value);
    }

    function add_new(){
    	$data=array();
		$str=$this->load->view("admin/properties/add_view",$data,true);	
		$value = array('status' => 'success', 'msg'=>$str);
		echo json_encode($value);
    }

    function save_add_property(){
    	$data['title']=$this->input->post('title');
    	$data['ptype']=$this->input->post('ptype');
    	$data['p_category']=$this->input->post('p_category');
    	$data['category']=$this->input->post('category');
    	$data['size']=$this->input->post('size');
    	$data['location']=$this->input->post('location');
    	$data['rera_no']=$this->input->post('rera_no');
    	$data['price']=$this->input->post('price');
    	$data['sqft_price']=$this->input->post('sqft_price');
    	$data['tot_sqft']=$this->input->post('tot_sqft');
    	$data['garage']=$this->input->post('garage');

    	//for resedentials
    	$data['beds']=$this->input->post('beds');
    	$data['bathrooms']=$this->input->post('bathrooms');
    	$data['balcony']=$this->input->post('balcony');
    	$data['units']=$this->input->post('units');

    	//for offices
    	$data['wstations']=$this->input->post('wstations');
    	$data['cabins']=$this->input->post('cabins');

    	//for industrials
    	$data['power_kw']=$this->input->post('power_kw');
    	$data['ceiling_ht']=$this->input->post('ceiling_ht');

    	//for retails
    	$data['d_space']=$this->input->post('d_space');

    	$data['createdBy']=get_adminId();
    	$data['createdDate']=cur_datetime();
    	$data['status']=1;
    	$data['p_visibility']=1;
    	$ins_id=$this->common_model->insert_table_data('properties',$data);
    	$result='fail';
    	$msg='Unable to process your request, try again';
    	$urlredirect='';
    	if($ins_id>0 && $ins_id!=''){
			$rand_chars=strtoupper($this->admin->randomCodenum(2));
			$rand_ints=$this->admin->random_integer(2);
			$property_code=$rand_chars.$rand_ints.$ins_id;
	        $slug=create_slug($data['title'].' '.$data['location'].' '.$property_code);
	        
	        $dir = 'uploads/properties/'.strtolower($property_code).'/';
	        if(!file_exists($dir)){
	            mkdir($dir , 0777, true);
	        }
	        $up_data['code']=$property_code;
	        $up_data['upload_dir']=$dir;
			$up_data['slug']=$slug;
			$where = array('propertyId' => $ins_id);
			$this->common_model->update_table_data('properties',$where,$up_data);
			//print_r($this->db->last_query());
			$detail_data = array('propertyId' => $property_code,'createdDate'=>$data['createdDate'],'createdBy'=>$data['createdBy']);
			$this->common_model->insert_table_data('property_details',$detail_data);

			$urlredirect='admin/properties/edit/?id='.$property_code;
			$result='success';
			$msg="Property has been added successfully<br>Click OK to goto property details";

			$logData['action']='add';
	        $logData['description']='added new property '.$property_code.', '.$data['title'].', '.$data['location'];
	        $logData['dataId']=$ins_id;
	        $logData['module']='properties';
	        $logData['table_name']='properties';
	        insert_a_log($logData);
		}else{
			$msg="Unable to add this property, try after sometime!";
		}
		$value = array('result'=>$result,'msg' => $msg,'urlredirect'=>$urlredirect);
		echo json_encode($value);
    }

    function delete_property(){
        $propertyId=$this->input->post('id');
        $where = array('code'=>$propertyId);
        $get_res=$this->common_model->get_table_data('properties',$where,'*',true);
        $result='fail';
        $msg='';
        if($get_res->num_rows()>0){
            $res=$this->common_model->delete_table_data('properties',$where);
            $where = array('propertyId'=>$propertyId);
            $this->common_model->delete_table_data('property_details',$where);
            $this->common_model->delete_table_data('property_tags',$where);
            if($res>0){
                $result='success';
                $msg='Property '.$propertyId.' has been deleted';

                $logData['action']='delete';
		        $logData['description']='deleted the property '.$propertyId.', '.$get_res->row()->title.', '.$get_res->row()->location;
		        $logData['dataId']=$propertyId;
		        $logData['module']='properties';
		        $logData['table_name']='properties';
		        insert_a_log($logData);
            }else{
                $msg='Unable to delete property, try after sometime';
            }
        }else{
            $msg='Property data error, refresh this page and try again';
        }
        $value=array(
            'result'=>$result,
            'msg'=>$msg
        );        
        echo json_encode($value);
    }

    function edit() {
    	$id=$_GET['id'];
        $data = $this->admin->common_admin_files();
		$data['title']="Edit Property";
		$data['propertyQ']=$this->property_model->get_property($id);
		if($data['propertyQ']->num_rows()>0){
			$where = array('propertyId' => $id);
			$data['detailsQ']=$this->common_model->get_table_data('property_details',$where,'*',true);
			$data['photosQ']=$this->common_model->get_table_data('property_images',$where,'*',true);
			$this->load->view("admin/properties/edit_view",$data);
		}else{
			redirect(base_url().'error404');
		}
    }

	function get_update(){
		$data=array();
		$id=$this->input->post('id');
		$type=$this->input->post('type');
		$where = array('propertyId' => $id);
		switch ($type) {
			case 'details':
				$data['dataQ']=$this->property_model->get_property($id);
				$msg=$this->load->view('admin/properties/details/details_view',$data,true);
				break;

			case 'f_image':
				$data['id']=$id;
				$msg=$this->load->view('admin/properties/details/add_image_view',$data,true);
				break;

			case 'description':
				$data['type']=$type;
				$data['dataQ']=$this->common_model->get_table_data('property_details',$where,'*',true);
				$msg=$this->load->view('admin/properties/details/description_view',$data,true);
				break;

			case 'features':
				$data['type']=$type;
				$data['dataQ']=$this->common_model->get_table_data('property_details',$where,'*',true);
				$msg=$this->load->view('admin/properties/details/features_view',$data,true);
				break;

			case 'floor_plan':
				$data['type']=$type;
				$data['dataQ']=$this->common_model->get_table_data('property_details',$where,'*',true);
				$msg=$this->load->view('admin/properties/details/floor_plan_view',$data,true);
				break;

			case 'property_photo':
				$data['type']=$type;
				$data['id']=$id;
				$msg=$this->load->view('admin/properties/details/add_property_photo_view',$data,true);
				break;

			case 'video':
				$data['type']=$type;
				$data['id']=$id;
				$msg=$this->load->view('admin/properties/details/add_video_view',$data,true);
				break;

			default:
				$msg='Unable to process your request, please refresh this page and try again';
				break;
		}
		$value = array('result'=>'success','msg' => $msg);
		echo json_encode($value);
	}

	function do_update(){
		$data=array();
		$id=$this->input->post('id');
		$type=$this->input->post('type');
		$where = array('propertyId' => $id);

		$result='fail';
		$msg='Unable to update, try after sometime';
		$res=0;
		$data['updatedDate']=cur_datetime();
		$data['updatedBy']=get_adminId();

		switch ($type) {
			case 'status':
				$data['status'] = (!empty($this->input->post('status'))) ? $this->input->post('status') : "0";
				$res=$this->common_model->update_table_data('properties',$where,$data);
				$logData['description']='updated property ('.$id.') status';
				break;
			case 'description':
				$data['description']=$this->input->post('content');				
				$res=$this->common_model->update_table_data('property_details',$where,$data);
				$logData['description']='updated property ('.$id.') description content';
				break;
			case 'features':
				$data['features']=$this->input->post('content');
				$res=$this->common_model->update_table_data('property_details',$where,$data);
				$logData['description']='updated property ('.$id.') feature content';
				break;
			case 'details':
				$data['title']=$this->input->post('title');
				$data['ptype']=$this->input->post('ptype');
		    	$data['p_category']=$this->input->post('p_category');
		    	$data['category']=$this->input->post('category');
		    	$data['size']=$this->input->post('size');
		    	$data['location']=$this->input->post('location');
		    	$data['rera_no']=$this->input->post('rera_no');
		    	$data['sqft_price']=$this->input->post('sqft_price');
		    	$data['tot_sqft']=$this->input->post('tot_sqft');
		    	$data['price']=$this->input->post('price');
		    	$data['garage']=$this->input->post('garage');

		    	//for resedentials
		    	$data['beds']=$this->input->post('beds');
		    	$data['bathrooms']=$this->input->post('bathrooms');
		    	$data['balcony']=$this->input->post('balcony');
		    	$data['units']=$this->input->post('units');

		    	//for offices
		    	$data['wstations']=$this->input->post('wstations');
		    	$data['cabins']=$this->input->post('cabins');

		    	//for industrials
		    	$data['power_kw']=$this->input->post('power_kw');
		    	$data['ceiling_ht']=$this->input->post('ceiling_ht');

		    	//for retails
		    	$data['d_space']=$this->input->post('d_space');

		        $data['slug']=create_slug($data['title'].' '.$data['location'].' '.$id);
		        $where = array('code' => $id);
		    	$res=$this->common_model->update_table_data('properties',$where,$data);

		    	$logData['description']='updated property ('.$id.') details';
		    	
				break;
			default:
				$msg='Unable to process your request, refresh this page and try again';
				break;
		}
		//print_r($this->db->last_query());
		if($res>0){
			$result='success';
			$msg='Updated successfully';

            $logData['action']='update';
            $logData['dataId']=$id;
            $logData['module']='properties';
            $logData['table_name']='properties';
            insert_a_log($logData);
		}
		$value = array('result'=>$result,'msg' => $msg);
		echo json_encode($value);
	}

	function update_featureimage(){
		$id=$this->input->post('id');
		if($id!=''){
	        $data['updatedDate']=cur_datetime();
	        $data['updatedBy']=get_adminId();
	        $where = array('code' => $id);
			$propertyQ=$this->property_model->get_property($id);

	        $result='fail';
	        $msg="";
	        $dir = $propertyQ->row()->upload_dir;
	        $extensions = array("jpeg","jpg","png","PNG","JPEG","JPG");
	        if(!empty($_FILES)){
	            //foreach($_FILES['attachment']['tmp_name'] as $key => $tmp_name )
	            for($i=0;$i<1;$i++)
	            {
	                $key = $i;
	                if(!empty($_FILES['attachment']['tmp_name'][$key])){
	                    $file_name = strtolower($_FILES['attachment']['name'][$key]);
	                    $file_size =$_FILES['attachment']['size'][$key];
	                    $file_tmp =$_FILES['attachment']['tmp_name'][$key];
	                    $file_type=$_FILES['attachment']['type'][$key];        
	                    $ext = pathinfo($file_name, PATHINFO_EXTENSION);
	                    if($file_size > 2048) {
	                        $msg='File size should not exceed 2 MB';
	                    }
	                    if(in_array($ext,$extensions ) === true)
	                    {  

	                        $target = $dir.$file_name;
	                        if(file_exists($target)){
	                            $file_name = rand(01,1000).$file_name;
	                        }
	                        $target = $dir.$file_name;
	                        if(move_uploaded_file($file_tmp, $dir.$file_name))
	                        {
	                            $data['feature_image']=$file_name;
	                            $result='success';
	                        }else{
	                            $msg = 'Error in uploading file';               
	                        }
	                    
	                    }else{
	                        $msg = 'Error in uploading file. <br>File type is not allowed.';
	                    }
	                }else{
	                   $msg='Please select the file to upload';
	                }
	            }
	        }else{
	            $msg='Please select the file to upload';
	        }
	        if($result=='success'){
	        	$where = array('propertyId' => $id);
	            $q=$this->common_model->update_table_data('property_details',$where,$data);
	            if($q>0){
	            	$result='success';
	            	$msg='Featured image has been updated';

	            	$logData['description']='updated the property('.$id.') featured image';
                    $logData['action']='update';
                    $logData['dataId']=$id;
                    $logData['module']='properties';
                    $logData['table_name']='properties';
                    insert_a_log($logData);
	            }else{
	            	$result='fail';
	            	$msg='Unable to update, try after sometime';
	            }
	        }
	    }else{
        	$result='fail';
        	$msg='Property data error, please refresh this page and try again';	    	
	    }
        $value=array(
            'result'=>$result,
            'msg'=>$msg
        );
        
        echo json_encode($value);
	}

	function save_floor_plan(){
		$id=$this->input->post('id');
		$data['floor_plan']=$this->input->post('content');
		$result='fail';
	    $msg="";
	    $res_file=1;

		if($id!=''){
	        $data['updatedDate']=cur_datetime();
	        $data['updatedBy']=get_adminId();
	        $where = array('code' => $id);
			$propertyQ=$this->property_model->get_property($id);
	        $dir = $propertyQ->row()->upload_dir;
	        $extensions = array("jpeg","jpg","png","PNG","JPEG","JPG");
	        if(!empty($_FILES)){
	            //foreach($_FILES['attachment']['tmp_name'] as $key => $tmp_name )
	            for($i=0;$i<1;$i++)
	            {
	                $key = $i;
	                if(!empty($_FILES['attachment']['tmp_name'][$key])){
	                    $file_name = strtolower($_FILES['attachment']['name'][$key]);
	                    $file_size =$_FILES['attachment']['size'][$key];
	                    $file_tmp =$_FILES['attachment']['tmp_name'][$key];
	                    $file_type=$_FILES['attachment']['type'][$key];        
	                    $ext = pathinfo($file_name, PATHINFO_EXTENSION);
	                    if($file_size > 2048) {
	                        $msg='File size should not exceed 2 MB';
	                        $res_file=0;
	                    }
	                    if(in_array($ext,$extensions ) === true)
	                    {
	                        $target = $dir.$file_name;
	                        if(file_exists($target)){
	                            $file_name = rand(01,1000).$file_name;
	                        }
	                        $target = $dir.$file_name;
	                        if(move_uploaded_file($file_tmp, $dir.$file_name))
	                        {
	                            $data['floor_diagram']=$file_name;
	                            $res_file=1;
	                        }else{
	                            $msg = 'Error in uploading file';
	                            $res_file=0;
	                        }	                    
	                    }else{
	                        $msg = 'Error in uploading file. <br>File type is not allowed.';
	                        $res_file=0;
	                    }
	                }
	            }
	        }
	        if($res_file==1){
	        	$where = array('propertyId' => $id);
	            $q=$this->common_model->update_table_data('property_details',$where,$data);
	            if($q>0){
	            	$result='success';
	            	$msg='Floor plan content has been updated';

	            	$logData['description']='updated the project('.$id.') floor plan content';
                    $logData['action']='update';
                    $logData['dataId']=$id;
                    $logData['module']='properties';
                    $logData['table_name']='properties';
                    insert_a_log($logData);
	            }else{
	            	$msg='Unable to update, try after sometime';
	            }
	        }
	    }else{
        	$msg='Property data error, please refresh this page and try again';	    	
	    }
        $value=array(
            'result'=>$result,
            'msg'=>$msg
        );
        
        echo json_encode($value);
	}

	function save_property_photo(){
		$id=$this->input->post('id');
		if($id!=''){
			$data['propertyId']=$id;
	        $data['uploadDate']=cur_datetime();
	        $data['uploadBy']=get_adminId();
	        $where = array('code' => $id);
			$propertyQ=$this->property_model->get_property($id);

	        $result='fail';
	        $msg="";
	        $dir = $propertyQ->row()->upload_dir.'photos/';

	        if(!file_exists($dir)){
	            mkdir($dir , 0777, true);
	        }

	        $data['folder']=$dir;
	        $extensions = array("jpeg","jpg","png","PNG","JPEG","JPG");
	        if(!empty($_FILES)){
	            //foreach($_FILES['attachment']['tmp_name'] as $key => $tmp_name )
	            for($i=0;$i<1;$i++)
	            {
	                $key = $i;
	                if(!empty($_FILES['attachment']['tmp_name'][$key])){
	                    $file_name = strtolower($_FILES['attachment']['name'][$key]);
	                    $file_size =$_FILES['attachment']['size'][$key];
	                    $file_tmp =$_FILES['attachment']['tmp_name'][$key];
	                    $file_type=$_FILES['attachment']['type'][$key];        
	                    $ext = pathinfo($file_name, PATHINFO_EXTENSION);
	                    if($file_size > 2048) {
	                        $msg='File size should not exceed 2 MB';
	                    }
	                    if(in_array($ext,$extensions ) === true)
	                    {  

	                        $target = $dir.$file_name;
	                        if(file_exists($target)){
	                            $file_name = rand(01,1000).$file_name;
	                        }
	                        $target = $dir.$file_name;
	                        if(move_uploaded_file($file_tmp, $dir.$file_name))
	                        {
	                            $data['file_name']=$file_name;
	                            $data['file_type']=$ext;
	                            $data['file_size']=$file_size;
	                            $result='success';
	                        }else{
	                            $msg = 'Error in uploading file';               
	                        }
	                    
	                    }else{
	                        $msg = 'Error in uploading file. <br>File type is not allowed.';
	                    }
	                }else{
	                   $msg='Please select the file to upload';
	                }
	            }
	        }else{
	            $msg='Please select the file to upload';
	        }
	        if($result=='success'){
	            $q=$this->common_model->insert_table_data('property_images',$data);
	            if($q>0){
	            	$result='success';
	            	$msg='Property image has been uploaded';

	            	$logData['description']='added media image for the property('.$id.')';
                    $logData['action']='update';
                    $logData['dataId']=$id;
                    $logData['module']='properties';
                    $logData['table_name']='properties';
                    insert_a_log($logData);
	            }else{
	            	$result='fail';
	            	$msg='Unable to update, try after sometime';
	            }
	        }
	    }else{
        	$result='fail';
        	$msg='Property data error, please refresh this page and try again';	    	
	    }
        $value=array(
            'result'=>$result,
            'msg'=>$msg
        );
        
        echo json_encode($value);
	}

	function delete_photo(){
		$id=$this->input->post('id');
		$p_id=$this->input->post('p_id');
		$where = array('id'=>$id,'propertyId' => $p_id);
		$get_res=$this->common_model->get_table_data('property_images',$where,'*',true);
		$result='fail';
		$msg='';
		if($get_res->num_rows()>0){			
			$res=$this->common_model->delete_table_data('property_images',$where);
			if($res>0){
				unlink($get_res->row()->folder.$get_res->row()->file_name);
				$result='success';
				$msg='File ('.$get_res->row()->file_name.') has been removed from your album';
				$logData['description']='deleted media image of the property('.$p_id.')';
                $logData['action']='delete';
                $logData['dataId']=$p_id;
                $logData['module']='properties';
                $logData['table_name']='properties';
                insert_a_log($logData);
			}else{
				$msg='Unable to remove your file, try after sometime';
			}
		}else{
			$msg='Security violations found, refresh your page and try again';
		}
		$value=array(
            'result'=>$result,
            'msg'=>$msg
        );        
        echo json_encode($value);
	}

	function get_photo_info(){
		$id=$this->input->post('id');
		$p_id=$this->input->post('p_id');
		$where = array('id'=>$id,'propertyId' => $p_id);
		$get_res=$this->common_model->get_table_data('property_images',$where,'*',true);
		if($get_res->num_rows()>0){
			$data['dataQ']=$get_res;
			$msg=$this->load->view("admin/properties/details/file_info_view",$data,true);
			$result='success';
		}else{
			$result='fail';
			$msg='Security violations found, refresh your page and try again';
		}
		$value=array(
            'result'=>$result,
            'msg'=>$msg
        );        
        echo json_encode($value);	
	}
	
	function save_property_video(){
		$id=$this->input->post('id');
		$data['video_url']=$this->input->post('video_url');
        $data['updatedDate']=cur_datetime();
        $data['updatedBy']=get_adminId();

		$where = array('propertyId' => $id);
		$res=$this->common_model->update_table_data('property_details',$where,$data);
		if($res>0){
			$result='success';
			$msg='Property video has been updated';

			$logData['description']='updated property('.$id.') video';
            $logData['action']='update';
            $logData['dataId']=$id;
            $logData['module']='properties';
            $logData['table_name']='properties';
            insert_a_log($logData);
		}else{
			$result='fail';
			$msg='Unable to update at this time, please try again';
		}
		$value=array(
            'result'=>$result,
            'msg'=>$msg
        );        
        echo json_encode($value);	
	}

}
