<?php

defined('BASEPATH') OR exit('No direct script access allowed');

class Projects extends CI_Controller {

	function __construct(){
		parent::__construct();
		check_admin_session();
		$this->load->model("adminmodel","",true);
		$this->load->model("common_model","",true);
		$this->load->model("project_model","",true);
		$this->admin->nocache(); 
	}
	
    public function index() {
        $data = $this->admin->common_admin_files();
		$data['title']="All Projects";
		$where = array('status' => 1);
		$data['categoryQ']=$this->common_model->get_table_data('categories',$where,'*',true);
		$this->load->view("admin/projects/main_view",$data);
    }

    function get_datas(){
        $page = (int) $this->input->post('page');
        $filter_data=$this->input->post('filter_data');
        $get_total_rows = $this->project_model->filter_datas($filter_data,0,0);
        $item_per_page="10";
        foreach ($filter_data as $k => $v) {
            if (($v['type'] == 'perpage') && $v['value'] != "") {
                $item_per_page = (int)$v['value'];
            }
        }
		if(empty($page)){
			$page=1;
		}
        $data = $this->common_model->getPaginationData($item_per_page,$page,$get_total_rows);        
        $data['dataQ']=$this->project_model->filter_datas($filter_data,$data['item_per_page'],$data['page_position']);        
        $str = $this->load->view("admin/projects/tbl_view", $data, true);
        $value = array(
        	'result'=>'success',
            'msg' => $str
        );
        echo json_encode($value);
    }

    function add_new(){
        $data=array();
        $str=$this->load->view("admin/projects/add_view",$data,true); 
        $value = array('status' => 'success', 'msg'=>$str);
        echo json_encode($value);
    }

    function save_new_project(){
        $data['name']=$this->input->post('name');
        $data['location']=$this->input->post('location');
        $data['p_category']=$this->input->post('p_category');
        $data['category']=$this->input->post('category');

        $data['min_sba']=$this->input->post('min_sba');
        $data['max_sba']=$this->input->post('max_sba');
        $data['min_carpet']=$this->input->post('min_carpet');
        $data['max_carpet']=$this->input->post('max_carpet');
        $data['min_price']=$this->input->post('min_price');
        $data['max_price']=$this->input->post('max_price');

        $data['createdBy']=get_adminId();
        $data['createdDate']=cur_datetime();
        $data['status']=1;
        $data['p_visibility']=1;
        $ins_id=$this->common_model->insert_table_data('projects',$data);
        //print_r($this->db->last_query());
        $result='fail';
        $msg='Unable to process your request, try again';
        $urlredirect='';
        if($ins_id>0 && $ins_id!=''){
            $rand_chars=strtoupper($this->admin->randomCodenum(2));
            $rand_ints=$this->admin->random_integer(2);
            $project_code=$rand_chars.$rand_ints.$ins_id;
            $slug=create_slug($data['name'].' '.$data['location'].' '.$project_code);
            
            $dir = 'uploads/projects/'.strtolower($project_code).'/';
            if(!file_exists($dir)){
                mkdir($dir , 0777, true);
            }
            $up_data['code']=$project_code;
            $up_data['upload_dir']=$dir;
            $up_data['slug']=$slug;
            $where = array('projectId' => $ins_id);
            $this->common_model->update_table_data('projects',$where,$up_data);
            

            $urlredirect='admin/projects/edit/?id='.$project_code;
            $result='success';
            $msg="Project has been added successfully<br>Click OK to goto project details";

            $logData['action']='add';
            $logData['description']='added new project '.$project_code.', '.$data['name'].', '.$data['location'];
            $logData['dataId']=$ins_id;
            $logData['module']='projects';
            $logData['table_name']='projects';
            insert_a_log($logData);
        }else{
            $msg="Unable to add this project, try after sometime!";
        }
        $value = array('result'=>$result,'msg' => $msg,'urlredirect'=>$urlredirect);
        echo json_encode($value);
    }

    function edit() {
        $id=$_GET['id'];
        $data = $this->admin->common_admin_files();
        $data['title']="Edit Project";
        $data['propertyQ']=$this->project_model->get_project($id);
        if($data['propertyQ']->num_rows()>0){
            $where = array('projectId' => $id);
            $data['photosQ']=$this->common_model->get_table_data('project_images',$where,'*',true);

            $where = array('p_category' => $data['propertyQ']->row()->p_category,'category' => $data['propertyQ']->row()->category,'ptype'=>1);
            $data['prlistQ']=$this->common_model->get_table_data('properties',$where,'*',true);
            $this->load->view("admin/projects/edit_view",$data);
        }else{
            redirect(base_url().'error404');
        }
    }

    function delete_project(){
        $projectId=$this->input->post('id');
        $where = array('code'=>$projectId);
        $get_res=$this->common_model->get_table_data('projects',$where,'*',true);
        $result='fail';
        $msg='';
        if($get_res->num_rows()>0){
            $res=$this->common_model->delete_table_data('projects',$where);
            $where = array('tag_id'=>$projectId,'tag_type'=>'project');
            $this->common_model->delete_table_data('property_tags',$where);
            if($res>0){
                $result='success';
                $msg='Project '.$projectId.' has been deleted';

                $logData['action']='delete';
                $logData['description']='deleted the project '.$projectId.', '.$get_res->row()->name.', '.$get_res->row()->location;
                $logData['dataId']=$projectId;
                $logData['module']='projects';
                $logData['table_name']='projects';
                insert_a_log($logData);
            }else{
                $msg='Unable to delete project, try after sometime';
            }
        }else{
            $msg='Project data error, refresh this page and try again';
        }
        $value=array(
            'result'=>$result,
            'msg'=>$msg
        );        
        echo json_encode($value);
    }

    function get_update(){
        $data=array();
        $id=$this->input->post('id');
        $type=$this->input->post('type');
        $where = array('code' => $id);
        switch ($type) {
            case 'details':
                $data['type']=$type;
                $data['id']=$id;
                $data['dataQ']=$this->project_model->get_project($id);
                $msg=$this->load->view('admin/projects/details/details_view',$data,true);
                break;
            case 'f_image':
                $data['id']=$id;
                $msg=$this->load->view('admin/projects/details/add_feature_image_view',$data,true);
                break;

            case 'description':
                $data['type']=$type;
                $data['id']=$id;
                $data['dataQ']=$this->common_model->get_table_data('projects',$where,'*',true);
                $msg=$this->load->view('admin/projects/details/description_view',$data,true);
                break;

            case 'property_photo':
                $data['type']=$type;
                $data['id']=$id;
                $msg=$this->load->view('admin/projects/details/add_photo_view',$data,true);
                break;

            default:
                $msg='Unable to process your request, please refresh this page and try again';
                break;
        }
        $value = array('result'=>'success','msg' => $msg);
        echo json_encode($value);
    }

    function do_update(){
        $data=array();
        $id=$this->input->post('id');
        $type=$this->input->post('type');
        $where = array('code' => $id);

        $result='fail';
        $msg='Unable to update, try after sometime';
        $res=0;
        $data['updatedDate']=cur_datetime();
        $data['updatedBy']=get_adminId();

        switch ($type) {
            case 'details':
                $data['name']=$this->input->post('name');
                $data['location']=$this->input->post('location');
                $data['p_category']=$this->input->post('p_category');
                $data['category']=$this->input->post('category');

                $data['min_sba']=$this->input->post('min_sba');
                $data['max_sba']=$this->input->post('max_sba');
                $data['min_carpet']=$this->input->post('min_carpet');
                $data['max_carpet']=$this->input->post('max_carpet');
                $data['min_price']=$this->input->post('min_price');
                $data['max_price']=$this->input->post('max_price');

                $data['updatedBy']=get_adminId();
                $data['updatedDate']=cur_datetime();
                $res=$this->common_model->update_table_data('projects',$where,$data);
                break;
            case 'status':
                $data['p_visibility'] = (!empty($this->input->post('status'))) ? $this->input->post('status') : "0";
                $res=$this->common_model->update_table_data('projects',$where,$data);
                $logData['description']='updated the project('.$id.') status';
                break;

            case 'description':
                $data['description']=$this->input->post('content');             
                $res=$this->common_model->update_table_data('projects',$where,$data);
                $logData['description']='updated the project('.$id.') description';
                break;
                
                break;
            default:
                $msg='Unable to process your request, refresh this page and try again';
                break;
        }
        //print_r($this->db->last_query());
        if($res>0){
            $result='success';
            $msg='Updated successfully';

            $logData['action']='update';
            $logData['dataId']=$id;
            $logData['module']='projects';
            $logData['table_name']='projects';
            insert_a_log($logData);
        }
        $value = array('result'=>$result,'msg' => $msg);
        echo json_encode($value);
    }

    function update_feature_image(){
        $id=$this->input->post('id');
        if($id!=''){
            $data['updatedDate']=cur_datetime();
            $data['updatedBy']=get_adminId();
            $where = array('code' => $id);
            $propertyQ=$this->project_model->get_project($id);

            $result='fail';
            $msg="";
            $dir = $propertyQ->row()->upload_dir;
            $extensions = array("jpeg","jpg","png","PNG","JPEG","JPG");
            if(!empty($_FILES)){
                //foreach($_FILES['attachment']['tmp_name'] as $key => $tmp_name )
                for($i=0;$i<1;$i++)
                {
                    $key = $i;
                    if(!empty($_FILES['attachment']['tmp_name'][$key])){
                        $file_name = strtolower($_FILES['attachment']['name'][$key]);
                        $file_size =$_FILES['attachment']['size'][$key];
                        $file_tmp =$_FILES['attachment']['tmp_name'][$key];
                        $file_type=$_FILES['attachment']['type'][$key];        
                        $ext = pathinfo($file_name, PATHINFO_EXTENSION);
                        if($file_size > 2048) {
                            $msg='File size should not exceed 2 MB';
                        }
                        if(in_array($ext,$extensions ) === true)
                        {  

                            $target = $dir.$file_name;
                            if(file_exists($target)){
                                $file_name = rand(01,1000).$file_name;
                            }
                            $target = $dir.$file_name;
                            if(move_uploaded_file($file_tmp, $dir.$file_name))
                            {
                                $data['feature_image']=$file_name;
                                $result='success';
                            }else{
                                $msg = 'Error in uploading file';               
                            }
                        
                        }else{
                            $msg = 'Error in uploading file. <br>File type is not allowed.';
                        }
                    }else{
                       $msg='Please select the file to upload';
                    }
                }
            }else{
                $msg='Please select the file to upload';
            }
            if($result=='success'){
                $q=$this->common_model->update_table_data('projects',$where,$data);
                //print_r($this->db->last_query());
                if($q>0){
                    $result='success';
                    $msg='Featured image has been updated';

                    $logData['description']='updated the project('.$id.') featured image';
                    $logData['action']='update';
                    $logData['dataId']=$id;
                    $logData['module']='projects';
                    $logData['table_name']='projects';
                    insert_a_log($logData);
                }else{
                    $result='fail';
                    $msg='Unable to update, try after sometime';
                }
            }
        }else{
            $result='fail';
            $msg='Project data error, please refresh this page and try again';         
        }
        $value=array(
            'result'=>$result,
            'msg'=>$msg
        );
        
        echo json_encode($value);
    }

    function save_property_photo(){
        $id=$this->input->post('id');
        if($id!=''){
            $data['projectId']=$id;
            $data['uploadDate']=cur_datetime();
            $data['uploadBy']=get_adminId();
            $where = array('code' => $id);
            $propertyQ=$this->project_model->get_project($id);

            $result='fail';
            $msg="";
            $dir = $propertyQ->row()->upload_dir.'photos/';

            if(!file_exists($dir)){
                mkdir($dir , 0777, true);
            }

            $data['folder']=$dir;
            $extensions = array("jpeg","jpg","png","PNG","JPEG","JPG");
            if(!empty($_FILES)){
                //foreach($_FILES['attachment']['tmp_name'] as $key => $tmp_name )
                for($i=0;$i<1;$i++)
                {
                    $key = $i;
                    if(!empty($_FILES['attachment']['tmp_name'][$key])){
                        $file_name = strtolower($_FILES['attachment']['name'][$key]);
                        $file_size =$_FILES['attachment']['size'][$key];
                        $file_tmp =$_FILES['attachment']['tmp_name'][$key];
                        $file_type=$_FILES['attachment']['type'][$key];        
                        $ext = pathinfo($file_name, PATHINFO_EXTENSION);
                        if($file_size > 2048) {
                            $msg='File size should not exceed 2 MB';
                        }
                        if(in_array($ext,$extensions ) === true)
                        {  

                            $target = $dir.$file_name;
                            if(file_exists($target)){
                                $file_name = rand(01,1000).$file_name;
                            }
                            $target = $dir.$file_name;
                            if(move_uploaded_file($file_tmp, $dir.$file_name))
                            {
                                $data['file_name']=$file_name;
                                $data['file_type']=$ext;
                                $data['file_size']=$file_size;
                                $result='success';
                            }else{
                                $msg = 'Error in uploading file';               
                            }
                        
                        }else{
                            $msg = 'Error in uploading file. <br>File type is not allowed.';
                        }
                    }else{
                       $msg='Please select the file to upload';
                    }
                }
            }else{
                $msg='Please select the file to upload';
            }
            if($result=='success'){
                $q=$this->common_model->insert_table_data('project_images',$data);
                if($q>0){
                    $result='success';
                    $msg='Project image has been uploaded';

                    $logData['description']='added media image for the project('.$id.')';
                    $logData['action']='update';
                    $logData['dataId']=$id;
                    $logData['module']='projects';
                    $logData['table_name']='projects';
                    insert_a_log($logData);
                }else{
                    $result='fail';
                    $msg='Unable to update, try after sometime';
                }
            }
        }else{
            $result='fail';
            $msg='Project data error, please refresh this page and try again';         
        }
        $value=array(
            'result'=>$result,
            'msg'=>$msg
        );
        
        echo json_encode($value);
    }

    function delete_photo(){
        $id=$this->input->post('id');
        $p_id=$this->input->post('p_id');
        $where = array('id'=>$id,'projectId' => $p_id);
        $get_res=$this->common_model->get_table_data('project_images',$where,'*',true);
        $result='fail';
        $msg='';
        if($get_res->num_rows()>0){         
            $res=$this->common_model->delete_table_data('project_images',$where);
            if($res>0){
                unlink($get_res->row()->folder.$get_res->row()->file_name);
                $result='success';
                $msg='File ('.$get_res->row()->file_name.') has been removed from project album';

                $logData['description']='deleted media image of the project('.$p_id.')';
                $logData['action']='delete';
                $logData['dataId']=$p_id;
                $logData['module']='projects';
                $logData['table_name']='projects';
                insert_a_log($logData);
            }else{
                $msg='Unable to remove your file, try after sometime';
            }
        }else{
            $msg='Project data error, refresh this page and try again';
        }
        $value=array(
            'result'=>$result,
            'msg'=>$msg
        );        
        echo json_encode($value);
    }

    function get_photo_info(){
        $id=$this->input->post('id');
        $p_id=$this->input->post('p_id');
        $where = array('id'=>$id,'projectId' => $p_id);
        $get_res=$this->common_model->get_table_data('project_images',$where,'*',true);
        if($get_res->num_rows()>0){
            $data['dataQ']=$get_res;
            $msg=$this->load->view("admin/projects/details/file_info_view",$data,true);
            $result='success';
        }else{
            $result='fail';
            $msg='Project data error, refresh this page and try again';
        }
        $value=array(
            'result'=>$result,
            'msg'=>$msg
        );        
        echo json_encode($value);   
    }

    function get_tags(){
        $id=$this->input->post('id');
        $page = (int) $this->input->post('page');
        $get_total_rows = $this->project_model->get_tag_properties($id,0,0);
        $item_per_page="10";
        $data = $this->common_model->getPaginationData($item_per_page,$page,$get_total_rows);        
        $data['dataQ']=$this->project_model->get_tag_properties($id,$data['item_per_page'],$data['page_position']);        
        $str = $this->load->view("admin/projects/details/tags_tbl_view", $data, true);
        $value = array(
            'result'=>'success',
            'msg' => $str
        );
        echo json_encode($value);
    }

    function save_tags(){
        $data['tag_id']=$this->input->post('p_id');
        $data['propertyId']=$this->input->post('property_id');
        $data['tag_type']='project';
        $data['createdDate']=cur_datetime();
        $data['createdBy']=get_adminId();

        $msg='Unable to add, try after sometime';
        $result='fail';
        $res=$this->project_model->save_property_tag($data);
        if($res['result']>=0){
            $result='success';
            $msg=$res['msg'];

            $logData['description']='added property('.$data['propertyId'].') to the project('.$data['tag_id'].') tag list';
            $logData['action']='delete';
            $logData['dataId']=$data['tag_id'];
            $logData['module']='projects';
            $logData['table_name']='projects';
            insert_a_log($logData);
        }
        //print_r($this->db->last_query());
        $value=array(
            'result'=>$result,
            'msg'=>$msg
        );        
        echo json_encode($value); 
    }

    function remove_tag(){
        $propertyId=$this->input->post('id');
        $projectId=$this->input->post('p_id');
        $where = array('tag_id'=>$projectId,'propertyId' => $propertyId);
        $get_res=$this->common_model->get_table_data('property_tags',$where,'*',true);
        $result='fail';
        $msg='';
        if($get_res->num_rows()>0){         
            $res=$this->common_model->delete_table_data('property_tags',$where);
            if($res>0){
                $result='success';
                $msg='Property ('.$get_res->row()->tag_id.') tag has been removed from the project';

                $logData['description']='removed property('.$propertyId.') from the project('.$projectId.') tag list';
                $logData['action']='delete';
                $logData['dataId']=$projectId;
                $logData['module']='projects';
                $logData['table_name']='projects';
                insert_a_log($logData);
            }else{
                $msg='Unable to remove property tag, try after sometime';
            }
        }else{
            $msg='Project data error, refresh this page and try again';
        }
        $value=array(
            'result'=>$result,
            'msg'=>$msg
        );        
        echo json_encode($value);
    }

}
