<?php
class Profile extends CI_Controller{
	
	function __construct(){
		parent::__construct();
        check_admin_session();
		$this->load->model("adminmodel","",true);
        $this->load->model("common_model","",true);
		$this->admin->nocache(); 
	}
	
	function index(){
    	$data = $this->admin->common_admin_files();
        $adminId=get_adminId();
        $where = array('adminId' => $adminId);
    	$data['dataQ']=$this->common_model->get_table_data('admin_users',$where,'*',true);
    	$data['title']="Profile Settings";
    	$this->load->view("admin/profile/myprofile_view",$data);
	}

    function save_profile(){
        $adminId=get_adminId();
        $data['name']=$this->input->post("name");
        //$data['email']=$this->input->post("email");
        $data['phone']=$this->input->post("phone");
        $data['updatedDate']=cur_datetime();

        $result='fail';
            $where=array('adminId'=>$adminId);
            $q=$this->common_model->update_table_data('admin_users',$where,$data);
            if($q>0){
                $result='success';
                $logData['action']='Update';
                $logData['description']='updated account profile';
                $logData['dataId']=$adminId;
                $logData['module']='Profile Settings';
                $logData['table_name']='admin_users';
                insert_a_log($logData);
            }
        //print_r($this->db->last_query());
        $value=array(
            'result'=>$result
        );
        
        echo json_encode($value);
    }

    function change_password(){
        $data = $this->admin->common_admin_files();
        $adminId=get_adminId();
        $where = array('adminId' => $adminId);
        $data['dataQ']=$this->common_model->get_table_data('admin_users',$where,'*',true);
        $data['title']="Password Settings";
        $this->load->view("admin/profile/change_password_view",$data);
    }

    function update_password(){
        $adminId=get_adminId();
        $data['password'] = $this->common_model->hash($this->input->post('password'));
        $data['updatedDate']=cur_datetime();

        $result='fail';
        $where=array('adminId'=>$adminId);
        $q=$this->common_model->update_table_data('admin_users',$where,$data);
        if($q>0){
            $result='success';
            $logData['action']='Update';
            $logData['description']='updated account password';
            $logData['dataId']=$adminId;
            $logData['module']='Profile Settings';
            $logData['table_name']='admin_users';
            insert_a_log($logData);
        }
        $value=array(
            'result'=>$result
        );
        
        echo json_encode($value);
    }
}