<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Login extends CI_Controller {

	function __construct(){
		parent::__construct();
		$this->admin->nocache(); 
		$this->load->model("common_model","",true);
		$this->load->model("adminmodel","",true);
		$this->load->library('user_agent');
		$this->admin->nocache(); 
	}

	public function index()
	{
		if(is_a_logged() && get_adminId()!=''){			
			redirect(base_url().'admin/dashboard');			
		}
		$data = $this->admin->common_admin_files();
		unset($data['header_menu']);
		unset($data['header_main']);
		$data['title'] = "Admin Login";
		$this->load->view('admin/loginView',$data);

	}
	
	function authentication()
	{
		$urldirect = "";
		$result='fail';
		$msg='';
		$uname=$this->input->post("uid");
		$password=$this->input->post("pwd");
		$remember = $this->input->post('remember');
		
		$q = $this->adminmodel->getAuth($uname);

		if($q->num_rows()>0){
			if($q->row()->status == "1") {
				$pass = $q->row()->password;
				$check_pass = $this->common_model->verifyHash($password, $pass);
				if($check_pass){
					$userdata=array(
						'tc_adminId'=>$q->row()->adminId,
						'tc_aUserName'=>$q->row()->username,
						'tc_aEmail'=>$q->row()->email,
						'tc_aRoleId'=>$q->row()->roleId,
						'tc_aadmin'=>$q->row()->is_admin,
						'tc_aisLogged'=>1
					);
					$this->adminmodel->setlog($q->row()->adminId);
					$this->session->set_userdata($userdata);
					setRemember($remember, $uname, $password);
					$result='success';
					$msg="Login success! Redirecting...";

					$logData['action']='Login';
			        $logData['description']='logged in to the system';
			        $logData['dataId']=$q->row()->adminId;
			        $logData['module']='Login';
			        $logData['table_name']='admin_users';
			        insert_a_log($logData);
			        $urldirect = base_url().'admin/dashboard';	
				}else{
					$msg="Username or Password wrong";
				}
			}else{
				$msg="Your account is inactive, please contact admin!";
			}
		}else{
			$msg="It seems your account not exist, please contact admin!";
		}

		
		$value=array(
			'result'=>$result,
			'msg'=>$msg,
			'urldirect'=>$urldirect
		);
		echo json_encode($value);
	}
	

	
}
