<?php

defined('BASEPATH') OR exit('No direct script access allowed');

class Forms extends CI_Controller {

	function __construct(){
		parent::__construct();
		check_admin_session();
		$this->load->model("adminmodel","",true);
		$this->load->model("common_model","",true);
		$this->load->model("formmodel","",true);
		$this->admin->nocache(); 
	}

    function index(){
        redirect('admin/dashboard');
    }

    function get_details(){
    	$data=array();
    	$type=$this->input->post('type');
    	$id=$this->input->post('id');
    	$where = array('id' => $id);
    	switch ($type) {

    		case 'contact':
    			$where = array('id' => $id,'type'=>'contact');
    			$data['dataQ']=$this->common_model->get_table_data('callback_enquiries',$where,'*',true);
    			$str=$this->load->view("admin/forms/contact/detail_view", $data, true);
    			break;

            case 'career':
                $where = array('id' => $id,'type'=>'career');
                $data['dataQ']=$this->common_model->get_table_data('careers',$where,'*',true);
                $str=$this->load->view("admin/forms/career/detail_view", $data, true);
                break;
            
            case 'demo':
                $where = array('id' => $id,'type'=>'demo');
                $data['dataQ']=$this->common_model->get_table_data('request_demo',$where,'*',true);
                $str=$this->load->view("admin/forms/demo/detail_view", $data, true);
                break;
    		
    		default:
    			$str="Data error, try again by refreshing page";
    			break;
    	}
    	$value = array(
        	'result'=>'success',
            'msg' => $str
        );
        echo json_encode($value);
    }
	

    function delete_data(){
    	$type=$this->input->post('type');
    	$id=$this->input->post('id');
    	$where = array('id' => $id);
    	switch ($type) {

    		case 'contact':
    			$where = array('id' => $id,'type'=>'contact');
    			$get_res=$this->common_model->get_table_data('callback_enquiries',$where,'*',true);
    			$res=$this->common_model->delete_table_data('callback_enquiries',$where);

		        $logData['module']='contacts';
		        $logData['table_name']='callback_enquiries';
	        	$logData['description']='deleted contact data '.$get_res->row()->name.'('.$get_res->row()->email.')';
    			break;
            
            case 'demo':
                $where = array('id' => $id,'type'=>'demo');
                $get_res=$this->common_model->get_table_data('request_demo',$where,'*',true);
                $res=$this->common_model->delete_table_data('request_demo',$where);

                $logData['module']='demos';
                $logData['table_name']='request_demo';
                $logData['description']='deleted demo request data '.$get_res->row()->name.'('.$get_res->row()->email.')';
                break;

            case 'career':
                $where = array('id' => $id,'type'=>'career');
                $get_res=$this->common_model->get_table_data('careers',$where,'*',true);
                $res=$this->common_model->delete_table_data('careers',$where);

                $logData['module']='Careers';
                $logData['table_name']='careers';
                $logData['description']='deleted career data '.$get_res->row()->name.'('.$get_res->row()->email.')';
                break;
    		
    		default:
    			$res=0;
    			break;
    	}
        
    	if($res>0){
    		$logData['action']='delete';
			$logData['dataId']=$id;
	        insert_a_log($logData);

    		$str=ucwords($type).' data has been removed';
    		$result='success';
    	}else{
    		$str="Data error, try again by refreshing page";
    		$result='fail';
    	}
    	$value = array(
        	'result'=>$result,
            'msg' => $str
        );
        echo json_encode($value);
    }

    public function contact() {
        $data = $this->admin->common_admin_files();
		$data['title']="Contact Form";
		$this->load->view("admin/forms/contact/main_view",$data);
    }

    function get_contacts(){
        $page = (int) $this->input->post('page');
        $filter_data=$this->input->post('filter_data');
        $get_total_rows = $this->formmodel->filter_contacts($filter_data,0,0);
        $item_per_page="10";
        foreach ($filter_data as $k => $v) {
            if (($v['type'] == 'perpage') && $v['value'] != "") {
                $item_per_page = (int)$v['value'];
            }
        }
		if(empty($page)){
			$page=1;
		}
        $data = $this->common_model->getPaginationData($item_per_page,$page,$get_total_rows);        
        $data['dataQ']=$this->formmodel->filter_contacts($filter_data,$data['item_per_page'],$data['page_position']);        
        $str = $this->load->view("admin/forms/contact/tbl_view", $data, true);
        $value = array(
        	'result'=>'success',
            'msg' => $str
        );
        echo json_encode($value);
    }

	public function career() {
        $data = $this->admin->common_admin_files();
		$data['title']="Career Form";
		$this->load->view("admin/forms/career/main_view",$data);
    }

    function get_careers(){
        $page = (int) $this->input->post('page');
        $filter_data=$this->input->post('filter_data');
        $get_total_rows = $this->formmodel->filter_careers($filter_data,0,0);
        $item_per_page="10";
        foreach ($filter_data as $k => $v) {
            if (($v['type'] == 'perpage') && $v['value'] != "") {
                $item_per_page = (int)$v['value'];
            }
        }
		if(empty($page)){
			$page=1;
		}
        $data = $this->common_model->getPaginationData($item_per_page,$page,$get_total_rows);        
        $data['dataQ']=$this->formmodel->filter_careers($filter_data,$data['item_per_page'],$data['page_position']);        
        $str = $this->load->view("admin/forms/career/tbl_view", $data, true);
        $value = array(
        	'result'=>'success',
            'msg' => $str
        );
        echo json_encode($value);
    }

    public function demo() {
        $data = $this->admin->common_admin_files();
		$data['title']="Product Demo Request Form";
		$this->load->view("admin/forms/demo/main_view",$data);
    }

    function get_demos(){
        $page = (int) $this->input->post('page');
        $filter_data=$this->input->post('filter_data');
        $get_total_rows = $this->formmodel->filter_demos($filter_data,0,0);
        $item_per_page="10";
        foreach ($filter_data as $k => $v) {
            if (($v['type'] == 'perpage') && $v['value'] != "") {
                $item_per_page = (int)$v['value'];
            }
        }
		if(empty($page)){
			$page=1;
		}
        $data = $this->common_model->getPaginationData($item_per_page,$page,$get_total_rows);        
        $data['dataQ']=$this->formmodel->filter_demos($filter_data,$data['item_per_page'],$data['page_position']);        
        $str = $this->load->view("admin/forms/demo/tbl_view", $data, true);
        $value = array(
        	'result'=>'success',
            'msg' => $str
        );
        echo json_encode($value);
    }

}