<?php

defined('BASEPATH') OR exit('No direct script access allowed');

class Featured extends CI_Controller {

	function __construct(){
		parent::__construct();
		check_admin_session();
		$this->load->model("adminmodel","",true);
		$this->load->model("common_model","",true);
		$this->load->model("property_model","",true);
		$this->load->model("project_model","",true);
		$this->admin->nocache(); 
	}

    function index(){
        redirect('admin/dashboard');
    }
	
    public function properties() {
        $data = $this->admin->common_admin_files();
		$data['title']="Featured Properties";
		$where = array('p_visibility' => 1);
		$data['pr_listQ']=$this->common_model->get_table_data('properties',$where,'*',true);
		$this->load->view("admin/featured/properties/main_view",$data);
    }

    function get_properties(){
        $page = (int) $this->input->post('page');
        $filter_data=$this->input->post('filter_data');
        $get_total_rows = $this->property_model->filter_featured($filter_data,0,0);
        $item_per_page="10";
        foreach ($filter_data as $k => $v) {
            if (($v['type'] == 'perpage') && $v['value'] != "") {
                $item_per_page = (int)$v['value'];
            }
        }
		if(empty($page)){
			$page=1;
		}
        $data = $this->common_model->getPaginationData($item_per_page,$page,$get_total_rows);        
        $data['dataQ']=$this->property_model->filter_featured($filter_data,$data['item_per_page'],$data['page_position']);        
        $str = $this->load->view("admin/featured/properties/tbl_view", $data, true);
        $value = array(
        	'result'=>'success',
            'msg' => $str
        );
        echo json_encode($value);
    }

    function save_property(){
        $data['tag_id']=$this->input->post('property_id');
        $data['tag_type']='property';
        $data['createdDate']=cur_datetime();
        $data['createdBy']=get_adminId();

        $msg='Unable to add, try after sometime';
        $result='fail';
        $where = array('tag_type'=>'property', 'tag_id'=>$data['tag_id']);
        $get_res=$this->common_model->get_table_data('featured_items',$where,'*',true);
        if($get_res->num_rows()>0){
        	$msg='Property already exists in featured list';
        }else{
	        $res=$this->common_model->insert_table_data('featured_items',$data);
	        if($res>0){
	            $result='success';
	            $msg='Property added to feature list';

                $logData['action']='add';
                $logData['dataId']=$res;
                $logData['module']='featured properties';
                $logData['table_name']='featured_items';
                $logData['description']='added property '.$data['tag_id'].' to featured list';
                insert_a_log($logData);
	        }
	    }
        //print_r($this->db->last_query());
        $value=array(
            'result'=>$result,
            'msg'=>$msg
        );        
        echo json_encode($value); 
    }

    function remove_property(){
        $itemId=$this->input->post('id');
        $property_code=$this->input->post('code');
        $where = array('id'=>$itemId,'tag_id'=>$property_code,'tag_type' => 'property');
        $get_res=$this->common_model->get_table_data('featured_items',$where,'*',true);
        $result='fail';
        $msg='';
        if($get_res->num_rows()>0){         
            $res=$this->common_model->delete_table_data('featured_items',$where);
            if($res>0){
                $result='success';
                $msg='Property ('.$get_res->row()->tag_id.') has been removed from the featured list';

                $logData['action']='delete';
                $logData['dataId']=$property_code;
                $logData['module']='featured properties';
                $logData['table_name']='featured_items';
                $logData['description']='removed the property '.$property_code.' from featured list';
                insert_a_log($logData);
            }else{
                $msg='Unable to remove property, try after sometime';
            }
        }else{
            $msg='Property data error, refresh this page and try again';
        }
        $value=array(
            'result'=>$result,
            'msg'=>$msg
        );        
        echo json_encode($value);
    }

    public function projects() {
        $data = $this->admin->common_admin_files();
		$data['title']="Featured Projects";
		$where = array('p_visibility' => 1);
		$data['pr_listQ']=$this->common_model->get_table_data('projects',$where,'*',true);
		$this->load->view("admin/featured/projects/main_view",$data);
    }

    function get_projects(){
        $page = (int) $this->input->post('page');
        $filter_data=$this->input->post('filter_data');
        $get_total_rows = $this->project_model->filter_featured($filter_data,0,0);
        $item_per_page="10";
        foreach ($filter_data as $k => $v) {
            if (($v['type'] == 'perpage') && $v['value'] != "") {
                $item_per_page = (int)$v['value'];
            }
        }
        $data = $this->common_model->getPaginationData($item_per_page,$page,$get_total_rows);        
        $data['dataQ']=$this->project_model->filter_featured($filter_data,$data['item_per_page'],$data['page_position']);        
        $str = $this->load->view("admin/featured/projects/tbl_view", $data, true);
        $value = array(
        	'result'=>'success',
            'msg' => $str
        );
        echo json_encode($value);
    }

    function save_project(){
        $data['tag_id']=$this->input->post('project_id');
        $data['tag_type']='project';
        $data['createdDate']=cur_datetime();
        $data['createdBy']=get_adminId();

        $msg='Unable to add, try after sometime';
        $result='fail';
        $where = array('tag_type'=>'project', 'tag_id'=>$data['tag_id']);
        $get_res=$this->common_model->get_table_data('featured_items',$where,'*',true);
        if($get_res->num_rows()>0){
        	$msg='Project already exists in featured list';
        }else{
	        $res=$this->common_model->insert_table_data('featured_items',$data);
	        if($res>0){
	            $result='success';
	            $msg='Project added to feature list';

                $logData['action']='add';
                $logData['dataId']=$res;
                $logData['module']='featured projects';
                $logData['table_name']='featured_items';
                $logData['description']='added project '.$data['tag_id'].' to featured list';
                insert_a_log($logData);
	        }
	    }
        //print_r($this->db->last_query());
        $value=array(
            'result'=>$result,
            'msg'=>$msg
        );        
        echo json_encode($value); 
    }

    function remove_project(){
        $itemId=$this->input->post('id');
        $property_code=$this->input->post('code');
        $where = array('id'=>$itemId,'tag_id'=>$property_code,'tag_type' => 'project');
        $get_res=$this->common_model->get_table_data('featured_items',$where,'*',true);
        $result='fail';
        $msg='';
        if($get_res->num_rows()>0){         
            $res=$this->common_model->delete_table_data('featured_items',$where);
            if($res>0){
                $result='success';
                $msg='Project ('.$get_res->row()->tag_id.') has been removed from the featured list';

                $logData['action']='delete';
                $logData['dataId']=$property_code;
                $logData['module']='featured projects';
                $logData['table_name']='featured_items';
                $logData['description']='removed the project '.$property_code.' from featured list';
                insert_a_log($logData);
            }else{
                $msg='Unable to remove project, try after sometime';
            }
        }else{
            $msg='Project data error, refresh this page and try again';
        }
        $value=array(
            'result'=>$result,
            'msg'=>$msg
        );        
        echo json_encode($value);
    }

}
